# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `syntax_tree` gem.
# Please instead update this file by running `bin/tapioca gem syntax_tree`.

# Syntax Tree is a suite of tools built on top of the internal CRuby parser. It
# provides the ability to generate a syntax tree from source, as well as the
# tools necessary to inspect and manipulate that syntax tree. It can be used to
# build formatters, linters, language servers, and more.
#
# source://syntax_tree//lib/syntax_tree/node.rb#3
module SyntaxTree
  class << self
    # Parses the given source and returns the formatted source.
    #
    # source://syntax_tree//lib/syntax_tree.rb#60
    def format(source, maxwidth = T.unsafe(nil), base_indentation = T.unsafe(nil), options: T.unsafe(nil)); end

    # Parses the given file and returns the formatted source.
    #
    # source://syntax_tree//lib/syntax_tree.rb#76
    def format_file(filepath, maxwidth = T.unsafe(nil), base_indentation = T.unsafe(nil), options: T.unsafe(nil)); end

    # Accepts a node in the tree and returns the formatted source.
    #
    # source://syntax_tree//lib/syntax_tree.rb#86
    def format_node(source, node, maxwidth = T.unsafe(nil), base_indentation = T.unsafe(nil), options: T.unsafe(nil)); end

    # Indexes the given source code to return a list of all class, module, and
    # method definitions. Used to quickly provide indexing capability for IDEs or
    # documentation generation.
    #
    # source://syntax_tree//lib/syntax_tree.rb#103
    def index(source); end

    # Indexes the given file to return a list of all class, module, and method
    # definitions. Used to quickly provide indexing capability for IDEs or
    # documentation generation.
    #
    # source://syntax_tree//lib/syntax_tree.rb#110
    def index_file(filepath); end

    # A convenience method for creating a new mutation visitor.
    #
    # @yield [visitor]
    #
    # source://syntax_tree//lib/syntax_tree.rb#115
    def mutation; end

    # Parses the given source and returns the syntax tree.
    #
    # source://syntax_tree//lib/syntax_tree.rb#122
    def parse(source); end

    # Parses the given file and returns the syntax tree.
    #
    # source://syntax_tree//lib/syntax_tree.rb#129
    def parse_file(filepath); end

    # Returns the source from the given filepath taking into account any potential
    # magic encoding comments.
    #
    # source://syntax_tree//lib/syntax_tree.rb#135
    def read(filepath); end

    # This is a hook provided so that plugins can register themselves as the
    # handler for a particular file type.
    #
    # source://syntax_tree//lib/syntax_tree.rb#150
    def register_handler(extension, handler); end

    # Searches through the given source using the given pattern and yields each
    # node in the tree that matches the pattern to the given block.
    #
    # source://syntax_tree//lib/syntax_tree.rb#156
    def search(source, query, &block); end

    # Searches through the given file using the given pattern and yields each
    # node in the tree that matches the pattern to the given block.
    #
    # source://syntax_tree//lib/syntax_tree.rb#165
    def search_file(filepath, query, &block); end
  end
end

# ARef represents when you're pulling a value out of a collection at a
# specific index. Put another way, it's any time you're calling the method
# #[].
#
#     collection[index]
#
# The nodes usually contains two children, the collection and the index. In
# some cases, you don't necessarily have the second child node, because you
# can call procs with a pretty esoteric syntax. In the following example, you
# wouldn't have a second child node:
#
#     collection[]
#
# source://syntax_tree//lib/syntax_tree/node.rb#568
class SyntaxTree::ARef < ::SyntaxTree::Node
  # @return [ARef] a new instance of ARef
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#577
  def initialize(collection:, index:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#632
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#584
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#588
  def child_nodes; end

  # [Node] the value being indexed
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#569
  def collection; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#575
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#592
  def copy(collection: T.unsafe(nil), index: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#588
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#606
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#615
  def format(q); end

  # [nil | Args] the value being passed within the brackets
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#572
  def index; end
end

# ARefField represents assigning values into collections at specific indices.
# Put another way, it's any time you're calling the method #[]=. The
# ARefField node itself is just the left side of the assignment, and they're
# always wrapped in assign nodes.
#
#     collection[index] = value
#
# source://syntax_tree//lib/syntax_tree/node.rb#646
class SyntaxTree::ARefField < ::SyntaxTree::Node
  # @return [ARefField] a new instance of ARefField
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#655
  def initialize(collection:, index:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#710
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#662
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#666
  def child_nodes; end

  # [Node] the value being indexed
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#647
  def collection; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#653
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#670
  def copy(collection: T.unsafe(nil), index: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#666
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#684
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#693
  def format(q); end

  # [nil | Args] the value being passed within the brackets
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#650
  def index; end
end

# Alias represents the use of the +alias+ keyword with regular arguments (not
# global variables). The +alias+ keyword is used to make a method respond to
# another name as well as the current one.
#
#     alias aliased_name name
#
# For the example above, in the current context you can now call aliased_name
# and it will execute the name method. When you're aliasing two methods, you
# can either provide bare words (like the example above) or you can provide
# symbols (note that this includes dynamic symbols like
# :"left-#{middle}-right").
#
# source://syntax_tree//lib/syntax_tree/node.rb#460
class SyntaxTree::AliasNode < ::SyntaxTree::Node
  # @return [AliasNode] a new instance of AliasNode
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#496
  def initialize(left:, right:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#545
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#503
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#507
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#494
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#511
  def copy(left: T.unsafe(nil), right: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#507
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#525
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#529
  def format(q); end

  # [DynaSymbol | GVar | SymbolLiteral] the new name of the method
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#488
  def left; end

  # [Backref | DynaSymbol | GVar | SymbolLiteral] the old name of the method
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#491
  def right; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#549
  def var_alias?; end
end

# Formats an argument to the alias keyword. For symbol literals it uses the
# value of the symbol directly to look like bare words.
#
# source://syntax_tree//lib/syntax_tree/node.rb#461
class SyntaxTree::AliasNode::AliasArgumentFormatter
  # @return [AliasArgumentFormatter] a new instance of AliasArgumentFormatter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#466
  def initialize(argument); end

  # [Backref | DynaSymbol | GVar | SymbolLiteral] the argument being passed
  # to alias
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#464
  def argument; end

  # source://syntax_tree//lib/syntax_tree/node.rb#470
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#478
  def format(q); end
end

# ArgBlock represents using a block operator on an expression.
#
#     method(&expression)
#
# source://syntax_tree//lib/syntax_tree/node.rb#888
class SyntaxTree::ArgBlock < ::SyntaxTree::Node
  # @return [ArgBlock] a new instance of ArgBlock
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#894
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#930
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#900
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#904
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#892
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#908
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#904
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#921
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#925
  def format(q); end

  # [nil | Node] the expression being turned into a block
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#889
  def value; end
end

# ArgParen represents wrapping arguments to a method inside a set of
# parentheses.
#
#     method(argument)
#
# In the example above, there would be an ArgParen node around the Args node
# that represents the set of arguments being sent to the method method. The
# argument child node can be +nil+ if no arguments were passed, as in:
#
#     method()
#
# source://syntax_tree//lib/syntax_tree/node.rb#729
class SyntaxTree::ArgParen < ::SyntaxTree::Node
  # @return [ArgParen] a new instance of ArgParen
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#735
  def initialize(arguments:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#784
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#741
  def accept(visitor); end

  # [nil | Args | ArgsForward] the arguments inside the
  # parentheses
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#730
  def arguments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#788
  def arity; end

  # source://syntax_tree//lib/syntax_tree/node.rb#745
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#733
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#749
  def copy(arguments: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#745
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#762
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#766
  def format(q); end

  private

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#794
  def trailing_comma?; end
end

# Star represents using a splat operator on an expression.
#
#     method(*arguments)
#
# source://syntax_tree//lib/syntax_tree/node.rb#940
class SyntaxTree::ArgStar < ::SyntaxTree::Node
  # @return [ArgStar] a new instance of ArgStar
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#946
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#982
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#952
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#956
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#944
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#960
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#956
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#973
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#977
  def format(q); end

  # [nil | Node] the expression being splatted
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#941
  def value; end
end

# Args represents a list of arguments being passed to a method call or array
# literal.
#
#     method(first, second, third)
#
# source://syntax_tree//lib/syntax_tree/node.rb#822
class SyntaxTree::Args < ::SyntaxTree::Node
  # @return [Args] a new instance of Args
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#828
  def initialize(parts:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#863
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#834
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#867
  def arity; end

  # source://syntax_tree//lib/syntax_tree/node.rb#838
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#826
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#842
  def copy(parts: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#838
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#855
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#859
  def format(q); end

  # [Array[ Node ]] the arguments that this node wraps
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#823
  def parts; end
end

# ArgsForward represents forwarding all kinds of arguments onto another method
# call.
#
#     def request(method, path, **headers, &block); end
#
#     def get(...)
#       request(:GET, ...)
#     end
#
#     def post(...)
#       request(:POST, ...)
#     end
#
# In the example above, both the get and post methods are forwarding all of
# their arguments (positional, keyword, and block) on to the request method.
# The ArgsForward node appears in both the caller (the request method calls)
# and the callee (the get and post definitions).
#
# source://syntax_tree//lib/syntax_tree/node.rb#1005
class SyntaxTree::ArgsForward < ::SyntaxTree::Node
  # @return [ArgsForward] a new instance of ArgsForward
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1008
  def initialize(location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1038
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1013
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1042
  def arity; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1017
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1006
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1021
  def copy(location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1017
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1030
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1034
  def format(q); end
end

# ArrayLiteral represents an array literal, which can optionally contain
# elements.
#
#     []
#     [one, two, three]
#
# source://syntax_tree//lib/syntax_tree/node.rb#1056
class SyntaxTree::ArrayLiteral < ::SyntaxTree::Node
  # @return [ArrayLiteral] a new instance of ArrayLiteral
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1153
  def initialize(lbracket:, contents:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1229
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1160
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1164
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1151
  def comments; end

  # [nil | Args] the contents of the array
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1148
  def contents; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1168
  def copy(lbracket: T.unsafe(nil), contents: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1164
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1182
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1191
  def format(q); end

  # [nil | LBracket | QSymbolsBeg | QWordsBeg | SymbolsBeg | WordsBeg] the
  # bracket that opens this array
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1145
  def lbracket; end

  private

  # If we have an empty array that contains only comments, then we're going
  # to do some special printing to ensure they get indented correctly.
  #
  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1259
  def empty_with_comments?; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1251
  def qsymbols?; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1236
  def qwords?; end
end

# source://syntax_tree//lib/syntax_tree/node.rb#1063
SyntaxTree::ArrayLiteral::BREAKABLE_SPACE_SEPARATOR = T.let(T.unsafe(nil), SyntaxTree::ArrayLiteral::BreakableSpaceSeparator)

# It's very common to use seplist with ->(q) { q.breakable_space }. We wrap
# that pattern into an object to cut down on having to create a bunch of
# lambdas all over the place.
#
# source://syntax_tree//lib/syntax_tree/node.rb#1057
class SyntaxTree::ArrayLiteral::BreakableSpaceSeparator
  # source://syntax_tree//lib/syntax_tree/node.rb#1058
  def call(q); end
end

# This is a special formatter used if the array literal contains no values
# but _does_ contain comments. In this case we do some special formatting to
# make sure the comments gets indented properly.
#
# source://syntax_tree//lib/syntax_tree/node.rb#1120
class SyntaxTree::ArrayLiteral::EmptyWithCommentsFormatter
  # @return [EmptyWithCommentsFormatter] a new instance of EmptyWithCommentsFormatter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1124
  def initialize(lbracket); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1128
  def format(q); end

  # [LBracket] the opening bracket
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1122
  def lbracket; end
end

# Formats an array of multiple simple symbol literals into the %i syntax.
#
# source://syntax_tree//lib/syntax_tree/node.rb#1094
class SyntaxTree::ArrayLiteral::QSymbolsFormatter
  # @return [QSymbolsFormatter] a new instance of QSymbolsFormatter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1098
  def initialize(contents); end

  # [Args] the contents of the array
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1096
  def contents; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1102
  def format(q); end
end

# Formats an array of multiple simple string literals into the %w syntax.
#
# source://syntax_tree//lib/syntax_tree/node.rb#1066
class SyntaxTree::ArrayLiteral::QWordsFormatter
  # @return [QWordsFormatter] a new instance of QWordsFormatter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1070
  def initialize(contents); end

  # [Args] the contents of the array
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1068
  def contents; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1074
  def format(q); end
end

# When we're implementing the === operator for a node, we oftentimes need to
# compare two arrays. We want to skip over the === definition of array and use
# our own here, so we do that using this module.
#
# source://syntax_tree//lib/syntax_tree/node.rb#157
module SyntaxTree::ArrayMatch
  class << self
    # source://syntax_tree//lib/syntax_tree/node.rb#158
    def call(left, right); end
  end
end

# AryPtn represents matching against an array pattern using the Ruby 2.7+
# pattern matching syntax. It’s one of the more complicated nodes, because
# the four parameters that it accepts can almost all be nil.
#
#     case [1, 2, 3]
#     in [Integer, Integer]
#       "matched"
#     in Container[Integer, Integer]
#       "matched"
#     in [Integer, *, Integer]
#       "matched"
#     end
#
# An AryPtn node is created with four parameters: an optional constant
# wrapper, an array of positional matches, an optional splat with identifier,
# and an optional array of positional matches that occur after the splat.
# All of the in clauses above would create an AryPtn node.
#
# source://syntax_tree//lib/syntax_tree/node.rb#1283
class SyntaxTree::AryPtn < ::SyntaxTree::Node
  # @return [AryPtn] a new instance of AryPtn
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1320
  def initialize(constant:, requireds:, rest:, posts:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1388
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1329
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1333
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1318
  def comments; end

  # [nil | VarRef | ConstPathRef] the optional constant wrapper
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1303
  def constant; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1337
  def copy(constant: T.unsafe(nil), requireds: T.unsafe(nil), rest: T.unsafe(nil), posts: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1333
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1359
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1370
  def format(q); end

  # [Array[ Node ]] the list of positional arguments occurring after the
  # optional star if there is one
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1315
  def posts; end

  # [Array[ Node ]] the regular positional arguments that this array
  # pattern is matching against
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1307
  def requireds; end

  # [nil | VarField] the optional starred identifier that grabs up a list of
  # positional arguments
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1311
  def rest; end
end

# Formats the optional splat of an array pattern.
#
# source://syntax_tree//lib/syntax_tree/node.rb#1284
class SyntaxTree::AryPtn::RestFormatter
  # @return [RestFormatter] a new instance of RestFormatter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1288
  def initialize(value); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1292
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1296
  def format(q); end

  # [VarField] the identifier that represents the remaining positionals
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1286
  def value; end
end

# Assign represents assigning something to a variable or constant. Generally,
# the left side of the assignment is going to be any node that ends with the
# name "Field".
#
#     variable = value
#
# source://syntax_tree//lib/syntax_tree/node.rb#1420
class SyntaxTree::Assign < ::SyntaxTree::Node
  # @return [Assign] a new instance of Assign
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1429
  def initialize(target:, value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1479
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1436
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1440
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1427
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1444
  def copy(target: T.unsafe(nil), value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1440
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1458
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1462
  def format(q); end

  # [ARefField | ConstPathField | Field | TopConstField | VarField] the target
  # to assign the result of the expression to
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1421
  def target; end

  # [Node] the expression to be assigned
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1424
  def value; end

  private

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1485
  def skip_indent?; end
end

# Determins if the following value should be indented or not.
#
# source://syntax_tree//lib/syntax_tree/node.rb#1396
module SyntaxTree::AssignFormatting
  class << self
    # @return [Boolean]
    #
    # source://syntax_tree//lib/syntax_tree/node.rb#1397
    def skip_indent?(value); end
  end
end

# Assoc represents a key-value pair within a hash. It is a child node of
# either an AssocListFromArgs or a BareAssocHash.
#
#     { key1: value1, key2: value2 }
#
# In the above example, the would be two Assoc nodes.
#
# source://syntax_tree//lib/syntax_tree/node.rb#1498
class SyntaxTree::Assoc < ::SyntaxTree::Node
  # @return [Assoc] a new instance of Assoc
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1507
  def initialize(key:, value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1548
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1514
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1518
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1505
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1522
  def copy(key: T.unsafe(nil), value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1518
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1536
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1540
  def format(q); end

  # [Node] the key of this pair
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1499
  def key; end

  # [nil | Node] the value of this pair
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1502
  def value; end

  private

  # source://syntax_tree//lib/syntax_tree/node.rb#1554
  def format_contents(q); end
end

# AssocSplat represents double-splatting a value into a hash (either a hash
# literal or a bare hash in a method call).
#
#     { **pairs }
#
# source://syntax_tree//lib/syntax_tree/node.rb#1576
class SyntaxTree::AssocSplat < ::SyntaxTree::Node
  # @return [AssocSplat] a new instance of AssocSplat
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1582
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1618
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1588
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1592
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1580
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1596
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1592
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1609
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1613
  def format(q); end

  # [nil | Node] the expression that is being splatted
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1577
  def value; end
end

# BEGINBlock represents the use of the +BEGIN+ keyword, which hooks into the
# lifecycle of the interpreter. Whatever is inside the block will get executed
# when the program starts.
#
#     BEGIN {
#     }
#
# Interestingly, the BEGIN keyword doesn't allow the do and end keywords for
# the block. Only braces are permitted.
#
# source://syntax_tree//lib/syntax_tree/node.rb#176
class SyntaxTree::BEGINBlock < ::SyntaxTree::Node
  # @return [BEGINBlock] a new instance of BEGINBlock
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#185
  def initialize(lbrace:, statements:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#236
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#192
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#196
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#183
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#200
  def copy(lbrace: T.unsafe(nil), statements: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#196
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#214
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#223
  def format(q); end

  # [LBrace] the left brace that is seen after the keyword
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#177
  def lbrace; end

  # [Statements] the expressions to be executed
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#180
  def statements; end
end

# Backref represents a global variable referencing a matched value. It comes
# in the form of a $ followed by a positive integer.
#
#     $1
#
# source://syntax_tree//lib/syntax_tree/node.rb#1629
class SyntaxTree::Backref < ::SyntaxTree::Node
  # @return [Backref] a new instance of Backref
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1635
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1670
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1641
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1645
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1633
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1649
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1645
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1662
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1666
  def format(q); end

  # [String] the name of the global backreference variable
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1630
  def value; end
end

# Backtick represents the use of the ` operator. It's usually found being used
# for an XStringLiteral, but could also be found as the name of a method being
# defined.
#
# source://syntax_tree//lib/syntax_tree/node.rb#1679
class SyntaxTree::Backtick < ::SyntaxTree::Node
  # @return [Backtick] a new instance of Backtick
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1685
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1720
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1691
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1695
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1683
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1699
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1695
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1712
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1716
  def format(q); end

  # [String] the backtick in the string
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1680
  def value; end
end

# BareAssocHash represents a hash of contents being passed as a method
# argument (and therefore has omitted braces). It's very similar to an
# AssocListFromArgs node.
#
#     method(key1: value1, key2: value2)
#
# source://syntax_tree//lib/syntax_tree/node.rb#1835
class SyntaxTree::BareAssocHash < ::SyntaxTree::Node
  # @return [BareAssocHash] a new instance of BareAssocHash
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1841
  def initialize(assocs:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1876
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1847
  def accept(visitor); end

  # [Array[ Assoc | AssocSplat ]]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1836
  def assocs; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1851
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1839
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1855
  def copy(assocs: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1851
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1868
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1872
  def format(q); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1880
  def format_key(q, key); end
end

# BasicVisitor is the parent class of the Visitor class that provides the
# ability to walk down the tree. It does not define any handlers, so you
# should extend this class if you want your visitor to raise an error if you
# attempt to visit a node that you don't handle.
#
# source://syntax_tree//lib/syntax_tree/basic_visitor.rb#8
class SyntaxTree::BasicVisitor
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#105
  def visit(node); end

  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#109
  def visit_all(nodes); end

  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_child_nodes(node); end

  class << self
    # This is the list of all of the valid visit methods.
    #
    # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#72
    def valid_visit_methods; end

    # This method is here to help folks write visitors.
    #
    # It's not always easy to ensure you're writing the correct method name in
    # the visitor since it's perfectly valid to define methods that don't
    # override these parent methods.
    #
    # If you use this method, you can ensure you're writing the correct method
    # name. It will raise an error if the visit method you're defining isn't
    # actually a method on the parent visitor.
    #
    # @raise [VisitMethodError]
    #
    # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#86
    def visit_method(method_name); end

    # This method is here to help folks write visitors.
    #
    # Within the given block, every method that is defined will be checked to
    # ensure it's a valid visit method using the BasicVisitor::visit_method
    # method defined above.
    #
    # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#97
    def visit_methods; end
  end
end

# This class is used by DidYouMean to offer corrections to invalid visit
# method names.
#
# source://syntax_tree//lib/syntax_tree/basic_visitor.rb#22
class SyntaxTree::BasicVisitor::VisitMethodChecker
  # @return [VisitMethodChecker] a new instance of VisitMethodChecker
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#25
  def initialize(error); end

  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#29
  def corrections; end

  # Returns the value of attribute visit_method.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#23
  def visit_method; end
end

# This is raised when you use the Visitor.visit_method method and it fails.
# It is correctable to through DidYouMean.
#
# source://syntax_tree//lib/syntax_tree/basic_visitor.rb#11
class SyntaxTree::BasicVisitor::VisitMethodError < ::StandardError
  include ::DidYouMean::Correctable

  # @return [VisitMethodError] a new instance of VisitMethodError
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#14
  def initialize(visit_method); end

  # Returns the value of attribute visit_method.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#12
  def visit_method; end
end

# This module is responsible for checking all of the methods defined within
# a given block to ensure that they are valid visit methods.
#
# source://syntax_tree//lib/syntax_tree/basic_visitor.rb#45
class SyntaxTree::BasicVisitor::VisitMethodsChecker < ::Module
  # @return [VisitMethodsChecker] a new instance of VisitMethodsChecker
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#53
  def initialize; end

  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#65
  def disable!; end

  # This is the status of the checker. It's used to determine whether or not
  # we should be checking the methods that are defined. It is kept as an
  # instance variable so that it can be disabled later.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#51
  def status; end
end

# source://syntax_tree//lib/syntax_tree/basic_visitor.rb#46
class SyntaxTree::BasicVisitor::VisitMethodsChecker::Status < ::Struct
  # Returns the value of attribute checking
  #
  # @return [Object] the current value of checking
  def checking; end

  # Sets the attribute checking
  #
  # @param value [Object] the value to set the attribute checking to.
  # @return [Object] the newly set value
  def checking=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Begin represents a begin..end chain.
#
#     begin
#       value
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#1900
class SyntaxTree::Begin < ::SyntaxTree::Node
  # @return [Begin] a new instance of Begin
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1906
  def initialize(bodystmt:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1951
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1912
  def accept(visitor); end

  # [BodyStmt] the bodystmt that contains the contents of this begin block
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1901
  def bodystmt; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1916
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1904
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1920
  def copy(bodystmt: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1916
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1933
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1937
  def format(q); end
end

# Binary represents any expression that involves two sub-expressions with an
# operator in between. This can be something that looks like a mathematical
# operation:
#
#     1 + 1
#
# but can also be something like pushing a value onto an array:
#
#     array << value
#
# source://syntax_tree//lib/syntax_tree/node.rb#2033
class SyntaxTree::Binary < ::SyntaxTree::Node
  # @return [Binary] a new instance of Binary
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2056
  def initialize(left:, operator:, right:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2128
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2064
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2068
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2054
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#2072
  def copy(left: T.unsafe(nil), operator: T.unsafe(nil), right: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2068
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#2087
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2097
  def format(q); end

  # [Node] the left-hand side of the expression
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2045
  def left; end

  # [Symbol] the operator used between the two expressions
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2048
  def operator; end

  # [Node] the right-hand side of the expression
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2051
  def right; end
end

# BlockArg represents declaring a block parameter on a method definition.
#
#     def method(&block); end
#
# source://syntax_tree//lib/syntax_tree/node.rb#2228
class SyntaxTree::BlockArg < ::SyntaxTree::Node
  # @return [BlockArg] a new instance of BlockArg
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2234
  def initialize(name:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2270
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2240
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2244
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2232
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#2248
  def copy(name: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2244
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#2261
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2265
  def format(q); end

  # [nil | Ident] the name of the block argument
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2229
  def name; end
end

# Block represents passing a block to a method call using the +do+ and +end+
# keywords or the +{+ and +}+ operators.
#
#     method do |value|
#     end
#
#     method { |value| }
#
# source://syntax_tree//lib/syntax_tree/node.rb#4313
class SyntaxTree::BlockNode < ::SyntaxTree::Node
  # @return [BlockNode] a new instance of BlockNode
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4347
  def initialize(opening:, block_var:, bodystmt:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4420
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4355
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4429
  def arity; end

  # [nil | BlockVar] the optional variable declaration within this block
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4339
  def block_var; end

  # [BodyStmt | Statements] the expressions to be executed within this block
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4342
  def bodystmt; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4359
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4345
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4363
  def copy(opening: T.unsafe(nil), block_var: T.unsafe(nil), bodystmt: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4359
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4378
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4388
  def format(q); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4425
  def keywords?; end

  # [LBrace | Kw] the left brace or the do keyword that opens this block
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4336
  def opening; end

  private

  # If we're the predicate of a loop or conditional, then we're going to have
  # to go with the {..} bounds.
  #
  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4471
  def forced_brace_bounds?(q); end

  # If we're a sibling of a control-flow keyword, then we're going to have to
  # use the do..end bounds.
  #
  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4460
  def forced_do_end_bounds?(q); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4487
  def format_break(q, break_opening, break_closing); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4507
  def format_flat(q, flat_opening, flat_closing); end

  # If this is nested anywhere inside certain nodes, then we can't change
  # which operators/keywords we're using for the bounds of the block.
  #
  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4442
  def unchangeable_bounds?(q); end
end

# Formats the opening brace or keyword of a block.
#
# source://syntax_tree//lib/syntax_tree/node.rb#4314
class SyntaxTree::BlockNode::BlockOpenFormatter
  # @return [BlockOpenFormatter] a new instance of BlockOpenFormatter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4321
  def initialize(text, node); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4326
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4330
  def format(q); end

  # [LBrace | Keyword] the node that is being represented
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4319
  def node; end

  # [String] the actual output that should be printed
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4316
  def text; end
end

# BlockVar represents the parameters being declared for a block. Effectively
# this node is everything contained within the pipes. This includes all of the
# various parameter types, as well as block-local variable declarations.
#
#     method do |positional, optional = value, keyword:, &block; local|
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#2142
class SyntaxTree::BlockVar < ::SyntaxTree::Node
  # @return [BlockVar] a new instance of BlockVar
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2151
  def initialize(params:, locals:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2209
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2158
  def accept(visitor); end

  # When a single required parameter is declared for a block, it gets
  # automatically expanded if the values being yielded into it are an array.
  #
  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2216
  def arg0?; end

  # source://syntax_tree//lib/syntax_tree/node.rb#2162
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2149
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#2166
  def copy(params: T.unsafe(nil), locals: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2162
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#2180
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2196
  def format(q); end

  # [Array[ Ident ]] the list of block-local variable declarations
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2146
  def locals; end

  # [Params] the parameters being declared with the block
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2143
  def params; end
end

# We'll keep a single instance of this separator around for all block vars
# to cut down on allocations.
#
# source://syntax_tree//lib/syntax_tree/node.rb#2194
SyntaxTree::BlockVar::SEPARATOR = T.let(T.unsafe(nil), SyntaxTree::BlockVar::Separator)

# Within the pipes of the block declaration, we don't want any spaces. So
# we'll separate the parameters with a comma and space but no breakables.
#
# source://syntax_tree//lib/syntax_tree/node.rb#2186
class SyntaxTree::BlockVar::Separator
  # source://syntax_tree//lib/syntax_tree/node.rb#2187
  def call(q); end
end

# bodystmt can't actually determine its bounds appropriately because it
# doesn't necessarily know where it started. So the parent node needs to
# report back down into this one where it goes.
#
# source://syntax_tree//lib/syntax_tree/node.rb#2279
class SyntaxTree::BodyStmt < ::SyntaxTree::Node
  # @return [BodyStmt] a new instance of BodyStmt
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2297
  def initialize(statements:, rescue_clause:, else_keyword:, else_clause:, ensure_clause:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2428
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2352
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2314
  def bind(parser, start_char, start_column, end_char, end_column); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2356
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2295
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#2360
  def copy(statements: T.unsafe(nil), rescue_clause: T.unsafe(nil), else_keyword: T.unsafe(nil), else_clause: T.unsafe(nil), ensure_clause: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2356
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#2384
  def deconstruct_keys(_keys); end

  # [nil | Statements] the optional set of statements inside the else clause
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2289
  def else_clause; end

  # [nil | Kw] the optional else keyword
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2286
  def else_keyword; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2348
  def empty?; end

  # [nil | Ensure] the optional ensure clause
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2292
  def ensure_clause; end

  # source://syntax_tree//lib/syntax_tree/node.rb#2396
  def format(q); end

  # [nil | Rescue] the optional rescue chain attached to the begin clause
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2283
  def rescue_clause; end

  # [Statements] the list of statements inside the begin clause
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2280
  def statements; end
end

# Break represents using the +break+ keyword.
#
#     break
#
# It can also optionally accept arguments, as in:
#
#     break 1
#
# source://syntax_tree//lib/syntax_tree/node.rb#2635
class SyntaxTree::Break < ::SyntaxTree::Node
  # @return [Break] a new instance of Break
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2641
  def initialize(arguments:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2676
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2647
  def accept(visitor); end

  # [Args] the arguments being sent to the keyword
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2636
  def arguments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#2651
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2639
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#2655
  def copy(arguments: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2651
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#2668
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2672
  def format(q); end
end

# CHAR irepresents a single codepoint in the script encoding.
#
#     ?a
#
# In the example above, the CHAR node represents the string literal "a". You
# can use control characters with this as well, as in ?\C-a.
#
# source://syntax_tree//lib/syntax_tree/node.rb#249
class SyntaxTree::CHAR < ::SyntaxTree::Node
  # @return [CHAR] a new instance of CHAR
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#255
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#296
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#261
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#265
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#253
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#269
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#265
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#282
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#286
  def format(q); end

  # [String] the value of the character literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#250
  def value; end
end

# CVar represents the use of a class variable.
#
#     @@variable
#
# source://syntax_tree//lib/syntax_tree/node.rb#4047
class SyntaxTree::CVar < ::SyntaxTree::Node
  # @return [CVar] a new instance of CVar
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4053
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4088
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4059
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4063
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4051
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4067
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4063
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4080
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4084
  def format(q); end

  # [String] the name of the class variable
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4048
  def value; end
end

# This is probably the most complicated formatter in this file. It's
# responsible for formatting chains of method calls, with or without arguments
# or blocks. In general, we want to go from something like
#
#     foo.bar.baz
#
# to
#
#     foo
#       .bar
#       .baz
#
# Of course there are a lot of caveats to that, including trailing operators
# when necessary, where comments are places, how blocks are aligned, etc.
#
# source://syntax_tree//lib/syntax_tree/node.rb#2721
class SyntaxTree::CallChainFormatter
  # @return [CallChainFormatter] a new instance of CallChainFormatter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2725
  def initialize(node); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2729
  def format(q); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2795
  def format_chain(q, children); end

  # [CallNode | MethodAddBlock] the top of the call chain
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2723
  def node; end

  private

  # For certain nodes, we want to attach directly to the end and don't
  # want to indent the first call. So we'll pop off the first children and
  # format it separately here.
  #
  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2898
  def attach_directly?(node); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2908
  def format_child(q, child, skip_comments: T.unsafe(nil), skip_operator: T.unsafe(nil), skip_attached: T.unsafe(nil)); end

  class << self
    # @return [Boolean]
    #
    # source://syntax_tree//lib/syntax_tree/node.rb#2879
    def chained?(node); end
  end
end

# CallNode represents a method call.
#
#     receiver.message
#
# source://syntax_tree//lib/syntax_tree/node.rb#2947
class SyntaxTree::CallNode < ::SyntaxTree::Node
  # @return [CallNode] a new instance of CallNode
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2962
  def initialize(receiver:, operator:, message:, arguments:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3057
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2971
  def accept(visitor); end

  # [nil | ArgParen | Args] the arguments to the method call
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2957
  def arguments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3103
  def arity; end

  # source://syntax_tree//lib/syntax_tree/node.rb#2975
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2960
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#2984
  def copy(receiver: T.unsafe(nil), operator: T.unsafe(nil), message: T.unsafe(nil), arguments: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2975
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3006
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3017
  def format(q); end

  # Print out the arguments to this call. If there are no arguments, then do
  # nothing.
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3065
  def format_arguments(q); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3075
  def format_contents(q); end

  # [:call | Backtick | Const | Ident | Op] the message being sent
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2954
  def message; end

  # [nil | :"::" | Op | Period] the operator being used to send the message
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2951
  def operator; end

  # [nil | Node] the receiver of the method call
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2948
  def receiver; end
end

# Wraps a call operator (which can be a string literal :: or an Op node or a
# Period node) and formats it when called.
#
# source://syntax_tree//lib/syntax_tree/node.rb#2683
class SyntaxTree::CallOperatorFormatter
  # @return [CallOperatorFormatter] a new instance of CallOperatorFormatter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2687
  def initialize(operator); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2691
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#2695
  def format(q); end

  # [:"::" | Op | Period] the operator being formatted
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2685
  def operator; end
end

# Case represents the beginning of a case chain.
#
#     case value
#     when 1
#       "one"
#     when 2
#       "two"
#     else
#       "number"
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#3120
class SyntaxTree::Case < ::SyntaxTree::Node
  # @return [Case] a new instance of Case
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3132
  def initialize(keyword:, value:, consequent:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3190
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3140
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3144
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3130
  def comments; end

  # [In | When] the next clause in the chain
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3127
  def consequent; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3148
  def copy(keyword: T.unsafe(nil), value: T.unsafe(nil), consequent: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3144
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3163
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3173
  def format(q); end

  # [Kw] the keyword that opens this expression
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3121
  def keyword; end

  # [nil | Node] optional value being switched on
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3124
  def value; end
end

# Class represents defining a class using the +class+ keyword.
#
#     class Container
#     end
#
# Classes can have path names as their class name in case it's being nested
# under a namespace, as in:
#
#     class Namespace::Container
#     end
#
# Classes can also be defined as a top-level path, in the case that it's
# already in a namespace but you want to define it at the top-level instead,
# as in:
#
#     module OtherNamespace
#       class ::Namespace::Container
#       end
#     end
#
# All of these declarations can also have an optional superclass reference, as
# in:
#
#     class Child < Parent
#     end
#
# That superclass can actually be any Ruby expression, it doesn't necessarily
# need to be a constant, as in:
#
#     class Child < method
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#3317
class SyntaxTree::ClassDeclaration < ::SyntaxTree::Node
  # @return [ClassDeclaration] a new instance of ClassDeclaration
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3329
  def initialize(constant:, superclass:, bodystmt:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3392
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3337
  def accept(visitor); end

  # [BodyStmt] the expressions to execute within the context of the class
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3324
  def bodystmt; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3341
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3327
  def comments; end

  # [ConstPathRef | ConstRef | TopConstRef] the name of the class being
  # defined
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3318
  def constant; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3345
  def copy(constant: T.unsafe(nil), superclass: T.unsafe(nil), bodystmt: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3341
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3360
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3370
  def format(q); end

  # [nil | Node] the optional superclass declaration
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3321
  def superclass; end

  private

  # source://syntax_tree//lib/syntax_tree/node.rb#3399
  def format_declaration(q); end
end

# Comma represents the use of the , operator.
#
# source://syntax_tree//lib/syntax_tree/node.rb#3414
class SyntaxTree::Comma < ::SyntaxTree::Node
  # @return [Comma] a new instance of Comma
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3417
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3440
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3422
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3426
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3430
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3426
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3436
  def deconstruct_keys(_keys); end

  # [String] the comma in the string
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3415
  def value; end
end

# Command represents a method call with arguments and no parentheses. Note
# that Command nodes only happen when there is no explicit receiver for this
# method.
#
#     method argument
#
# source://syntax_tree//lib/syntax_tree/node.rb#3452
class SyntaxTree::Command < ::SyntaxTree::Node
  # @return [Command] a new instance of Command
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3464
  def initialize(message:, arguments:, block:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3514
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3472
  def accept(visitor); end

  # [Args] the arguments being sent with the message
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3456
  def arguments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3519
  def arity; end

  # [nil | BlockNode] the optional block being passed to the method
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3459
  def block; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3476
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3462
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3480
  def copy(message: T.unsafe(nil), arguments: T.unsafe(nil), block: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3476
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3495
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3505
  def format(q); end

  # [Const | Ident] the message being sent to the implicit receiver
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3453
  def message; end

  private

  # source://syntax_tree//lib/syntax_tree/node.rb#3525
  def align(q, node, &block); end
end

# CommandCall represents a method call on an object with arguments and no
# parentheses.
#
#     object.method argument
#
# source://syntax_tree//lib/syntax_tree/node.rb#3564
class SyntaxTree::CommandCall < ::SyntaxTree::Node
  # @return [CommandCall] a new instance of CommandCall
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3582
  def initialize(receiver:, operator:, message:, arguments:, block:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3686
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3599
  def accept(visitor); end

  # [nil | Args | ArgParen] the arguments going along with the message
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3574
  def arguments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3692
  def arity; end

  # [nil | BlockNode] the block associated with this method call
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3577
  def block; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3603
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3580
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3607
  def copy(receiver: T.unsafe(nil), operator: T.unsafe(nil), message: T.unsafe(nil), arguments: T.unsafe(nil), block: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3603
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3631
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3643
  def format(q); end

  # [:call | Const | Ident | Op] the message being send
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3571
  def message; end

  # [nil | :"::" | Op | Period] the operator used to send the message
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3568
  def operator; end

  # [nil | Node] the receiver of the message
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3565
  def receiver; end

  private

  # source://syntax_tree//lib/syntax_tree/node.rb#3698
  def argument_alignment(q, doc); end
end

# Comment represents a comment in the source.
#
#     # comment
#
# source://syntax_tree//lib/syntax_tree/node.rb#3726
class SyntaxTree::Comment < ::SyntaxTree::Node
  # @return [Comment] a new instance of Comment
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3734
  def initialize(value:, inline:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3793
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3767
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3771
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3763
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3775
  def copy(value: T.unsafe(nil), inline: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3771
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3785
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3789
  def format(q); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3759
  def ignore?; end

  # [boolean] whether or not there is code on the same line as this comment.
  # If there is, then inline will be true.
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3731
  def inline; end

  # [boolean] whether or not there is code on the same line as this comment.
  # If there is, then inline will be true.
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3731
  def inline?; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3743
  def leading!; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3747
  def leading?; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3751
  def trailing!; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3755
  def trailing?; end

  # [String] the contents of the comment
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3727
  def value; end
end

# Formats an If or Unless node.
#
# source://syntax_tree//lib/syntax_tree/node.rb#6317
class SyntaxTree::ConditionalFormatter
  # @return [ConditionalFormatter] a new instance of ConditionalFormatter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6324
  def initialize(keyword, node); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6329
  def format(q); end

  # [String] the keyword associated with this conditional
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6319
  def keyword; end

  # [If | Unless] the node that is being formatted
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6322
  def node; end

  private

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6453
  def contains_conditional?; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6388
  def format_break(q, force:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6380
  def format_flat(q); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6408
  def format_ternary(q); end
end

# Const represents a literal value that _looks_ like a constant. This could
# actually be a reference to a constant:
#
#     Constant
#
# It could also be something that looks like a constant in another context, as
# in a method call to a capitalized method:
#
#     object.Constant
#
# or a symbol that starts with a capital letter:
#
#     :Constant
#
# source://syntax_tree//lib/syntax_tree/node.rb#3813
class SyntaxTree::Const < ::SyntaxTree::Node
  # @return [Const] a new instance of Const
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3819
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3854
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3825
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3829
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3817
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3833
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3829
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3846
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3850
  def format(q); end

  # [String] the name of the constant
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3814
  def value; end
end

# ConstPathField represents the child node of some kind of assignment. It
# represents when you're assigning to a constant that is being referenced as
# a child of another variable.
#
#     object::Const = value
#
# source://syntax_tree//lib/syntax_tree/node.rb#3866
class SyntaxTree::ConstPathField < ::SyntaxTree::Node
  # @return [ConstPathField] a new instance of ConstPathField
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3875
  def initialize(parent:, constant:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3919
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3882
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3886
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3873
  def comments; end

  # [Const] the constant itself
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3870
  def constant; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3890
  def copy(parent: T.unsafe(nil), constant: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3886
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3904
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3913
  def format(q); end

  # [Node] the source of the constant
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3867
  def parent; end
end

# ConstPathRef represents referencing a constant by a path.
#
#     object::Const
#
# source://syntax_tree//lib/syntax_tree/node.rb#3930
class SyntaxTree::ConstPathRef < ::SyntaxTree::Node
  # @return [ConstPathRef] a new instance of ConstPathRef
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3939
  def initialize(parent:, constant:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3983
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3946
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3950
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3937
  def comments; end

  # [Const] the constant itself
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3934
  def constant; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3954
  def copy(parent: T.unsafe(nil), constant: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3950
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3968
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3977
  def format(q); end

  # [Node] the source of the constant
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3931
  def parent; end
end

# ConstRef represents the name of the constant being used in a class or module
# declaration.
#
#     class Container
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#3996
class SyntaxTree::ConstRef < ::SyntaxTree::Node
  # @return [ConstRef] a new instance of ConstRef
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4002
  def initialize(constant:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4037
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4008
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4012
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4000
  def comments; end

  # [Const] the constant itself
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3997
  def constant; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4016
  def copy(constant: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4012
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4029
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4033
  def format(q); end
end

# If the predicate of a conditional or loop contains an assignment (in which
# case we can't know for certain that that assignment doesn't impact the
# statements inside the conditional) then we can't use the modifier form
# and we must use the block form.
#
# source://syntax_tree//lib/syntax_tree/node.rb#6232
module SyntaxTree::ContainsAssignment
  class << self
    # source://syntax_tree//lib/syntax_tree/node.rb#6233
    def call(parent); end
  end
end

# The default indentation level for formatting. We allow changing this so
# that Syntax Tree can format arbitrary parts of a document.
#
# source://syntax_tree//lib/syntax_tree.rb#57
SyntaxTree::DEFAULT_INDENTATION = T.let(T.unsafe(nil), Integer)

# This is the default print width when formatting. It can be overridden in the
# CLI by passing the --print-width option or here in the API by passing the
# optional second argument to ::format.
#
# source://syntax_tree//lib/syntax_tree.rb#49
SyntaxTree::DEFAULT_PRINT_WIDTH = T.let(T.unsafe(nil), Integer)

# This is the default ruby version that we're going to target for formatting.
# It shouldn't really be changed except in very niche circumstances.
#
# source://syntax_tree//lib/syntax_tree.rb#53
SyntaxTree::DEFAULT_RUBY_VERSION = T.let(T.unsafe(nil), SyntaxTree::Formatter::SemanticVersion)

# This module provides shortcuts for creating AST nodes.
#
# source://syntax_tree//lib/syntax_tree/dsl.rb#5
module SyntaxTree::DSL
  # Create a new ARef node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#40
  def ARef(collection, index); end

  # Create a new ARefField node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#45
  def ARefField(collection, index); end

  # Create a new AliasNode node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#35
  def AliasNode(left, right); end

  # Create a new ArgBlock node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#64
  def ArgBlock(value); end

  # Create a new ArgParen node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#54
  def ArgParen(arguments); end

  # Create a new ArgStar node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#69
  def ArgStar(value); end

  # Create a new Args node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#59
  def Args(parts); end

  # Create a new ArgsForward node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#74
  def ArgsForward; end

  # Create a new ArrayLiteral node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#79
  def ArrayLiteral(lbracket, contents); end

  # Create a new AryPtn node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#88
  def AryPtn(constant, requireds, rest, posts); end

  # Create a new Assign node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#99
  def Assign(target, value); end

  # Create a new Assoc node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#104
  def Assoc(key, value); end

  # Create a new AssocSplat node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#109
  def AssocSplat(value); end

  # Create a new BEGINBlock node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#7
  def BEGINBlock(lbrace, statements); end

  # Create a new Backref node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#114
  def Backref(value); end

  # Create a new Backtick node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#119
  def Backtick(value); end

  # Create a new BareAssocHash node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#124
  def BareAssocHash(assocs); end

  # Create a new Begin node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#129
  def Begin(bodystmt); end

  # Create a new Binary node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#139
  def Binary(left, operator, right); end

  # Create a new BlockArg node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#154
  def BlockArg(name); end

  # Create a new BlockNode node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#317
  def BlockNode(opening, block_var, bodystmt); end

  # Create a new BlockVar node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#149
  def BlockVar(params, locals); end

  # Create a new BodyStmt node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#159
  def BodyStmt(statements, rescue_clause, else_keyword, else_clause, ensure_clause); end

  # Create a new Break node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#177
  def Break(arguments); end

  # Create a new CHAR node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#16
  def CHAR(value); end

  # Create a new CVar node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#288
  def CVar(value); end

  # Create a new CallNode node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#182
  def CallNode(receiver, operator, message, arguments); end

  # Create a new Case node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#193
  def Case(keyword, value, consequent); end

  # Create a new ClassDeclaration node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#213
  def ClassDeclaration(constant, superclass, bodystmt, location = T.unsafe(nil)); end

  # Create a new Comma node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#228
  def Comma(value); end

  # Create a new Command node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#233
  def Command(message, arguments, block, location = T.unsafe(nil)); end

  # Create a new CommandCall node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#243
  def CommandCall(receiver, operator, message, arguments, block); end

  # Create a new Comment node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#255
  def Comment(value, inline, location = T.unsafe(nil)); end

  # Create a new Const node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#260
  def Const(value); end

  # Create a new ConstPathField node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#265
  def ConstPathField(parent, constant); end

  # Create a new ConstPathRef node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#274
  def ConstPathRef(parent, constant); end

  # Create a new ConstRef node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#283
  def ConstRef(constant); end

  # Create a new DefNode node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#293
  def DefNode(target, operator, name, params, bodystmt, location = T.unsafe(nil)); end

  # Create a new Defined node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#312
  def Defined(value); end

  # Create a new DynaSymbol node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#337
  def DynaSymbol(parts, quote); end

  # Create a new ENDBlock node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#21
  def ENDBlock(lbrace, statements); end

  # Create a new Else node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#342
  def Else(keyword, statements); end

  # Create a new Elsif node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#351
  def Elsif(predicate, statements, consequent); end

  # Create a new EmbDoc node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#361
  def EmbDoc(value); end

  # Create a new EmbExprBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#366
  def EmbExprBeg(value); end

  # Create a new EmbExprEnd node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#371
  def EmbExprEnd(value); end

  # Create a new EmbVar node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#376
  def EmbVar(value); end

  # Create a new EndContent node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#30
  def EndContent(value); end

  # Create a new Ensure node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#381
  def Ensure(keyword, statements); end

  # Create a new ExcessedComma node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#390
  def ExcessedComma(value); end

  # Create a new Field node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#395
  def Field(parent, operator, name); end

  # Create a new FloatLiteral node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#405
  def FloatLiteral(value); end

  # Create a new FndPtn node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#410
  def FndPtn(constant, left, values, right); end

  # Create a new For node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#421
  def For(index, collection, statements); end

  # Create a new GVar node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#431
  def GVar(value); end

  # Create a new HashLiteral node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#436
  def HashLiteral(lbrace, assocs); end

  # Create a new Heredoc node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#445
  def Heredoc(beginning, ending, dedent, parts); end

  # Create a new HeredocBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#456
  def HeredocBeg(value); end

  # Create a new HeredocEnd node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#461
  def HeredocEnd(value); end

  # Create a new HshPtn node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#466
  def HshPtn(constant, keywords, keyword_rest); end

  # Create a new IVar node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#521
  def IVar(value); end

  # Create a new Ident node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#476
  def Ident(value); end

  # Create a new IfNode node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#481
  def IfNode(predicate, statements, consequent); end

  # Create a new IfOp node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#491
  def IfOp(predicate, truthy, falsy); end

  # Create a new Imaginary node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#501
  def Imaginary(value); end

  # Create a new In node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#506
  def In(pattern, statements, consequent); end

  # Create a new Int node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#516
  def Int(value); end

  # Create a new Kw node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#526
  def Kw(value); end

  # Create a new KwRestParam node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#531
  def KwRestParam(name); end

  # Create a new LBrace node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#560
  def LBrace(value); end

  # Create a new LBracket node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#565
  def LBracket(value); end

  # Create a new LParen node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#570
  def LParen(value); end

  # Create a new Label node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#536
  def Label(value); end

  # Create a new LabelEnd node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#541
  def LabelEnd(value); end

  # Create a new Lambda node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#546
  def Lambda(params, statements); end

  # Create a new LambdaVar node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#555
  def LambdaVar(params, locals); end

  # Create a new MAssign node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#575
  def MAssign(target, value); end

  # Create a new MLHS node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#585
  def MLHS(parts, comma); end

  # Create a new MLHSParen node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#590
  def MLHSParen(contents, comma); end

  # Create a new MRHS node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#608
  def MRHS(parts); end

  # Create a new MethodAddBlock node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#580
  def MethodAddBlock(call, block, location = T.unsafe(nil)); end

  # Create a new ModuleDeclaration node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#599
  def ModuleDeclaration(constant, bodystmt); end

  # Create a new Next node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#613
  def Next(arguments); end

  # Create a new Not node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#892
  def Not(statement, parentheses); end

  # Create a new Op node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#618
  def Op(value); end

  # Create a new OpAssign node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#623
  def OpAssign(target, operator, value); end

  # Create a new Params node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#633
  def Params(requireds, optionals, rest, posts, keywords, keyword_rest, block); end

  # Create a new Paren node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#647
  def Paren(lparen, contents); end

  # Create a new Period node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#652
  def Period(value); end

  # Create a new PinnedBegin node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#134
  def PinnedBegin(statement); end

  # Create a new PinnedVarRef node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#944
  def PinnedVarRef(value); end

  # Create a new Program node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#657
  def Program(statements); end

  # Create a new QSymbols node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#662
  def QSymbols(beginning, elements); end

  # Create a new QSymbolsBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#671
  def QSymbolsBeg(value); end

  # Create a new QWords node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#676
  def QWords(beginning, elements); end

  # Create a new QWordsBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#685
  def QWordsBeg(value); end

  # Create a new RAssign node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#203
  def RAssign(value, operator, pattern); end

  # Create a new RBrace node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#695
  def RBrace(value); end

  # Create a new RBracket node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#700
  def RBracket(value); end

  # Create a new RParen node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#783
  def RParen(value); end

  # Create a new RangeNode node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#327
  def RangeNode(left, operator, right); end

  # Create a new RationalLiteral node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#690
  def RationalLiteral(value); end

  # Create a new Redo node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#705
  def Redo; end

  # Create a new RegexpBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#719
  def RegexpBeg(value); end

  # Create a new RegexpContent node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#710
  def RegexpContent(beginning, parts); end

  # Create a new RegexpEnd node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#724
  def RegexpEnd(value); end

  # Create a new RegexpLiteral node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#729
  def RegexpLiteral(beginning, ending, parts); end

  # Create a new Rescue node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#748
  def Rescue(keyword, exception, statements, consequent); end

  # Create a new RescueEx node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#739
  def RescueEx(exceptions, variable); end

  # Create a new RescueMod node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#759
  def RescueMod(statement, value); end

  # Create a new RestParam node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#768
  def RestParam(name); end

  # Create a new Retry node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#773
  def Retry; end

  # Create a new ReturnNode node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#778
  def ReturnNode(arguments); end

  # Create a new SClass node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#788
  def SClass(target, bodystmt); end

  # Create a new Statements node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#793
  def Statements(body); end

  # Create a new StringConcat node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#803
  def StringConcat(left, right); end

  # Create a new StringContent node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#798
  def StringContent(parts); end

  # Create a new StringDVar node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#808
  def StringDVar(variable); end

  # Create a new StringEmbExpr node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#813
  def StringEmbExpr(statements); end

  # Create a new StringLiteral node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#818
  def StringLiteral(parts, quote); end

  # Create a new Super node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#823
  def Super(arguments); end

  # Create a new SymBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#828
  def SymBeg(value); end

  # Create a new SymbolContent node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#833
  def SymbolContent(value); end

  # Create a new SymbolLiteral node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#838
  def SymbolLiteral(value); end

  # Create a new Symbols node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#843
  def Symbols(beginning, elements); end

  # Create a new SymbolsBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#852
  def SymbolsBeg(value); end

  # Create a new TLamBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#862
  def TLamBeg(value); end

  # Create a new TLambda node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#857
  def TLambda(value); end

  # Create a new TStringBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#877
  def TStringBeg(value); end

  # Create a new TStringContent node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#882
  def TStringContent(value); end

  # Create a new TStringEnd node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#887
  def TStringEnd(value); end

  # Create a new TopConstField node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#867
  def TopConstField(constant); end

  # Create a new TopConstRef node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#872
  def TopConstRef(constant); end

  # Create a new Unary node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#901
  def Unary(operator, statement); end

  # Create a new Undef node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#910
  def Undef(symbols); end

  # Create a new UnlessNode node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#915
  def UnlessNode(predicate, statements, consequent); end

  # Create a new UntilNode node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#925
  def UntilNode(predicate, statements); end

  # Create a new VCall node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#949
  def VCall(value); end

  # Create a new VarField node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#934
  def VarField(value); end

  # Create a new VarRef node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#939
  def VarRef(value); end

  # Create a new VoidStmt node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#954
  def VoidStmt; end

  # Create a new When node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#959
  def When(arguments, statements, consequent); end

  # Create a new WhileNode node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#969
  def WhileNode(predicate, statements); end

  # Create a new Word node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#978
  def Word(parts); end

  # Create a new Words node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#983
  def Words(beginning, elements); end

  # Create a new WordsBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#992
  def WordsBeg(value); end

  # Create a new XString node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#997
  def XString(parts); end

  # Create a new XStringLiteral node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#1002
  def XStringLiteral(parts); end

  # Create a new YieldNode node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#1007
  def YieldNode(arguments); end

  # Create a new ZSuper node.
  #
  # source://syntax_tree//lib/syntax_tree/dsl.rb#1012
  def ZSuper; end
end

# Provides the ability to index source files into a database, then query for
# the nodes.
#
# source://syntax_tree//lib/syntax_tree/database.rb#6
module SyntaxTree::Database; end

# Query for the attributes of a node, optionally also filtering by type.
#
# source://syntax_tree//lib/syntax_tree/database.rb#99
class SyntaxTree::Database::AttrQuery
  # @return [AttrQuery] a new instance of AttrQuery
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#102
  def initialize(type, attrs); end

  # Returns the value of attribute attrs.
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#100
  def attrs; end

  # source://syntax_tree//lib/syntax_tree/database.rb#107
  def each(database, &block); end

  # Returns the value of attribute type.
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#100
  def type; end
end

# source://syntax_tree//lib/syntax_tree/database.rb#276
class SyntaxTree::Database::Connection
  # @return [Connection] a new instance of Connection
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#279
  def initialize(raw_connection); end

  # source://syntax_tree//lib/syntax_tree/database.rb#283
  def execute(query, binds = T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/database.rb#287
  def index_file(filepath); end

  # source://syntax_tree//lib/syntax_tree/database.rb#292
  def last_insert_row_id; end

  # source://syntax_tree//lib/syntax_tree/database.rb#296
  def prepare; end

  # Returns the value of attribute raw_connection.
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#277
  def raw_connection; end

  # source://syntax_tree//lib/syntax_tree/database.rb#326
  def search(query); end
end

# source://syntax_tree//lib/syntax_tree/database.rb#7
class SyntaxTree::Database::IndexingVisitor < ::SyntaxTree::FieldVisitor
  # @return [IndexingVisitor] a new instance of IndexingVisitor
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#10
  def initialize(database, filepath); end

  # Returns the value of attribute database.
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#8
  def database; end

  # Returns the value of attribute filepath.
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#8
  def filepath; end

  # Returns the value of attribute node_id.
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#8
  def node_id; end

  private

  # source://syntax_tree//lib/syntax_tree/database.rb#18
  def comments(node); end

  # source://syntax_tree//lib/syntax_tree/database.rb#21
  def field(name, value); end

  # source://syntax_tree//lib/syntax_tree/database.rb#31
  def list(name, values); end

  # source://syntax_tree//lib/syntax_tree/database.rb#41
  def node(node, _name); end

  # source://syntax_tree//lib/syntax_tree/database.rb#67
  def pairs(name, values); end

  # source://syntax_tree//lib/syntax_tree/database.rb#64
  def text(name, value); end
end

# Query for the results of either query.
#
# source://syntax_tree//lib/syntax_tree/database.rb#136
class SyntaxTree::Database::OrQuery
  # @return [OrQuery] a new instance of OrQuery
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#139
  def initialize(left, right); end

  # source://syntax_tree//lib/syntax_tree/database.rb#144
  def each(database, &block); end

  # Returns the value of attribute left.
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#137
  def left; end

  # Returns the value of attribute right.
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#137
  def right; end
end

# A pattern matching expression that will be compiled into a query.
#
# source://syntax_tree//lib/syntax_tree/database.rb#166
class SyntaxTree::Database::Pattern
  # @return [Pattern] a new instance of Pattern
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#172
  def initialize(query); end

  # source://syntax_tree//lib/syntax_tree/database.rb#176
  def compile; end

  # Returns the value of attribute query.
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#170
  def query; end

  private

  # Shortcut for combining two queries into one that returns the results of
  # if either query matches.
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#195
  def combine_or(left, right); end

  # in foo | bar
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#200
  def compile_binary(node); end

  # in Ident
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#207
  def compile_const(node); end

  # in SyntaxTree::Ident
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#219
  def compile_const_path_ref(node); end

  # @raise [CompilationError]
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#189
  def compile_error(node); end

  # in Ident[value: String]
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#234
  def compile_hshptn(node); end

  # source://syntax_tree//lib/syntax_tree/database.rb#258
  def compile_node(node); end

  # in Foo
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#248
  def compile_var_ref(node); end
end

# source://syntax_tree//lib/syntax_tree/database.rb#167
class SyntaxTree::Database::Pattern::CompilationError < ::StandardError; end

# A lazy query result.
#
# source://syntax_tree//lib/syntax_tree/database.rb#151
class SyntaxTree::Database::QueryResult
  # @return [QueryResult] a new instance of QueryResult
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#154
  def initialize(database, query); end

  # Returns the value of attribute database.
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#152
  def database; end

  # source://syntax_tree//lib/syntax_tree/database.rb#159
  def each(&block); end

  # Returns the value of attribute query.
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#152
  def query; end
end

# Query for a specific type of node.
#
# source://syntax_tree//lib/syntax_tree/database.rb#85
class SyntaxTree::Database::TypeQuery
  # @return [TypeQuery] a new instance of TypeQuery
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#88
  def initialize(type); end

  # source://syntax_tree//lib/syntax_tree/database.rb#92
  def each(database, &block); end

  # Returns the value of attribute type.
  #
  # source://syntax_tree//lib/syntax_tree/database.rb#86
  def type; end
end

# Def represents defining a regular method on the current self object.
#
#     def method(param) result end
#     def object.method(param) result end
#
# source://syntax_tree//lib/syntax_tree/node.rb#4099
class SyntaxTree::DefNode < ::SyntaxTree::Node
  # @return [DefNode] a new instance of DefNode
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4117
  def initialize(target:, operator:, name:, params:, bodystmt:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4217
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4127
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4230
  def arity; end

  # [BodyStmt | Node] the expressions to be executed by the method
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4112
  def bodystmt; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4131
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4115
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4135
  def copy(target: T.unsafe(nil), operator: T.unsafe(nil), name: T.unsafe(nil), params: T.unsafe(nil), bodystmt: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4131
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4159
  def deconstruct_keys(_keys); end

  # Returns true if the method was found in the source in the "endless" form,
  # i.e. where the method body is defined using the `=` operator after the
  # method name and parameters.
  #
  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4226
  def endless?; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4171
  def format(q); end

  # [Backtick | Const | Ident | Kw | Op] the name of the method
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4106
  def name; end

  # [nil | Op | Period] the operator being used to declare the method
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4103
  def operator; end

  # [nil | Params | Paren] the parameter declaration for the method
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4109
  def params; end

  # [nil | Node] the target where the method is being defined
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4100
  def target; end
end

# Defined represents the use of the +defined?+ operator. It can be used with
# and without parentheses.
#
#     defined?(variable)
#
# source://syntax_tree//lib/syntax_tree/node.rb#4250
class SyntaxTree::Defined < ::SyntaxTree::Node
  # @return [Defined] a new instance of Defined
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4256
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4299
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4262
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4266
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4254
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4270
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4266
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4283
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4287
  def format(q); end

  # [Node] the value being sent to the keyword
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4251
  def value; end
end

# DynaSymbol represents a symbol literal that uses quotes to dynamically
# define its value.
#
#     :"#{variable}"
#
# They can also be used as a special kind of dynamic hash key, as in:
#
#     { "#{key}": value }
#
# source://syntax_tree//lib/syntax_tree/node.rb#4665
class SyntaxTree::DynaSymbol < ::SyntaxTree::Node
  # @return [DynaSymbol] a new instance of DynaSymbol
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4674
  def initialize(parts:, quote:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4736
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4681
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4685
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4672
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4689
  def copy(parts: T.unsafe(nil), quote: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4685
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4703
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4707
  def format(q); end

  # [Array[ StringDVar | StringEmbExpr | TStringContent ]] the parts of the
  # dynamic symbol
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4666
  def parts; end

  # [nil | String] the quote used to delimit the dynamic symbol
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4669
  def quote; end

  private

  # Here we determine the quotes to use for a dynamic symbol. It's bound by a
  # lot of rules because it could be in many different contexts with many
  # different kinds of escaping.
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4746
  def quotes(q); end
end

# ENDBlock represents the use of the +END+ keyword, which hooks into the
# lifecycle of the interpreter. Whatever is inside the block will get executed
# when the program ends.
#
#     END {
#     }
#
# Interestingly, the END keyword doesn't allow the do and end keywords for the
# block. Only braces are permitted.
#
# source://syntax_tree//lib/syntax_tree/node.rb#311
class SyntaxTree::ENDBlock < ::SyntaxTree::Node
  # @return [ENDBlock] a new instance of ENDBlock
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#320
  def initialize(lbrace:, statements:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#371
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#327
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#331
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#318
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#335
  def copy(lbrace: T.unsafe(nil), statements: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#331
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#349
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#358
  def format(q); end

  # [LBrace] the left brace that is seen after the keyword
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#312
  def lbrace; end

  # [Statements] the expressions to be executed
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#315
  def statements; end
end

# Else represents the end of an +if+, +unless+, or +case+ chain.
#
#     if variable
#     else
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#4793
class SyntaxTree::Else < ::SyntaxTree::Node
  # @return [Else] a new instance of Else
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4802
  def initialize(keyword:, statements:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4853
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4809
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4813
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4800
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4817
  def copy(keyword: T.unsafe(nil), statements: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4813
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4831
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4840
  def format(q); end

  # [Kw] the else keyword
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4794
  def keyword; end

  # [Statements] the expressions to be executed
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4797
  def statements; end
end

# Elsif represents another clause in an +if+ or +unless+ chain.
#
#     if variable
#     elsif other_variable
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#4866
class SyntaxTree::Elsif < ::SyntaxTree::Node
  # @return [Elsif] a new instance of Elsif
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4878
  def initialize(predicate:, statements:, consequent:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4942
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4886
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4890
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4876
  def comments; end

  # [nil | Elsif | Else] the next clause in the chain
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4873
  def consequent; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4894
  def copy(predicate: T.unsafe(nil), statements: T.unsafe(nil), consequent: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4890
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4909
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4919
  def format(q); end

  # [Node] the expression to be checked
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4867
  def predicate; end

  # [Statements] the expressions to be executed
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4870
  def statements; end
end

# EmbDoc represents a multi-line comment.
#
#     =begin
#     first line
#     second line
#     =end
#
# source://syntax_tree//lib/syntax_tree/node.rb#4956
class SyntaxTree::EmbDoc < ::SyntaxTree::Node
  # @return [EmbDoc] a new instance of EmbDoc
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4959
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5027
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4995
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4999
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4991
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5003
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4999
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5012
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5016
  def format(q); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4987
  def ignore?; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4983
  def inline?; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4967
  def leading!; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4971
  def leading?; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4975
  def trailing!; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4979
  def trailing?; end

  # [String] the contents of the comment
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4957
  def value; end
end

# EmbExprBeg represents the beginning token for using interpolation inside of
# a parent node that accepts string content (like a string or regular
# expression).
#
#     "Hello, #{person}!"
#
# source://syntax_tree//lib/syntax_tree/node.rb#5039
class SyntaxTree::EmbExprBeg < ::SyntaxTree::Node
  # @return [EmbExprBeg] a new instance of EmbExprBeg
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5042
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5068
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5047
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5051
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5055
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5051
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5064
  def deconstruct_keys(_keys); end

  # [String] the #{ used in the string
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5040
  def value; end
end

# EmbExprEnd represents the ending token for using interpolation inside of a
# parent node that accepts string content (like a string or regular
# expression).
#
#     "Hello, #{person}!"
#
# source://syntax_tree//lib/syntax_tree/node.rb#5080
class SyntaxTree::EmbExprEnd < ::SyntaxTree::Node
  # @return [EmbExprEnd] a new instance of EmbExprEnd
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5083
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5109
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5088
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5092
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5096
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5092
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5105
  def deconstruct_keys(_keys); end

  # [String] the } used in the string
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5081
  def value; end
end

# EmbVar represents the use of shorthand interpolation for an instance, class,
# or global variable into a parent node that accepts string content (like a
# string or regular expression).
#
#     "#@variable"
#
# In the example above, an EmbVar node represents the # because it forces
#
# source://syntax_tree//lib/syntax_tree/node.rb#5123
class SyntaxTree::EmbVar < ::SyntaxTree::Node
  # @return [EmbVar] a new instance of EmbVar
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5126
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5152
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5131
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5135
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5139
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5135
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5148
  def deconstruct_keys(_keys); end

  # [String] the # used in the string
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5124
  def value; end
end

# EndContent represents the use of __END__ syntax, which allows individual
# scripts to keep content after the main ruby code that can be read through
# the DATA constant.
#
#     puts DATA.read
#
#     __END__
#     some other content that is not executed by the program
#
# source://syntax_tree//lib/syntax_tree/node.rb#387
class SyntaxTree::EndContent < ::SyntaxTree::Node
  # @return [EndContent] a new instance of EndContent
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#393
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#442
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#399
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#403
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#391
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#407
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#403
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#420
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#424
  def format(q); end

  # [String] the content after the script
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#388
  def value; end
end

# Ensure represents the use of the +ensure+ keyword and its subsequent
# statements.
#
#     begin
#     ensure
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#5165
class SyntaxTree::Ensure < ::SyntaxTree::Node
  # @return [Ensure] a new instance of Ensure
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5174
  def initialize(keyword:, statements:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5223
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5181
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5185
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5172
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5189
  def copy(keyword: T.unsafe(nil), statements: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5185
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5203
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5212
  def format(q); end

  # [Kw] the ensure keyword that began this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5166
  def keyword; end

  # [Statements] the expressions to be executed
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5169
  def statements; end
end

# ExcessedComma represents a trailing comma in a list of block parameters. It
# changes the block parameters such that they will destructure.
#
#     [[1, 2, 3], [2, 3, 4]].each do |first, second,|
#     end
#
# In the above example, an ExcessedComma node would appear in the third
# position of the Params node that is used to declare that block. The third
# position typically represents a rest-type parameter, but in this case is
# used to indicate that a trailing comma was used.
#
# source://syntax_tree//lib/syntax_tree/node.rb#5240
class SyntaxTree::ExcessedComma < ::SyntaxTree::Node
  # @return [ExcessedComma] a new instance of ExcessedComma
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5246
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5281
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5252
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5256
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5244
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5260
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5256
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5273
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5277
  def format(q); end

  # [String] the comma
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5241
  def value; end
end

# Field is always the child of an assignment. It represents assigning to a
# “field” on an object.
#
#     object.variable = value
#
# source://syntax_tree//lib/syntax_tree/node.rb#5292
class SyntaxTree::Field < ::SyntaxTree::Node
  # @return [Field] a new instance of Field
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5304
  def initialize(parent:, operator:, name:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5354
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5312
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5316
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5302
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5321
  def copy(parent: T.unsafe(nil), operator: T.unsafe(nil), name: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5316
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5336
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5346
  def format(q); end

  # [Const | Ident] the name of the field being assigned
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5299
  def name; end

  # [:"::" | Op | Period] the operator being used for the assignment
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5296
  def operator; end

  # [Node] the parent object that owns the field being assigned
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5293
  def parent; end
end

# This is the parent class of a lot of built-in visitors for Syntax Tree. It
# reflects visiting each of the fields on every node in turn. It itself does
# not do anything with these fields, it leaves that behavior up to the
# subclass to implement.
#
# In order to properly use this class, you will need to subclass it and
# implement #comments, #field, #list, #node, #pairs, and #text. Those are
# documented here.
#
# == comments(node)
#
# This accepts the node that is being visited and does something depending on
# the comments attached to the node.
#
# == field(name, value)
#
# This accepts the name of the field being visited as a string (like "value")
# and the actual value of that field. The value can be a subclass of Node or
# any other type that can be held within the tree.
#
# == list(name, values)
#
# This accepts the name of the field being visited as well as a list of
# values. This is used, for example, when visiting something like the body of
# a Statements node.
#
# == node(name, node)
#
# This is the parent serialization method for each node. It is called with the
# node itself, as well as the type of the node as a string. The type is an
# internally used value that usually resembles the name of the ripper event
# that generated the node. The method should yield to the given block which
# then calls through to visit each of the fields on the node.
#
# == text(name, value)
#
# This accepts the name of the field being visited as well as a string value
# representing the value of the field.
#
# == pairs(name, values)
#
# This accepts the name of the field being visited as well as a list of pairs
# that represent the value of the field. It is used only in a couple of
# circumstances, like when visiting the list of optional parameters defined on
# a method.
#
# source://syntax_tree//lib/syntax_tree/field_visitor.rb#50
class SyntaxTree::FieldVisitor < ::SyntaxTree::BasicVisitor
  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#163
  def visit_BEGIN(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#245
  def visit_CHAR(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#342
  def visit_END(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#1018
  def visit___end__(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#68
  def visit_alias(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#52
  def visit_aref(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#60
  def visit_aref_field(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#76
  def visit_arg_block(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#83
  def visit_arg_paren(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#90
  def visit_arg_star(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#97
  def visit_args(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#104
  def visit_args_forward(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#108
  def visit_array(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#115
  def visit_aryptn(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#125
  def visit_assign(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#133
  def visit_assoc(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#141
  def visit_assoc_splat(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#148
  def visit_backref(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#152
  def visit_backtick(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#156
  def visit_bare_assoc_hash(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#170
  def visit_begin(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#177
  def visit_binary(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#186
  def visit_block(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#201
  def visit_block_var(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#194
  def visit_blockarg(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#209
  def visit_bodystmt(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#219
  def visit_break(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#226
  def visit_call(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#236
  def visit_case(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#249
  def visit_class(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#258
  def visit_comma(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#262
  def visit_command(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#271
  def visit_command_call(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#282
  def visit_comment(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#286
  def visit_const(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#290
  def visit_const_path_field(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#298
  def visit_const_path_ref(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#306
  def visit_const_ref(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#313
  def visit_cvar(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#317
  def visit_def(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#328
  def visit_defined(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#335
  def visit_dyna_symbol(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#349
  def visit_else(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#356
  def visit_elsif(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#365
  def visit_embdoc(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#369
  def visit_embexpr_beg(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#373
  def visit_embexpr_end(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#377
  def visit_embvar(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#381
  def visit_ensure(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#388
  def visit_excessed_comma(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#392
  def visit_field(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#401
  def visit_float(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#405
  def visit_fndptn(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#415
  def visit_for(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#424
  def visit_gvar(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#428
  def visit_hash(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#435
  def visit_heredoc(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#442
  def visit_heredoc_beg(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#446
  def visit_heredoc_end(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#450
  def visit_hshptn(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#459
  def visit_ident(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#463
  def visit_if(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#472
  def visit_if_op(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#481
  def visit_imaginary(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#485
  def visit_in(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#494
  def visit_int(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#498
  def visit_ivar(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#502
  def visit_kw(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#506
  def visit_kwrest_param(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#513
  def visit_label(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#517
  def visit_label_end(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#521
  def visit_lambda(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#529
  def visit_lambda_var(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#537
  def visit_lbrace(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#541
  def visit_lbracket(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#545
  def visit_lparen(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#549
  def visit_massign(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#557
  def visit_method_add_block(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#565
  def visit_mlhs(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#572
  def visit_mlhs_paren(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#579
  def visit_module(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#587
  def visit_mrhs(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#594
  def visit_next(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#601
  def visit_not(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#608
  def visit_op(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#612
  def visit_opassign(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#621
  def visit_params(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#634
  def visit_paren(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#641
  def visit_period(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#645
  def visit_pinned_begin(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#652
  def visit_pinned_var_ref(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#659
  def visit_program(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#666
  def visit_qsymbols(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#673
  def visit_qsymbols_beg(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#677
  def visit_qwords(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#684
  def visit_qwords_beg(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#688
  def visit_range(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#697
  def visit_rassign(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#706
  def visit_rational(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#710
  def visit_rbrace(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#714
  def visit_rbracket(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#718
  def visit_redo(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#722
  def visit_regexp_beg(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#726
  def visit_regexp_content(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#730
  def visit_regexp_end(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#734
  def visit_regexp_literal(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#742
  def visit_rescue(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#751
  def visit_rescue_ex(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#759
  def visit_rescue_mod(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#767
  def visit_rest_param(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#774
  def visit_retry(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#778
  def visit_return(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#785
  def visit_rparen(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#789
  def visit_sclass(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#797
  def visit_statements(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#804
  def visit_string_concat(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#812
  def visit_string_content(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#816
  def visit_string_dvar(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#823
  def visit_string_embexpr(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#830
  def visit_string_literal(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#837
  def visit_super(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#844
  def visit_symbeg(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#848
  def visit_symbol_content(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#852
  def visit_symbol_literal(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#859
  def visit_symbols(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#866
  def visit_symbols_beg(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#870
  def visit_tlambda(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#874
  def visit_tlambeg(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#878
  def visit_top_const_field(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#885
  def visit_top_const_ref(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#892
  def visit_tstring_beg(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#896
  def visit_tstring_content(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#900
  def visit_tstring_end(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#904
  def visit_unary(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#912
  def visit_undef(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#919
  def visit_unless(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#928
  def visit_until(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#936
  def visit_var_field(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#943
  def visit_var_ref(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#950
  def visit_vcall(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#957
  def visit_void_stmt(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#961
  def visit_when(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#970
  def visit_while(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#978
  def visit_word(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#985
  def visit_words(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#992
  def visit_words_beg(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#996
  def visit_xstring(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#1000
  def visit_xstring_literal(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#1007
  def visit_yield(node); end

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#1014
  def visit_zsuper(node); end

  private

  # source://syntax_tree//lib/syntax_tree/field_visitor.rb#1025
  def visit_token(node, type); end
end

# FloatLiteral represents a floating point number literal.
#
#     1.0
#
# source://syntax_tree//lib/syntax_tree/node.rb#5365
class SyntaxTree::FloatLiteral < ::SyntaxTree::Node
  # @return [FloatLiteral] a new instance of FloatLiteral
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5371
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5406
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5377
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5381
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5369
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5385
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5381
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5398
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5402
  def format(q); end

  # [String] the value of the floating point number literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5366
  def value; end
end

# Formats either a Break, Next, or Return node.
#
# source://syntax_tree//lib/syntax_tree/node.rb#2438
class SyntaxTree::FlowControlFormatter
  # @return [FlowControlFormatter] a new instance of FlowControlFormatter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2445
  def initialize(keyword, node); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2450
  def format(q); end

  # [String] the keyword to print
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2440
  def keyword; end

  # [Break | Next | Return] the node being formatted
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2443
  def node; end

  private

  # source://syntax_tree//lib/syntax_tree/node.rb#2599
  def format_arguments(q, opening, closing); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2589
  def format_array_contents(q, array); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#2609
  def skip_parens?(node); end
end

# FndPtn represents matching against a pattern where you find a pattern in an
# array using the Ruby 3.0+ pattern matching syntax.
#
#     case value
#     in [*, 7, *]
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#5419
class SyntaxTree::FndPtn < ::SyntaxTree::Node
  # @return [FndPtn] a new instance of FndPtn
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5435
  def initialize(constant:, left:, values:, right:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5504
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5444
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5448
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5433
  def comments; end

  # [nil | VarRef | ConstPathRef] the optional constant wrapper
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5420
  def constant; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5452
  def copy(constant: T.unsafe(nil), left: T.unsafe(nil), values: T.unsafe(nil), right: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5448
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5468
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5479
  def format(q); end

  # [VarField] the splat on the left-hand side
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5423
  def left; end

  # [VarField] the splat on the right-hand side
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5430
  def right; end

  # [Array[ Node ]] the list of positional expressions in the pattern that
  # are being matched
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5427
  def values; end
end

# For represents using a +for+ loop.
#
#     for value in list do
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#5518
class SyntaxTree::For < ::SyntaxTree::Node
  # @return [For] a new instance of For
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5530
  def initialize(index:, collection:, statements:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5590
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5538
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5542
  def child_nodes; end

  # [Node] the object being enumerated in the loop
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5522
  def collection; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5528
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5546
  def copy(index: T.unsafe(nil), collection: T.unsafe(nil), statements: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5542
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5561
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5571
  def format(q); end

  # [MLHS | VarField] the variable declaration being used to
  # pull values out of the object being enumerated
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5519
  def index; end

  # [Statements] the statements to be executed
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5525
  def statements; end
end

# A slightly enhanced PP that knows how to format recursively including
# comments.
#
# source://syntax_tree//lib/syntax_tree/formatter.rb#9
class SyntaxTree::Formatter < ::PrettierPrint
  # @return [Formatter] a new instance of Formatter
  #
  # source://syntax_tree//lib/syntax_tree/formatter.rb#95
  def initialize(source, *args, options: T.unsafe(nil)); end

  # These options are overridden in plugins to we need to make sure they are
  # available here.
  #
  # source://syntax_tree//lib/syntax_tree/formatter.rb#87
  def disable_auto_ternary; end

  # These options are overridden in plugins to we need to make sure they are
  # available here.
  #
  # source://syntax_tree//lib/syntax_tree/formatter.rb#87
  def disable_auto_ternary?; end

  # source://syntax_tree//lib/syntax_tree/formatter.rb#115
  def format(node, stackable: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/formatter.rb#175
  def format_each(nodes); end

  # source://syntax_tree//lib/syntax_tree/formatter.rb#179
  def grandparent; end

  # This is a simplified version of prettyprint's group. It doesn't provide
  # any of the more advanced options because we don't need them and they take
  # up expensive computation time.
  #
  # source://syntax_tree//lib/syntax_tree/formatter.rb#194
  def group; end

  # source://syntax_tree//lib/syntax_tree/formatter.rb#183
  def parent; end

  # source://syntax_tree//lib/syntax_tree/formatter.rb#187
  def parents; end

  # These options are overridden in plugins to we need to make sure they are
  # available here.
  #
  # source://syntax_tree//lib/syntax_tree/formatter.rb#87
  def quote; end

  # A similar version to the super, except that it calls back into the
  # separator proc with the instance of `self`.
  #
  # source://syntax_tree//lib/syntax_tree/formatter.rb#208
  def seplist(list, sep = T.unsafe(nil), iter_method = T.unsafe(nil)); end

  # Returns the value of attribute source.
  #
  # source://syntax_tree//lib/syntax_tree/formatter.rb#83
  def source; end

  # Returns the value of attribute stack.
  #
  # source://syntax_tree//lib/syntax_tree/formatter.rb#83
  def stack; end

  # These options are overridden in plugins to we need to make sure they are
  # available here.
  #
  # source://syntax_tree//lib/syntax_tree/formatter.rb#87
  def target_ruby_version; end

  # This is a much simplified version of prettyprint's text. It avoids
  # calculating width by pushing the string directly onto the target.
  #
  # source://syntax_tree//lib/syntax_tree/formatter.rb#224
  def text(string); end

  # These options are overridden in plugins to we need to make sure they are
  # available here.
  #
  # source://syntax_tree//lib/syntax_tree/formatter.rb#87
  def trailing_comma; end

  # These options are overridden in plugins to we need to make sure they are
  # available here.
  #
  # source://syntax_tree//lib/syntax_tree/formatter.rb#87
  def trailing_comma?; end

  class << self
    # source://syntax_tree//lib/syntax_tree/formatter.rb#108
    def format(source, node, base_indentation = T.unsafe(nil)); end
  end
end

# source://syntax_tree//lib/syntax_tree/formatter.rb#80
SyntaxTree::Formatter::COMMENT_PRIORITY = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/formatter.rb#81
SyntaxTree::Formatter::HEREDOC_PRIORITY = T.let(T.unsafe(nil), Integer)

# We want to minimize as much as possible the number of options that are
# available in syntax tree. For the most part, if users want non-default
# formatting, they should override the format methods on the specific nodes
# themselves. However, because of some history with prettier and the fact
# that folks have become entrenched in their ways, we decided to provide a
# small amount of configurability.
#
# source://syntax_tree//lib/syntax_tree/formatter.rb#23
class SyntaxTree::Formatter::Options
  # @return [Options] a new instance of Options
  #
  # source://syntax_tree//lib/syntax_tree/formatter.rb#29
  def initialize(quote: T.unsafe(nil), trailing_comma: T.unsafe(nil), disable_auto_ternary: T.unsafe(nil), target_ruby_version: T.unsafe(nil)); end

  # Returns the value of attribute disable_auto_ternary.
  #
  # source://syntax_tree//lib/syntax_tree/formatter.rb#24
  def disable_auto_ternary; end

  # Returns the value of attribute quote.
  #
  # source://syntax_tree//lib/syntax_tree/formatter.rb#24
  def quote; end

  # Returns the value of attribute target_ruby_version.
  #
  # source://syntax_tree//lib/syntax_tree/formatter.rb#24
  def target_ruby_version; end

  # Returns the value of attribute trailing_comma.
  #
  # source://syntax_tree//lib/syntax_tree/formatter.rb#24
  def trailing_comma; end
end

# Unfortunately, Gem::Version.new is not ractor-safe because it performs
# global caching using a class variable. This works around that by just
# setting the instance variables directly.
#
# source://syntax_tree//lib/syntax_tree/formatter.rb#10
class SyntaxTree::Formatter::SemanticVersion < ::Gem::Version
  # @return [SemanticVersion] a new instance of SemanticVersion
  #
  # source://syntax_tree//lib/syntax_tree/formatter.rb#11
  def initialize(version); end
end

# GVar represents a global variable literal.
#
#     $variable
#
# source://syntax_tree//lib/syntax_tree/node.rb#5601
class SyntaxTree::GVar < ::SyntaxTree::Node
  # @return [GVar] a new instance of GVar
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5607
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5642
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5613
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5617
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5605
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5621
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5617
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5634
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5638
  def format(q); end

  # [String] the name of the global variable
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5602
  def value; end
end

# This holds references to objects that respond to both #parse and #format
# so that we can use them in the CLI.
#
# source://syntax_tree//lib/syntax_tree.rb#43
SyntaxTree::HANDLERS = T.let(T.unsafe(nil), Hash)

# This module is responsible for formatting the assocs contained within a
# hash or bare hash. It first determines if every key in the hash can use
# labels. If it can, it uses labels. Otherwise it uses hash rockets.
#
# source://syntax_tree//lib/syntax_tree/node.rb#1728
module SyntaxTree::HashKeyFormatter
  class << self
    # source://syntax_tree//lib/syntax_tree/node.rb#1786
    def for(container); end
  end
end

# When formatting a single assoc node without the context of the parent
# hash, this formatter is used. It uses whatever is present in the node,
# because there is nothing to be consistent with.
#
# source://syntax_tree//lib/syntax_tree/node.rb#1775
class SyntaxTree::HashKeyFormatter::Identity
  # source://syntax_tree//lib/syntax_tree/node.rb#1776
  def format_key(q, key); end
end

# Formats the keys of a hash literal using labels.
#
# source://syntax_tree//lib/syntax_tree/node.rb#1730
class SyntaxTree::HashKeyFormatter::Labels
  # source://syntax_tree//lib/syntax_tree/node.rb#1733
  def format_key(q, key); end
end

# source://syntax_tree//lib/syntax_tree/node.rb#1731
SyntaxTree::HashKeyFormatter::Labels::LABEL = T.let(T.unsafe(nil), Regexp)

# Formats the keys of a hash literal using hash rockets.
#
# source://syntax_tree//lib/syntax_tree/node.rb#1756
class SyntaxTree::HashKeyFormatter::Rockets
  # source://syntax_tree//lib/syntax_tree/node.rb#1757
  def format_key(q, key); end
end

# HashLiteral represents a hash literal.
#
#     { key => value }
#
# source://syntax_tree//lib/syntax_tree/node.rb#5654
class SyntaxTree::HashLiteral < ::SyntaxTree::Node
  # @return [HashLiteral] a new instance of HashLiteral
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5687
  def initialize(lbrace:, assocs:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5728
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5694
  def accept(visitor); end

  # [Array[ Assoc | AssocSplat ]] the optional contents of the hash
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5682
  def assocs; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5698
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5685
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5702
  def copy(lbrace: T.unsafe(nil), assocs: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5698
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5716
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5720
  def format(q); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5733
  def format_key(q, key); end

  # [LBrace] the left brace that opens this hash
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5679
  def lbrace; end

  private

  # If we have an empty hash that contains only comments, then we're going
  # to do some special printing to ensure they get indented correctly.
  #
  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5741
  def empty_with_comments?; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5745
  def format_contents(q); end
end

# This is a special formatter used if the hash literal contains no values
# but _does_ contain comments. In this case we do some special formatting to
# make sure the comments gets indented properly.
#
# source://syntax_tree//lib/syntax_tree/node.rb#5655
class SyntaxTree::HashLiteral::EmptyWithCommentsFormatter
  # @return [EmptyWithCommentsFormatter] a new instance of EmptyWithCommentsFormatter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5659
  def initialize(lbrace); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5663
  def format(q); end

  # [LBrace] the opening brace
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5657
  def lbrace; end
end

# Heredoc represents a heredoc string literal.
#
#     <<~DOC
#       contents
#     DOC
#
# source://syntax_tree//lib/syntax_tree/node.rb#5775
class SyntaxTree::Heredoc < ::SyntaxTree::Node
  # @return [Heredoc] a new instance of Heredoc
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5791
  def initialize(beginning:, location:, ending: T.unsafe(nil), dedent: T.unsafe(nil), parts: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5873
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5800
  def accept(visitor); end

  # [HeredocBeg] the opening of the heredoc
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5776
  def beginning; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5804
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5789
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5808
  def copy(beginning: T.unsafe(nil), location: T.unsafe(nil), ending: T.unsafe(nil), parts: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5804
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5823
  def deconstruct_keys(_keys); end

  # [Integer] how far to dedent the heredoc
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5782
  def dedent; end

  # [HeredocEnd] the ending of the heredoc
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5779
  def ending; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5838
  def format(q); end

  # [Array[ StringEmbExpr | StringDVar | TStringContent ]] the parts of the
  # heredoc string literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5786
  def parts; end
end

# This is a very specific behavior where you want to force a newline, but
# don't want to force the break parent.
#
# source://syntax_tree//lib/syntax_tree/node.rb#5835
SyntaxTree::Heredoc::SEPARATOR = T.let(T.unsafe(nil), PrettierPrint::Breakable)

# HeredocBeg represents the beginning declaration of a heredoc.
#
#     <<~DOC
#       contents
#     DOC
#
# In the example above the HeredocBeg node represents <<~DOC.
#
# source://syntax_tree//lib/syntax_tree/node.rb#5887
class SyntaxTree::HeredocBeg < ::SyntaxTree::Node
  # @return [HeredocBeg] a new instance of HeredocBeg
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5893
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5928
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5899
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5903
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5891
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5907
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5903
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5920
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5924
  def format(q); end

  # [String] the opening declaration of the heredoc
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5888
  def value; end
end

# HeredocEnd represents the closing declaration of a heredoc.
#
#     <<~DOC
#       contents
#     DOC
#
# In the example above the HeredocEnd node represents the closing DOC.
#
# source://syntax_tree//lib/syntax_tree/node.rb#5941
class SyntaxTree::HeredocEnd < ::SyntaxTree::Node
  # @return [HeredocEnd] a new instance of HeredocEnd
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5947
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5982
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5953
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5957
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5945
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5961
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5957
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#5974
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#5978
  def format(q); end

  # [String] the closing declaration of the heredoc
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5942
  def value; end
end

# HshPtn represents matching against a hash pattern using the Ruby 2.7+
# pattern matching syntax.
#
#     case value
#     in { key: }
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#5995
class SyntaxTree::HshPtn < ::SyntaxTree::Node
  # @return [HshPtn] a new instance of HshPtn
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6054
  def initialize(constant:, keywords:, keyword_rest:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6147
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6062
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6066
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6052
  def comments; end

  # [nil | VarRef | ConstPathRef] the optional constant wrapper
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6042
  def constant; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6070
  def copy(constant: T.unsafe(nil), keywords: T.unsafe(nil), keyword_rest: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6066
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6085
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6095
  def format(q); end

  # [nil | VarField] an optional parameter to gather up all remaining keywords
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6049
  def keyword_rest; end

  # [Array[ [DynaSymbol | Label, nil | Node] ]] the set of tuples
  # representing the keywords that should be matched against in the pattern
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6046
  def keywords; end

  private

  # source://syntax_tree//lib/syntax_tree/node.rb#6158
  def format_contents(q, parts, nested); end
end

# Formats a key-value pair in a hash pattern. The value is optional.
#
# source://syntax_tree//lib/syntax_tree/node.rb#5996
class SyntaxTree::HshPtn::KeywordFormatter
  # @return [KeywordFormatter] a new instance of KeywordFormatter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6003
  def initialize(key, value); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6008
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6012
  def format(q); end

  # [Label] the keyword being used
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#5998
  def key; end

  # [Node] the optional value for the keyword
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6001
  def value; end
end

# Formats the optional double-splat from the pattern.
#
# source://syntax_tree//lib/syntax_tree/node.rb#6023
class SyntaxTree::HshPtn::KeywordRestFormatter
  # @return [KeywordRestFormatter] a new instance of KeywordRestFormatter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6027
  def initialize(keyword_rest); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6031
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6035
  def format(q); end

  # [VarField] the parameter that matches the remaining keywords
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6025
  def keyword_rest; end
end

# IVar represents an instance variable literal.
#
#     @variable
#
# source://syntax_tree//lib/syntax_tree/node.rb#6879
class SyntaxTree::IVar < ::SyntaxTree::Node
  # @return [IVar] a new instance of IVar
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6885
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6920
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6891
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6895
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6883
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6899
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6895
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6912
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6916
  def format(q); end

  # [String] the name of the instance variable
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6880
  def value; end
end

# Ident represents an identifier anywhere in code. It can represent a very
# large number of things, depending on where it is in the syntax tree.
#
#     value
#
# source://syntax_tree//lib/syntax_tree/node.rb#6182
class SyntaxTree::Ident < ::SyntaxTree::Node
  # @return [Ident] a new instance of Ident
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6188
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6223
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6194
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6198
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6186
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6202
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6198
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6215
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6219
  def format(q); end

  # [String] the value of the identifier
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6183
  def value; end
end

# If represents the first clause in an +if+ chain.
#
#     if predicate
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#6472
class SyntaxTree::IfNode < ::SyntaxTree::Node
  # @return [IfNode] a new instance of IfNode
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6484
  def initialize(predicate:, statements:, consequent:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6529
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6492
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6496
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6482
  def comments; end

  # [nil | Elsif | Else] the next clause in the chain
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6479
  def consequent; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6500
  def copy(predicate: T.unsafe(nil), statements: T.unsafe(nil), consequent: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6496
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6515
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6525
  def format(q); end

  # Checks if the node was originally found in the modifier form.
  #
  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6535
  def modifier?; end

  # [Node] the expression to be checked
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6473
  def predicate; end

  # [Statements] the expressions to be executed
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6476
  def statements; end
end

# IfOp represents a ternary clause.
#
#     predicate ? truthy : falsy
#
# source://syntax_tree//lib/syntax_tree/node.rb#6545
class SyntaxTree::IfOp < ::SyntaxTree::Node
  # @return [IfOp] a new instance of IfOp
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6557
  def initialize(predicate:, truthy:, falsy:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6631
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6565
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6569
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6555
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6573
  def copy(predicate: T.unsafe(nil), truthy: T.unsafe(nil), falsy: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6569
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6588
  def deconstruct_keys(_keys); end

  # [Node] the expression to be executed if the predicate is falsy
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6552
  def falsy; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6598
  def format(q); end

  # [Node] the expression to be checked
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6546
  def predicate; end

  # [Node] the expression to be executed if the predicate is truthy
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6549
  def truthy; end

  private

  # source://syntax_tree//lib/syntax_tree/node.rb#6638
  def format_break(q); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6661
  def format_flat(q); end
end

# Imaginary represents an imaginary number literal.
#
#     1i
#
# source://syntax_tree//lib/syntax_tree/node.rb#6681
class SyntaxTree::Imaginary < ::SyntaxTree::Node
  # @return [Imaginary] a new instance of Imaginary
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6687
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6722
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6693
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6697
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6685
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6701
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6697
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6714
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6718
  def format(q); end

  # [String] the value of the imaginary number literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6682
  def value; end
end

# In represents using the +in+ keyword within the Ruby 2.7+ pattern matching
# syntax.
#
#     case value
#     in pattern
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#6735
class SyntaxTree::In < ::SyntaxTree::Node
  # @return [In] a new instance of In
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6747
  def initialize(pattern:, statements:, consequent:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6812
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6755
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6759
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6745
  def comments; end

  # [nil | In | Else] the next clause in the chain
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6742
  def consequent; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6763
  def copy(pattern: T.unsafe(nil), statements: T.unsafe(nil), consequent: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6759
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6778
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6788
  def format(q); end

  # [Node] the pattern to check against
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6736
  def pattern; end

  # [Statements] the expressions to execute if the pattern matched
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6739
  def statements; end
end

# This class can be used to build an index of the structure of Ruby files. We
# define an index as the list of constants and methods defined within a file.
#
# This index strives to be as fast as possible to better support tools like
# IDEs. Because of that, it has different backends depending on what
# functionality is available.
#
# source://syntax_tree//lib/syntax_tree/index.rb#10
module SyntaxTree::Index
  class << self
    # This method accepts source code and then indexes it.
    #
    # source://syntax_tree//lib/syntax_tree/index.rb#674
    def index(source, backend: T.unsafe(nil)); end

    # This method accepts a filepath and then indexes it.
    #
    # source://syntax_tree//lib/syntax_tree/index.rb#679
    def index_file(filepath, backend: T.unsafe(nil)); end
  end
end

# This entry represents a method definition that was created using the alias
# keyword.
#
# source://syntax_tree//lib/syntax_tree/index.rb#85
class SyntaxTree::Index::AliasMethodDefinition
  # @return [AliasMethodDefinition] a new instance of AliasMethodDefinition
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#88
  def initialize(nesting, name, location, comments); end

  # Returns the value of attribute comments.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#86
  def comments; end

  # Returns the value of attribute location.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#86
  def location; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#86
  def name; end

  # Returns the value of attribute nesting.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#86
  def nesting; end
end

# This entry represents a class definition using the class keyword.
#
# source://syntax_tree//lib/syntax_tree/index.rb#22
class SyntaxTree::Index::ClassDefinition
  # @return [ClassDefinition] a new instance of ClassDefinition
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#25
  def initialize(nesting, name, superclass, location, comments); end

  # Returns the value of attribute comments.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#23
  def comments; end

  # Returns the value of attribute location.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#23
  def location; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#23
  def name; end

  # Returns the value of attribute nesting.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#23
  def nesting; end

  # Returns the value of attribute superclass.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#23
  def superclass; end
end

# This entry represents a constant assignment.
#
# source://syntax_tree//lib/syntax_tree/index.rb#35
class SyntaxTree::Index::ConstantDefinition
  # @return [ConstantDefinition] a new instance of ConstantDefinition
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#38
  def initialize(nesting, name, location, comments); end

  # Returns the value of attribute comments.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#36
  def comments; end

  # Returns the value of attribute location.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#36
  def location; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#36
  def name; end

  # Returns the value of attribute nesting.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#36
  def nesting; end
end

# This class handles parsing comments from Ruby source code in the case that
# we use the instruction sequence backend. Because the instruction sequence
# backend doesn't provide comments (since they are dropped) we provide this
# interface to lazily parse them out.
#
# source://syntax_tree//lib/syntax_tree/index.rb#152
class SyntaxTree::Index::EntryComments
  include ::Enumerable

  # @return [EntryComments] a new instance of EntryComments
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#156
  def initialize(file_comments, location); end

  # source://syntax_tree//lib/syntax_tree/index.rb#161
  def each(&block); end

  # Returns the value of attribute file_comments.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#154
  def file_comments; end

  # Returns the value of attribute location.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#154
  def location; end
end

# When you're using the instruction sequence backend, this class is used to
# lazily parse comments out of the source code.
#
# source://syntax_tree//lib/syntax_tree/index.rb#98
class SyntaxTree::Index::FileComments
  # @return [FileComments] a new instance of FileComments
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#139
  def initialize(source); end

  # source://syntax_tree//lib/syntax_tree/index.rb#143
  def comments; end

  # Returns the value of attribute source.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#137
  def source; end
end

# This represents the Ruby source in the form of a file. When it needs to
# be read we'll read the file.
#
# source://syntax_tree//lib/syntax_tree/index.rb#115
class SyntaxTree::Index::FileComments::FileSource
  # @return [FileSource] a new instance of FileSource
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#118
  def initialize(filepath); end

  # Returns the value of attribute filepath.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#116
  def filepath; end

  # source://syntax_tree//lib/syntax_tree/index.rb#122
  def source; end
end

# We use the ripper library to pull out source comments.
#
# source://syntax_tree//lib/syntax_tree/index.rb#100
class SyntaxTree::Index::FileComments::Parser < ::Ripper
  # @return [Parser] a new instance of Parser
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#103
  def initialize(*_arg0); end

  # Returns the value of attribute comments.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#101
  def comments; end

  # source://syntax_tree//lib/syntax_tree/index.rb#108
  def on_comment(value); end
end

# This represents the Ruby source in the form of a string. When it needs
# to be read the string is returned.
#
# source://syntax_tree//lib/syntax_tree/index.rb#129
class SyntaxTree::Index::FileComments::StringSource
  # @return [StringSource] a new instance of StringSource
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#132
  def initialize(source); end

  # Returns the value of attribute source.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#130
  def source; end
end

# The class defined here is used to perform the indexing, depending on what
# functionality is available from the runtime.
#
# source://syntax_tree//lib/syntax_tree/index.rb#670
SyntaxTree::Index::INDEX_BACKEND = SyntaxTree::Index::ISeqBackend

# This backend creates the index using RubyVM::InstructionSequence, which is
# faster than using the Syntax Tree parser, but is not available on all
# runtimes.
#
# source://syntax_tree//lib/syntax_tree/index.rb#177
class SyntaxTree::Index::ISeqBackend
  # source://syntax_tree//lib/syntax_tree/index.rb#184
  def index(source); end

  # source://syntax_tree//lib/syntax_tree/index.rb#191
  def index_file(filepath); end

  private

  # source://syntax_tree//lib/syntax_tree/index.rb#242
  def find_attr_arguments(insns, index); end

  # source://syntax_tree//lib/syntax_tree/index.rb#205
  def find_constant_path(insns, index); end

  # source://syntax_tree//lib/syntax_tree/index.rb#273
  def index_iseq(iseq, file_comments); end

  # source://syntax_tree//lib/syntax_tree/index.rb#200
  def location_for(iseq); end

  # source://syntax_tree//lib/syntax_tree/index.rb#258
  def method_definition(nesting, name, location, file_comments); end
end

# source://syntax_tree//lib/syntax_tree/index.rb#182
SyntaxTree::Index::ISeqBackend::VM_DEFINECLASS_FLAG_HAS_SUPERCLASS = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/index.rb#181
SyntaxTree::Index::ISeqBackend::VM_DEFINECLASS_FLAG_SCOPED = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/index.rb#178
SyntaxTree::Index::ISeqBackend::VM_DEFINECLASS_TYPE_CLASS = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/index.rb#180
SyntaxTree::Index::ISeqBackend::VM_DEFINECLASS_TYPE_MODULE = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/index.rb#179
SyntaxTree::Index::ISeqBackend::VM_DEFINECLASS_TYPE_SINGLETON_CLASS = T.let(T.unsafe(nil), Integer)

# This is a location for an index entry.
#
# source://syntax_tree//lib/syntax_tree/index.rb#12
class SyntaxTree::Index::Location
  # @return [Location] a new instance of Location
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#15
  def initialize(line, column); end

  # Returns the value of attribute column.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#13
  def column; end

  # Returns the value of attribute line.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#13
  def line; end
end

# This entry represents a method definition using the def keyword.
#
# source://syntax_tree//lib/syntax_tree/index.rb#59
class SyntaxTree::Index::MethodDefinition
  # @return [MethodDefinition] a new instance of MethodDefinition
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#62
  def initialize(nesting, name, location, comments); end

  # Returns the value of attribute comments.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#60
  def comments; end

  # Returns the value of attribute location.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#60
  def location; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#60
  def name; end

  # Returns the value of attribute nesting.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#60
  def nesting; end
end

# This entry represents a module definition using the module keyword.
#
# source://syntax_tree//lib/syntax_tree/index.rb#47
class SyntaxTree::Index::ModuleDefinition
  # @return [ModuleDefinition] a new instance of ModuleDefinition
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#50
  def initialize(nesting, name, location, comments); end

  # Returns the value of attribute comments.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#48
  def comments; end

  # Returns the value of attribute location.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#48
  def location; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#48
  def name; end

  # Returns the value of attribute nesting.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#48
  def nesting; end
end

# This backend creates the index using the Syntax Tree parser and a visitor.
# It is not as fast as using the instruction sequences directly, but is
# supported on all runtimes.
#
# source://syntax_tree//lib/syntax_tree/index.rb#452
class SyntaxTree::Index::ParserBackend
  # source://syntax_tree//lib/syntax_tree/index.rb#659
  def index(source); end

  # source://syntax_tree//lib/syntax_tree/index.rb#663
  def index_file(filepath); end
end

# source://syntax_tree//lib/syntax_tree/index.rb#453
class SyntaxTree::Index::ParserBackend::ConstantNameVisitor < ::SyntaxTree::Visitor
  # source://syntax_tree//lib/syntax_tree/index.rb#458
  def visit_const_path_ref(node); end

  # source://syntax_tree//lib/syntax_tree/index.rb#454
  def visit_const_ref(node); end

  # source://syntax_tree//lib/syntax_tree/index.rb#462
  def visit_var_ref(node); end
end

# source://syntax_tree//lib/syntax_tree/index.rb#467
class SyntaxTree::Index::ParserBackend::IndexVisitor < ::SyntaxTree::Visitor
  # @return [IndexVisitor] a new instance of IndexVisitor
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#470
  def initialize; end

  # Returns the value of attribute nesting.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#468
  def nesting; end

  # Returns the value of attribute results.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#468
  def results; end

  # Returns the value of attribute statements.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#468
  def statements; end

  # source://syntax_tree//lib/syntax_tree/index.rb#477
  def visit_alias(node); end

  # source://syntax_tree//lib/syntax_tree/index.rb#496
  def visit_assign(node); end

  # source://syntax_tree//lib/syntax_tree/index.rb#515
  def visit_class(node); end

  # source://syntax_tree//lib/syntax_tree/index.rb#547
  def visit_command(node); end

  # source://syntax_tree//lib/syntax_tree/index.rb#584
  def visit_def(node); end

  # source://syntax_tree//lib/syntax_tree/index.rb#608
  def visit_module(node); end

  # source://syntax_tree//lib/syntax_tree/index.rb#626
  def visit_program(node); end

  # source://syntax_tree//lib/syntax_tree/index.rb#631
  def visit_statements(node); end

  private

  # source://syntax_tree//lib/syntax_tree/index.rb#639
  def comments_for(node); end
end

# This entry represents a singleton method definition using the def keyword
# with a specified target.
#
# source://syntax_tree//lib/syntax_tree/index.rb#72
class SyntaxTree::Index::SingletonMethodDefinition
  # @return [SingletonMethodDefinition] a new instance of SingletonMethodDefinition
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#75
  def initialize(nesting, name, location, comments); end

  # Returns the value of attribute comments.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#73
  def comments; end

  # Returns the value of attribute location.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#73
  def location; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#73
  def name; end

  # Returns the value of attribute nesting.
  #
  # source://syntax_tree//lib/syntax_tree/index.rb#73
  def nesting; end
end

# Int represents an integer number literal.
#
#     1
#
# source://syntax_tree//lib/syntax_tree/node.rb#6823
class SyntaxTree::Int < ::SyntaxTree::Node
  # @return [Int] a new instance of Int
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6829
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6869
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6835
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6839
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6827
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6843
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6839
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6853
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6857
  def format(q); end

  # [String] the value of the integer
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6824
  def value; end
end

# This visitor transforms the AST into a hash that contains only primitives
# that can be easily serialized into JSON.
#
# source://syntax_tree//lib/syntax_tree/json_visitor.rb#8
class SyntaxTree::JSONVisitor < ::SyntaxTree::FieldVisitor
  # @return [JSONVisitor] a new instance of JSONVisitor
  #
  # source://syntax_tree//lib/syntax_tree/json_visitor.rb#11
  def initialize; end

  # Returns the value of attribute target.
  #
  # source://syntax_tree//lib/syntax_tree/json_visitor.rb#9
  def target; end

  private

  # source://syntax_tree//lib/syntax_tree/json_visitor.rb#17
  def comments(node); end

  # source://syntax_tree//lib/syntax_tree/json_visitor.rb#21
  def field(name, value); end

  # source://syntax_tree//lib/syntax_tree/json_visitor.rb#25
  def list(name, values); end

  # source://syntax_tree//lib/syntax_tree/json_visitor.rb#29
  def node(node, type); end

  # source://syntax_tree//lib/syntax_tree/json_visitor.rb#38
  def pairs(name, values); end

  # source://syntax_tree//lib/syntax_tree/json_visitor.rb#42
  def text(name, value); end

  # source://syntax_tree//lib/syntax_tree/json_visitor.rb#46
  def visit_location(location); end
end

# Kw represents the use of a keyword. It can be almost anywhere in the syntax
# tree, so you end up seeing it quite a lot.
#
#     if value
#     end
#
# In the above example, there would be two Kw nodes: one for the if and one
# for the end. Note that anything that matches the list of keywords in Ruby
# will use a Kw, so if you use a keyword in a symbol literal for instance:
#
#     :if
#
# then the contents of the symbol node will contain a Kw node.
#
# source://syntax_tree//lib/syntax_tree/node.rb#6939
class SyntaxTree::Kw < ::SyntaxTree::Node
  # @return [Kw] a new instance of Kw
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6948
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6981
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6955
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6959
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6946
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6963
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6959
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#6973
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#6977
  def format(q); end

  # [Symbol] the symbol version of the value
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6943
  def name; end

  # [String] the value of the keyword
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6940
  def value; end
end

# KwRestParam represents defining a parameter in a method definition that
# accepts all remaining keyword parameters.
#
#     def method(**kwargs) end
#
# source://syntax_tree//lib/syntax_tree/node.rb#6992
class SyntaxTree::KwRestParam < ::SyntaxTree::Node
  # @return [KwRestParam] a new instance of KwRestParam
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6998
  def initialize(name:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7034
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7004
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7008
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6996
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7012
  def copy(name: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7008
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7025
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7029
  def format(q); end

  # [nil | Ident] the name of the parameter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6993
  def name; end
end

# LBrace represents the use of a left brace, i.e., {.
#
# source://syntax_tree//lib/syntax_tree/node.rb#7317
class SyntaxTree::LBrace < ::SyntaxTree::Node
  # @return [LBrace] a new instance of LBrace
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7323
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7358
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7329
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7333
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7321
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7337
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7333
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7350
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7354
  def format(q); end

  # [String] the left brace
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7318
  def value; end

  class << self
    # Because some nodes keep around a { token so that comments can be attached
    # to it if they occur in the source, oftentimes an LBrace is a child of
    # another node. This means it's required at initialization time. To make it
    # easier to create LBrace nodes without any specific value, this method
    # provides a default node.
    #
    # source://syntax_tree//lib/syntax_tree/node.rb#7367
    def default; end
  end
end

# LBracket represents the use of a left bracket, i.e., [.
#
# source://syntax_tree//lib/syntax_tree/node.rb#7374
class SyntaxTree::LBracket < ::SyntaxTree::Node
  # @return [LBracket] a new instance of LBracket
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7380
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7415
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7386
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7390
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7378
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7394
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7390
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7407
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7411
  def format(q); end

  # [String] the left bracket
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7375
  def value; end

  class << self
    # Because some nodes keep around a [ token so that comments can be attached
    # to it if they occur in the source, oftentimes an LBracket is a child of
    # another node. This means it's required at initialization time. To make it
    # easier to create LBracket nodes without any specific value, this method
    # provides a default node.
    #
    # source://syntax_tree//lib/syntax_tree/node.rb#7424
    def default; end
  end
end

# LParen represents the use of a left parenthesis, i.e., (.
#
# source://syntax_tree//lib/syntax_tree/node.rb#7431
class SyntaxTree::LParen < ::SyntaxTree::Node
  # @return [LParen] a new instance of LParen
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7437
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7472
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7443
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7447
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7435
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7451
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7447
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7464
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7468
  def format(q); end

  # [String] the left parenthesis
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7432
  def value; end

  class << self
    # Because some nodes keep around a ( token so that comments can be attached
    # to it if they occur in the source, oftentimes an LParen is a child of
    # another node. This means it's required at initialization time. To make it
    # easier to create LParen nodes without any specific value, this method
    # provides a default node.
    #
    # source://syntax_tree//lib/syntax_tree/node.rb#7481
    def default; end
  end
end

# Label represents the use of an identifier to associate with an object. You
# can find it in a hash key, as in:
#
#     { key: value }
#
# In this case "key:" would be the body of the label. You can also find it in
# pattern matching, as in:
#
#     case value
#     in key:
#     end
#
# In this case "key:" would be the body of the label.
#
# source://syntax_tree//lib/syntax_tree/node.rb#7053
class SyntaxTree::Label < ::SyntaxTree::Node
  # @return [Label] a new instance of Label
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7059
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7094
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7065
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7069
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7057
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7073
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7069
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7086
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7090
  def format(q); end

  # [String] the value of the label
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7054
  def value; end
end

# LabelEnd represents the end of a dynamic symbol.
#
#     { "key": value }
#
# In the example above, LabelEnd represents the "\":" token at the end of the
# hash key. This node is important for determining the type of quote being
# used by the label.
#
# source://syntax_tree//lib/syntax_tree/node.rb#7107
class SyntaxTree::LabelEnd < ::SyntaxTree::Node
  # @return [LabelEnd] a new instance of LabelEnd
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7110
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7136
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7115
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7119
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7123
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7119
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7132
  def deconstruct_keys(_keys); end

  # [String] the end of the label
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7108
  def value; end
end

# Lambda represents using a lambda literal (not the lambda method call).
#
#     ->(value) { value * 2 }
#
# source://syntax_tree//lib/syntax_tree/node.rb#7146
class SyntaxTree::Lambda < ::SyntaxTree::Node
  # @return [Lambda] a new instance of Lambda
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7155
  def initialize(params:, statements:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7239
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7162
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7166
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7153
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7170
  def copy(params: T.unsafe(nil), statements: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7166
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7184
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7193
  def format(q); end

  # [LambdaVar | Paren] the parameter declaration for this lambda
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7147
  def params; end

  # [BodyStmt | Statements] the expressions to be executed in this lambda
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7150
  def statements; end
end

# LambdaVar represents the parameters being declared for a lambda. Effectively
# this node is everything contained within the parentheses. This includes all
# of the various parameter types, as well as block-local variable
# declarations.
#
#     -> (positional, optional = value, keyword:, &block; local) do
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#7254
class SyntaxTree::LambdaVar < ::SyntaxTree::Node
  # @return [LambdaVar] a new instance of LambdaVar
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7263
  def initialize(params:, locals:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7309
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7270
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7274
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7261
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7278
  def copy(params: T.unsafe(nil), locals: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7274
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7292
  def deconstruct_keys(_keys); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7296
  def empty?; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7300
  def format(q); end

  # [Array[ Ident ]] the list of block-local variable declarations
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7258
  def locals; end

  # [Params] the parameters being declared with the block
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7255
  def params; end
end

# Syntax Tree additionally ships with a language server conforming to the
# language server protocol. It can be invoked through the CLI by running:
#
#     stree lsp
#
# source://syntax_tree//lib/syntax_tree/language_server.rb#14
class SyntaxTree::LanguageServer
  # @return [LanguageServer] a new instance of LanguageServer
  #
  # source://syntax_tree//lib/syntax_tree/language_server.rb#217
  def initialize(input: T.unsafe(nil), output: T.unsafe(nil), print_width: T.unsafe(nil)); end

  # Returns the value of attribute input.
  #
  # source://syntax_tree//lib/syntax_tree/language_server.rb#215
  def input; end

  # Returns the value of attribute output.
  #
  # source://syntax_tree//lib/syntax_tree/language_server.rb#215
  def output; end

  # Returns the value of attribute print_width.
  #
  # source://syntax_tree//lib/syntax_tree/language_server.rb#215
  def print_width; end

  # source://syntax_tree//lib/syntax_tree/language_server.rb#228
  def run; end

  private

  # source://syntax_tree//lib/syntax_tree/language_server.rb#280
  def capabilities; end

  # source://syntax_tree//lib/syntax_tree/language_server.rb#293
  def format(source, extension); end

  # source://syntax_tree//lib/syntax_tree/language_server.rb#317
  def inlay_hints(source); end

  # source://syntax_tree//lib/syntax_tree/language_server.rb#333
  def log(message); end

  # source://syntax_tree//lib/syntax_tree/language_server.rb#327
  def write(value); end
end

# This class provides inlay hints for the language server. For more
# information, see the spec here:
# https://github.com/microsoft/language-server-protocol/issues/956.
#
# source://syntax_tree//lib/syntax_tree/language_server.rb#19
class SyntaxTree::LanguageServer::InlayHints < ::SyntaxTree::Visitor
  # @return [InlayHints] a new instance of InlayHints
  #
  # source://syntax_tree//lib/syntax_tree/language_server.rb#43
  def initialize; end

  # Returns the value of attribute hints.
  #
  # source://syntax_tree//lib/syntax_tree/language_server.rb#41
  def hints; end

  # Returns the value of attribute stack.
  #
  # source://syntax_tree//lib/syntax_tree/language_server.rb#41
  def stack; end

  # source://syntax_tree//lib/syntax_tree/language_server.rb#48
  def visit(node); end

  # source://syntax_tree//lib/syntax_tree/language_server.rb#67
  def visit_assign(node); end

  # source://syntax_tree//lib/syntax_tree/language_server.rb#81
  def visit_binary(node); end

  # source://syntax_tree//lib/syntax_tree/language_server.rb#102
  def visit_if_op(node); end

  # source://syntax_tree//lib/syntax_tree/language_server.rb#124
  def visit_rescue(node); end

  # source://syntax_tree//lib/syntax_tree/language_server.rb#145
  def visit_unary(node); end

  private

  # source://syntax_tree//lib/syntax_tree/language_server.rb#156
  def parentheses(location); end
end

# This represents a hint that is going to be displayed in the editor.
#
# source://syntax_tree//lib/syntax_tree/language_server.rb#20
class SyntaxTree::LanguageServer::InlayHints::Hint
  # @return [Hint] a new instance of Hint
  #
  # source://syntax_tree//lib/syntax_tree/language_server.rb#23
  def initialize(line:, character:, label:); end

  # Returns the value of attribute character.
  #
  # source://syntax_tree//lib/syntax_tree/language_server.rb#21
  def character; end

  # Returns the value of attribute label.
  #
  # source://syntax_tree//lib/syntax_tree/language_server.rb#21
  def label; end

  # Returns the value of attribute line.
  #
  # source://syntax_tree//lib/syntax_tree/language_server.rb#21
  def line; end

  # This is the shape that the LSP expects.
  #
  # source://syntax_tree//lib/syntax_tree/language_server.rb#30
  def to_json(*opts); end
end

# This is a small module that effectively mirrors pattern matching. We're
# using it so that we can support truffleruby without having to ignore the
# language server.
#
# source://syntax_tree//lib/syntax_tree/language_server.rb#174
module SyntaxTree::LanguageServer::Request
  class << self
    # source://syntax_tree//lib/syntax_tree/language_server.rb#203
    def [](value); end
  end
end

# Represents a hash pattern.
#
# source://syntax_tree//lib/syntax_tree/language_server.rb#176
class SyntaxTree::LanguageServer::Request::Shape
  # @return [Shape] a new instance of Shape
  #
  # source://syntax_tree//lib/syntax_tree/language_server.rb#179
  def initialize(values); end

  # source://syntax_tree//lib/syntax_tree/language_server.rb#183
  def ===(other); end

  # Returns the value of attribute values.
  #
  # source://syntax_tree//lib/syntax_tree/language_server.rb#177
  def values; end
end

# Represents an array pattern.
#
# source://syntax_tree//lib/syntax_tree/language_server.rb#191
class SyntaxTree::LanguageServer::Request::Tuple
  # @return [Tuple] a new instance of Tuple
  #
  # source://syntax_tree//lib/syntax_tree/language_server.rb#194
  def initialize(values); end

  # source://syntax_tree//lib/syntax_tree/language_server.rb#198
  def ===(other); end

  # Returns the value of attribute values.
  #
  # source://syntax_tree//lib/syntax_tree/language_server.rb#192
  def values; end
end

# Represents the location of a node in the tree from the source code.
#
# source://syntax_tree//lib/syntax_tree/node.rb#5
class SyntaxTree::Location
  # @return [Location] a new instance of Location
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#13
  def initialize(start_line:, start_char:, start_column:, end_line:, end_char:, end_column:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#33
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#50
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#54
  def deconstruct_keys(_keys); end

  # Returns the value of attribute end_char.
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6
  def end_char; end

  # Returns the value of attribute end_column.
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6
  def end_column; end

  # Returns the value of attribute end_line.
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6
  def end_line; end

  # source://syntax_tree//lib/syntax_tree/node.rb#29
  def lines; end

  # Returns the value of attribute start_char.
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6
  def start_char; end

  # Returns the value of attribute start_column.
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6
  def start_column; end

  # Returns the value of attribute start_line.
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#6
  def start_line; end

  # source://syntax_tree//lib/syntax_tree/node.rb#39
  def to(other); end

  class << self
    # A convenience method that is typically used when you don't care about the
    # location of a node, but need to create a Location instance to pass to a
    # constructor.
    #
    # source://syntax_tree//lib/syntax_tree/node.rb#90
    def default; end

    # source://syntax_tree//lib/syntax_tree/node.rb#76
    def fixed(line:, char:, column:); end

    # source://syntax_tree//lib/syntax_tree/node.rb#65
    def token(line:, char:, column:, size:); end
  end
end

# Formats an Until or While node.
#
# source://syntax_tree//lib/syntax_tree/node.rb#11378
class SyntaxTree::LoopFormatter
  # @return [LoopFormatter] a new instance of LoopFormatter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11385
  def initialize(keyword, node); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11390
  def format(q); end

  # [String] the name of the keyword used for this loop
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11380
  def keyword; end

  # [Until | While] the node that is being formatted
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11383
  def node; end

  private

  # source://syntax_tree//lib/syntax_tree/node.rb#11437
  def format_break(q); end
end

# MAssign is a parent node of any kind of multiple assignment. This includes
# splitting out variables on the left like:
#
#     first, second, third = value
#
# as well as splitting out variables on the right, as in:
#
#     value = first, second, third
#
# Both sides support splats, as well as variables following them. There's also
# destructuring behavior that you can achieve with the following:
#
#     first, = value
#
# source://syntax_tree//lib/syntax_tree/node.rb#7501
class SyntaxTree::MAssign < ::SyntaxTree::Node
  # @return [MAssign] a new instance of MAssign
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7510
  def initialize(target:, value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7554
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7517
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7521
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7508
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7525
  def copy(target: T.unsafe(nil), value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7521
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7539
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7543
  def format(q); end

  # [MLHS | MLHSParen] the target of the multiple assignment
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7502
  def target; end

  # [Node] the value being assigned
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7505
  def value; end
end

# MLHS represents a list of values being destructured on the left-hand side
# of a multiple assignment.
#
#     first, second, third = value
#
# source://syntax_tree//lib/syntax_tree/node.rb#7644
class SyntaxTree::MLHS < ::SyntaxTree::Node
  # @return [MLHS] a new instance of MLHS
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7655
  def initialize(parts:, location:, comma: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7693
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7662
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7666
  def child_nodes; end

  # [boolean] whether or not there is a trailing comma at the end of this
  # list, which impacts destructuring. It's an attr_accessor so that while
  # the syntax tree is being built it can be set by its parent node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7650
  def comma; end

  # [boolean] whether or not there is a trailing comma at the end of this
  # list, which impacts destructuring. It's an attr_accessor so that while
  # the syntax tree is being built it can be set by its parent node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7650
  def comma=(_arg0); end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7653
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7670
  def copy(parts: T.unsafe(nil), location: T.unsafe(nil), comma: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7666
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7684
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7688
  def format(q); end

  # [
  #   Array[
  #     ARefField | ArgStar | ConstPathField | Field | Ident | MLHSParen |
  #       TopConstField | VarField
  #   ]
  # ] the parts of the left-hand side of a multiple assignment
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7645
  def parts; end
end

# MLHSParen represents parentheses being used to destruct values in a multiple
# assignment on the left hand side.
#
#     (left, right) = value
#
# source://syntax_tree//lib/syntax_tree/node.rb#7705
class SyntaxTree::MLHSParen < ::SyntaxTree::Node
  # @return [MLHSParen] a new instance of MLHSParen
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7716
  def initialize(contents:, location:, comma: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7769
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7723
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7727
  def child_nodes; end

  # [boolean] whether or not there is a trailing comma at the end of this
  # list, which impacts destructuring. It's an attr_accessor so that while
  # the syntax tree is being built it can be set by its parent node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7711
  def comma; end

  # [boolean] whether or not there is a trailing comma at the end of this
  # list, which impacts destructuring. It's an attr_accessor so that while
  # the syntax tree is being built it can be set by its parent node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7711
  def comma=(_arg0); end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7714
  def comments; end

  # [MLHS | MLHSParen] the contents inside of the parentheses
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7706
  def contents; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7731
  def copy(contents: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7727
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7744
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7748
  def format(q); end
end

# MRHS represents the values that are being assigned on the right-hand side of
# a multiple assignment.
#
#     values = first, second, third
#
# source://syntax_tree//lib/syntax_tree/node.rb#7870
class SyntaxTree::MRHS < ::SyntaxTree::Node
  # @return [MRHS] a new instance of MRHS
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7876
  def initialize(parts:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7911
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7882
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7886
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7874
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7890
  def copy(parts: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7886
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7903
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7907
  def format(q); end

  # [Array[Node]] the parts that are being assigned
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7871
  def parts; end
end

# This visitor transforms the AST into a Ruby pattern matching expression that
# would match correctly against the AST.
#
# source://syntax_tree//lib/syntax_tree/match_visitor.rb#6
class SyntaxTree::MatchVisitor < ::SyntaxTree::FieldVisitor
  # @return [MatchVisitor] a new instance of MatchVisitor
  #
  # source://syntax_tree//lib/syntax_tree/match_visitor.rb#9
  def initialize(q); end

  # Returns the value of attribute q.
  #
  # source://syntax_tree//lib/syntax_tree/match_visitor.rb#7
  def q; end

  # source://syntax_tree//lib/syntax_tree/match_visitor.rb#13
  def visit(node); end

  private

  # source://syntax_tree//lib/syntax_tree/match_visitor.rb#30
  def comments(node); end

  # source://syntax_tree//lib/syntax_tree/match_visitor.rb#44
  def field(name, value); end

  # source://syntax_tree//lib/syntax_tree/match_visitor.rb#52
  def list(name, values); end

  # source://syntax_tree//lib/syntax_tree/match_visitor.rb#65
  def node(node, _type); end

  # source://syntax_tree//lib/syntax_tree/match_visitor.rb#86
  def pairs(name, values); end

  # source://syntax_tree//lib/syntax_tree/match_visitor.rb#112
  def text(name, value); end
end

# This module is responsible for rendering mermaid (https://mermaid.js.org/)
# flow charts.
#
# source://syntax_tree//lib/syntax_tree/mermaid.rb#9
module SyntaxTree::Mermaid
  class << self
    # Escape a label to be used in the mermaid syntax. This is used to escape
    # HTML entities such that they render properly within the quotes.
    #
    # source://syntax_tree//lib/syntax_tree/mermaid.rb#158
    def escape(label); end

    # Create a new flowchart. If a block is given, it will be yielded to and
    # the flowchart will be rendered. Otherwise, the flowchart will be
    # returned.
    #
    # source://syntax_tree//lib/syntax_tree/mermaid.rb#165
    def flowchart; end
  end
end

# This is the main class that handles rendering a flowchart. It keeps track
# of its nodes and links and renders them according to the mermaid syntax.
#
# source://syntax_tree//lib/syntax_tree/mermaid.rb#12
class SyntaxTree::Mermaid::FlowChart
  # @return [FlowChart] a new instance of FlowChart
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#15
  def initialize; end

  # Retrieve a node that has already been added to the flowchart by its id.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#25
  def fetch(id); end

  # Add a link to the flowchart between two nodes with an optional label.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#30
  def link(from, to, label = T.unsafe(nil), type: T.unsafe(nil), color: T.unsafe(nil)); end

  # Returns the value of attribute links.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#13
  def links; end

  # Add a node to the flowchart with an optional label.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#39
  def node(id, label = T.unsafe(nil), shape: T.unsafe(nil)); end

  # Returns the value of attribute nodes.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#13
  def nodes; end

  # Returns the value of attribute output.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#13
  def output; end

  # Returns the value of attribute prefix.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#13
  def prefix; end

  # Return the rendered flowchart.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#64
  def render; end

  # Add a subgraph to the flowchart. Within the given block, all of the
  # nodes will be rendered within the subgraph.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#49
  def subgraph(label); end
end

# This class represents a link between two nodes in a flowchart. It is not
# meant to be interacted with directly, but rather used as a data structure
# by the FlowChart class.
#
# source://syntax_tree//lib/syntax_tree/mermaid.rb#78
class SyntaxTree::Mermaid::Link
  # @return [Link] a new instance of Link
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#84
  def initialize(from, to, label, type, color); end

  # Returns the value of attribute color.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#82
  def color; end

  # Returns the value of attribute from.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#82
  def from; end

  # Returns the value of attribute label.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#82
  def label; end

  # source://syntax_tree//lib/syntax_tree/mermaid.rb#95
  def render; end

  # Returns the value of attribute to.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#82
  def to; end

  # Returns the value of attribute type.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#82
  def type; end

  private

  # source://syntax_tree//lib/syntax_tree/mermaid.rb#108
  def sides; end
end

# source://syntax_tree//lib/syntax_tree/mermaid.rb#80
SyntaxTree::Mermaid::Link::COLORS = T.let(T.unsafe(nil), Array)

# source://syntax_tree//lib/syntax_tree/mermaid.rb#79
SyntaxTree::Mermaid::Link::TYPES = T.let(T.unsafe(nil), Array)

# This class represents a node in a flowchart. Unlike the Link class, it can
# be used directly. It is the return value of the #node method, and is meant
# to be passed around to #link methods to create links between nodes.
#
# source://syntax_tree//lib/syntax_tree/mermaid.rb#121
class SyntaxTree::Mermaid::Node
  # @return [Node] a new instance of Node
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#126
  def initialize(id, label, shape); end

  # Returns the value of attribute id.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#124
  def id; end

  # Returns the value of attribute label.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#124
  def label; end

  # source://syntax_tree//lib/syntax_tree/mermaid.rb#134
  def render; end

  # Returns the value of attribute shape.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid.rb#124
  def shape; end

  private

  # source://syntax_tree//lib/syntax_tree/mermaid.rb#141
  def bounds; end
end

# source://syntax_tree//lib/syntax_tree/mermaid.rb#122
SyntaxTree::Mermaid::Node::SHAPES = T.let(T.unsafe(nil), Array)

# This visitor transforms the AST into a mermaid flow chart.
#
# source://syntax_tree//lib/syntax_tree/mermaid_visitor.rb#5
class SyntaxTree::MermaidVisitor < ::SyntaxTree::FieldVisitor
  # @return [MermaidVisitor] a new instance of MermaidVisitor
  #
  # source://syntax_tree//lib/syntax_tree/mermaid_visitor.rb#8
  def initialize; end

  # Returns the value of attribute flowchart.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid_visitor.rb#6
  def flowchart; end

  # Returns the value of attribute target.
  #
  # source://syntax_tree//lib/syntax_tree/mermaid_visitor.rb#6
  def target; end

  # source://syntax_tree//lib/syntax_tree/mermaid_visitor.rb#13
  def visit_program(node); end

  private

  # source://syntax_tree//lib/syntax_tree/mermaid_visitor.rb#20
  def comments(node); end

  # source://syntax_tree//lib/syntax_tree/mermaid_visitor.rb#24
  def field(name, value); end

  # source://syntax_tree//lib/syntax_tree/mermaid_visitor.rb#37
  def list(name, values); end

  # source://syntax_tree//lib/syntax_tree/mermaid_visitor.rb#43
  def node(node, type); end

  # source://syntax_tree//lib/syntax_tree/mermaid_visitor.rb#55
  def pairs(name, values); end

  # source://syntax_tree//lib/syntax_tree/mermaid_visitor.rb#65
  def text(name, value); end
end

# MethodAddBlock represents a method call with a block argument.
#
#     method {}
#
# source://syntax_tree//lib/syntax_tree/node.rb#7564
class SyntaxTree::MethodAddBlock < ::SyntaxTree::Node
  # @return [MethodAddBlock] a new instance of MethodAddBlock
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7573
  def initialize(call:, block:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7622
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7580
  def accept(visitor); end

  # [BlockNode] the block being sent with the method call
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7568
  def block; end

  # [ARef | CallNode | Command | CommandCall | Super | ZSuper] the method call
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7565
  def call; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7584
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7571
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7588
  def copy(call: T.unsafe(nil), block: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7584
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7602
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7606
  def format(q); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7627
  def format_contents(q); end
end

# ModuleDeclaration represents defining a module using the +module+ keyword.
#
#     module Namespace
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#7780
class SyntaxTree::ModuleDeclaration < ::SyntaxTree::Node
  # @return [ModuleDeclaration] a new instance of ModuleDeclaration
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7789
  def initialize(constant:, bodystmt:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7849
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7796
  def accept(visitor); end

  # [BodyStmt] the expressions to be executed in the context of the module
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7784
  def bodystmt; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7800
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7787
  def comments; end

  # [ConstPathRef | ConstRef | TopConstRef] the name of the module
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7781
  def constant; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7804
  def copy(constant: T.unsafe(nil), bodystmt: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7800
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7818
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7827
  def format(q); end

  private

  # source://syntax_tree//lib/syntax_tree/node.rb#7856
  def format_declaration(q); end
end

# This visitor walks through the tree and copies each node as it is being
# visited. This is useful for mutating the tree before it is formatted.
#
# source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#6
class SyntaxTree::MutationVisitor < ::SyntaxTree::BasicVisitor
  # @return [MutationVisitor] a new instance of MutationVisitor
  #
  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#9
  def initialize; end

  # Create a new mutation based on the given query that will mutate the node
  # using the given block. The block should return a new node that will take
  # the place of the given node in the tree. These blocks frequently make use
  # of the `copy` method on nodes to create a new node with the same
  # properties as the original node.
  #
  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#18
  def mutate(query, &block); end

  # Returns the value of attribute mutations.
  #
  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#7
  def mutations; end

  # This is the base visit method for each node in the tree. It first creates
  # a copy of the node using the visit_* methods defined below. Then it checks
  # each mutation in sequence and calls it if it finds a match.
  #
  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#25
  def visit(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#38
  def visit_BEGIN(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#46
  def visit_CHAR(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#51
  def visit_END(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#59
  def visit___end__(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#64
  def visit_alias(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#69
  def visit_aref(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#74
  def visit_aref_field(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#89
  def visit_arg_block(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#79
  def visit_arg_paren(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#94
  def visit_arg_star(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#84
  def visit_args(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#99
  def visit_args_forward(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#104
  def visit_array(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#112
  def visit_aryptn(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#122
  def visit_assign(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#127
  def visit_assoc(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#132
  def visit_assoc_splat(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#137
  def visit_backref(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#142
  def visit_backtick(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#147
  def visit_bare_assoc_hash(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#152
  def visit_begin(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#162
  def visit_binary(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#295
  def visit_block(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#167
  def visit_block_var(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#172
  def visit_blockarg(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#177
  def visit_bodystmt(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#187
  def visit_break(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#192
  def visit_call(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#202
  def visit_case(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#216
  def visit_class(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#225
  def visit_comma(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#230
  def visit_command(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#239
  def visit_command_call(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#249
  def visit_comment(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#254
  def visit_const(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#259
  def visit_const_path_field(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#264
  def visit_const_path_ref(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#269
  def visit_const_ref(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#274
  def visit_cvar(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#279
  def visit_def(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#290
  def visit_defined(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#313
  def visit_dyna_symbol(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#318
  def visit_else(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#326
  def visit_elsif(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#334
  def visit_embdoc(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#339
  def visit_embexpr_beg(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#344
  def visit_embexpr_end(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#349
  def visit_embvar(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#354
  def visit_ensure(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#362
  def visit_excessed_comma(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#367
  def visit_field(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#375
  def visit_float(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#380
  def visit_fndptn(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#390
  def visit_for(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#395
  def visit_gvar(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#400
  def visit_hash(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#405
  def visit_heredoc(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#414
  def visit_heredoc_beg(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#419
  def visit_heredoc_end(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#424
  def visit_hshptn(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#434
  def visit_ident(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#439
  def visit_if(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#448
  def visit_if_op(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#453
  def visit_imaginary(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#458
  def visit_in(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#466
  def visit_int(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#471
  def visit_ivar(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#476
  def visit_kw(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#481
  def visit_kwrest_param(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#486
  def visit_label(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#491
  def visit_label_end(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#496
  def visit_lambda(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#504
  def visit_lambda_var(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#509
  def visit_lbrace(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#514
  def visit_lbracket(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#519
  def visit_lparen(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#524
  def visit_massign(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#529
  def visit_method_add_block(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#534
  def visit_mlhs(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#539
  def visit_mlhs_paren(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#544
  def visit_module(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#552
  def visit_mrhs(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#557
  def visit_next(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#812
  def visit_not(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#562
  def visit_op(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#567
  def visit_opassign(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#572
  def visit_params(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#588
  def visit_paren(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#593
  def visit_period(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#157
  def visit_pinned_begin(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#854
  def visit_pinned_var_ref(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#598
  def visit_program(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#603
  def visit_qsymbols(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#611
  def visit_qsymbols_beg(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#616
  def visit_qwords(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#624
  def visit_qwords_beg(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#304
  def visit_range(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#211
  def visit_rassign(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#629
  def visit_rational(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#634
  def visit_rbrace(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#639
  def visit_rbracket(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#644
  def visit_redo(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#654
  def visit_regexp_beg(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#649
  def visit_regexp_content(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#659
  def visit_regexp_end(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#664
  def visit_regexp_literal(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#674
  def visit_rescue(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#669
  def visit_rescue_ex(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#684
  def visit_rescue_mod(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#689
  def visit_rest_param(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#694
  def visit_retry(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#699
  def visit_return(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#704
  def visit_rparen(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#709
  def visit_sclass(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#714
  def visit_statements(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#724
  def visit_string_concat(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#719
  def visit_string_content(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#729
  def visit_string_dvar(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#734
  def visit_string_embexpr(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#739
  def visit_string_literal(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#744
  def visit_super(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#749
  def visit_symbeg(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#754
  def visit_symbol_content(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#759
  def visit_symbol_literal(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#764
  def visit_symbols(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#772
  def visit_symbols_beg(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#777
  def visit_tlambda(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#782
  def visit_tlambeg(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#787
  def visit_top_const_field(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#792
  def visit_top_const_ref(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#797
  def visit_tstring_beg(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#802
  def visit_tstring_content(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#807
  def visit_tstring_end(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#817
  def visit_unary(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#822
  def visit_undef(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#827
  def visit_unless(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#836
  def visit_until(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#844
  def visit_var_field(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#849
  def visit_var_ref(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#859
  def visit_vcall(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#864
  def visit_void_stmt(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#869
  def visit_when(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#878
  def visit_while(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#886
  def visit_word(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#891
  def visit_words(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#899
  def visit_words_beg(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#904
  def visit_xstring(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#909
  def visit_xstring_literal(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#914
  def visit_yield(node); end

  # source://syntax_tree//lib/syntax_tree/mutation_visitor.rb#919
  def visit_zsuper(node); end
end

# Next represents using the +next+ keyword.
#
#     next
#
# The +next+ keyword can also optionally be called with an argument:
#
#     next value
#
# +next+ can even be called with multiple arguments, but only if parentheses
# are omitted, as in:
#
#     next first, second, third
#
# If a single value is being given, parentheses can be used, as in:
#
#     next(value)
#
# source://syntax_tree//lib/syntax_tree/node.rb#7934
class SyntaxTree::Next < ::SyntaxTree::Node
  # @return [Next] a new instance of Next
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7940
  def initialize(arguments:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7975
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7946
  def accept(visitor); end

  # [Args] the arguments passed to the next keyword
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7935
  def arguments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7950
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7938
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7954
  def copy(arguments: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7950
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#7967
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#7971
  def format(q); end
end

# This is the parent node of all of the syntax tree nodes. It's pretty much
# exclusively here to make it easier to operate with the tree in cases where
# you're trying to monkey-patch or strictly type.
#
# source://syntax_tree//lib/syntax_tree/node.rb#105
class SyntaxTree::Node
  # @raise [NotImplementedError]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#109
  def accept(visitor); end

  # @raise [NotImplementedError]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#113
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#149
  def construct_keys; end

  # @raise [NotImplementedError]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#117
  def deconstruct; end

  # @raise [NotImplementedError]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#121
  def deconstruct_keys(keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#133
  def end_char; end

  # @raise [NotImplementedError]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#125
  def format(q); end

  # [Location] the location of this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#107
  def location; end

  # source://syntax_tree//lib/syntax_tree/node.rb#137
  def pretty_print(q); end

  # source://syntax_tree//lib/syntax_tree/node.rb#129
  def start_char; end

  # source://syntax_tree//lib/syntax_tree/node.rb#141
  def to_json(*opts); end

  # source://syntax_tree//lib/syntax_tree/node.rb#145
  def to_mermaid; end
end

# Not represents the unary +not+ method being called on an expression.
#
#     not value
#
# source://syntax_tree//lib/syntax_tree/node.rb#11078
class SyntaxTree::Not < ::SyntaxTree::Node
  # @return [Not] a new instance of Not
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11088
  def initialize(statement:, parentheses:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11150
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11095
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11099
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11086
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11103
  def copy(statement: T.unsafe(nil), parentheses: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11099
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11117
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11126
  def format(q); end

  # [boolean] whether or not parentheses were used
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11082
  def parentheses; end

  # [boolean] whether or not parentheses were used
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11082
  def parentheses?; end

  # [nil | Node] the statement on which to operate
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11079
  def statement; end
end

# Op represents an operator literal in the source.
#
#     1 + 2
#
# In the example above, the Op node represents the + operator.
#
# source://syntax_tree//lib/syntax_tree/node.rb#7986
class SyntaxTree::Op < ::SyntaxTree::Node
  # @return [Op] a new instance of Op
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7995
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8028
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8002
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8006
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7993
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8010
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8006
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8020
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8024
  def format(q); end

  # [Symbol] the symbol version of the value
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7990
  def name; end

  # [String] the operator
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#7987
  def value; end
end

# OpAssign represents assigning a value to a variable or constant using an
# operator like += or ||=.
#
#     variable += value
#
# source://syntax_tree//lib/syntax_tree/node.rb#8040
class SyntaxTree::OpAssign < ::SyntaxTree::Node
  # @return [OpAssign] a new instance of OpAssign
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8052
  def initialize(target:, operator:, value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8111
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8060
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8064
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8050
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8068
  def copy(target: T.unsafe(nil), operator: T.unsafe(nil), value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8064
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8083
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8093
  def format(q); end

  # [Op] the operator being used for the assignment
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8044
  def operator; end

  # [ARefField | ConstPathField | Field | TopConstField | VarField] the target
  # to assign the result of the expression to
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8041
  def target; end

  # [Node] the expression to be assigned
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8047
  def value; end

  private

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8118
  def skip_indent?; end
end

# The list of nodes that represent patterns inside of pattern matching so that
# when a pattern is being printed it knows if it's nested.
#
# source://syntax_tree//lib/syntax_tree/node.rb#6174
SyntaxTree::PATTERNS = T.let(T.unsafe(nil), Array)

# Params represents defining parameters on a method or lambda.
#
#     def method(param) end
#
# source://syntax_tree//lib/syntax_tree/node.rb#8198
class SyntaxTree::Params < ::SyntaxTree::Node
  # @return [Params] a new instance of Params
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8298
  def initialize(location:, requireds: T.unsafe(nil), optionals: T.unsafe(nil), rest: T.unsafe(nil), posts: T.unsafe(nil), keywords: T.unsafe(nil), keyword_rest: T.unsafe(nil), block: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8428
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8328
  def accept(visitor); end

  # Returns a range representing the possible number of arguments accepted
  # by this params node not including the block. For example:
  #
  #     def foo(a, b = 1, c:, d: 2, &block)
  #       ...
  #     end
  #
  # has arity 2..4.
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8451
  def arity; end

  # [nil | BlockArg] the optional block parameter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8293
  def block; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8332
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8296
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8346
  def copy(location: T.unsafe(nil), requireds: T.unsafe(nil), optionals: T.unsafe(nil), rest: T.unsafe(nil), posts: T.unsafe(nil), keywords: T.unsafe(nil), keyword_rest: T.unsafe(nil), block: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8332
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8374
  def deconstruct_keys(_keys); end

  # Params nodes are the most complicated in the tree. Occasionally you want
  # to know if they are "empty", which means not having any parameters
  # declared. This logic accesses every kind of parameter and determines if
  # it's missing.
  #
  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8323
  def empty?; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8388
  def format(q); end

  # [nil | :nil | ArgsForward | KwRestParam] the optional keyword rest
  # parameter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8290
  def keyword_rest; end

  # [Array[ [ Label, nil | Node ] ]] any keyword parameters and their
  # optional default values
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8286
  def keywords; end

  # [Array[ [ Ident, Node ] ]] any optional parameters and their default
  # values
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8274
  def optionals; end

  # [Array[ Ident | MLHSParen ]] any positional parameters that exist after a
  #  rest parameter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8282
  def posts; end

  # [Array[ Ident | MLHSParen ]] any required parameters
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8270
  def requireds; end

  # [nil | ArgsForward | ExcessedComma | RestParam] the optional rest
  # parameter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8278
  def rest; end

  private

  # source://syntax_tree//lib/syntax_tree/node.rb#8467
  def format_contents(q, parts); end
end

# Formats the keyword position of the parameters. This includes the label,
# as well as an optional default value.
#
# source://syntax_tree//lib/syntax_tree/node.rb#8224
class SyntaxTree::Params::KeywordFormatter
  # @return [KeywordFormatter] a new instance of KeywordFormatter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8231
  def initialize(name, value); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8236
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8240
  def format(q); end

  # [Ident] the name of the parameter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8226
  def name; end

  # [nil | Node] the value of the parameter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8229
  def value; end
end

# Formats the keyword_rest position of the parameters. This can be the **nil
# syntax, the ... syntax, or the ** syntax.
#
# source://syntax_tree//lib/syntax_tree/node.rb#8252
class SyntaxTree::Params::KeywordRestFormatter
  # @return [KeywordRestFormatter] a new instance of KeywordRestFormatter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8256
  def initialize(value); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8260
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8264
  def format(q); end

  # [:nil | ArgsForward | KwRestParam] the value of the parameter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8254
  def value; end
end

# Formats the optional position of the parameters. This includes the label,
# as well as the default value.
#
# source://syntax_tree//lib/syntax_tree/node.rb#8199
class SyntaxTree::Params::OptionalFormatter
  # @return [OptionalFormatter] a new instance of OptionalFormatter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8206
  def initialize(name, value); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8211
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8215
  def format(q); end

  # [Ident] the name of the parameter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8201
  def name; end

  # [Node] the value of the parameter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8204
  def value; end
end

# Paren represents using balanced parentheses in a couple places in a Ruby
# program. In general parentheses can be used anywhere a Ruby expression can
# be used.
#
#     (1 + 2)
#
# source://syntax_tree//lib/syntax_tree/node.rb#8480
class SyntaxTree::Paren < ::SyntaxTree::Node
  # @return [Paren] a new instance of Paren
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8489
  def initialize(lparen:, contents:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8545
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8496
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8500
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8487
  def comments; end

  # [nil | Node] the expression inside the parentheses
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8484
  def contents; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8504
  def copy(lparen: T.unsafe(nil), contents: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8500
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8518
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8527
  def format(q); end

  # [LParen] the left parenthesis that opened this statement
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8481
  def lparen; end
end

# If you have a modifier statement (for instance a modifier if statement or a
# modifier while loop) there are times when you need to wrap the entire
# statement in parentheses. This occurs when you have something like:
#
#     foo[:foo] =
#       if bar?
#         baz
#       end
#
# Normally we would shorten this to an inline version, which would result in:
#
#     foo[:foo] = baz if bar?
#
# but this actually has different semantic meaning. The first example will
# result in a nil being inserted into the hash for the :foo key, whereas the
# second example will result in an empty hash because the if statement applies
# to the entire assignment.
#
# We can fix this in a couple of ways. We can use the then keyword, as in:
#
#     foo[:foo] = if bar? then baz end
#
# But this isn't used very often. We can also just leave it as is with the
# multi-line version, but for a short predicate and short value it looks
# verbose. The last option and the one used here is to add parentheses on
# both sides of the expression, as in:
#
#     foo[:foo] = (baz if bar?)
#
# This approach maintains the nice conciseness of the inline version, while
# keeping the correct semantic meaning.
#
# source://syntax_tree//lib/syntax_tree/node.rb#8155
module SyntaxTree::Parentheses
  class << self
    # source://syntax_tree//lib/syntax_tree/node.rb#8175
    def break(q); end

    # source://syntax_tree//lib/syntax_tree/node.rb#8167
    def flat(q); end
  end
end

# source://syntax_tree//lib/syntax_tree/node.rb#8156
SyntaxTree::Parentheses::NODES = T.let(T.unsafe(nil), Array)

# Parser is a subclass of the Ripper library that subscribes to the stream of
# tokens and nodes coming from the parser and builds up a syntax tree.
#
# source://syntax_tree//lib/syntax_tree/parser.rb#8
class SyntaxTree::Parser < ::Ripper
  # @return [Parser] a new instance of Parser
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#116
  def initialize(source, *_arg1); end

  # [Array[ Comment | EmbDoc ]] the list of comments that have been found
  # while parsing the source.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#114
  def comments; end

  # [Array[ SingleByteString | MultiByteString ]] the list of objects that
  # represent the start of each line in character offsets
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#105
  def line_counts; end

  # [String] the source being parsed
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#101
  def source; end

  # [Array[ untyped ]] a running list of tokens that have been found in the
  # source. This list changes a lot as certain nodes will "consume" these
  # tokens to determine their bounds.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#110
  def tokens; end

  private

  # Attaches comments to the nodes in the tree that most closely correspond to
  # the location of the comments.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2911
  def attach_comments(program, comments); end

  # This represents the current place in the source string that we've gotten
  # to so far. We have a memoized line_counts object that we can use to get
  # the number of characters that we've had to go through to get to the
  # beginning of this line, then we add the number of columns into this line
  # that we've gone through.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#197
  def char_pos; end

  # @raise [ParseError]
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#295
  def consume_error(name, location); end

  # source://syntax_tree//lib/syntax_tree/parser.rb#312
  def consume_keyword(name); end

  # source://syntax_tree//lib/syntax_tree/parser.rb#318
  def consume_operator(name); end

  # source://syntax_tree//lib/syntax_tree/parser.rb#300
  def consume_token(type); end

  # source://syntax_tree//lib/syntax_tree/parser.rb#306
  def consume_tstring_end(location); end

  # This represents the current column we're in relative to the beginning of
  # the current line.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#203
  def current_column; end

  # A helper function to find a :: operator. We do special handling instead of
  # using find_token here because we don't pop off all of the :: operators so
  # you could end up getting the wrong information if you have for instance
  # ::X::Y::Z.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#328
  def find_colon2_before(const); end

  # source://syntax_tree//lib/syntax_tree/parser.rb#272
  def find_keyword(name); end

  # source://syntax_tree//lib/syntax_tree/parser.rb#277
  def find_keyword_between(name, left, right); end

  # Finds the next position in the source string that begins a statement. This
  # is used to bind statements lists and make sure they don't include a
  # preceding comment. For example, we want the following comment to be
  # attached to the class node and not the statement node:
  #
  #       ...
  #     end
  #
  # By finding the next non-space character, we can make sure that the bounds
  # of the statement list are correct.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#349
  def find_next_statement_start(position); end

  # source://syntax_tree//lib/syntax_tree/parser.rb#290
  def find_operator(name); end

  # As we build up a list of tokens, we'll periodically need to go backwards
  # and find the ones that we've already hit in order to determine the
  # location information for nodes that use them. For example, if you have a
  # module node then you'll look backward for a kw token to determine your
  # start location.
  #
  # This works with nesting since we're deleting tokens from the list once
  # they've been used up. For example if you had nested module declarations
  # then the innermost declaration would grab the last kw node that matches
  # "module" (which would happen to be the innermost keyword). Then the outer
  # one would only be able to grab the first one. In this way all of the
  # tokens act as their own stack.
  #
  # If we're expecting to be able to find a token and consume it, but can't
  # actually find it, then we need to raise an error. This is _usually_ caused
  # by a syntax error in the source that we're printing. It could also be
  # caused by accidentally attempting to consume a token twice by two
  # different parser event handlers.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#254
  def find_token(type); end

  # source://syntax_tree//lib/syntax_tree/parser.rb#259
  def find_token_between(type, left, right); end

  # Returns the current location that is being looked at for the parser for
  # the purpose of locating the error.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#210
  def find_token_error(location); end

  # Ripper doesn't support capturing lambda local variables until 3.2. To
  # mitigate this, we have to parse that code for ourselves. We use the range
  # from the parentheses to find where we _should_ be looking. Then we check
  # if the resulting tokens match a pattern that we determine means that the
  # declaration has block-local variables. Once it does, we parse those out
  # and convert them into Ident nodes.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2362
  def lambda_locals(source); end

  # Responsible for finding the nearest nodes to the given comment within the
  # context of the given encapsulating node.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2946
  def nearest_nodes(node, comment); end

  # :call-seq:
  #   on_BEGIN: (Statements statements) -> BEGINBlock
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#371
  def on_BEGIN(statements); end

  # :call-seq:
  #   on_CHAR: (String value) -> CHAR
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#395
  def on_CHAR(value); end

  # :call-seq:
  #   on_END: (Statements statements) -> ENDBlock
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#410
  def on_END(statements); end

  # :call-seq:
  #   on___end__: (String value) -> EndContent
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#434
  def on___end__(value); end

  # :call-seq:
  #   on_alias: (
  #     (DynaSymbol | SymbolLiteral) left,
  #     (DynaSymbol | SymbolLiteral) right
  #   ) -> AliasNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#453
  def on_alias(left, right); end

  # If we encounter a parse error, just immediately bail out so that our
  # runner can catch it.
  #
  # @raise [ParseError]
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2863
  def on_alias_error(error, *_arg1); end

  # :call-seq:
  #   on_aref: (untyped collection, (nil | Args) index) -> ARef
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#465
  def on_aref(collection, index); end

  # :call-seq:
  #   on_aref_field: (
  #     untyped collection,
  #     (nil | Args) index
  #   ) -> ARefField
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#481
  def on_aref_field(collection, index); end

  # :call-seq:
  #   on_arg_paren: (
  #     (nil | Args | ArgsForward) arguments
  #   ) -> ArgParen
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#500
  def on_arg_paren(arguments); end

  # :call-seq:
  #   on_args_add: (Args arguments, untyped argument) -> Args
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#522
  def on_args_add(arguments, argument); end

  # :call-seq:
  #   on_args_add_block: (
  #     Args arguments,
  #     (false | untyped) block
  #   ) -> Args
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#543
  def on_args_add_block(arguments, block); end

  # :call-seq:
  #   on_args_add_star: (Args arguments, untyped star) -> Args
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#581
  def on_args_add_star(arguments, argument); end

  # :call-seq:
  #   on_args_forward: () -> ArgsForward
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#603
  def on_args_forward; end

  # :call-seq:
  #   on_args_new: () -> Args
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#611
  def on_args_new; end

  # :call-seq:
  #   on_array: ((nil | Args) contents) ->
  #     ArrayLiteral | QSymbols | QWords | Symbols | Words
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#622
  def on_array(contents); end

  # :call-seq:
  #   on_aryptn: (
  #     (nil | VarRef) constant,
  #     (nil | Array[untyped]) requireds,
  #     (nil | VarField) rest,
  #     (nil | Array[untyped]) posts
  #   ) -> AryPtn
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#701
  def on_aryptn(constant, requireds, rest, posts); end

  # :call-seq:
  #   on_assign: (
  #     (
  #       ARefField |
  #       ConstPathField |
  #       Field |
  #       TopConstField |
  #       VarField
  #     ) target,
  #     untyped value
  #   ) -> Assign
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#756
  def on_assign(target, value); end

  # If we encounter a parse error, just immediately bail out so that our
  # runner can catch it.
  #
  # @raise [ParseError]
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2863
  def on_assign_error(error, *_arg1); end

  # :call-seq:
  #   on_assoc_new: (untyped key, untyped value) -> Assoc
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#766
  def on_assoc_new(key, value); end

  # :call-seq:
  #   on_assoc_splat: (untyped value) -> AssocSplat
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#775
  def on_assoc_splat(value); end

  # :call-seq:
  #   on_backref: (String value) -> Backref
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#790
  def on_backref(value); end

  # :call-seq:
  #   on_backtick: (String value) -> Backtick
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#805
  def on_backtick(value); end

  # :call-seq:
  #   on_bare_assoc_hash: (
  #     Array[AssocNew | AssocSplat] assocs
  #   ) -> BareAssocHash
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#826
  def on_bare_assoc_hash(assocs); end

  # :call-seq:
  #   on_begin: (untyped bodystmt) -> Begin | PinnedBegin
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#835
  def on_begin(bodystmt); end

  # :call-seq:
  #   on_binary: (
  #     untyped left,
  #     (Op | Symbol) operator,
  #     untyped right
  #   ) -> Binary
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#874
  def on_binary(left, operator, right); end

  # :call-seq:
  #   on_block_var: (Params params, (nil | Array[Ident]) locals) -> BlockVar
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#906
  def on_block_var(params, locals); end

  # :call-seq:
  #   on_blockarg: (Ident name) -> BlockArg
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#946
  def on_blockarg(name); end

  # :call-seq:
  #   on_bodystmt: (
  #     Statements statements,
  #     (nil | Rescue) rescue_clause,
  #     (nil | Statements) else_clause,
  #     (nil | Ensure) ensure_clause
  #   ) -> BodyStmt
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#962
  def on_bodystmt(statements, rescue_clause, else_clause, ensure_clause); end

  # :call-seq:
  #   on_brace_block: (
  #     (nil | BlockVar) block_var,
  #     Statements statements
  #   ) -> BlockNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#988
  def on_brace_block(block_var, statements); end

  # :call-seq:
  #   on_break: (Args arguments) -> Break
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1025
  def on_break(arguments); end

  # :call-seq:
  #   on_call: (
  #     untyped receiver,
  #     (:"::" | Op | Period) operator,
  #     (:call | Backtick | Const | Ident | Op) message
  #   ) -> CallNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1040
  def on_call(receiver, operator, message); end

  # :call-seq:
  #   on_case: (untyped value, untyped consequent) -> Case | RAssign
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1061
  def on_case(value, consequent); end

  # :call-seq:
  #   on_class: (
  #     (ConstPathRef | ConstRef | TopConstRef) constant,
  #     untyped superclass,
  #     BodyStmt bodystmt
  #   ) -> ClassDeclaration
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1096
  def on_class(constant, superclass, bodystmt); end

  # If we encounter a parse error, just immediately bail out so that our
  # runner can catch it.
  #
  # @raise [ParseError]
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2863
  def on_class_name_error(error, *_arg1); end

  # :call-seq:
  #   on_comma: (String value) -> Comma
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1120
  def on_comma(value); end

  # :call-seq:
  #   on_command: ((Const | Ident) message, Args arguments) -> Command
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1139
  def on_command(message, arguments); end

  # :call-seq:
  #   on_command_call: (
  #     untyped receiver,
  #     (:"::" | Op | Period) operator,
  #     (Const | Ident | Op) message,
  #     (nil | Args) arguments
  #   ) -> CommandCall
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1155
  def on_command_call(receiver, operator, message, arguments); end

  # :call-seq:
  #   on_comment: (String value) -> Comment
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1170
  def on_comment(value); end

  # :call-seq:
  #   on_const: (String value) -> Const
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1208
  def on_const(value); end

  # :call-seq:
  #   on_const_path_field: (untyped parent, Const constant) ->
  #     ConstPathField | Field
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1224
  def on_const_path_field(parent, constant); end

  # :call-seq:
  #   on_const_path_ref: (untyped parent, Const constant) -> ConstPathRef
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1243
  def on_const_path_ref(parent, constant); end

  # :call-seq:
  #   on_const_ref: (Const constant) -> ConstRef
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1253
  def on_const_ref(constant); end

  # :call-seq:
  #   on_cvar: (String value) -> CVar
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1259
  def on_cvar(value); end

  # :call-seq:
  #   on_def: (
  #     (Backtick | Const | Ident | Kw | Op) name,
  #     (nil | Params | Paren) params,
  #     untyped bodystmt
  #   ) -> DefNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1278
  def on_def(name, params, bodystmt); end

  # :call-seq:
  #   on_defined: (untyped value) -> Defined
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1346
  def on_defined(value); end

  # :call-seq:
  #   on_defs: (
  #     untyped target,
  #     (Op | Period) operator,
  #     (Backtick | Const | Ident | Kw | Op) name,
  #     (Params | Paren) params,
  #     BodyStmt bodystmt
  #   ) -> DefNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1370
  def on_defs(target, operator, name, params, bodystmt); end

  # :call-seq:
  #   on_do_block: (BlockVar block_var, BodyStmt bodystmt) -> BlockNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1435
  def on_do_block(block_var, bodystmt); end

  # :call-seq:
  #   on_dot2: ((nil | untyped) left, (nil | untyped) right) -> RangeNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1459
  def on_dot2(left, right); end

  # :call-seq:
  #   on_dot3: ((nil | untyped) left, (nil | untyped) right) -> RangeNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1475
  def on_dot3(left, right); end

  # :call-seq:
  #   on_dyna_symbol: (StringContent string_content) -> DynaSymbol
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1491
  def on_dyna_symbol(string_content); end

  # :call-seq:
  #   on_else: (Statements statements) -> Else
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1517
  def on_else(statements); end

  # :call-seq:
  #   on_elsif: (
  #     untyped predicate,
  #     Statements statements,
  #     (nil | Elsif | Else) consequent
  #   ) -> Elsif
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1558
  def on_elsif(predicate, statements, consequent); end

  # :call-seq:
  #   on_embdoc: (String value) -> EmbDoc
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1588
  def on_embdoc(value); end

  # :call-seq:
  #   on_embdoc_beg: (String value) -> EmbDoc
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1595
  def on_embdoc_beg(value); end

  # :call-seq:
  #   on_embdoc_end: (String value) -> EmbDoc
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1606
  def on_embdoc_end(value); end

  # :call-seq:
  #   on_embexpr_beg: (String value) -> EmbExprBeg
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1630
  def on_embexpr_beg(value); end

  # :call-seq:
  #   on_embexpr_end: (String value) -> EmbExprEnd
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1649
  def on_embexpr_end(value); end

  # :call-seq:
  #   on_embvar: (String value) -> EmbVar
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1668
  def on_embvar(value); end

  # :call-seq:
  #   on_ensure: (Statements statements) -> Ensure
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1687
  def on_ensure(statements); end

  # The handler for this event accepts no parameters (though in previous
  # versions of Ruby it accepted a string literal with a value of ",").
  #
  # :call-seq:
  #   on_excessed_comma: () -> ExcessedComma
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1714
  def on_excessed_comma(*_arg0); end

  # :call-seq:
  #   on_fcall: ((Const | Ident) value) -> CallNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1722
  def on_fcall(value); end

  # :call-seq:
  #   on_field: (
  #     untyped parent,
  #     (:"::" | Op | Period) operator
  #     (Const | Ident) name
  #   ) -> Field
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1738
  def on_field(parent, operator, name); end

  # :call-seq:
  #   on_float: (String value) -> FloatLiteral
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1749
  def on_float(value); end

  # :call-seq:
  #   on_fndptn: (
  #     (nil | untyped) constant,
  #     VarField left,
  #     Array[untyped] values,
  #     VarField right
  #   ) -> FndPtn
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1769
  def on_fndptn(constant, left, values, right); end

  # :call-seq:
  #   on_for: (
  #     (MLHS | VarField) value,
  #     untyped collection,
  #     Statements statements
  #   ) -> For
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1821
  def on_for(index, collection, statements); end

  # :call-seq:
  #   on_gvar: (String value) -> GVar
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1859
  def on_gvar(value); end

  # :call-seq:
  #   on_hash: ((nil | Array[AssocNew | AssocSplat]) assocs) -> HashLiteral
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1874
  def on_hash(assocs); end

  # :call-seq:
  #   on_heredoc_beg: (String value) -> HeredocBeg
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1887
  def on_heredoc_beg(value); end

  # :call-seq:
  #   on_heredoc_dedent: (StringContent string, Integer width) -> Heredoc
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1906
  def on_heredoc_dedent(string, width); end

  # :call-seq:
  #   on_heredoc_end: (String value) -> Heredoc
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1920
  def on_heredoc_end(value); end

  # :call-seq:
  #   on_hshptn: (
  #     (nil | untyped) constant,
  #     Array[[Label | StringContent, untyped]] keywords,
  #     (nil | VarField) keyword_rest
  #   ) -> HshPtn
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#1956
  def on_hshptn(constant, keywords, keyword_rest); end

  # :call-seq:
  #   on_ident: (String value) -> Ident
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2026
  def on_ident(value); end

  # :call-seq:
  #   on_if: (
  #     untyped predicate,
  #     Statements statements,
  #     (nil | Elsif | Else) consequent
  #   ) -> IfNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2045
  def on_if(predicate, statements, consequent); end

  # :call-seq:
  #   on_if_mod: (untyped predicate, untyped statement) -> IfNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2085
  def on_if_mod(predicate, statement); end

  # :call-seq:
  #   on_ifop: (untyped predicate, untyped truthy, untyped falsy) -> IfOp
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2074
  def on_ifop(predicate, truthy, falsy); end

  # :call-seq:
  #   on_imaginary: (String value) -> Imaginary
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2107
  def on_imaginary(value); end

  # :call-seq:
  #   on_in: (RAssign pattern, nil statements, nil consequent) -> RAssign
  #        | (
  #            untyped pattern,
  #            Statements statements,
  #            (nil | In | Else) consequent
  #          ) -> In
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2127
  def on_in(pattern, statements, consequent); end

  # :call-seq:
  #   on_int: (String value) -> Int
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2172
  def on_int(value); end

  # :call-seq:
  #   on_ivar: (String value) -> IVar
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2187
  def on_ivar(value); end

  # :call-seq:
  #   on_kw: (String value) -> Kw
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2202
  def on_kw(value); end

  # :call-seq:
  #   on_kwrest_param: ((nil | Ident) name) -> KwRestParam
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2221
  def on_kwrest_param(name); end

  # :call-seq:
  #   on_label: (String value) -> Label
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2230
  def on_label(value); end

  # :call-seq:
  #   on_label_end: (String value) -> LabelEnd
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2245
  def on_label_end(value); end

  # :call-seq:
  #   on_lambda: (
  #     (Params | Paren) params,
  #     (BodyStmt | Statements) statements
  #   ) -> Lambda
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2267
  def on_lambda(params, statements); end

  # :call-seq:
  #   on_lambda_var: (Params params, Array[ Ident ] locals) -> LambdaVar
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2349
  def on_lambda_var(params, locals); end

  # :call-seq:
  #   on_lbrace: (String value) -> LBrace
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2432
  def on_lbrace(value); end

  # :call-seq:
  #   on_lbracket: (String value) -> LBracket
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2451
  def on_lbracket(value); end

  # :call-seq:
  #   on_lparen: (String value) -> LParen
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2470
  def on_lparen(value); end

  # :call-seq:
  #   on_massign: ((MLHS | MLHSParen) target, untyped value) -> MAssign
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2493
  def on_massign(target, value); end

  # :call-seq:
  #   on_method_add_arg: (
  #     CallNode call,
  #     (ArgParen | Args) arguments
  #   ) -> CallNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2509
  def on_method_add_arg(call, arguments); end

  # :call-seq:
  #   on_method_add_block: (
  #     (Break | Call | Command | CommandCall, Next) call,
  #     Block block
  #   ) -> Break | MethodAddBlock
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2527
  def on_method_add_block(call, block); end

  # :call-seq:
  #   on_mlhs_add: (
  #     MLHS mlhs,
  #     (ARefField | Field | Ident | MLHSParen | VarField) part
  #   ) -> MLHS
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2556
  def on_mlhs_add(mlhs, part); end

  # :call-seq:
  #   on_mlhs_add_post: (MLHS left, MLHS right) -> MLHS
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2565
  def on_mlhs_add_post(left, right); end

  # :call-seq:
  #   on_mlhs_add_star: (
  #     MLHS mlhs,
  #     (nil | ARefField | Field | Ident | VarField) part
  #   ) -> MLHS
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2577
  def on_mlhs_add_star(mlhs, part); end

  # :call-seq:
  #   on_mlhs_new: () -> MLHS
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2590
  def on_mlhs_new; end

  # :call-seq:
  #   on_mlhs_paren: ((MLHS | MLHSParen) contents) -> MLHSParen
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2600
  def on_mlhs_paren(contents); end

  # :call-seq:
  #   on_module: (
  #     (ConstPathRef | ConstRef | TopConstRef) constant,
  #     BodyStmt bodystmt
  #   ) -> ModuleDeclaration
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2618
  def on_module(constant, bodystmt); end

  # :call-seq:
  #   on_mrhs_add: (MRHS mrhs, untyped part) -> MRHS
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2650
  def on_mrhs_add(mrhs, part); end

  # :call-seq:
  #   on_mrhs_add_star: (MRHS mrhs, untyped value) -> MRHS
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2659
  def on_mrhs_add_star(mrhs, value); end

  # :call-seq:
  #   on_mrhs_new: () -> MRHS
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2640
  def on_mrhs_new; end

  # :call-seq:
  #   on_mrhs_new_from_args: (Args arguments) -> MRHS
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2681
  def on_mrhs_new_from_args(arguments); end

  # :call-seq:
  #   on_next: (Args arguments) -> Next
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2687
  def on_next(arguments); end

  # :call-seq:
  #   on_op: (String value) -> Op
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2706
  def on_op(value); end

  # :call-seq:
  #   on_opassign: (
  #     (
  #       ARefField |
  #       ConstPathField |
  #       Field |
  #       TopConstField |
  #       VarField
  #     ) target,
  #     Op operator,
  #     untyped value
  #   ) -> OpAssign
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2735
  def on_opassign(target, operator, value); end

  # If we encounter a parse error, just immediately bail out so that our
  # runner can catch it.
  #
  # @raise [ParseError]
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2863
  def on_param_error(error, *_arg1); end

  # :call-seq:
  #   on_params: (
  #     (nil | Array[Ident]) requireds,
  #     (nil | Array[[Ident, untyped]]) optionals,
  #     (nil | ArgsForward | ExcessedComma | RestParam) rest,
  #     (nil | Array[Ident]) posts,
  #     (nil | Array[[Ident, nil | untyped]]) keywords,
  #     (nil | :nil | ArgsForward | KwRestParam) keyword_rest,
  #     (nil | :& | BlockArg) block
  #   ) -> Params
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2758
  def on_params(requireds, optionals, rest, posts, keywords, keyword_rest, block); end

  # :call-seq:
  #   on_paren: (untyped contents) -> Paren
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2823
  def on_paren(contents); end

  # If we encounter a parse error, just immediately bail out so that our
  # runner can catch it.
  #
  # @raise [ParseError]
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2863
  def on_parse_error(error, *_arg1); end

  # :call-seq:
  #   on_period: (String value) -> Period
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2873
  def on_period(value); end

  # :call-seq:
  #   on_program: (Statements statements) -> Program
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#2888
  def on_program(statements); end

  # :call-seq:
  #   on_qsymbols_add: (QSymbols qsymbols, TStringContent element) -> QSymbols
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3000
  def on_qsymbols_add(qsymbols, element); end

  # :call-seq:
  #   on_qsymbols_beg: (String value) -> QSymbolsBeg
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3010
  def on_qsymbols_beg(value); end

  # :call-seq:
  #   on_qsymbols_new: () -> QSymbols
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3029
  def on_qsymbols_new; end

  # :call-seq:
  #   on_qwords_add: (QWords qwords, TStringContent element) -> QWords
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3041
  def on_qwords_add(qwords, element); end

  # :call-seq:
  #   on_qwords_beg: (String value) -> QWordsBeg
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3051
  def on_qwords_beg(value); end

  # :call-seq:
  #   on_qwords_new: () -> QWords
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3070
  def on_qwords_new; end

  # :call-seq:
  #   on_rational: (String value) -> RationalLiteral
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3082
  def on_rational(value); end

  # :call-seq:
  #   on_rbrace: (String value) -> RBrace
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3097
  def on_rbrace(value); end

  # :call-seq:
  #   on_rbracket: (String value) -> RBracket
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3116
  def on_rbracket(value); end

  # :call-seq:
  #   on_redo: () -> Redo
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3135
  def on_redo; end

  # :call-seq:
  #   on_regexp_add: (
  #     RegexpContent regexp_content,
  #     (StringDVar | StringEmbExpr | TStringContent) part
  #   ) -> RegexpContent
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3146
  def on_regexp_add(regexp_content, part); end

  # :call-seq:
  #   on_regexp_beg: (String value) -> RegexpBeg
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3156
  def on_regexp_beg(value); end

  # :call-seq:
  #   on_regexp_end: (String value) -> RegexpEnd
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3175
  def on_regexp_end(value); end

  # :call-seq:
  #   on_regexp_literal: (
  #     RegexpContent regexp_content,
  #     (nil | RegexpEnd) ending
  #   ) -> RegexpLiteral
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3193
  def on_regexp_literal(regexp_content, ending); end

  # :call-seq:
  #   on_regexp_new: () -> RegexpContent
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3211
  def on_regexp_new; end

  # :call-seq:
  #   on_rescue: (
  #     (nil | [untyped] | MRHS | MRHSAddStar) exceptions,
  #     (nil | Field | VarField) variable,
  #     Statements statements,
  #     (nil | Rescue) consequent
  #   ) -> Rescue
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3228
  def on_rescue(exceptions, variable, statements, consequent); end

  # :call-seq:
  #   on_rescue_mod: (untyped statement, untyped value) -> RescueMod
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3281
  def on_rescue_mod(statement, value); end

  # :call-seq:
  #   on_rest_param: ((nil | Ident) name) -> RestParam
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3293
  def on_rest_param(name); end

  # :call-seq:
  #   on_retry: () -> Retry
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3302
  def on_retry; end

  # :call-seq:
  #   on_return: (Args arguments) -> ReturnNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3310
  def on_return(arguments); end

  # :call-seq:
  #   on_return0: () -> ReturnNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3321
  def on_return0; end

  # :call-seq:
  #   on_rparen: (String value) -> RParen
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3329
  def on_rparen(value); end

  # :call-seq:
  #   on_sclass: (untyped target, BodyStmt bodystmt) -> SClass
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3348
  def on_sclass(target, bodystmt); end

  # :call-seq:
  #   on_semicolon: (String value) -> Semicolon
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3381
  def on_semicolon(value); end

  # stmts_add is a parser event that represents a single statement inside a
  # list of statements within any lexical block. It accepts as arguments the
  # parent stmts node as well as an stmt which can be any expression in
  # Ruby.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3400
  def on_stmts_add(statements, statement); end

  # :call-seq:
  #   on_stmts_new: () -> Statements
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3413
  def on_stmts_new; end

  # :call-seq:
  #   on_string_add: (
  #     String string,
  #     (StringEmbExpr | StringDVar | TStringContent) part
  #   ) -> StringContent
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3426
  def on_string_add(string, part); end

  # :call-seq:
  #   on_string_concat: (
  #     (StringConcat | StringLiteral) left,
  #     StringLiteral right
  #   ) -> StringConcat
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3443
  def on_string_concat(left, right); end

  # :call-seq:
  #   on_string_content: () -> StringContent
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3453
  def on_string_content; end

  # :call-seq:
  #   on_string_dvar: ((Backref | VarRef) variable) -> StringDVar
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3463
  def on_string_dvar(variable); end

  # :call-seq:
  #   on_string_embexpr: (Statements statements) -> StringEmbExpr
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3474
  def on_string_embexpr(statements); end

  # :call-seq:
  #   on_string_literal: (String string) -> Heredoc | StringLiteral
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3504
  def on_string_literal(string); end

  # :call-seq:
  #   on_super: ((ArgParen | Args) arguments) -> Super
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3544
  def on_super(arguments); end

  # symbeg is a token that represents the beginning of a symbol literal. In
  # most cases it will contain just ":" as in the value, but if its a dynamic
  # symbol being defined it will contain ":'" or ":\"".
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3556
  def on_symbeg(value); end

  # :call-seq:
  #   on_symbol: (
  #     (Backtick | Const | CVar | GVar | Ident | IVar | Kw | Op) value
  #   ) -> SymbolContent
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3577
  def on_symbol(value); end

  # :call-seq:
  #   on_symbol_literal: (
  #     (
  #       Backtick | Const | CVar | GVar | Ident |
  #       IVar | Kw | Op | SymbolContent
  #     ) value
  #   ) -> SymbolLiteral
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3590
  def on_symbol_literal(value); end

  # :call-seq:
  #   on_symbols_add: (Symbols symbols, Word word) -> Symbols
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3606
  def on_symbols_add(symbols, word); end

  # :call-seq:
  #   on_symbols_beg: (String value) -> SymbolsBeg
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3616
  def on_symbols_beg(value); end

  # :call-seq:
  #   on_symbols_new: () -> Symbols
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3635
  def on_symbols_new; end

  # :call-seq:
  #   on_tlambda: (String value) -> TLambda
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3647
  def on_tlambda(value); end

  # :call-seq:
  #   on_tlambeg: (String value) -> TLamBeg
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3666
  def on_tlambeg(value); end

  # :call-seq:
  #   on_top_const_field: (Const constant) -> TopConstRef
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3685
  def on_top_const_field(constant); end

  # :call-seq:
  #   on_top_const_ref: (Const constant) -> TopConstRef
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3696
  def on_top_const_ref(constant); end

  # :call-seq:
  #   on_tstring_beg: (String value) -> TStringBeg
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3707
  def on_tstring_beg(value); end

  # :call-seq:
  #   on_tstring_content: (String value) -> TStringContent
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3726
  def on_tstring_content(value); end

  # :call-seq:
  #   on_tstring_end: (String value) -> TStringEnd
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3741
  def on_tstring_end(value); end

  # :call-seq:
  #   on_unary: (:not operator, untyped statement) -> Not
  #           | (Symbol operator, untyped statement) -> Unary
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3761
  def on_unary(operator, statement); end

  # :call-seq:
  #   on_undef: (Array[DynaSymbol | SymbolLiteral] symbols) -> Undef
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3804
  def on_undef(symbols); end

  # :call-seq:
  #   on_unless: (
  #     untyped predicate,
  #     Statements statements,
  #     ((nil | Elsif | Else) consequent)
  #   ) -> UnlessNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3819
  def on_unless(predicate, statements, consequent); end

  # :call-seq:
  #   on_unless_mod: (untyped predicate, untyped statement) -> UnlessNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3848
  def on_unless_mod(predicate, statement); end

  # :call-seq:
  #   on_until: (untyped predicate, Statements statements) -> UntilNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3862
  def on_until(predicate, statements); end

  # :call-seq:
  #   on_until_mod: (untyped predicate, untyped statement) -> UntilNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3893
  def on_until_mod(predicate, statement); end

  # :call-seq:
  #   on_var_alias: (GVar left, (Backref | GVar) right) -> AliasNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3906
  def on_var_alias(left, right); end

  # :call-seq:
  #   on_var_field: (
  #     (nil | Const | CVar | GVar | Ident | IVar) value
  #   ) -> VarField
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3920
  def on_var_field(value); end

  # :call-seq:
  #   on_var_ref: ((Const | CVar | GVar | Ident | IVar | Kw) value) -> VarRef
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3935
  def on_var_ref(value); end

  # :call-seq:
  #   on_vcall: (Ident ident) -> VCall
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3941
  def on_vcall(ident); end

  # :call-seq:
  #   on_void_stmt: () -> VoidStmt
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3947
  def on_void_stmt; end

  # :call-seq:
  #   on_when: (
  #     Args arguments,
  #     Statements statements,
  #     (nil | Else | When) consequent
  #   ) -> When
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3960
  def on_when(arguments, statements, consequent); end

  # :call-seq:
  #   on_while: (untyped predicate, Statements statements) -> WhileNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3992
  def on_while(predicate, statements); end

  # :call-seq:
  #   on_while_mod: (untyped predicate, untyped statement) -> WhileNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#4023
  def on_while_mod(predicate, statement); end

  # :call-seq:
  #   on_word_add: (
  #     Word word,
  #     (StringEmbExpr | StringDVar | TStringContent) part
  #   ) -> Word
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#4039
  def on_word_add(word, part); end

  # :call-seq:
  #   on_word_new: () -> Word
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#4048
  def on_word_new; end

  # :call-seq:
  #   on_words_add: (Words words, Word word) -> Words
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#4058
  def on_words_add(words, word); end

  # :call-seq:
  #   on_words_beg: (String value) -> WordsBeg
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#4068
  def on_words_beg(value); end

  # :call-seq:
  #   on_words_new: () -> Words
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#4087
  def on_words_new; end

  # :call-seq:
  #   on_xstring_add: (
  #     XString xstring,
  #     (StringEmbExpr | StringDVar | TStringContent) part
  #   ) -> XString
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#4106
  def on_xstring_add(xstring, part); end

  # :call-seq:
  #   on_xstring_literal: (XString xstring) -> Heredoc | XStringLiteral
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#4130
  def on_xstring_literal(xstring); end

  # :call-seq:
  #   on_xstring_new: () -> XString
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#4115
  def on_xstring_new; end

  # :call-seq:
  #   on_yield: ((Args | Paren) arguments) -> YieldNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#4153
  def on_yield(arguments); end

  # :call-seq:
  #   on_yield0: () -> YieldNode
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#4164
  def on_yield0; end

  # :call-seq:
  #   on_zsuper: () -> ZSuper
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#4172
  def on_zsuper; end
end

# Represents a line in the source. If this class is being used, it means
# that there are characters in the string that are multi-byte, so we will
# build up an array of indices, such that array[byteindex] will be equal to
# the index of the character within the string.
#
# source://syntax_tree//lib/syntax_tree/parser.rb#38
class SyntaxTree::Parser::MultiByteString
  # @return [MultiByteString] a new instance of MultiByteString
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#41
  def initialize(start, line); end

  # Technically it's possible for the column index to be a negative value if
  # there's a BOM at the beginning of the file, which is the reason we need
  # to compare it to 0 here.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#55
  def [](byteindex); end

  # Returns the value of attribute indices.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#39
  def indices; end

  # Returns the value of attribute start.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#39
  def start; end
end

# A special parser error so that we can get nice syntax displays on the
# error message when prettier prints out the results.
#
# source://syntax_tree//lib/syntax_tree/parser.rb#9
class SyntaxTree::Parser::ParseError < ::StandardError
  # @return [ParseError] a new instance of ParseError
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#12
  def initialize(error, lineno, column); end

  # Returns the value of attribute column.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#10
  def column; end

  # Returns the value of attribute lineno.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#10
  def lineno; end
end

# Ugh... I really do not like this class. Basically, ripper doesn't provide
# enough information about where pins are located in the tree. It only gives
# events for ^ ops and var_ref nodes. You have to piece it together
# yourself.
#
# Note that there are edge cases here that we straight up do not address,
# because I honestly think it's going to be faster to write a new parser
# than to address them. For example, this will not work properly:
#
#     foo in ^((bar = 0; bar; baz))
#
# If someone actually does something like that, we'll have to find another
# way to make this work.
#
# source://syntax_tree//lib/syntax_tree/parser.rb#656
class SyntaxTree::Parser::PinVisitor < ::SyntaxTree::Visitor
  # @return [PinVisitor] a new instance of PinVisitor
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#659
  def initialize(pins); end

  # Returns the value of attribute pins.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#657
  def pins; end

  # Returns the value of attribute stack.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#657
  def stack; end

  # source://syntax_tree//lib/syntax_tree/parser.rb#664
  def visit(node); end

  # source://syntax_tree//lib/syntax_tree/parser.rb#672
  def visit_var_ref(node); end

  class << self
    # source://syntax_tree//lib/syntax_tree/parser.rb#677
    def visit(node, tokens); end
  end
end

# Semicolons are tokens that get added to the token list but never get
# attached to the AST. Because of this they only need to track their
# associated location so they can be used for computing bounds.
#
# source://syntax_tree//lib/syntax_tree/parser.rb#3371
class SyntaxTree::Parser::Semicolon
  # @return [Semicolon] a new instance of Semicolon
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3374
  def initialize(location); end

  # Returns the value of attribute location.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#3372
  def location; end
end

# Represents a line in the source. If this class is being used, it means
# that every character in the string is 1 byte in length, so we can just
# return the start of the line + the index.
#
# source://syntax_tree//lib/syntax_tree/parser.rb#22
class SyntaxTree::Parser::SingleByteString
  # @return [SingleByteString] a new instance of SingleByteString
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#25
  def initialize(start); end

  # source://syntax_tree//lib/syntax_tree/parser.rb#29
  def [](byteindex); end

  # Returns the value of attribute start.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#23
  def start; end
end

# This represents all of the tokens coming back from the lexer. It is
# replacing a simple array because it keeps track of the last deleted token
# from the list for better error messages.
#
# source://syntax_tree//lib/syntax_tree/parser.rb#63
class SyntaxTree::Parser::TokenList
  # @return [TokenList] a new instance of TokenList
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#66
  def initialize; end

  # source://syntax_tree//lib/syntax_tree/parser.rb#71
  def <<(token); end

  # source://syntax_tree//lib/syntax_tree/parser.rb#75
  def [](index); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#79
  def any?(&block); end

  # source://syntax_tree//lib/syntax_tree/parser.rb#91
  def delete(value); end

  # source://syntax_tree//lib/syntax_tree/parser.rb#95
  def delete_at(index); end

  # Returns the value of attribute last_deleted.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#64
  def last_deleted; end

  # source://syntax_tree//lib/syntax_tree/parser.rb#83
  def reverse_each(&block); end

  # source://syntax_tree//lib/syntax_tree/parser.rb#87
  def rindex(&block); end

  # Returns the value of attribute tokens.
  #
  # source://syntax_tree//lib/syntax_tree/parser.rb#64
  def tokens; end
end

# A pattern is an object that wraps a Ruby pattern matching expression. The
# expression would normally be passed to an `in` clause within a `case`
# expression or a rightward assignment expression. For example, in the
# following snippet:
#
#     case node
#     in Const[value: "SyntaxTree"]
#     end
#
# the pattern is the `Const[value: "SyntaxTree"]` expression. Within Syntax
# Tree, every node generates these kinds of expressions using the
# #construct_keys method.
#
# The pattern gets compiled into an object that responds to call by running
# the #compile method. This method itself will run back through Syntax Tree to
# parse the expression into a tree, then walk the tree to generate the
# necessary callable objects. For example, if you wanted to compile the
# expression above into a callable, you would:
#
#     callable = SyntaxTree::Pattern.new("Const[value: 'SyntaxTree']").compile
#     callable.call(node)
#
# The callable object returned by #compile is guaranteed to respond to #call
# with a single argument, which is the node to match against. It also is
# guaranteed to respond to #===, which means it itself can be used in a `case`
# expression, as in:
#
#     case node
#     when callable
#     end
#
# If the query given to the initializer cannot be compiled into a valid
# matcher (either because of a syntax error or because it is using syntax we
# do not yet support) then a SyntaxTree::Pattern::CompilationError will be
# raised.
#
# source://syntax_tree//lib/syntax_tree/pattern.rb#39
class SyntaxTree::Pattern
  # @return [Pattern] a new instance of Pattern
  #
  # source://syntax_tree//lib/syntax_tree/pattern.rb#61
  def initialize(query); end

  # source://syntax_tree//lib/syntax_tree/pattern.rb#65
  def compile; end

  # Returns the value of attribute query.
  #
  # source://syntax_tree//lib/syntax_tree/pattern.rb#59
  def query; end

  private

  # Shortcut for combining two procs into one that returns true if both return
  # true.
  #
  # source://syntax_tree//lib/syntax_tree/pattern.rb#80
  def combine_and(left, right); end

  # Shortcut for combining two procs into one that returns true if either
  # returns true.
  #
  # source://syntax_tree//lib/syntax_tree/pattern.rb#86
  def combine_or(left, right); end

  # in [foo, bar, baz]
  #
  # source://syntax_tree//lib/syntax_tree/pattern.rb#109
  def compile_aryptn(node); end

  # in foo | bar
  #
  # source://syntax_tree//lib/syntax_tree/pattern.rb#134
  def compile_binary(node); end

  # in Ident
  # in String
  #
  # source://syntax_tree//lib/syntax_tree/pattern.rb#142
  def compile_const(node); end

  # in SyntaxTree::Ident
  #
  # source://syntax_tree//lib/syntax_tree/pattern.rb#159
  def compile_const_path_ref(node); end

  # in :""
  # in :"foo"
  #
  # source://syntax_tree//lib/syntax_tree/pattern.rb#172
  def compile_dyna_symbol(node); end

  # Raise an error because the given node is not supported.
  #
  # @raise [CompilationError]
  #
  # source://syntax_tree//lib/syntax_tree/pattern.rb#91
  def compile_error(node); end

  # in Ident[value: String]
  # in { value: String }
  #
  # source://syntax_tree//lib/syntax_tree/pattern.rb#188
  def compile_hshptn(node); end

  # Compile any kind of node. Dispatch out to the individual compilation
  # methods based on the type of node.
  #
  # source://syntax_tree//lib/syntax_tree/pattern.rb#260
  def compile_node(node); end

  # in /foo/
  #
  # source://syntax_tree//lib/syntax_tree/pattern.rb#214
  def compile_regexp_literal(node); end

  # in ""
  # in "foo"
  #
  # source://syntax_tree//lib/syntax_tree/pattern.rb#226
  def compile_string_literal(node); end

  # in :+
  # in :foo
  #
  # source://syntax_tree//lib/syntax_tree/pattern.rb#238
  def compile_symbol_literal(node); end

  # in Foo
  # in nil
  #
  # source://syntax_tree//lib/syntax_tree/pattern.rb#246
  def compile_var_ref(node); end

  # There are a couple of nodes (string literals, dynamic symbols, and regexp)
  # that contain list of parts. This can include plain string content,
  # interpolated expressions, and interpolated variables. We only support
  # plain string content, so this method will extract out the plain string
  # content if it is the only element in the list.
  #
  # source://syntax_tree//lib/syntax_tree/pattern.rb#100
  def extract_string(node); end
end

# Raised when the query given to a pattern is either invalid Ruby syntax or
# is using syntax that we don't yet support.
#
# source://syntax_tree//lib/syntax_tree/pattern.rb#42
class SyntaxTree::Pattern::CompilationError < ::StandardError
  # @return [CompilationError] a new instance of CompilationError
  #
  # source://syntax_tree//lib/syntax_tree/pattern.rb#43
  def initialize(repr); end
end

# Period represents the use of the +.+ operator. It is usually found in method
# calls.
#
# source://syntax_tree//lib/syntax_tree/node.rb#8554
class SyntaxTree::Period < ::SyntaxTree::Node
  # @return [Period] a new instance of Period
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8560
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8595
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8566
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8570
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8558
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8574
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8570
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8587
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8591
  def format(q); end

  # [String] the period
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8555
  def value; end
end

# PinnedBegin represents a pinning a nested statement within pattern matching.
#
#     case value
#     in ^(statement)
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#1963
class SyntaxTree::PinnedBegin < ::SyntaxTree::Node
  # @return [PinnedBegin] a new instance of PinnedBegin
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1969
  def initialize(statement:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2014
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1975
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1979
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1967
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1983
  def copy(statement: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#1979
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#1996
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#2000
  def format(q); end

  # [Node] the expression being pinned
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#1964
  def statement; end
end

# PinnedVarRef represents a pinned variable reference within a pattern
# matching pattern.
#
#     case value
#     in ^variable
#     end
#
# This can be a plain local variable like the example above. It can also be a
# a class variable, a global variable, or an instance variable.
#
# source://syntax_tree//lib/syntax_tree/node.rb#11662
class SyntaxTree::PinnedVarRef < ::SyntaxTree::Node
  # @return [PinnedVarRef] a new instance of PinnedVarRef
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11668
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11706
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11674
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11678
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11666
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11682
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11678
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11695
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11699
  def format(q); end

  # [Const | CVar | GVar | Ident | IVar] the value of this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11663
  def value; end
end

# This visitor pretty-prints the AST into an equivalent s-expression.
#
# source://syntax_tree//lib/syntax_tree/pretty_print_visitor.rb#5
class SyntaxTree::PrettyPrintVisitor < ::SyntaxTree::FieldVisitor
  # @return [PrettyPrintVisitor] a new instance of PrettyPrintVisitor
  #
  # source://syntax_tree//lib/syntax_tree/pretty_print_visitor.rb#8
  def initialize(q); end

  # Returns the value of attribute q.
  #
  # source://syntax_tree//lib/syntax_tree/pretty_print_visitor.rb#6
  def q; end

  # This is here because we need to make sure the operator is cast to a string
  # before we print it out.
  #
  # source://syntax_tree//lib/syntax_tree/pretty_print_visitor.rb#14
  def visit_binary(node); end

  # This is here to make it a little nicer to look at labels since they
  # typically have their : at the end of the value.
  #
  # source://syntax_tree//lib/syntax_tree/pretty_print_visitor.rb#25
  def visit_label(node); end

  private

  # source://syntax_tree//lib/syntax_tree/pretty_print_visitor.rb#36
  def comments(node); end

  # source://syntax_tree//lib/syntax_tree/pretty_print_visitor.rb#45
  def field(_name, value); end

  # source://syntax_tree//lib/syntax_tree/pretty_print_visitor.rb#50
  def list(_name, values); end

  # source://syntax_tree//lib/syntax_tree/pretty_print_visitor.rb#55
  def node(_node, type); end

  # source://syntax_tree//lib/syntax_tree/pretty_print_visitor.rb#62
  def pairs(_name, values); end

  # source://syntax_tree//lib/syntax_tree/pretty_print_visitor.rb#78
  def text(_name, value); end
end

# Program represents the overall syntax tree.
#
# source://syntax_tree//lib/syntax_tree/node.rb#8602
class SyntaxTree::Program < ::SyntaxTree::Node
  # @return [Program] a new instance of Program
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8608
  def initialize(statements:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8648
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8614
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8618
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8606
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8622
  def copy(statements: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8618
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8635
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8639
  def format(q); end

  # [Statements] the top-level expressions of the program
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8603
  def statements; end
end

# QSymbols represents a symbol literal array without interpolation.
#
#     %i[one two three]
#
# source://syntax_tree//lib/syntax_tree/node.rb#8658
class SyntaxTree::QSymbols < ::SyntaxTree::Node
  # @return [QSymbols] a new instance of QSymbols
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8667
  def initialize(beginning:, elements:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8727
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8674
  def accept(visitor); end

  # [QSymbolsBeg] the token that opens this array literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8659
  def beginning; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8678
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8665
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8682
  def copy(beginning: T.unsafe(nil), elements: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8678
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8696
  def deconstruct_keys(_keys); end

  # [Array[ TStringContent ]] the elements of the array
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8662
  def elements; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8705
  def format(q); end
end

# QSymbolsBeg represents the beginning of a symbol literal array.
#
#     %i[one two three]
#
# In the snippet above, QSymbolsBeg represents the "%i[" token. Note that
# these kinds of arrays can start with a lot of different delimiter types
# (e.g., %i| or %i<).
#
# source://syntax_tree//lib/syntax_tree/node.rb#8741
class SyntaxTree::QSymbolsBeg < ::SyntaxTree::Node
  # @return [QSymbolsBeg] a new instance of QSymbolsBeg
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8744
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8770
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8749
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8753
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8757
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8753
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8766
  def deconstruct_keys(_keys); end

  # [String] the beginning of the array literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8742
  def value; end
end

# QWords represents a string literal array without interpolation.
#
#     %w[one two three]
#
# source://syntax_tree//lib/syntax_tree/node.rb#8780
class SyntaxTree::QWords < ::SyntaxTree::Node
  # @return [QWords] a new instance of QWords
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8789
  def initialize(beginning:, elements:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8845
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8796
  def accept(visitor); end

  # [QWordsBeg] the token that opens this array literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8781
  def beginning; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8800
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8787
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8804
  def copy(beginning: T.unsafe(nil), elements: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8800
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8814
  def deconstruct_keys(_keys); end

  # [Array[ TStringContent ]] the elements of the array
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8784
  def elements; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8823
  def format(q); end
end

# QWordsBeg represents the beginning of a string literal array.
#
#     %w[one two three]
#
# In the snippet above, QWordsBeg represents the "%w[" token. Note that these
# kinds of arrays can start with a lot of different delimiter types (e.g.,
# %w| or %w<).
#
# source://syntax_tree//lib/syntax_tree/node.rb#8859
class SyntaxTree::QWordsBeg < ::SyntaxTree::Node
  # @return [QWordsBeg] a new instance of QWordsBeg
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8862
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8888
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8867
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8871
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8875
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8871
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8884
  def deconstruct_keys(_keys); end

  # [String] the beginning of the array literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8860
  def value; end
end

# Responsible for providing information about quotes to be used for strings
# and dynamic symbols.
#
# source://syntax_tree//lib/syntax_tree/node.rb#4615
module SyntaxTree::Quotes
  class << self
    # If there is some part of this string that matches an escape sequence or
    # that contains the interpolation pattern ("#{"), then we are locked into
    # whichever quote the user chose. (If they chose single quotes, then double
    # quoting would activate the escape sequence, and if they chose double
    # quotes, then single quotes would deactivate it.)
    #
    # @return [Boolean]
    #
    # source://syntax_tree//lib/syntax_tree/node.rb#4624
    def locked?(node, quote); end

    # Find the matching closing quote for the given opening quote.
    #
    # source://syntax_tree//lib/syntax_tree/node.rb#4631
    def matching(quote); end

    # Escape and unescape single and double quotes as needed to be able to
    # enclose +content+ with +enclosing+.
    #
    # source://syntax_tree//lib/syntax_tree/node.rb#4637
    def normalize(content, enclosing); end
  end
end

# The matching pairs of quotes that can be used with % literals.
#
# source://syntax_tree//lib/syntax_tree/node.rb#4617
SyntaxTree::Quotes::PAIRS = T.let(T.unsafe(nil), Hash)

# RAssign represents a single-line pattern match.
#
#     value in pattern
#     value => pattern
#
# source://syntax_tree//lib/syntax_tree/node.rb#3202
class SyntaxTree::RAssign < ::SyntaxTree::Node
  # @return [RAssign] a new instance of RAssign
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3215
  def initialize(value:, operator:, pattern:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3277
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3223
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3227
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3213
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3231
  def copy(value: T.unsafe(nil), operator: T.unsafe(nil), pattern: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3227
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#3246
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#3256
  def format(q); end

  # [Kw | Op] the operator being used to match against the pattern, which is
  # either => or in
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3207
  def operator; end

  # [Node] the pattern on the right-hand side of the expression
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3210
  def pattern; end

  # [Node] the left-hand expression
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#3203
  def value; end
end

# RBrace represents the use of a right brace, i.e., +++.
#
# source://syntax_tree//lib/syntax_tree/node.rb#8946
class SyntaxTree::RBrace < ::SyntaxTree::Node
  # @return [RBrace] a new instance of RBrace
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8949
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8975
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8954
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8958
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8962
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8958
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8971
  def deconstruct_keys(_keys); end

  # [String] the right brace
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8947
  def value; end
end

# RBracket represents the use of a right bracket, i.e., +]+.
#
# source://syntax_tree//lib/syntax_tree/node.rb#8982
class SyntaxTree::RBracket < ::SyntaxTree::Node
  # @return [RBracket] a new instance of RBracket
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8985
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9011
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8990
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8994
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8998
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8994
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9007
  def deconstruct_keys(_keys); end

  # [String] the right bracket
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8983
  def value; end
end

# RParen represents the use of a right parenthesis, i.e., +)+.
#
# source://syntax_tree//lib/syntax_tree/node.rb#9752
class SyntaxTree::RParen < ::SyntaxTree::Node
  # @return [RParen] a new instance of RParen
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9755
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9781
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9760
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9764
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9768
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9764
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9777
  def deconstruct_keys(_keys); end

  # [String] the parenthesis
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9753
  def value; end
end

# RangeNode represents using the .. or the ... operator between two
# expressions. Usually this is to create a range object.
#
#     1..2
#
# Sometimes this operator is used to create a flip-flop.
#
#     if value == 5 .. value == 10
#     end
#
# One of the sides of the expression may be nil, but not both.
#
# source://syntax_tree//lib/syntax_tree/node.rb#4541
class SyntaxTree::RangeNode < ::SyntaxTree::Node
  # @return [RangeNode] a new instance of RangeNode
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4553
  def initialize(left:, operator:, right:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4607
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4561
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4565
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4551
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4569
  def copy(left: T.unsafe(nil), operator: T.unsafe(nil), right: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4565
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#4584
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#4594
  def format(q); end

  # [nil | Node] the left side of the expression
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4542
  def left; end

  # [Op] the operator used for this range
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4545
  def operator; end

  # [nil | Node] the right side of the expression
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#4548
  def right; end
end

# RationalLiteral represents the use of a rational number literal.
#
#     1r
#
# source://syntax_tree//lib/syntax_tree/node.rb#8898
class SyntaxTree::RationalLiteral < ::SyntaxTree::Node
  # @return [RationalLiteral] a new instance of RationalLiteral
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8904
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8939
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8910
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8914
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8902
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8918
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8914
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#8931
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#8935
  def format(q); end

  # [String] the rational number literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#8899
  def value; end
end

# Redo represents the use of the +redo+ keyword.
#
#     redo
#
# source://syntax_tree//lib/syntax_tree/node.rb#9021
class SyntaxTree::Redo < ::SyntaxTree::Node
  # @return [Redo] a new instance of Redo
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9024
  def initialize(location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9054
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9029
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9033
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9022
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9037
  def copy(location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9033
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9046
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9050
  def format(q); end
end

# RegexpBeg represents the start of a regular expression literal.
#
#     /.+/
#
# In the example above, RegexpBeg represents the first / token. Regular
# expression literals can also be declared using the %r syntax, as in:
#
#     %r{.+}
#
# source://syntax_tree//lib/syntax_tree/node.rb#9117
class SyntaxTree::RegexpBeg < ::SyntaxTree::Node
  # @return [RegexpBeg] a new instance of RegexpBeg
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9120
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9146
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9125
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9129
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9133
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9129
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9142
  def deconstruct_keys(_keys); end

  # [String] the beginning of the regular expression
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9118
  def value; end
end

# RegexpContent represents the body of a regular expression.
#
#     /.+ #{pattern} .+/
#
# In the example above, a RegexpContent node represents everything contained
# within the forward slashes.
#
# source://syntax_tree//lib/syntax_tree/node.rb#9066
class SyntaxTree::RegexpContent < ::SyntaxTree::Node
  # @return [RegexpContent] a new instance of RegexpContent
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9073
  def initialize(beginning:, parts:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9101
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9079
  def accept(visitor); end

  # [String] the opening of the regular expression
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9067
  def beginning; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9083
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9087
  def copy(beginning: T.unsafe(nil), parts: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9083
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9097
  def deconstruct_keys(_keys); end

  # [Array[ StringDVar | StringEmbExpr | TStringContent ]] the parts of the
  # regular expression
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9071
  def parts; end
end

# RegexpEnd represents the end of a regular expression literal.
#
#     /.+/m
#
# In the example above, the RegexpEnd event represents the /m at the end of
# the regular expression literal. You can also declare regular expression
# literals using %r, as in:
#
#     %r{.+}m
#
# source://syntax_tree//lib/syntax_tree/node.rb#9162
class SyntaxTree::RegexpEnd < ::SyntaxTree::Node
  # @return [RegexpEnd] a new instance of RegexpEnd
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9165
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9191
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9170
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9174
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9178
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9174
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9187
  def deconstruct_keys(_keys); end

  # [String] the end of the regular expression
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9163
  def value; end
end

# RegexpLiteral represents a regular expression literal.
#
#     /.+/
#
# source://syntax_tree//lib/syntax_tree/node.rb#9201
class SyntaxTree::RegexpLiteral < ::SyntaxTree::Node
  # @return [RegexpLiteral] a new instance of RegexpLiteral
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9214
  def initialize(beginning:, ending:, parts:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9296
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9222
  def accept(visitor); end

  # [String] the beginning of the regular expression literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9202
  def beginning; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9226
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9212
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9230
  def copy(beginning: T.unsafe(nil), ending: T.unsafe(nil), parts: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9226
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9245
  def deconstruct_keys(_keys); end

  # [String] the ending of the regular expression literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9205
  def ending; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9256
  def format(q); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9302
  def options; end

  # [Array[ StringEmbExpr | StringDVar | TStringContent ]] the parts of the
  # regular expression literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9209
  def parts; end

  private

  # If the first part of this regex is plain string content, we have a space
  # or an =, and we're contained within a command or command_call node, then
  # we want to use braces because otherwise we could end up with an ambiguous
  # operator, e.g. foo / bar/ or foo /=bar/
  #
  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9318
  def ambiguous?(q); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9308
  def include?(pattern); end
end

# Rescue represents the use of the rescue keyword inside of a BodyStmt node.
#
#     begin
#     rescue
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#9409
class SyntaxTree::Rescue < ::SyntaxTree::Node
  # @return [Rescue] a new instance of Rescue
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9424
  def initialize(keyword:, exception:, statements:, consequent:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9520
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9455
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9433
  def bind_end(end_char, end_column); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9459
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9422
  def comments; end

  # [nil | Rescue] the optional next clause in the chain
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9419
  def consequent; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9463
  def copy(keyword: T.unsafe(nil), exception: T.unsafe(nil), statements: T.unsafe(nil), consequent: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9459
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9485
  def deconstruct_keys(_keys); end

  # [nil | RescueEx] the exceptions being rescued
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9413
  def exception; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9496
  def format(q); end

  # [Kw] the rescue keyword
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9410
  def keyword; end

  # [Statements] the expressions to evaluate when an error is rescued
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9416
  def statements; end
end

# RescueEx represents the list of exceptions being rescued in a rescue clause.
#
#     begin
#     rescue Exception => exception
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#9334
class SyntaxTree::RescueEx < ::SyntaxTree::Node
  # @return [RescueEx] a new instance of RescueEx
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9344
  def initialize(exceptions:, variable:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9396
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9351
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9355
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9342
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9359
  def copy(exceptions: T.unsafe(nil), variable: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9355
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9373
  def deconstruct_keys(_keys); end

  # [nil | Node] the list of exceptions being rescued
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9335
  def exceptions; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9382
  def format(q); end

  # [nil | Field | VarField] the expression being used to capture the raised
  # exception
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9339
  def variable; end
end

# RescueMod represents the use of the modifier form of a +rescue+ clause.
#
#     expression rescue value
#
# source://syntax_tree//lib/syntax_tree/node.rb#9532
class SyntaxTree::RescueMod < ::SyntaxTree::Node
  # @return [RescueMod] a new instance of RescueMod
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9541
  def initialize(statement:, value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9597
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9548
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9552
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9539
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9556
  def copy(statement: T.unsafe(nil), value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9552
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9570
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9579
  def format(q); end

  # [Node] the expression to execute
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9533
  def statement; end

  # [Node] the value to use if the executed expression raises an error
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9536
  def value; end
end

# RestParam represents defining a parameter in a method definition that
# accepts all remaining positional parameters.
#
#     def method(*rest) end
#
# source://syntax_tree//lib/syntax_tree/node.rb#9609
class SyntaxTree::RestParam < ::SyntaxTree::Node
  # @return [RestParam] a new instance of RestParam
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9615
  def initialize(name:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9651
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9621
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9625
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9613
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9629
  def copy(name: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9625
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9642
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9646
  def format(q); end

  # [nil | Ident] the name of the parameter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9610
  def name; end
end

# Retry represents the use of the +retry+ keyword.
#
#     retry
#
# source://syntax_tree//lib/syntax_tree/node.rb#9661
class SyntaxTree::Retry < ::SyntaxTree::Node
  # @return [Retry] a new instance of Retry
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9664
  def initialize(location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9694
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9669
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9673
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9662
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9677
  def copy(location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9673
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9686
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9690
  def format(q); end
end

# Return represents using the +return+ keyword with arguments.
#
#     return value
#
# source://syntax_tree//lib/syntax_tree/node.rb#9704
class SyntaxTree::ReturnNode < ::SyntaxTree::Node
  # @return [ReturnNode] a new instance of ReturnNode
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9710
  def initialize(arguments:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9745
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9716
  def accept(visitor); end

  # [nil | Args] the arguments being passed to the keyword
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9705
  def arguments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9720
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9708
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9724
  def copy(arguments: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9720
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9737
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9741
  def format(q); end
end

# SClass represents a block of statements that should be evaluated within the
# context of the singleton class of an object. It's frequently used to define
# singleton methods.
#
#     class << self
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#9794
class SyntaxTree::SClass < ::SyntaxTree::Node
  # @return [SClass] a new instance of SClass
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9803
  def initialize(target:, bodystmt:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9854
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9810
  def accept(visitor); end

  # [BodyStmt] the expressions to be executed
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9798
  def bodystmt; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9814
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9801
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9818
  def copy(target: T.unsafe(nil), bodystmt: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9814
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9832
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9841
  def format(q); end

  # [Node] the target of the singleton class to enter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9795
  def target; end
end

# Provides an interface for searching for a pattern of nodes against a
# subtree of an AST.
#
# source://syntax_tree//lib/syntax_tree/search.rb#6
class SyntaxTree::Search
  # @return [Search] a new instance of Search
  #
  # source://syntax_tree//lib/syntax_tree/search.rb#9
  def initialize(pattern); end

  # Returns the value of attribute pattern.
  #
  # source://syntax_tree//lib/syntax_tree/search.rb#7
  def pattern; end

  # source://syntax_tree//lib/syntax_tree/search.rb#13
  def scan(root); end
end

# Everything that has a block of code inside of it has a list of statements.
# Normally we would just track those as a node that has an array body, but we
# have some special handling in order to handle empty statement lists. They
# need to have the right location information, so all of the parent node of
# stmts nodes will report back down the location information. We then
# propagate that onto void_stmt nodes inside the stmts in order to make sure
# all comments get printed appropriately.
#
# source://syntax_tree//lib/syntax_tree/node.rb#9868
class SyntaxTree::Statements < ::SyntaxTree::Node
  # @return [Statements] a new instance of Statements
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9874
  def initialize(body:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10000
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9927
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9880
  def bind(parser, start_char, start_column, end_char, end_column); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9909
  def bind_end(end_char, end_column); end

  # [Array[ Node ]] the list of expressions contained within this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9869
  def body; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9931
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9872
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9935
  def copy(body: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#9931
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9948
  def deconstruct_keys(_keys); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#9921
  def empty?; end

  # source://syntax_tree//lib/syntax_tree/node.rb#9952
  def format(q); end

  private

  # As efficiently as possible, gather up all of the comments that have been
  # found while this statements list was being parsed and add them into the
  # body.
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10009
  def attach_comments(parser, start_char, end_char); end
end

# StringConcat represents concatenating two strings together using a backward
# slash.
#
#     "first" \
#       "second"
#
# source://syntax_tree//lib/syntax_tree/node.rb#10126
class SyntaxTree::StringConcat < ::SyntaxTree::Node
  # @return [StringConcat] a new instance of StringConcat
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10135
  def initialize(left:, right:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10179
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10142
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10146
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10133
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10150
  def copy(left: T.unsafe(nil), right: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10146
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10164
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10168
  def format(q); end

  # [Heredoc | StringConcat | StringLiteral] the left side of the
  # concatenation
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10127
  def left; end

  # [StringLiteral] the right side of the concatenation
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10130
  def right; end
end

# StringContent represents the contents of a string-like value.
#
#     "string"
#
# source://syntax_tree//lib/syntax_tree/node.rb#10053
class SyntaxTree::StringContent < ::SyntaxTree::Node
  # @return [StringContent] a new instance of StringContent
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10059
  def initialize(parts:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10086
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10065
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10069
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10057
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10073
  def copy(parts: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10069
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10082
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10090
  def format(q); end

  # [Array[ StringEmbExpr | StringDVar | TStringContent ]] the parts of the
  # string
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10054
  def parts; end
end

# StringDVar represents shorthand interpolation of a variable into a string.
# It allows you to take an instance variable, class variable, or global
# variable and omit the braces when interpolating.
#
#     "#@variable"
#
# source://syntax_tree//lib/syntax_tree/node.rb#10191
class SyntaxTree::StringDVar < ::SyntaxTree::Node
  # @return [StringDVar] a new instance of StringDVar
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10197
  def initialize(variable:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10234
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10203
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10207
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10195
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10211
  def copy(variable: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10207
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10224
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10228
  def format(q); end

  # [Backref | VarRef] the variable being interpolated
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10192
  def variable; end
end

# StringEmbExpr represents interpolated content. It can be contained within a
# couple of different parent nodes, including regular expressions, strings,
# and dynamic symbols.
#
#     "string #{expression}"
#
# source://syntax_tree//lib/syntax_tree/node.rb#10246
class SyntaxTree::StringEmbExpr < ::SyntaxTree::Node
  # @return [StringEmbExpr] a new instance of StringEmbExpr
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10252
  def initialize(statements:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10309
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10258
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10262
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10250
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10266
  def copy(statements: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10262
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10279
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10283
  def format(q); end

  # [Statements] the expressions to be interpolated
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10247
  def statements; end
end

# StringLiteral represents a string literal.
#
#     "string"
#
# source://syntax_tree//lib/syntax_tree/node.rb#10320
class SyntaxTree::StringLiteral < ::SyntaxTree::Node
  # @return [StringLiteral] a new instance of StringLiteral
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10329
  def initialize(parts:, quote:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10403
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10336
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10340
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10327
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10344
  def copy(parts: T.unsafe(nil), quote: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10340
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10358
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10362
  def format(q); end

  # [Array[ StringEmbExpr | StringDVar | TStringContent ]] the parts of the
  # string literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10321
  def parts; end

  # [nil | String] which quote was used by the string literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10324
  def quote; end
end

# Super represents using the +super+ keyword with arguments. It can optionally
# use parentheses.
#
#     super(value)
#
# source://syntax_tree//lib/syntax_tree/node.rb#10415
class SyntaxTree::Super < ::SyntaxTree::Node
  # @return [Super] a new instance of Super
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10421
  def initialize(arguments:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10465
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10427
  def accept(visitor); end

  # [ArgParen | Args] the arguments to the keyword
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10416
  def arguments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10431
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10419
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10435
  def copy(arguments: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10431
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10448
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10452
  def format(q); end
end

# SymBeg represents the beginning of a symbol literal.
#
#     :symbol
#
# SymBeg is also used for dynamic symbols, as in:
#
#     :"symbol"
#
# Finally, SymBeg is also used for symbols using the %s syntax, as in:
#
#     %s[symbol]
#
# The value of this node is a string. In most cases (as in the first example
# above) it will contain just ":". In the case of dynamic symbols it will
# contain ":'" or ":\"". In the case of %s symbols, it will contain the start
# of the symbol including the %s and the delimiter.
#
# source://syntax_tree//lib/syntax_tree/node.rb#10487
class SyntaxTree::SymBeg < ::SyntaxTree::Node
  # @return [SymBeg] a new instance of SymBeg
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10490
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10516
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10495
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10499
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10503
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10499
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10512
  def deconstruct_keys(_keys); end

  # [String] the beginning of the symbol
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10488
  def value; end
end

# SymbolContent represents symbol contents and is always the child of a
# SymbolLiteral node.
#
#     :symbol
#
# source://syntax_tree//lib/syntax_tree/node.rb#10528
class SyntaxTree::SymbolContent < ::SyntaxTree::Node
  # @return [SymbolContent] a new instance of SymbolContent
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10531
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10557
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10536
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10540
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10544
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10540
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10553
  def deconstruct_keys(_keys); end

  # [Backtick | Const | CVar | GVar | Ident | IVar | Kw | Op] the value of the
  # symbol
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10529
  def value; end
end

# SymbolLiteral represents a symbol in the system with no interpolation
# (as opposed to a DynaSymbol which has interpolation).
#
#     :symbol
#
# source://syntax_tree//lib/syntax_tree/node.rb#10569
class SyntaxTree::SymbolLiteral < ::SyntaxTree::Node
  # @return [SymbolLiteral] a new instance of SymbolLiteral
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10575
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10612
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10581
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10585
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10573
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10589
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10585
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10602
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10606
  def format(q); end

  # [Backtick | Const | CVar | GVar | Ident | IVar | Kw | Op | TStringContent]
  # the value of the symbol
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10570
  def value; end
end

# Symbols represents a symbol array literal with interpolation.
#
#     %I[one two three]
#
# source://syntax_tree//lib/syntax_tree/node.rb#10622
class SyntaxTree::Symbols < ::SyntaxTree::Node
  # @return [Symbols] a new instance of Symbols
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10631
  def initialize(beginning:, elements:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10687
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10638
  def accept(visitor); end

  # [SymbolsBeg] the token that opens this array literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10623
  def beginning; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10642
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10629
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10646
  def copy(beginning: T.unsafe(nil), elements: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10642
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10656
  def deconstruct_keys(_keys); end

  # [Array[ Word ]] the words in the symbol array literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10626
  def elements; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10665
  def format(q); end
end

# SymbolsBeg represents the start of a symbol array literal with
# interpolation.
#
#     %I[one two three]
#
# In the snippet above, SymbolsBeg represents the "%I[" token. Note that these
# kinds of arrays can start with a lot of different delimiter types
# (e.g., %I| or %I<).
#
# source://syntax_tree//lib/syntax_tree/node.rb#10702
class SyntaxTree::SymbolsBeg < ::SyntaxTree::Node
  # @return [SymbolsBeg] a new instance of SymbolsBeg
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10705
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10731
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10710
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10714
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10718
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10714
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10727
  def deconstruct_keys(_keys); end

  # [String] the beginning of the symbol literal array
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10703
  def value; end
end

# TLamBeg represents the beginning of the body of a lambda literal using
# braces.
#
#     -> { value }
#
# In the example above the TLamBeg represents the +{+ operator.
#
# source://syntax_tree//lib/syntax_tree/node.rb#10783
class SyntaxTree::TLamBeg < ::SyntaxTree::Node
  # @return [TLamBeg] a new instance of TLamBeg
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10786
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10812
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10791
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10795
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10799
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10795
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10808
  def deconstruct_keys(_keys); end

  # [String] the beginning of the body of the lambda literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10784
  def value; end
end

# TLambda represents the beginning of a lambda literal.
#
#     -> { value }
#
# In the example above the TLambda represents the +->+ operator.
#
# source://syntax_tree//lib/syntax_tree/node.rb#10742
class SyntaxTree::TLambda < ::SyntaxTree::Node
  # @return [TLambda] a new instance of TLambda
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10745
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10771
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10750
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10754
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10758
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10754
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10767
  def deconstruct_keys(_keys); end

  # [String] the beginning of the lambda literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10743
  def value; end
end

# TStringBeg represents the beginning of a string literal.
#
#     "string"
#
# In the example above, TStringBeg represents the first set of quotes. Strings
# can also use single quotes. They can also be declared using the +%q+ and
# +%Q+ syntax, as in:
#
#     %q{string}
#
# source://syntax_tree//lib/syntax_tree/node.rb#10935
class SyntaxTree::TStringBeg < ::SyntaxTree::Node
  # @return [TStringBeg] a new instance of TStringBeg
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10938
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10964
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10943
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10947
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10951
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10947
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10960
  def deconstruct_keys(_keys); end

  # [String] the beginning of the string
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10936
  def value; end
end

# TStringContent represents plain characters inside of an entity that accepts
# string content like a string, heredoc, command string, or regular
# expression.
#
#     "string"
#
# In the example above, TStringContent represents the +string+ token contained
# within the string.
#
# source://syntax_tree//lib/syntax_tree/node.rb#10978
class SyntaxTree::TStringContent < ::SyntaxTree::Node
  # @return [TStringContent] a new instance of TStringContent
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10984
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11023
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10994
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10998
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10982
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11002
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10998
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11015
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11019
  def format(q); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10990
  def match?(pattern); end

  # [String] the content of the string
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10979
  def value; end
end

# TStringEnd represents the end of a string literal.
#
#     "string"
#
# In the example above, TStringEnd represents the second set of quotes.
# Strings can also use single quotes. They can also be declared using the +%q+
# and +%Q+ syntax, as in:
#
#     %q{string}
#
# source://syntax_tree//lib/syntax_tree/node.rb#11039
class SyntaxTree::TStringEnd < ::SyntaxTree::Node
  # @return [TStringEnd] a new instance of TStringEnd
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11042
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11068
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11047
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11051
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11055
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11051
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11064
  def deconstruct_keys(_keys); end

  # [String] the end of the string
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11040
  def value; end
end

# In order for an `if` or `unless` expression to be shortened to a ternary,
# there has to be one and only one consequent clause which is an Else. Both
# the body of the main node and the body of the Else node must have only one
# statement, and that statement must not be on the denied list of potential
# statements.
#
# source://syntax_tree//lib/syntax_tree/node.rb#6254
module SyntaxTree::Ternaryable
  class << self
    # source://syntax_tree//lib/syntax_tree/node.rb#6256
    def call(q, node); end

    private

    # Certain expressions cannot be reduced to a ternary without adding
    # parentheses around them. In this case we say they cannot be ternaried
    # and default instead to breaking them into multiple lines.
    #
    # @return [Boolean]
    #
    # source://syntax_tree//lib/syntax_tree/node.rb#6294
    def ternaryable?(statement); end
  end
end

# TopConstField is always the child node of some kind of assignment. It
# represents when you're assigning to a constant that is being referenced at
# the top level.
#
#     ::Constant = value
#
# source://syntax_tree//lib/syntax_tree/node.rb#10824
class SyntaxTree::TopConstField < ::SyntaxTree::Node
  # @return [TopConstField] a new instance of TopConstField
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10830
  def initialize(constant:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10866
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10836
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10840
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10828
  def comments; end

  # [Const] the constant being assigned
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10825
  def constant; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10844
  def copy(constant: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10840
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10857
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10861
  def format(q); end
end

# TopConstRef is very similar to TopConstField except that it is not involved
# in an assignment.
#
#     ::Constant
#
# source://syntax_tree//lib/syntax_tree/node.rb#10877
class SyntaxTree::TopConstRef < ::SyntaxTree::Node
  # @return [TopConstRef] a new instance of TopConstRef
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10883
  def initialize(constant:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10919
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10889
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10893
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10881
  def comments; end

  # [Const] the constant being referenced
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#10878
  def constant; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10897
  def copy(constant: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10893
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#10910
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#10914
  def format(q); end
end

# This module is responsible for translating the Syntax Tree syntax tree into
# other representations.
#
# source://syntax_tree//lib/syntax_tree/translation.rb#6
module SyntaxTree::Translation
  class << self
    # This method translates the given node into the representation defined by
    # the whitequark/parser gem. We don't explicitly list it as a dependency
    # because it's not required for the core functionality of Syntax Tree.
    #
    # source://syntax_tree//lib/syntax_tree/translation.rb#10
    def to_parser(node, buffer); end

    # This method translates the given node into the representation defined by
    # the rubocop/rubocop-ast gem. We don't explicitly list it as a dependency
    # because it's not required for the core functionality of Syntax Tree.
    #
    # source://syntax_tree//lib/syntax_tree/translation.rb#20
    def to_rubocop_ast(node, buffer); end
  end
end

# Unary represents a unary method being called on an expression, as in +!+ or
# +~+.
#
#     !value
#
# source://syntax_tree//lib/syntax_tree/node.rb#11162
class SyntaxTree::Unary < ::SyntaxTree::Node
  # @return [Unary] a new instance of Unary
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11171
  def initialize(operator:, statement:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11214
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11178
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11182
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11169
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11186
  def copy(operator: T.unsafe(nil), statement: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11182
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11200
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11209
  def format(q); end

  # [String] the operator being used
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11163
  def operator; end

  # [Node] the statement on which to operate
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11166
  def statement; end
end

# Undef represents the use of the +undef+ keyword.
#
#     undef method
#
# source://syntax_tree//lib/syntax_tree/node.rb#11227
class SyntaxTree::Undef < ::SyntaxTree::Node
  # @return [Undef] a new instance of Undef
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11255
  def initialize(symbols:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11298
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11261
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11265
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11253
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11269
  def copy(symbols: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11265
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11282
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11286
  def format(q); end

  # [Array[ DynaSymbol | SymbolLiteral ]] the symbols to undefine
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11250
  def symbols; end
end

# Undef accepts a variable number of arguments that can be either DynaSymbol
# or SymbolLiteral objects. For SymbolLiteral objects we descend directly
# into the value in order to have it come out as bare words.
#
# source://syntax_tree//lib/syntax_tree/node.rb#11228
class SyntaxTree::Undef::UndefArgumentFormatter
  # @return [UndefArgumentFormatter] a new instance of UndefArgumentFormatter
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11232
  def initialize(node); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11236
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11244
  def format(q); end

  # [DynaSymbol | SymbolLiteral] the symbol to undefine
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11230
  def node; end
end

# Unless represents the first clause in an +unless+ chain.
#
#     unless predicate
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#11309
class SyntaxTree::UnlessNode < ::SyntaxTree::Node
  # @return [UnlessNode] a new instance of UnlessNode
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11321
  def initialize(predicate:, statements:, consequent:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11366
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11329
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11333
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11319
  def comments; end

  # [nil | Elsif | Else] the next clause in the chain
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11316
  def consequent; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11337
  def copy(predicate: T.unsafe(nil), statements: T.unsafe(nil), consequent: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11333
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11352
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11362
  def format(q); end

  # Checks if the node was originally found in the modifier form.
  #
  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11372
  def modifier?; end

  # [Node] the expression to be checked
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11310
  def predicate; end

  # [Statements] the expressions to be executed
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11313
  def statements; end
end

# Until represents an +until+ loop.
#
#     until predicate
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#11455
class SyntaxTree::UntilNode < ::SyntaxTree::Node
  # @return [UntilNode] a new instance of UntilNode
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11464
  def initialize(predicate:, statements:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11506
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11471
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11475
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11462
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11479
  def copy(predicate: T.unsafe(nil), statements: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11475
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11493
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11502
  def format(q); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11511
  def modifier?; end

  # [Node] the expression to be checked
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11456
  def predicate; end

  # [Statements] the expressions to be executed
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11459
  def statements; end
end

# VCall represent any plain named object with Ruby that could be either a
# local variable or a method call.
#
#     variable
#
# source://syntax_tree//lib/syntax_tree/node.rb#11717
class SyntaxTree::VCall < ::SyntaxTree::Node
  # @return [VCall] a new instance of VCall
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11723
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11758
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11729
  def accept(visitor); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11762
  def access_control?; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11766
  def arity; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11733
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11721
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11737
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11733
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11750
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11754
  def format(q); end

  # [Ident] the value of this expression
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11718
  def value; end
end

# source://syntax_tree//lib/syntax_tree/version.rb#4
SyntaxTree::VERSION = T.let(T.unsafe(nil), String)

# VarField represents a variable that is being assigned a value. As such, it
# is always a child of an assignment type node.
#
#     variable = value
#
# In the example above, the VarField node represents the +variable+ token.
#
# source://syntax_tree//lib/syntax_tree/node.rb#11523
class SyntaxTree::VarField < ::SyntaxTree::Node
  # @return [VarField] a new instance of VarField
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11529
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11568
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11535
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11539
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11527
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11543
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11539
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11556
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11560
  def format(q); end

  # [nil | :nil | Const | CVar | GVar | Ident | IVar] the target of this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11524
  def value; end
end

# VarRef represents a variable reference.
#
#     true
#
# This can be a plain local variable like the example above. It can also be a
# constant, a class variable, a global variable, an instance variable, a
# keyword (like +self+, +nil+, +true+, or +false+), or a numbered block
# variable.
#
# source://syntax_tree//lib/syntax_tree/node.rb#11582
class SyntaxTree::VarRef < ::SyntaxTree::Node
  # @return [VarRef] a new instance of VarRef
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11588
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11623
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11594
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11598
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11586
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11602
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11598
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11615
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11619
  def format(q); end

  # Oh man I hate this so much. Basically, ripper doesn't provide enough
  # functionality to actually know where pins are within an expression. So we
  # have to walk the tree ourselves and insert more information. In doing so,
  # we have to replace this node by a pinned node when necessary.
  #
  # To be clear, this method should just not exist. It's not good. It's a
  # place of shame. But it's necessary for now, so I'm keeping it.
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11634
  def pin(parent, pin); end

  # [Const | CVar | GVar | Ident | IVar | Kw] the value of this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11583
  def value; end
end

# Visitor is a parent class that provides the ability to walk down the tree
# and handle a subset of nodes. By defining your own subclass, you can
# explicitly handle a node type by defining a visit_* method.
#
# source://syntax_tree//lib/syntax_tree/visitor.rb#8
class SyntaxTree::Visitor < ::SyntaxTree::BasicVisitor
  # Visit a BEGINBlock node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_BEGIN(node); end

  # Visit a CHAR node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_CHAR(node); end

  # Visit an ENDBlock node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_END(node); end

  # Visit an EndContent node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit___end__(node); end

  # Visit an AliasNode node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_alias(node); end

  # Visit an ARef node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_aref(node); end

  # Visit an ARefField node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_aref_field(node); end

  # Visit an ArgBlock node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_arg_block(node); end

  # Visit an ArgParen node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_arg_paren(node); end

  # Visit an ArgStar node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_arg_star(node); end

  # Visit an Args node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_args(node); end

  # Visit an ArgsForward node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_args_forward(node); end

  # Visit an ArrayLiteral node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_array(node); end

  # Visit an AryPtn node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_aryptn(node); end

  # Visit an Assign node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_assign(node); end

  # Visit an Assoc node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_assoc(node); end

  # Visit an AssocSplat node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_assoc_splat(node); end

  # Visit a Backref node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_backref(node); end

  # Visit a Backtick node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_backtick(node); end

  # Visit a BareAssocHash node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_bare_assoc_hash(node); end

  # Visit a Begin node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_begin(node); end

  # Visit a Binary node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_binary(node); end

  # Visit a Block node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_block(node); end

  # Visit a BlockVar node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_block_var(node); end

  # Visit a BlockArg node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_blockarg(node); end

  # Visit a BodyStmt node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_bodystmt(node); end

  # Visit a Break node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_break(node); end

  # Visit a Call node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_call(node); end

  # Visit a Case node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_case(node); end

  # Visit a ClassDeclaration node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_class(node); end

  # Visit a Comma node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_comma(node); end

  # Visit a Command node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_command(node); end

  # Visit a CommandCall node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_command_call(node); end

  # Visit a Comment node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_comment(node); end

  # Visit a Const node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_const(node); end

  # Visit a ConstPathField node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_const_path_field(node); end

  # Visit a ConstPathRef node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_const_path_ref(node); end

  # Visit a ConstRef node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_const_ref(node); end

  # Visit a CVar node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_cvar(node); end

  # Visit a Def node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_def(node); end

  # Visit a Defined node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_defined(node); end

  # Visit a DynaSymbol node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_dyna_symbol(node); end

  # Visit an Else node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_else(node); end

  # Visit an Elsif node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_elsif(node); end

  # Visit an EmbDoc node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_embdoc(node); end

  # Visit an EmbExprBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_embexpr_beg(node); end

  # Visit an EmbExprEnd node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_embexpr_end(node); end

  # Visit an EmbVar node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_embvar(node); end

  # Visit an Ensure node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_ensure(node); end

  # Visit an ExcessedComma node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_excessed_comma(node); end

  # Visit a Field node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_field(node); end

  # Visit a FloatLiteral node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_float(node); end

  # Visit a FndPtn node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_fndptn(node); end

  # Visit a For node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_for(node); end

  # Visit a GVar node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_gvar(node); end

  # Visit a HashLiteral node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_hash(node); end

  # Visit a Heredoc node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_heredoc(node); end

  # Visit a HeredocBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_heredoc_beg(node); end

  # Visit a HeredocEnd node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_heredoc_end(node); end

  # Visit a HshPtn node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_hshptn(node); end

  # Visit an Ident node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_ident(node); end

  # Visit an IfNode node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_if(node); end

  # Visit an IfOp node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_if_op(node); end

  # Visit an Imaginary node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_imaginary(node); end

  # Visit an In node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_in(node); end

  # Visit an Int node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_int(node); end

  # Visit an IVar node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_ivar(node); end

  # Visit a Kw node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_kw(node); end

  # Visit a KwRestParam node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_kwrest_param(node); end

  # Visit a Label node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_label(node); end

  # Visit a LabelEnd node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_label_end(node); end

  # Visit a Lambda node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_lambda(node); end

  # Visit a LambdaVar node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_lambda_var(node); end

  # Visit a LBrace node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_lbrace(node); end

  # Visit a LBracket node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_lbracket(node); end

  # Visit a LParen node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_lparen(node); end

  # Visit a MAssign node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_massign(node); end

  # Visit a MethodAddBlock node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_method_add_block(node); end

  # Visit a MLHS node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_mlhs(node); end

  # Visit a MLHSParen node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_mlhs_paren(node); end

  # Visit a ModuleDeclaration node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_module(node); end

  # Visit a MRHS node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_mrhs(node); end

  # Visit a Next node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_next(node); end

  # Visit a Not node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_not(node); end

  # Visit an Op node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_op(node); end

  # Visit an OpAssign node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_opassign(node); end

  # Visit a Params node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_params(node); end

  # Visit a Paren node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_paren(node); end

  # Visit a Period node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_period(node); end

  # Visit a PinnedBegin node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_pinned_begin(node); end

  # Visit a PinnedVarRef node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_pinned_var_ref(node); end

  # Visit a Program node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_program(node); end

  # Visit a QSymbols node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_qsymbols(node); end

  # Visit a QSymbolsBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_qsymbols_beg(node); end

  # Visit a QWords node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_qwords(node); end

  # Visit a QWordsBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_qwords_beg(node); end

  # Visit a RangeNode node
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_range(node); end

  # Visit a RAssign node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_rassign(node); end

  # Visit a RationalLiteral node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_rational(node); end

  # Visit a RBrace node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_rbrace(node); end

  # Visit a RBracket node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_rbracket(node); end

  # Visit a Redo node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_redo(node); end

  # Visit a RegexpBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_regexp_beg(node); end

  # Visit a RegexpContent node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_regexp_content(node); end

  # Visit a RegexpEnd node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_regexp_end(node); end

  # Visit a RegexpLiteral node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_regexp_literal(node); end

  # Visit a Rescue node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_rescue(node); end

  # Visit a RescueEx node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_rescue_ex(node); end

  # Visit a RescueMod node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_rescue_mod(node); end

  # Visit a RestParam node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_rest_param(node); end

  # Visit a Retry node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_retry(node); end

  # Visit a Return node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_return(node); end

  # Visit a RParen node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_rparen(node); end

  # Visit a SClass node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_sclass(node); end

  # Visit a Statements node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_statements(node); end

  # Visit a StringConcat node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_string_concat(node); end

  # Visit a StringContent node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_string_content(node); end

  # Visit a StringDVar node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_string_dvar(node); end

  # Visit a StringEmbExpr node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_string_embexpr(node); end

  # Visit a StringLiteral node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_string_literal(node); end

  # Visit a Super node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_super(node); end

  # Visit a SymBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_symbeg(node); end

  # Visit a SymbolContent node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_symbol_content(node); end

  # Visit a SymbolLiteral node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_symbol_literal(node); end

  # Visit a Symbols node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_symbols(node); end

  # Visit a SymbolsBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_symbols_beg(node); end

  # Visit a TLambda node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_tlambda(node); end

  # Visit a TLamBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_tlambeg(node); end

  # Visit a TopConstField node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_top_const_field(node); end

  # Visit a TopConstRef node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_top_const_ref(node); end

  # Visit a TStringBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_tstring_beg(node); end

  # Visit a TStringContent node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_tstring_content(node); end

  # Visit a TStringEnd node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_tstring_end(node); end

  # Visit an Unary node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_unary(node); end

  # Visit an Undef node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_undef(node); end

  # Visit an UnlessNode node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_unless(node); end

  # Visit an UntilNode node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_until(node); end

  # Visit a VarField node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_var_field(node); end

  # Visit a VarRef node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_var_ref(node); end

  # Visit a VCall node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_vcall(node); end

  # Visit a VoidStmt node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_void_stmt(node); end

  # Visit a When node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_when(node); end

  # Visit a WhileNode node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_while(node); end

  # Visit a Word node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_word(node); end

  # Visit a Words node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_words(node); end

  # Visit a WordsBeg node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_words_beg(node); end

  # Visit a XString node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_xstring(node); end

  # Visit a XStringLiteral node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_xstring_literal(node); end

  # Visit a YieldNode node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_yield(node); end

  # Visit a ZSuper node.
  #
  # source://syntax_tree//lib/syntax_tree/basic_visitor.rb#113
  def visit_zsuper(node); end
end

# VoidStmt represents an empty lexical block of code.
#
#     ;;
#
# source://syntax_tree//lib/syntax_tree/node.rb#11776
class SyntaxTree::VoidStmt < ::SyntaxTree::Node
  # @return [VoidStmt] a new instance of VoidStmt
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11779
  def initialize(location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11808
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11784
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11788
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11777
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11792
  def copy(location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11788
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11801
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11805
  def format(q); end
end

# When represents a +when+ clause in a +case+ chain.
#
#     case value
#     when predicate
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#11820
class SyntaxTree::When < ::SyntaxTree::Node
  # @return [When] a new instance of When
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11832
  def initialize(arguments:, statements:, consequent:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11924
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11840
  def accept(visitor); end

  # [Args] the arguments to the when clause
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11821
  def arguments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11844
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11830
  def comments; end

  # [nil | Else | When] the next clause in the chain
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11827
  def consequent; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11848
  def copy(arguments: T.unsafe(nil), statements: T.unsafe(nil), consequent: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11844
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11863
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11889
  def format(q); end

  # [Statements] the expressions to be executed
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11824
  def statements; end
end

# We're going to keep a single instance of this separator around so we don't
# have to allocate a new one every time we format a when clause.
#
# source://syntax_tree//lib/syntax_tree/node.rb#11887
SyntaxTree::When::SEPARATOR = T.let(T.unsafe(nil), SyntaxTree::When::Separator)

# We have a special separator here for when clauses which causes them to
# fill as much of the line as possible as opposed to everything breaking
# into its own line as soon as you hit the print limit.
#
# source://syntax_tree//lib/syntax_tree/node.rb#11876
class SyntaxTree::When::Separator
  # source://syntax_tree//lib/syntax_tree/node.rb#11877
  def call(q); end
end

# While represents a +while+ loop.
#
#     while predicate
#     end
#
# source://syntax_tree//lib/syntax_tree/node.rb#11936
class SyntaxTree::WhileNode < ::SyntaxTree::Node
  # @return [WhileNode] a new instance of WhileNode
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11945
  def initialize(predicate:, statements:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11987
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11952
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11956
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11943
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11960
  def copy(predicate: T.unsafe(nil), statements: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11956
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#11974
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#11983
  def format(q); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11992
  def modifier?; end

  # [Node] the expression to be checked
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11937
  def predicate; end

  # [Statements] the expressions to be executed
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#11940
  def statements; end
end

# WithScope is a module intended to be included in classes inheriting from
# Visitor. The module overrides a few visit methods to automatically keep
# track of local variables and arguments defined in the current scope.
# Example usage:
#
#     class MyVisitor < Visitor
#       include WithScope
#
#       def visit_ident(node)
#         # Check if we're visiting an identifier for an argument, a local
#         # variable or something else
#         local = current_scope.find_local(node)
#
#         if local.type == :argument
#           # handle identifiers for arguments
#         elsif local.type == :variable
#           # handle identifiers for variables
#         else
#           # handle other identifiers, such as method names
#         end
#       end
#     end
#
# source://syntax_tree//lib/syntax_tree/with_scope.rb#27
module SyntaxTree::WithScope
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#122
  def initialize(*args, **kwargs, &block); end

  # Returns the value of attribute current_scope.
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#120
  def current_scope; end

  # Visit for capturing local variables defined in regex named capture groups
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#236
  def visit_binary(node); end

  # source://syntax_tree//lib/syntax_tree/with_scope.rb#189
  def visit_block_var(node); end

  # source://syntax_tree//lib/syntax_tree/with_scope.rb#182
  def visit_blockarg(node); end

  # Visits for nodes that create new scopes, such as classes, modules
  # and method definitions.
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#131
  def visit_class(node); end

  # source://syntax_tree//lib/syntax_tree/with_scope.rb#147
  def visit_def(node); end

  # source://syntax_tree//lib/syntax_tree/with_scope.rb#175
  def visit_kwrest_param(node); end

  # source://syntax_tree//lib/syntax_tree/with_scope.rb#189
  def visit_lambda_var(node); end

  # When we find a method invocation with a block, only the code that happens
  # inside of the block needs a fresh scope. The method invocation
  # itself happens in the same scope.
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#142
  def visit_method_add_block(node); end

  # source://syntax_tree//lib/syntax_tree/with_scope.rb#135
  def visit_module(node); end

  # Visit for keeping track of local arguments, such as method and block
  # arguments.
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#153
  def visit_params(node); end

  # Visit for keeping track of local variable definitions
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#207
  def visit_pinned_var_ref(node); end

  # source://syntax_tree//lib/syntax_tree/with_scope.rb#168
  def visit_rest_param(node); end

  # Visit for keeping track of local variable definitions
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#199
  def visit_var_field(node); end

  # Visits for keeping track of variable and argument usages
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#215
  def visit_var_ref(node); end

  # When using regex named capture groups, vcalls might actually be a variable
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#227
  def visit_vcall(node); end

  private

  # source://syntax_tree//lib/syntax_tree/with_scope.rb#285
  def add_argument_definitions(list); end

  # source://syntax_tree//lib/syntax_tree/with_scope.rb#299
  def next_scope_id; end

  # source://syntax_tree//lib/syntax_tree/with_scope.rb#303
  def with_scope(parent_scope = T.unsafe(nil)); end
end

# The scope class is used to keep track of local variables and arguments
# inside a particular scope.
#
# source://syntax_tree//lib/syntax_tree/with_scope.rb#30
class SyntaxTree::WithScope::Scope
  # @return [Scope] a new instance of Scope
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#68
  def initialize(id, parent = T.unsafe(nil)); end

  # Adding a local definition will either insert a new entry in the locals
  # hash or append a new definition location to an existing local. Notice
  # that it's not possible to change the type of a local after it has been
  # registered.
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#78
  def add_local_definition(identifier, type); end

  # Adding a local usage will either insert a new entry in the locals
  # hash or append a new usage location to an existing local. Notice that
  # it's not possible to change the type of a local after it has been
  # registered.
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#95
  def add_local_usage(identifier, type); end

  # Try to find the local given its name in this scope or any of its
  # parents.
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#102
  def find_local(name); end

  # [Integer] a unique identifier for this scope
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#59
  def id; end

  # [Hash[String, Local]] The local variables and arguments defined in this
  # scope
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#66
  def locals; end

  # [scope | nil] The parent scope
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#62
  def parent; end

  private

  # source://syntax_tree//lib/syntax_tree/with_scope.rb#108
  def resolve_local(name, type); end
end

# This class tracks the occurrences of a local variable or argument.
#
# source://syntax_tree//lib/syntax_tree/with_scope.rb#32
class SyntaxTree::WithScope::Scope::Local
  # @return [Local] a new instance of Local
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#43
  def initialize(type); end

  # source://syntax_tree//lib/syntax_tree/with_scope.rb#49
  def add_definition(location); end

  # source://syntax_tree//lib/syntax_tree/with_scope.rb#53
  def add_usage(location); end

  # [Array[Location]] The locations of all definitions and assignments of
  # this local
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#38
  def definitions; end

  # [Symbol] The type of the local (e.g. :argument, :variable)
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#34
  def type; end

  # [Array[Location]] The locations of all usages of this local
  #
  # source://syntax_tree//lib/syntax_tree/with_scope.rb#41
  def usages; end
end

# Word represents an element within a special array literal that accepts
# interpolation.
#
#     %W[a#{b}c xyz]
#
# In the example above, there would be two Word nodes within a parent Words
# node.
#
# source://syntax_tree//lib/syntax_tree/node.rb#12006
class SyntaxTree::Word < ::SyntaxTree::Node
  # @return [Word] a new instance of Word
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12012
  def initialize(parts:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12051
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12022
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12026
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12010
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#12030
  def copy(parts: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12026
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#12043
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12047
  def format(q); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12018
  def match?(pattern); end

  # [Array[ StringEmbExpr | StringDVar | TStringContent ]] the parts of the
  # word
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12007
  def parts; end
end

# Words represents a string literal array with interpolation.
#
#     %W[one two three]
#
# source://syntax_tree//lib/syntax_tree/node.rb#12061
class SyntaxTree::Words < ::SyntaxTree::Node
  # @return [Words] a new instance of Words
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12070
  def initialize(beginning:, elements:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12126
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12077
  def accept(visitor); end

  # [WordsBeg] the token that opens this array literal
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12062
  def beginning; end

  # source://syntax_tree//lib/syntax_tree/node.rb#12081
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12068
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#12085
  def copy(beginning: T.unsafe(nil), elements: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12081
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#12095
  def deconstruct_keys(_keys); end

  # [Array[ Word ]] the elements of this array
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12065
  def elements; end

  # source://syntax_tree//lib/syntax_tree/node.rb#12104
  def format(q); end
end

# WordsBeg represents the beginning of a string literal array with
# interpolation.
#
#     %W[one two three]
#
# In the snippet above, a WordsBeg would be created with the value of "%W[".
# Note that these kinds of arrays can start with a lot of different delimiter
# types (e.g., %W| or %W<).
#
# source://syntax_tree//lib/syntax_tree/node.rb#12141
class SyntaxTree::WordsBeg < ::SyntaxTree::Node
  # @return [WordsBeg] a new instance of WordsBeg
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12144
  def initialize(value:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12170
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12149
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12153
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#12157
  def copy(value: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12153
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#12166
  def deconstruct_keys(_keys); end

  # [String] the start of the word literal array
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12142
  def value; end
end

# XString represents the contents of an XStringLiteral.
#
#     `ls`
#
# source://syntax_tree//lib/syntax_tree/node.rb#12181
class SyntaxTree::XString < ::SyntaxTree::Node
  # @return [XString] a new instance of XString
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12184
  def initialize(parts:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12210
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12189
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12193
  def child_nodes; end

  # source://syntax_tree//lib/syntax_tree/node.rb#12197
  def copy(parts: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12193
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#12206
  def deconstruct_keys(_keys); end

  # [Array[ StringEmbExpr | StringDVar | TStringContent ]] the parts of the
  # xstring
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12182
  def parts; end
end

# XStringLiteral represents a string that gets executed.
#
#     `ls`
#
# source://syntax_tree//lib/syntax_tree/node.rb#12221
class SyntaxTree::XStringLiteral < ::SyntaxTree::Node
  # @return [XStringLiteral] a new instance of XStringLiteral
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12227
  def initialize(parts:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12264
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12233
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12237
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12225
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#12241
  def copy(parts: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12237
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#12254
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12258
  def format(q); end

  # [Array[ StringEmbExpr | StringDVar | TStringContent ]] the parts of the
  # xstring
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12222
  def parts; end
end

# This module provides an object representation of the YARV bytecode.
#
# source://syntax_tree//lib/syntax_tree/yarv/basic_block.rb#4
module SyntaxTree::YARV
  class << self
    # A convenience method for creating a CallData object.
    #
    # source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#88
    def calldata(method, argc = T.unsafe(nil), flags = T.unsafe(nil), kw_arg = T.unsafe(nil)); end

    # Compile the given source into a YARV instruction sequence.
    #
    # source://syntax_tree//lib/syntax_tree/yarv.rb#25
    def compile(source, options = T.unsafe(nil)); end

    # Compile and interpret the given source.
    #
    # source://syntax_tree//lib/syntax_tree/yarv.rb#30
    def interpret(source, options = T.unsafe(nil)); end
  end
end

# ### Summary
#
# `adjuststack` accepts a single integer argument and removes that many
# elements from the top of the stack.
#
# ### Usage
#
# ~~~ruby
# x = [true]
# x[0] ||= nil
# x[0]
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#69
class SyntaxTree::YARV::AdjustStack < ::SyntaxTree::YARV::Instruction
  # @return [AdjustStack] a new instance of AdjustStack
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#72
  def initialize(number); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#88
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#100
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#84
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#76
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#92
  def length; end

  # Returns the value of attribute number.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#70
  def number; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#96
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#80
  def to_a(_iseq); end
end

# ### Summary
#
# `anytostring` ensures that the value on top of the stack is a string.
#
# It pops two values off the stack. If the first value is a string it
# pushes it back on the stack. If the first value is not a string, it uses
# Ruby's built in string coercion to coerce the second value to a string
# and then pushes that back on the stack.
#
# This is used in conjunction with `objtostring` as a fallback for when an
# object's `to_s` method does not return a string.
#
# ### Usage
#
# ~~~ruby
# "#{5}"
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#123
class SyntaxTree::YARV::AnyToString < ::SyntaxTree::YARV::Instruction
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#136
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#148
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#132
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#124
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#140
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#144
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#128
  def to_a(_iseq); end
end

# source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#5
class SyntaxTree::YARV::Assembler
  # @return [Assembler] a new instance of Assembler
  #
  # source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#66
  def initialize(lines); end

  # source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#70
  def assemble; end

  # Returns the value of attribute lines.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#64
  def lines; end

  private

  # source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#88
  def assemble_iseq(iseq, lines); end

  # source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#408
  def find_local(iseq, operands); end

  # source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#417
  def parse(value); end

  # source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#449
  def parse_calldata(value); end

  # source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#444
  def parse_nested(lines); end

  # source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#432
  def parse_number(value); end

  # source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#424
  def parse_options(value, options); end

  # source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#436
  def parse_string(value); end

  # source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#440
  def parse_symbol(value); end

  # source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#428
  def parse_type(value, type); end

  class << self
    # source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#78
    def assemble(source); end

    # source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#82
    def assemble_file(filepath); end
  end
end

# source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#28
SyntaxTree::YARV::Assembler::CALLDATA_FLAGS = T.let(T.unsafe(nil), Hash)

# source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#43
SyntaxTree::YARV::Assembler::DEFINED_TYPES = T.let(T.unsafe(nil), Array)

# source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#6
class SyntaxTree::YARV::Assembler::ObjectVisitor < ::SyntaxTree::YARV::Compiler::RubyVisitor
  # source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#7
  def visit_dyna_symbol(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/assembler.rb#15
  def visit_string_literal(node); end
end

# This object represents a single basic block, wherein all contained
# instructions do not branch except for the last one.
#
# source://syntax_tree//lib/syntax_tree/yarv/basic_block.rb#7
class SyntaxTree::YARV::BasicBlock
  # @return [BasicBlock] a new instance of BasicBlock
  #
  # source://syntax_tree//lib/syntax_tree/yarv/basic_block.rb#23
  def initialize(block_start, insns); end

  # This is the index into the list of instructions where this block starts.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/basic_block.rb#12
  def block_start; end

  # Yield each instruction in this basic block along with its index from the
  # original instruction sequence.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/basic_block.rb#35
  def each_with_length; end

  # This is the unique identifier for this basic block.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/basic_block.rb#9
  def id; end

  # This is an array of basic blocks that lead into this block.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/basic_block.rb#18
  def incoming_blocks; end

  # This is the set of instructions that this block contains.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/basic_block.rb#15
  def insns; end

  # This is an array of basic blocks that this block leads into.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/basic_block.rb#21
  def outgoing_blocks; end

  # This method is used to verify that the basic block is well formed. It
  # checks that the only instruction in this basic block that branches is
  # the last instruction.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/basic_block.rb#48
  def verify; end
end

# Parses the given source code into a syntax tree, compiles that syntax tree
# into YARV bytecode.
#
# source://syntax_tree//lib/syntax_tree/yarv/bf.rb#7
class SyntaxTree::YARV::Bf
  # @return [Bf] a new instance of Bf
  #
  # source://syntax_tree//lib/syntax_tree/yarv/bf.rb#10
  def initialize(source); end

  # source://syntax_tree//lib/syntax_tree/yarv/bf.rb#14
  def compile; end

  # Returns the value of attribute source.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/bf.rb#8
  def source; end

  private

  # $tape[$cursor] += value
  #
  # source://syntax_tree//lib/syntax_tree/yarv/bf.rb#84
  def change_by(iseq, value); end

  # $tape[$cursor] = $stdin.getc.ord
  #
  # source://syntax_tree//lib/syntax_tree/yarv/bf.rb#133
  def input_char(iseq); end

  # Jump back to the start of the loop.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/bf.rb#163
  def loop_end(iseq, start_label, end_label); end

  # unless $tape[$cursor] == 0
  #
  # source://syntax_tree//lib/syntax_tree/yarv/bf.rb#146
  def loop_start(iseq); end

  # $stdout.putc($tape[$cursor].chr)
  #
  # source://syntax_tree//lib/syntax_tree/yarv/bf.rb#120
  def output_char(iseq); end

  # $cursor += value
  #
  # source://syntax_tree//lib/syntax_tree/yarv/bf.rb#105
  def shift_by(iseq, value); end
end

# ### Summary
#
# `branchif` has one argument: the jump index. It pops one value off the
# stack: the jump condition.
#
# If the value popped off the stack is true, `branchif` jumps to
# the jump index and continues executing there.
#
# ### Usage
#
# ~~~ruby
# x = true
# x ||= "foo"
# puts x
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#175
class SyntaxTree::YARV::BranchIf < ::SyntaxTree::YARV::Instruction
  # @return [BranchIf] a new instance of BranchIf
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#178
  def initialize(label); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#194
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#210
  def branch_targets; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#206
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#190
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#182
  def disasm(fmt); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#214
  def falls_through?; end

  # Returns the value of attribute label.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#176
  def label; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#198
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#202
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#186
  def to_a(_iseq); end
end

# ### Summary
#
# `branchnil` has one argument: the jump index. It pops one value off the
# stack: the jump condition.
#
# If the value popped off the stack is nil, `branchnil` jumps to
# the jump index and continues executing there.
#
# ### Usage
#
# ~~~ruby
# x = nil
# if x&.to_s
#   puts "hi"
# end
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#236
class SyntaxTree::YARV::BranchNil < ::SyntaxTree::YARV::Instruction
  # @return [BranchNil] a new instance of BranchNil
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#239
  def initialize(label); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#255
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#271
  def branch_targets; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#267
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#251
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#243
  def disasm(fmt); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#275
  def falls_through?; end

  # Returns the value of attribute label.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#237
  def label; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#259
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#263
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#247
  def to_a(_iseq); end
end

# ### Summary
#
# `branchunless` has one argument: the jump index. It pops one value off
# the stack: the jump condition.
#
# If the value popped off the stack is false or nil, `branchunless` jumps
# to the jump index and continues executing there.
#
# ### Usage
#
# ~~~ruby
# if 2 + 3
#   puts "foo"
# end
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#296
class SyntaxTree::YARV::BranchUnless < ::SyntaxTree::YARV::Instruction
  # @return [BranchUnless] a new instance of BranchUnless
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#299
  def initialize(label); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#315
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#331
  def branch_targets; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#327
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#311
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#303
  def disasm(fmt); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#335
  def falls_through?; end

  # Returns the value of attribute label.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#297
  def label; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#319
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#323
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#307
  def to_a(_iseq); end
end

# This is an operand to various YARV instructions that represents the
# information about a specific call site.
#
# source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#7
class SyntaxTree::YARV::CallData
  # @return [CallData] a new instance of CallData
  #
  # source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#31
  def initialize(method, argc = T.unsafe(nil), flags = T.unsafe(nil), kw_arg = T.unsafe(nil)); end

  # Returns the value of attribute argc.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#29
  def argc; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#43
  def flag?(mask); end

  # Returns the value of attribute flags.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#29
  def flags; end

  # source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#53
  def inspect; end

  # Returns the value of attribute kw_arg.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#29
  def kw_arg; end

  # Returns the value of attribute method.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#29
  def method; end

  # source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#47
  def to_h; end

  class << self
    # source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#77
    def from(serialized); end
  end
end

# source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#27
SyntaxTree::YARV::CallData::CALL_ARGS_BLOCKARG = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#27
SyntaxTree::YARV::CallData::CALL_ARGS_SIMPLE = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#27
SyntaxTree::YARV::CallData::CALL_ARGS_SPLAT = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#27
SyntaxTree::YARV::CallData::CALL_BLOCKISEQ = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#27
SyntaxTree::YARV::CallData::CALL_FCALL = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#27
SyntaxTree::YARV::CallData::CALL_KWARG = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#27
SyntaxTree::YARV::CallData::CALL_KW_SPLAT = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#27
SyntaxTree::YARV::CallData::CALL_KW_SPLAT_MUT = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#27
SyntaxTree::YARV::CallData::CALL_OPT_SEND = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#27
SyntaxTree::YARV::CallData::CALL_SUPER = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#27
SyntaxTree::YARV::CallData::CALL_TAILCALL = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#27
SyntaxTree::YARV::CallData::CALL_VCALL = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/calldata.rb#27
SyntaxTree::YARV::CallData::CALL_ZSUPER = T.let(T.unsafe(nil), Integer)

# ### Summary
#
# `checkkeyword` checks if a keyword was passed at the callsite that
# called into the method represented by the instruction sequence. It has
# two arguments: the index of the local variable that stores the keywords
# metadata and the index of the keyword within that metadata. It pushes
# a boolean onto the stack indicating whether or not the keyword was
# given.
#
# ### Usage
#
# ~~~ruby
# def evaluate(value: rand)
#   value
# end
#
# evaluate(value: 3)
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#359
class SyntaxTree::YARV::CheckKeyword < ::SyntaxTree::YARV::Instruction
  # @return [CheckKeyword] a new instance of CheckKeyword
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#362
  def initialize(keyword_bits_index, keyword_index); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#386
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#400
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#382
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#367
  def disasm(fmt); end

  # Returns the value of attribute keyword_bits_index.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#360
  def keyword_bits_index; end

  # Returns the value of attribute keyword_index.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#360
  def keyword_index; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#392
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#396
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#374
  def to_a(iseq); end
end

# ### Summary
#
# `checkmatch` checks if the current pattern matches the current value. It
# pops the target and the pattern off the stack and pushes a boolean onto
# the stack if it matches or not.
#
# ### Usage
#
# ~~~ruby
# foo in Foo
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#417
class SyntaxTree::YARV::CheckMatch < ::SyntaxTree::YARV::Instruction
  # @return [CheckMatch] a new instance of CheckMatch
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#426
  def initialize(type); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#442
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#458
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#438
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#430
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#446
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#450
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#454
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#434
  def to_a(_iseq); end

  # Returns the value of attribute type.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#424
  def type; end

  private

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#472
  def check?(pattern, target); end
end

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#422
SyntaxTree::YARV::CheckMatch::VM_CHECKMATCH_ARRAY = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#419
SyntaxTree::YARV::CheckMatch::VM_CHECKMATCH_TYPE_CASE = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#421
SyntaxTree::YARV::CheckMatch::VM_CHECKMATCH_TYPE_MASK = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#420
SyntaxTree::YARV::CheckMatch::VM_CHECKMATCH_TYPE_RESCUE = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#418
SyntaxTree::YARV::CheckMatch::VM_CHECKMATCH_TYPE_WHEN = T.let(T.unsafe(nil), Integer)

# ### Summary
#
# `checktype` checks if the value on top of the stack is of a certain type.
# The type is the only argument. It pops the value off the stack and pushes
# a boolean onto the stack indicating whether or not the value is of the
# given type.
#
# ### Usage
#
# ~~~ruby
# foo in [bar]
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#501
class SyntaxTree::YARV::CheckType < ::SyntaxTree::YARV::Instruction
  # @return [CheckType] a new instance of CheckType
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#526
  def initialize(type); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#588
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#608
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#584
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#530
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#592
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#596
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#600
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#580
  def to_a(_iseq); end

  # Returns the value of attribute type.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#524
  def type; end
end

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#508
SyntaxTree::YARV::CheckType::TYPE_ARRAY = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#511
SyntaxTree::YARV::CheckType::TYPE_BIGNUM = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#503
SyntaxTree::YARV::CheckType::TYPE_CLASS = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#515
SyntaxTree::YARV::CheckType::TYPE_COMPLEX = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#513
SyntaxTree::YARV::CheckType::TYPE_DATA = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#519
SyntaxTree::YARV::CheckType::TYPE_FALSE = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#512
SyntaxTree::YARV::CheckType::TYPE_FILE = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#521
SyntaxTree::YARV::CheckType::TYPE_FIXNUM = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#505
SyntaxTree::YARV::CheckType::TYPE_FLOAT = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#509
SyntaxTree::YARV::CheckType::TYPE_HASH = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#514
SyntaxTree::YARV::CheckType::TYPE_MATCH = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#504
SyntaxTree::YARV::CheckType::TYPE_MODULE = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#517
SyntaxTree::YARV::CheckType::TYPE_NIL = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#502
SyntaxTree::YARV::CheckType::TYPE_OBJECT = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#516
SyntaxTree::YARV::CheckType::TYPE_RATIONAL = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#507
SyntaxTree::YARV::CheckType::TYPE_REGEXP = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#506
SyntaxTree::YARV::CheckType::TYPE_STRING = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#510
SyntaxTree::YARV::CheckType::TYPE_STRUCT = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#520
SyntaxTree::YARV::CheckType::TYPE_SYMBOL = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#518
SyntaxTree::YARV::CheckType::TYPE_TRUE = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#522
SyntaxTree::YARV::CheckType::TYPE_UNDEF = T.let(T.unsafe(nil), Integer)

# This class is an experiment in transforming Syntax Tree nodes into their
# corresponding YARV instruction sequences. It attempts to mirror the
# behavior of RubyVM::InstructionSequence.compile.
#
# You use this as with any other visitor. First you parse code into a tree,
# then you visit it with this compiler. Visiting the root node of the tree
# will return a SyntaxTree::YARV::Compiler::InstructionSequence object.
# With that object you can call #to_a on it, which will return a serialized
# form of the instruction sequence as an array. This array _should_ mirror
# the array given by RubyVM::InstructionSequence#to_a.
#
# As an example, here is how you would compile a single expression:
#
#     program = SyntaxTree.parse("1 + 2")
#     program.accept(SyntaxTree::YARV::Compiler.new).to_a
#
#     [
#       "YARVInstructionSequence/SimpleDataFormat",
#       3,
#       1,
#       1,
#       {:arg_size=>0, :local_size=>0, :stack_max=>2},
#       "<compiled>",
#       "<compiled>",
#       "<compiled>",
#       1,
#       :top,
#       [],
#       {},
#       [],
#       [
#         [:putobject_INT2FIX_1_],
#         [:putobject, 2],
#         [:opt_plus, {:mid=>:+, :flag=>16, :orig_argc=>1}],
#         [:leave]
#       ]
#     ]
#
# Note that this is the same output as calling:
#
#     RubyVM::InstructionSequence.compile("1 + 2").to_a
#
# source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#51
class SyntaxTree::YARV::Compiler < ::SyntaxTree::BasicVisitor
  # @return [Compiler] a new instance of Compiler
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#293
  def initialize(options = T.unsafe(nil)); end

  # The current instruction sequence that is being compiled.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#286
  def iseq; end

  # A boolean to track if we're currently compiling the last statement
  # within a set of statements. This information is necessary to determine
  # if we need to return the value of the last statement.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#291
  def last_statement; end

  # These options mirror the compilation options that we currently support
  # that can be also passed to RubyVM::InstructionSequence.compile.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#283
  def options; end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#299
  def visit_BEGIN(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#303
  def visit_CHAR(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#311
  def visit_END(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#339
  def visit_alias(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#347
  def visit_aref(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#369
  def visit_arg_block(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#373
  def visit_arg_paren(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#377
  def visit_arg_star(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#382
  def visit_args(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#386
  def visit_array(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#421
  def visit_aryptn(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#424
  def visit_assign(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#522
  def visit_assoc(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#527
  def visit_assoc_splat(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#531
  def visit_backref(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#535
  def visit_bare_assoc_hash(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#543
  def visit_begin(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#546
  def visit_binary(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#575
  def visit_block(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#585
  def visit_block_var(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#599
  def visit_blockarg(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#605
  def visit_bodystmt(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#609
  def visit_break(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#612
  def visit_call(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#712
  def visit_case(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#757
  def visit_class(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#792
  def visit_command(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#805
  def visit_command_call(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#818
  def visit_const_path_field(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#822
  def visit_const_path_ref(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#827
  def visit_def(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#850
  def visit_defined(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#907
  def visit_dyna_symbol(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#913
  def visit_else(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#918
  def visit_elsif(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#929
  def visit_ensure(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#932
  def visit_field(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#936
  def visit_float(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#940
  def visit_fndptn(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#943
  def visit_for(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#976
  def visit_hash(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#988
  def visit_heredoc(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#985
  def visit_hshptn(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#999
  def visit_if(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1053
  def visit_if_op(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1074
  def visit_imaginary(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1078
  def visit_int(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1082
  def visit_kwrest_param(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1088
  def visit_label(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1092
  def visit_lambda(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1106
  def visit_lambda_var(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1110
  def visit_massign(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1116
  def visit_method_add_block(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1129
  def visit_mlhs(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1142
  def visit_module(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1171
  def visit_mrhs(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1180
  def visit_next(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1183
  def visit_not(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1188
  def visit_opassign(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1254
  def visit_params(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1360
  def visit_paren(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1364
  def visit_pinned_begin(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1367
  def visit_pinned_var_ref(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1370
  def visit_program(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1421
  def visit_qsymbols(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1425
  def visit_qwords(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1434
  def visit_range(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1444
  def visit_rassign(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1521
  def visit_rational(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1525
  def visit_redo(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1528
  def visit_regexp_literal(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1538
  def visit_rescue(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1541
  def visit_rescue_ex(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1544
  def visit_rescue_mod(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1547
  def visit_rest_param(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1553
  def visit_retry(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1556
  def visit_return(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1559
  def visit_sclass(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1580
  def visit_statements(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1594
  def visit_string_concat(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1606
  def visit_string_embexpr(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1610
  def visit_string_literal(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1619
  def visit_super(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1633
  def visit_symbol_literal(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1637
  def visit_symbols(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1656
  def visit_top_const_ref(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1660
  def visit_tstring_content(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1668
  def visit_unary(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1689
  def visit_undef(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1699
  def visit_unless(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1725
  def visit_until(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1744
  def visit_var_field(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1761
  def visit_var_ref(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1796
  def visit_vcall(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1808
  def visit_when(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1812
  def visit_while(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1831
  def visit_word(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1840
  def visit_words(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1850
  def visit_xstring_literal(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1863
  def visit_yield(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1869
  def visit_zsuper(_node); end

  private

  # This is a helper that is used in places where arguments may be present
  # or they may be wrapped in parentheses. It's meant to descend down the
  # tree and return an array of argument nodes.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1887
  def argument_parts(node); end

  # Constant names when they are being assigned or referenced come in as a
  # tree, but it's more convenient to work with them as an array. This
  # method converts them into that array. This is nice because it's the
  # operand that goes to opt_getconstant_path in Ruby 3.2.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1908
  def constant_names(node); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#2196
  def last_statement?; end

  # For the most part when an OpAssign (operator assignment) node with a ||=
  # operator is being compiled it's a matter of reading the target, checking
  # if the value should be evaluated, evaluating it if so, and then writing
  # the result back to the target.
  #
  # However, in certain kinds of assignments (X, ::X, X::Y, @@x, and $x) we
  # first check if the value is defined using the defined instruction. I
  # don't know why it is necessary, and suspect that it isn't.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#1936
  def opassign_defined(node); end

  # Whenever a value is interpolated into a string-like structure, these
  # three instructions are pushed.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#2016
  def push_interpolate; end

  # Visit a type of pattern in a pattern match.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#2029
  def visit_pattern(node, end_label); end

  # There are a lot of nodes in the AST that act as contains of parts of
  # strings. This includes things like string literals, regular expressions,
  # heredocs, etc. This method will visit all the parts of a string within
  # those containers.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#2137
  def visit_string_parts(node); end

  # The current instruction sequence that we're compiling is always stored
  # on the compiler. When we descend into a node that has its own
  # instruction sequence, this method can be called to temporarily set the
  # new value of the instruction sequence, yield, and then set it back.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#2167
  def with_child_iseq(child_iseq); end

  # When we're compiling the last statement of a set of statements within a
  # scope, the instructions sometimes change from pops to leaves. These
  # kinds of peephole optimizations can reduce the overall number of
  # instructions. Therefore, we keep track of whether we're compiling the
  # last statement of a scope and allow visit methods to query that
  # information.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#2185
  def with_last_statement; end

  # OpAssign nodes can have a number of different kinds of nodes as their
  # "target" (i.e., the left-hand side of the assignment). When compiling
  # these nodes we typically need to first fetch the current value of the
  # variable, then perform some kind of action, then store the result back
  # into the variable. This method handles that by first fetching the value,
  # then yielding to the block, then storing the result.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#2206
  def with_opassign(node); end
end

# This represents a set of options that can be passed to the compiler to
# control how it compiles the code. It mirrors the options that can be
# passed to RubyVM::InstructionSequence.compile, except it only includes
# options that actually change the behavior.
#
# source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#52
class SyntaxTree::YARV::Compiler::Options
  # @return [Options] a new instance of Options
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#53
  def initialize(frozen_string_literal: T.unsafe(nil), inline_const_cache: T.unsafe(nil), operands_unification: T.unsafe(nil), peephole_optimization: T.unsafe(nil), specialized_instruction: T.unsafe(nil), tailcall_optimization: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#80
  def frozen_string_literal!; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#84
  def frozen_string_literal?; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#88
  def inline_const_cache?; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#92
  def operands_unification?; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#96
  def peephole_optimization?; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#100
  def specialized_instruction?; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#104
  def tailcall_optimization?; end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#69
  def to_hash; end
end

# This visitor is responsible for converting Syntax Tree nodes into their
# corresponding Ruby structures. This is used to convert the operands of
# some instructions like putobject that push a Ruby object directly onto
# the stack. It is only used when the entire structure can be represented
# at compile-time, as opposed to constructed at run-time.
#
# source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#116
class SyntaxTree::YARV::Compiler::RubyVisitor < ::SyntaxTree::BasicVisitor
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_BEGIN(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_CHAR(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_END(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit___end__(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_alias(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_aref(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_aref_field(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_arg_block(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_arg_paren(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_arg_star(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_args(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_args_forward(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#128
  def visit_array(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_aryptn(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_assign(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_assoc(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_assoc_splat(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_backref(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_backtick(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#132
  def visit_bare_assoc_hash(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_begin(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_binary(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_block(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_block_var(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_blockarg(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_bodystmt(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_break(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_call(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_case(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_class(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_comma(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_command(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_command_call(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_comment(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_const(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_const_path_field(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_const_path_ref(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_const_ref(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_cvar(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_def(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_defined(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_dyna_symbol(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_else(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_elsif(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_embdoc(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_embexpr_beg(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_embexpr_end(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_embvar(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_ensure(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_excessed_comma(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_field(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#141
  def visit_float(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_fndptn(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_for(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_gvar(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#132
  def visit_hash(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_heredoc(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_heredoc_beg(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_heredoc_end(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_hshptn(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_ident(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_if(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_if_op(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#147
  def visit_imaginary(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_in(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#151
  def visit_int(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_ivar(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_kw(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_kwrest_param(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#166
  def visit_label(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_label_end(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_lambda(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_lambda_var(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_lbrace(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_lbracket(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_lparen(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_massign(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_method_add_block(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_mlhs(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_mlhs_paren(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_module(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#170
  def visit_mrhs(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_next(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_not(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_op(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_opassign(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_params(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_paren(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_period(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_pinned_begin(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_pinned_var_ref(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_program(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#174
  def visit_qsymbols(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_qsymbols_beg(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#178
  def visit_qwords(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_qwords_beg(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#182
  def visit_range(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_rassign(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#187
  def visit_rational(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_rbrace(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_rbracket(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_redo(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_regexp_beg(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_regexp_content(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_regexp_end(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#191
  def visit_regexp_literal(node); end

  # This isn't actually a visit method, though maybe it should be. It is
  # responsible for converting the set of string options on a regular
  # expression into its equivalent integer.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#249
  def visit_regexp_literal_flags(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_rescue(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_rescue_ex(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_rescue_mod(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_rest_param(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_retry(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_return(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_rparen(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_sclass(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_statements(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_string_concat(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_string_content(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_string_dvar(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_string_embexpr(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_string_literal(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_super(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_symbeg(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_symbol_content(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#204
  def visit_symbol_literal(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#208
  def visit_symbols(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_symbols_beg(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_tlambda(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_tlambeg(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_top_const_field(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_top_const_ref(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_tstring_beg(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#212
  def visit_tstring_content(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_tstring_end(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_unary(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_undef(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_unless(_node); end

  # @raise [CompilationError]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_unsupported(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_until(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_var_field(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#216
  def visit_var_ref(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_vcall(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_void_stmt(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_when(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_while(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#231
  def visit_word(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#241
  def visit_words(node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_words_beg(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_xstring(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_xstring_literal(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_yield(_node); end

  # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#268
  def visit_zsuper(_node); end

  class << self
    # This will attempt to compile the given node. If it's possible, then
    # it will return the compiled object. Otherwise it will return nil.
    #
    # source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#122
    def compile(node); end
  end
end

# This error is raised whenever a node cannot be converted into a Ruby
# object at compile-time.
#
# source://syntax_tree//lib/syntax_tree/yarv/compiler.rb#117
class SyntaxTree::YARV::Compiler::RubyVisitor::CompilationError < ::StandardError; end

# ### Summary
#
# `concatarray` concatenates the two Arrays on top of the stack.
#
# It coerces the two objects at the top of the stack into Arrays by
# calling `to_a` if necessary, and makes sure to `dup` the first Array if
# it was already an Array, to avoid mutating it when concatenating.
#
# ### Usage
#
# ~~~ruby
# [1, *2]
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#674
class SyntaxTree::YARV::ConcatArray < ::SyntaxTree::YARV::Instruction
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#687
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#699
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#683
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#675
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#691
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#695
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#679
  def to_a(_iseq); end
end

# ### Summary
#
# `concatstrings` pops a number of strings from the stack joins them
# together into a single string and pushes that string back on the stack.
#
# This does no coercion and so is always used in conjunction with
# `objtostring` and `anytostring` to ensure the stack contents are always
# strings.
#
# ### Usage
#
# ~~~ruby
# "#{5}"
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#720
class SyntaxTree::YARV::ConcatStrings < ::SyntaxTree::YARV::Instruction
  # @return [ConcatStrings] a new instance of ConcatStrings
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#723
  def initialize(number); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#739
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#755
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#735
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#727
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#743
  def length; end

  # Returns the value of attribute number.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#721
  def number; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#747
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#751
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#731
  def to_a(_iseq); end
end

# This class represents a control flow graph of a YARV instruction sequence.
# It constructs a graph of basic blocks that hold subsets of the list of
# instructions from the instruction sequence.
#
# You can use this class by calling the ::compile method and passing it a
# YARV instruction sequence. It will return a control flow graph object.
#
#     iseq = RubyVM::InstructionSequence.compile("1 + 2")
#     iseq = SyntaxTree::YARV::InstructionSequence.from(iseq.to_a)
#     cfg = SyntaxTree::YARV::ControlFlowGraph.compile(iseq)
#
# source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#16
class SyntaxTree::YARV::ControlFlowGraph
  # @return [ControlFlowGraph] a new instance of ControlFlowGraph
  #
  # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#173
  def initialize(iseq, insns, blocks); end

  # This is the set of basic blocks that this control-flow graph contains.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#171
  def blocks; end

  # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#179
  def disasm; end

  # This is the list of instructions that this control flow graph contains.
  # It is effectively the same as the list of instructions in the
  # instruction sequence but with line numbers and events filtered out.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#168
  def insns; end

  # This is the instruction sequence that this control flow graph
  # corresponds to.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#163
  def iseq; end

  # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#202
  def to_dfg; end

  # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#210
  def to_mermaid; end

  # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#206
  def to_son; end

  # This method is used to verify that the control flow graph is well
  # formed. It does this by checking that each basic block is itself well
  # formed.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#248
  def verify; end

  class << self
    # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#252
    def compile(iseq); end
  end
end

# This class is responsible for creating a control flow graph from the
# given instruction sequence.
#
# source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#19
class SyntaxTree::YARV::ControlFlowGraph::Compiler
  # @return [Compiler] a new instance of Compiler
  #
  # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#34
  def initialize(iseq); end

  # This method is used to compile the instruction sequence into a control
  # flow graph. It returns an instance of ControlFlowGraph.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#54
  def compile; end

  # This is a hash of indices in the YARV instruction sequence that point
  # to their corresponding instruction.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#25
  def insns; end

  # This is the instruction sequence that is being compiled.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#21
  def iseq; end

  # This is a hash of labels that point to their corresponding index into
  # the YARV instruction sequence. Note that this is not the same as the
  # index into the list of instructions on the instruction sequence
  # object. Instead, this is the index into the C array, so it includes
  # operands.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#32
  def labels; end

  private

  # Builds up a set of basic blocks by iterating over the starts of each
  # block. They are keyed by the index of their first instruction.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#92
  def build_basic_blocks; end

  # Connect the blocks by letting them know which blocks are incoming and
  # outgoing from each block.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#123
  def connect_basic_blocks(blocks); end

  # Finds the indices of the instructions that start a basic block because
  # they're either:
  #
  # * the start of an instruction sequence
  # * the target of a branch
  # * fallen through to from a branch
  #
  # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#72
  def find_basic_block_starts; end

  # If there are blocks that are unreachable, we can remove them from the
  # graph entirely at this point.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/control_flow_graph.rb#145
  def prune_basic_blocks(blocks); end
end

# Constructs a data-flow-graph of a YARV instruction sequence, via a
# control-flow-graph. Data flow is discovered locally and then globally. The
# graph only considers data flow through the stack - local variables and
# objects are considered fully escaped in this analysis.
#
# You can use this class by calling the ::compile method and passing it a
# control flow graph. It will return a data flow graph object.
#
#     iseq = RubyVM::InstructionSequence.compile("1 + 2")
#     iseq = SyntaxTree::YARV::InstructionSequence.from(iseq.to_a)
#     cfg = SyntaxTree::YARV::ControlFlowGraph.compile(iseq)
#     dfg = SyntaxTree::YARV::DataFlowGraph.compile(cfg)
#
# source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#18
class SyntaxTree::YARV::DataFlowGraph
  # @return [DataFlowGraph] a new instance of DataFlowGraph
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#68
  def initialize(cfg, insn_flows, block_flows); end

  # Returns the value of attribute block_flows.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#66
  def block_flows; end

  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#74
  def blocks; end

  # Returns the value of attribute cfg.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#66
  def cfg; end

  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#78
  def disasm; end

  # Returns the value of attribute insn_flows.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#66
  def insn_flows; end

  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#127
  def to_mermaid; end

  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#123
  def to_son; end

  # Verify that we constructed the data flow graph correctly.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#179
  def verify; end

  class << self
    # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#204
    def compile(cfg); end
  end
end

# This represents an object that goes on the stack that is passed between
# basic blocks.
#
# source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#32
class SyntaxTree::YARV::DataFlowGraph::BlockArgument
  # @return [BlockArgument] a new instance of BlockArgument
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#35
  def initialize(name); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#39
  def local?; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#33
  def name; end

  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#43
  def to_str; end
end

# This class is responsible for creating a data flow graph from the given
# control flow graph.
#
# source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#210
class SyntaxTree::YARV::DataFlowGraph::Compiler
  # @return [Compiler] a new instance of Compiler
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#221
  def initialize(cfg); end

  # This data structure will hold the data flow between basic blocks.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#219
  def block_flows; end

  # This is the control flow graph that is being compiled.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#212
  def cfg; end

  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#227
  def compile; end

  # This data structure will hold the data flow between instructions
  # within individual basic blocks.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#216
  def insn_flows; end

  private

  # Find the data that flows between basic blocks.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#304
  def find_external_flow; end

  # Find the data flow within each basic block. Using an abstract stack,
  # connect from consumers of data to the producers of that data.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#237
  def find_internal_flow; end
end

# This object represents the flow of data between instructions.
#
# source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#20
class SyntaxTree::YARV::DataFlowGraph::DataFlow
  # @return [DataFlow] a new instance of DataFlow
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#24
  def initialize; end

  # Returns the value of attribute in.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#21
  def in; end

  # Returns the value of attribute out.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#22
  def out; end
end

# This represents an object that goes on the stack that is passed between
# instructions within a basic block.
#
# source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#50
class SyntaxTree::YARV::DataFlowGraph::LocalArgument
  # @return [LocalArgument] a new instance of LocalArgument
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#53
  def initialize(length); end

  # Returns the value of attribute length.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#51
  def length; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#57
  def local?; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#51
  def name; end

  # source://syntax_tree//lib/syntax_tree/yarv/data_flow_graph.rb#61
  def to_str; end
end

# This class is responsible for taking a compiled instruction sequence and
# walking through it to generate equivalent Ruby code.
#
# source://syntax_tree//lib/syntax_tree/yarv/decompiler.rb#7
class SyntaxTree::YARV::Decompiler
  include ::SyntaxTree::DSL

  # @return [Decompiler] a new instance of Decompiler
  #
  # source://syntax_tree//lib/syntax_tree/yarv/decompiler.rb#32
  def initialize(iseq); end

  # Returns the value of attribute block_label.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/decompiler.rb#30
  def block_label; end

  # Returns the value of attribute iseq.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/decompiler.rb#30
  def iseq; end

  # source://syntax_tree//lib/syntax_tree/yarv/decompiler.rb#37
  def to_ruby; end

  private

  # source://syntax_tree//lib/syntax_tree/yarv/decompiler.rb#52
  def decompile(iseq); end

  # source://syntax_tree//lib/syntax_tree/yarv/decompiler.rb#256
  def local_name(index, level); end

  # source://syntax_tree//lib/syntax_tree/yarv/decompiler.rb#43
  def node_for(value); end
end

# When we're decompiling, we use a looped case statement to emulate
# jumping around in the same way the virtual machine would. This class
# provides convenience methods for generating the AST nodes that have to
# do with that label.
#
# source://syntax_tree//lib/syntax_tree/yarv/decompiler.rb#12
class SyntaxTree::YARV::Decompiler::BlockLabel
  include ::SyntaxTree::DSL

  # @return [BlockLabel] a new instance of BlockLabel
  #
  # source://syntax_tree//lib/syntax_tree/yarv/decompiler.rb#16
  def initialize(name); end

  # source://syntax_tree//lib/syntax_tree/yarv/decompiler.rb#20
  def field; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/decompiler.rb#14
  def name; end

  # source://syntax_tree//lib/syntax_tree/yarv/decompiler.rb#24
  def ref; end
end

# ### Summary
#
# `defineclass` defines a class. First it pops the superclass off the
# stack, then it pops the object off the stack that the class should be
# defined under. It has three arguments: the name of the constant, the
# instruction sequence associated with the class, and various flags that
# indicate if it is a singleton class, a module, or a regular class.
#
# ### Usage
#
# ~~~ruby
# class Foo
# end
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#775
class SyntaxTree::YARV::DefineClass < ::SyntaxTree::YARV::Instruction
  # @return [DefineClass] a new instance of DefineClass
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#784
  def initialize(name, class_iseq, flags); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#806
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#823
  def call(vm); end

  # Returns the value of attribute class_iseq.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#782
  def class_iseq; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#802
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#790
  def disasm(fmt); end

  # Returns the value of attribute flags.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#782
  def flags; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#811
  def length; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#782
  def name; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#815
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#819
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#798
  def to_a(_iseq); end
end

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#780
SyntaxTree::YARV::DefineClass::FLAG_HAS_SUPERCLASS = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#779
SyntaxTree::YARV::DefineClass::FLAG_SCOPED = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#776
SyntaxTree::YARV::DefineClass::TYPE_CLASS = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#778
SyntaxTree::YARV::DefineClass::TYPE_MODULE = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#777
SyntaxTree::YARV::DefineClass::TYPE_SINGLETON_CLASS = T.let(T.unsafe(nil), Integer)

# ### Summary
#
# `definemethod` defines a method on the class of the current value of
# `self`. It accepts two arguments. The first is the name of the method
# being defined. The second is the instruction sequence representing the
# body of the method.
#
# ### Usage
#
# ~~~ruby
# def value = "value"
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1068
class SyntaxTree::YARV::DefineMethod < ::SyntaxTree::YARV::Instruction
  # @return [DefineMethod] a new instance of DefineMethod
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1071
  def initialize(method_name, method_iseq); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1092
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1101
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1088
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1076
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1097
  def length; end

  # Returns the value of attribute method_iseq.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1069
  def method_iseq; end

  # Returns the value of attribute method_name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1069
  def method_name; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1084
  def to_a(_iseq); end
end

# ### Summary
#
# `definesmethod` defines a method on the singleton class of the current
# value of `self`. It accepts two arguments. The first is the name of the
# method being defined. The second is the instruction sequence representing
# the body of the method. It pops the object off the stack that the method
# should be defined on.
#
# ### Usage
#
# ~~~ruby
# def self.value = "value"
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1137
class SyntaxTree::YARV::DefineSMethod < ::SyntaxTree::YARV::Instruction
  # @return [DefineSMethod] a new instance of DefineSMethod
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1140
  def initialize(method_name, method_iseq); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1161
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1174
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1157
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1145
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1166
  def length; end

  # Returns the value of attribute method_iseq.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1138
  def method_iseq; end

  # Returns the value of attribute method_name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1138
  def method_name; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1170
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1153
  def to_a(_iseq); end
end

# ### Summary
#
# `defined` checks if the top value of the stack is defined. If it is, it
# pushes its value onto the stack. Otherwise it pushes `nil`.
#
# ### Usage
#
# ~~~ruby
# defined?(x)
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#859
class SyntaxTree::YARV::Defined < ::SyntaxTree::YARV::Instruction
  # @return [Defined] a new instance of Defined
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#880
  def initialize(type, name, message); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#939
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#956
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#935
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#886
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#944
  def length; end

  # Returns the value of attribute message.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#878
  def message; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#878
  def name; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#948
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#952
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#931
  def to_a(_iseq); end

  # Returns the value of attribute type.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#878
  def type; end
end

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#872
SyntaxTree::YARV::Defined::TYPE_ASGN = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#865
SyntaxTree::YARV::Defined::TYPE_CONST = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#876
SyntaxTree::YARV::Defined::TYPE_CONST_FROM = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#864
SyntaxTree::YARV::Defined::TYPE_CVAR = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#873
SyntaxTree::YARV::Defined::TYPE_EXPR = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#871
SyntaxTree::YARV::Defined::TYPE_FALSE = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#875
SyntaxTree::YARV::Defined::TYPE_FUNC = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#863
SyntaxTree::YARV::Defined::TYPE_GVAR = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#861
SyntaxTree::YARV::Defined::TYPE_IVAR = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#862
SyntaxTree::YARV::Defined::TYPE_LVAR = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#866
SyntaxTree::YARV::Defined::TYPE_METHOD = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#860
SyntaxTree::YARV::Defined::TYPE_NIL = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#874
SyntaxTree::YARV::Defined::TYPE_REF = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#869
SyntaxTree::YARV::Defined::TYPE_SELF = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#870
SyntaxTree::YARV::Defined::TYPE_TRUE = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#867
SyntaxTree::YARV::Defined::TYPE_YIELD = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#868
SyntaxTree::YARV::Defined::TYPE_ZSUPER = T.let(T.unsafe(nil), Integer)

# ### Summary
#
# `definedivar` checks if an instance variable is defined. It is a
# specialization of the `defined` instruction. It accepts three arguments:
# the name of the instance variable, an inline cache, and the string that
# should be pushed onto the stack in the event that the instance variable
# is defined.
#
# ### Usage
#
# ~~~ruby
# defined?(@value)
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1011
class SyntaxTree::YARV::DefinedIVar < ::SyntaxTree::YARV::Instruction
  # @return [DefinedIVar] a new instance of DefinedIVar
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1014
  def initialize(name, cache, message); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1035
  def ==(other); end

  # Returns the value of attribute cache.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1012
  def cache; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1048
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1031
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1020
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1040
  def length; end

  # Returns the value of attribute message.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1012
  def message; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1012
  def name; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1044
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1027
  def to_a(_iseq); end
end

# source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#5
class SyntaxTree::YARV::Disassembler
  # @return [Disassembler] a new instance of Disassembler
  #
  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#46
  def initialize(current_iseq = T.unsafe(nil)); end

  # Helpers for various instructions
  #
  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#58
  def calldata(value); end

  # Returns the value of attribute current_iseq.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#44
  def current_iseq; end

  # Sets the attribute current_iseq
  #
  # @param value the value to set the attribute current_iseq to.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#44
  def current_iseq=(_arg0); end

  # Returns the value of attribute current_prefix.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#43
  def current_prefix; end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#62
  def enqueue(iseq); end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#66
  def event(name); end

  # Entrypoints
  #
  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#116
  def format!; end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#123
  def format_insns!(insns, length = T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#87
  def inline_storage(cache); end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#91
  def instruction(name, operands = T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#95
  def label(value); end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#99
  def local(index, explicit: T.unsafe(nil), implicit: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#108
  def object(value); end

  # Returns the value of attribute output.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#41
  def output; end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#167
  def print(string); end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#171
  def puts(string); end

  # Returns the value of attribute queue.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#41
  def queue; end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#175
  def string; end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#179
  def with_prefix(value); end

  private

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#192
  def format_iseq(iseq); end
end

# This class is another object that handles disassembling a YARV
# instruction sequence but it renders it without any of the extra spacing
# or alignment.
#
# source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#9
class SyntaxTree::YARV::Disassembler::Squished
  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#10
  def calldata(value); end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#14
  def enqueue(iseq); end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#17
  def event(name); end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#20
  def inline_storage(cache); end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#24
  def instruction(name, operands = T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#28
  def label(value); end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#32
  def local(index, **_arg1); end

  # source://syntax_tree//lib/syntax_tree/yarv/disassembler.rb#36
  def object(value); end
end

# ### Summary
#
# `dup` copies the top value of the stack and pushes it onto the stack.
#
# ### Usage
#
# ~~~ruby
# $global = 5
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1206
class SyntaxTree::YARV::Dup < ::SyntaxTree::YARV::Instruction
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1219
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1231
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1215
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1207
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1223
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1227
  def pushes; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1235
  def side_effects?; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1211
  def to_a(_iseq); end
end

# ### Summary
#
# `duparray` dups an Array literal and pushes it onto the stack.
#
# ### Usage
#
# ~~~ruby
# [true]
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1250
class SyntaxTree::YARV::DupArray < ::SyntaxTree::YARV::Instruction
  # @return [DupArray] a new instance of DupArray
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1253
  def initialize(object); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1269
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1281
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1265
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1257
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1273
  def length; end

  # Returns the value of attribute object.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1251
  def object; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1277
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1261
  def to_a(_iseq); end
end

# ### Summary
#
# `duphash` dups a Hash literal and pushes it onto the stack.
#
# ### Usage
#
# ~~~ruby
# { a: 1 }
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1296
class SyntaxTree::YARV::DupHash < ::SyntaxTree::YARV::Instruction
  # @return [DupHash] a new instance of DupHash
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1299
  def initialize(object); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1315
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1327
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1311
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1303
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1319
  def length; end

  # Returns the value of attribute object.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1297
  def object; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1323
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1307
  def to_a(_iseq); end
end

# ### Summary
#
# `dupn` duplicates the top `n` stack elements.
#
# ### Usage
#
# ~~~ruby
# Object::X ||= true
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1342
class SyntaxTree::YARV::DupN < ::SyntaxTree::YARV::Instruction
  # @return [DupN] a new instance of DupN
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1345
  def initialize(number); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1361
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1373
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1357
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1349
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1365
  def length; end

  # Returns the value of attribute number.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1343
  def number; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1369
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1353
  def to_a(_iseq); end
end

# ### Summary
#
# `expandarray` looks at the top of the stack, and if the value is an array
# it replaces it on the stack with `number` elements of the array, or `nil`
# if the elements are missing.
#
# ### Usage
#
# ~~~ruby
# x, = [true, false, nil]
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1392
class SyntaxTree::YARV::ExpandArray < ::SyntaxTree::YARV::Instruction
  # @return [ExpandArray] a new instance of ExpandArray
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1395
  def initialize(number, flags); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1412
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1429
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1408
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1400
  def disasm(fmt); end

  # Returns the value of attribute flags.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1393
  def flags; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1417
  def length; end

  # Returns the value of attribute number.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1393
  def number; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1421
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1425
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1404
  def to_a(_iseq); end
end

# ### Summary
#
# `getblockparam` is a similar instruction to `getlocal` in that it looks
# for a local variable in the current instruction sequence's local table and
# walks recursively up the parent instruction sequences until it finds it.
# The local it retrieves, however, is a special block local that was passed
# to the current method. It pushes the value of the block local onto the
# stack.
#
# ### Usage
#
# ~~~ruby
# def foo(&block)
#   block
# end
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1486
class SyntaxTree::YARV::GetBlockParam < ::SyntaxTree::YARV::Instruction
  # @return [GetBlockParam] a new instance of GetBlockParam
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1489
  def initialize(index, level); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1508
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1521
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1504
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1494
  def disasm(fmt); end

  # Returns the value of attribute index.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1487
  def index; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1513
  def length; end

  # Returns the value of attribute level.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1487
  def level; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1517
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1498
  def to_a(iseq); end
end

# ### Summary
#
# `getblockparamproxy` is almost the same as `getblockparam` except that it
# pushes a proxy object onto the stack instead of the actual value of the
# block local. This is used when a method is being called on the block
# local.
#
# ### Usage
#
# ~~~ruby
# def foo(&block)
#   block.call
# end
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1541
class SyntaxTree::YARV::GetBlockParamProxy < ::SyntaxTree::YARV::Instruction
  # @return [GetBlockParamProxy] a new instance of GetBlockParamProxy
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1544
  def initialize(index, level); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1566
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1579
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1562
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1549
  def disasm(fmt); end

  # Returns the value of attribute index.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1542
  def index; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1571
  def length; end

  # Returns the value of attribute level.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1542
  def level; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1575
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1556
  def to_a(iseq); end
end

# ### Summary
#
# `getclassvariable` looks for a class variable in the current class and
# pushes its value onto the stack. It uses an inline cache to reduce the
# need to lookup the class variable in the class hierarchy every time.
#
# ### Usage
#
# ~~~ruby
# @@class_variable
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1596
class SyntaxTree::YARV::GetClassVariable < ::SyntaxTree::YARV::Instruction
  # @return [GetClassVariable] a new instance of GetClassVariable
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1599
  def initialize(name, cache); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1619
  def ==(other); end

  # Returns the value of attribute cache.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1597
  def cache; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1632
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1615
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1604
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1624
  def length; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1597
  def name; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1628
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1611
  def to_a(_iseq); end
end

# ### Summary
#
# `getconstant` performs a constant lookup and pushes the value of the
# constant onto the stack. It pops both the class it should look in and
# whether or not it should look globally as well.
#
# ### Usage
#
# ~~~ruby
# Constant
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1651
class SyntaxTree::YARV::GetConstant < ::SyntaxTree::YARV::Instruction
  # @return [GetConstant] a new instance of GetConstant
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1654
  def initialize(name); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1670
  def ==(other); end

  # @raise [NameError]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1686
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1666
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1658
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1674
  def length; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1652
  def name; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1678
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1682
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1662
  def to_a(_iseq); end
end

# ### Summary
#
# `getglobal` pushes the value of a global variables onto the stack.
#
# ### Usage
#
# ~~~ruby
# $$
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1717
class SyntaxTree::YARV::GetGlobal < ::SyntaxTree::YARV::Instruction
  # @return [GetGlobal] a new instance of GetGlobal
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1720
  def initialize(name); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1736
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1748
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1732
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1724
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1740
  def length; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1718
  def name; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1744
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1728
  def to_a(_iseq); end
end

# ### Summary
#
# `getinstancevariable` pushes the value of an instance variable onto the
# stack. It uses an inline cache to avoid having to look up the instance
# variable in the class hierarchy every time.
#
# This instruction has two forms, but both have the same structure. Before
# Ruby 3.2, the inline cache corresponded to both the get and set
# instructions and could be shared. Since Ruby 3.2, it uses object shapes
# instead so the caches are unique per instruction.
#
# ### Usage
#
# ~~~ruby
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1772
class SyntaxTree::YARV::GetInstanceVariable < ::SyntaxTree::YARV::Instruction
  # @return [GetInstanceVariable] a new instance of GetInstanceVariable
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1775
  def initialize(name, cache); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1795
  def ==(other); end

  # Returns the value of attribute cache.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1773
  def cache; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1808
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1791
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1780
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1800
  def length; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1773
  def name; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1804
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1787
  def to_a(_iseq); end
end

# ### Summary
#
# `getlocal` fetches the value of a local variable from a frame determined
# by the level and index arguments. The level is the number of frames back
# to look and the index is the index in the local table. It pushes the value
# it finds onto the stack.
#
# ### Usage
#
# ~~~ruby
# value = 5
# tap { tap { value } }
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1828
class SyntaxTree::YARV::GetLocal < ::SyntaxTree::YARV::Instruction
  # @return [GetLocal] a new instance of GetLocal
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1831
  def initialize(index, level); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1850
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1862
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1846
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1836
  def disasm(fmt); end

  # Returns the value of attribute index.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1829
  def index; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1854
  def length; end

  # Returns the value of attribute level.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1829
  def level; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1858
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1840
  def to_a(iseq); end
end

# ### Summary
#
# `getlocal_WC_0` is a specialized version of the `getlocal` instruction. It
# fetches the value of a local variable from the current frame determined by
# the index given as its only argument.
#
# ### Usage
#
# ~~~ruby
# value = 5
# value
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1880
class SyntaxTree::YARV::GetLocalWC0 < ::SyntaxTree::YARV::Instruction
  # @return [GetLocalWC0] a new instance of GetLocalWC0
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1883
  def initialize(index); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1899
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1915
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1911
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1895
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1887
  def disasm(fmt); end

  # Returns the value of attribute index.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1881
  def index; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1903
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1907
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1891
  def to_a(iseq); end
end

# ### Summary
#
# `getlocal_WC_1` is a specialized version of the `getlocal` instruction. It
# fetches the value of a local variable from the parent frame determined by
# the index given as its only argument.
#
# ### Usage
#
# ~~~ruby
# value = 5
# self.then { value }
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1933
class SyntaxTree::YARV::GetLocalWC1 < ::SyntaxTree::YARV::Instruction
  # @return [GetLocalWC1] a new instance of GetLocalWC1
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1936
  def initialize(index); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1952
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1968
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1964
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1948
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1940
  def disasm(fmt); end

  # Returns the value of attribute index.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1934
  def index; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1956
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1960
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1944
  def to_a(iseq); end
end

# ### Summary
#
# `getspecial` pushes the value of a special local variable onto the stack.
#
# ### Usage
#
# ~~~ruby
# 1 if (a == 1) .. (b == 2)
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1983
class SyntaxTree::YARV::GetSpecial < ::SyntaxTree::YARV::Instruction
  # @return [GetSpecial] a new instance of GetSpecial
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1990
  def initialize(key, type); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2007
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2019
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2003
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1995
  def disasm(fmt); end

  # Returns the value of attribute key.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1988
  def key; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2011
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2015
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1999
  def to_a(_iseq); end

  # Returns the value of attribute type.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1988
  def type; end
end

# $~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1985
SyntaxTree::YARV::GetSpecial::SVAR_BACKREF = T.let(T.unsafe(nil), Integer)

# flipflop
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1986
SyntaxTree::YARV::GetSpecial::SVAR_FLIPFLOP_START = T.let(T.unsafe(nil), Integer)

# $_
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#1984
SyntaxTree::YARV::GetSpecial::SVAR_LASTLINE = T.let(T.unsafe(nil), Integer)

# This is a base class for all YARV instructions. It provides a few
# convenience methods for working with instructions.
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#7
class SyntaxTree::YARV::Instruction
  # This returns an array of labels.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#33
  def branch_targets; end

  # This method creates an instruction that represents the canonical
  # (non-specialized) form of this instruction. If this instruction is not
  # a specialized instruction, then this method returns `self`.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#11
  def canonical; end

  # Whether or not this instruction falls through to the next instruction if
  # its branching fails.
  #
  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#44
  def falls_through?; end

  # Whether or not this instruction leaves the current frame.
  #
  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#38
  def leaves?; end

  # This returns the size of the instruction in terms of the number of slots
  # it occupies in the instruction sequence. Effectively this is 1 plus the
  # number of operands.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#18
  def length; end

  # This returns the number of values that are popped off the stack.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#28
  def pops; end

  # This returns the number of values that are pushed onto the stack.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#23
  def pushes; end

  # Does the instruction have side effects? Control-flow counts as a
  # side-effect, as do some special-case instructions like Leave. By default
  # every instruction is marked as having side effects.
  #
  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#51
  def side_effects?; end
end

# This class is meant to mirror RubyVM::InstructionSequence. It contains a
# list of instructions along with the metadata pertaining to them. It also
# functions as a builder for the instruction sequence.
#
# source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#9
class SyntaxTree::YARV::InstructionSequence
  # @return [InstructionSequence] a new instance of InstructionSequence
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#168
  def initialize(name, file, line, type, parent_iseq = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#652
  def adjuststack(number); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#656
  def anytostring; end

  # Returns the value of attribute argument_options.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#143
  def argument_options; end

  # This is the list of information about the arguments to this
  # instruction sequence.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#142
  def argument_size; end

  # This is the list of information about the arguments to this
  # instruction sequence.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#142
  def argument_size=(_arg0); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#472
  def block_child_iseq(line); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#660
  def branchif(label); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#664
  def branchnil(label); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#668
  def branchunless(label); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#565
  def catch_break(iseq, begin_label, end_label, exit_label, restore_sp); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#575
  def catch_ensure(iseq, begin_label, end_label, exit_label, restore_sp); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#585
  def catch_next(begin_label, end_label, exit_label, restore_sp); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#595
  def catch_redo(begin_label, end_label, exit_label, restore_sp); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#605
  def catch_rescue(iseq, begin_label, end_label, exit_label, restore_sp); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#615
  def catch_retry(begin_label, end_label, exit_label, restore_sp); end

  # The catch table for this instruction sequence.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#146
  def catch_table; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#672
  def checkkeyword(keyword_bits_index, keyword_index); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#676
  def checkmatch(type); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#680
  def checktype(type); end

  # Child instruction sequence methods
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#468
  def child_iseq(name, line, type); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#478
  def class_child_iseq(name, line); end

  # This method converts our linked list of instructions into a final array
  # and performs any other compilation steps necessary.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#305
  def compile!; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#684
  def concatarray; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#688
  def concatstrings(number); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#692
  def defineclass(name, class_iseq, flags); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#696
  def defined(type, name, message); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#700
  def definedivar(name, cache, message); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#709
  def definemethod(name, method_iseq); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#713
  def definesmethod(name, method_iseq); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#292
  def disasm; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#717
  def dup; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#721
  def duparray(object); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#725
  def duphash(object); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#729
  def dupn(number); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#232
  def eval; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#648
  def event(name); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#733
  def expandarray(length, flags); end

  # The source location of the instruction sequence.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#132
  def file; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#737
  def getblockparam(index, level); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#741
  def getblockparamproxy(index, level); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#745
  def getclassvariable(name); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#753
  def getconstant(name); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#757
  def getglobal(name); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#761
  def getinstancevariable(name); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#769
  def getlocal(index, level); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#788
  def getspecial(key, type); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#207
  def inline_storage; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#213
  def inline_storage_for(name); end

  # The hash of names of instance and class variables pointing to the
  # index of their associated inline storage.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#156
  def inline_storages; end

  # The list of instructions for this instruction sequence.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#149
  def insns; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#299
  def inspect; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#792
  def intern; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#796
  def invokeblock(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#800
  def invokesuper(calldata, block_iseq); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#804
  def jump(label); end

  # Instruction push methods
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#629
  def label; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#808
  def leave; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#219
  def length; end

  # The source location of the instruction sequence.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#132
  def line; end

  # The table of local variables.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#152
  def local_table; end

  # Query methods
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#199
  def local_variable(name, level = T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#482
  def method_child_iseq(name, line); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#486
  def module_child_iseq(name, line); end

  # The name of the instruction sequence.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#129
  def name; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#812
  def newarray(number); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#816
  def newarraykwsplat(number); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#820
  def newhash(number); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#824
  def newrange(exclude_end); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#828
  def nop; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#832
  def objtostring(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#836
  def once(iseq, cache); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#840
  def opt_aref_with(object, calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#844
  def opt_aset_with(object, calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#848
  def opt_case_dispatch(case_dispatch_hash, else_label); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#852
  def opt_getconstant_path(names); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#888
  def opt_getinlinecache(label, cache); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#892
  def opt_setinlinecache(cache); end

  # These are various compilation options provided.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#166
  def options; end

  # The parent instruction sequence, if there is one.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#138
  def parent_iseq; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#896
  def pop; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#633
  def push(value); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#900
  def putnil; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#904
  def putobject(object); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#922
  def putself; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#926
  def putspecialobject(object); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#930
  def putstring(object); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#934
  def send(calldata, block_iseq = T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#938
  def setblockparam(index, level); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#942
  def setclassvariable(name); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#950
  def setconstant(name); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#954
  def setglobal(name); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#958
  def setinstancevariable(name); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#966
  def setlocal(index, level); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#985
  def setn(number); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#989
  def setspecial(key); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#490
  def singleton_class_child_iseq(line); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#341
  def specialize_instructions!; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#993
  def splatarray(flag); end

  # An object that will track the current size of the stack and the
  # maximum size of the stack for this instruction sequence.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#163
  def stack; end

  # The index of the next inline storage that will be created.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#159
  def storage_index; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#997
  def swap; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#1001
  def throw(type); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#236
  def to_a; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#280
  def to_cfg; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#284
  def to_dfg; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#288
  def to_son; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#1005
  def topn(number); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#1009
  def toregexp(options, length); end

  # The type of the instruction sequence.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#135
  def type; end

  class << self
    # This method will create a new instruction sequence from a serialized
    # RubyVM::InstructionSequence object.
    #
    # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#1015
    def from(source, options = T.unsafe(nil), parent_iseq = T.unsafe(nil)); end

    # This provides a handle to the rb_iseq_load function, which allows you
    # to pass a serialized iseq to Ruby and have it return a
    # RubyVM::InstructionSequence object.
    #
    # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#13
    def iseq_load(iseq); end
  end
end

# source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#510
class SyntaxTree::YARV::InstructionSequence::CatchBreak < ::SyntaxTree::YARV::InstructionSequence::CatchEntry
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#511
  def to_a; end
end

# source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#523
class SyntaxTree::YARV::InstructionSequence::CatchEnsure < ::SyntaxTree::YARV::InstructionSequence::CatchEntry
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#524
  def to_a; end
end

# Catch table methods
#
# source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#498
class SyntaxTree::YARV::InstructionSequence::CatchEntry
  # @return [CatchEntry] a new instance of CatchEntry
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#501
  def initialize(iseq, begin_label, end_label, exit_label, restore_sp); end

  # Returns the value of attribute begin_label.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#499
  def begin_label; end

  # Returns the value of attribute end_label.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#499
  def end_label; end

  # Returns the value of attribute exit_label.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#499
  def exit_label; end

  # Returns the value of attribute iseq.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#499
  def iseq; end

  # Returns the value of attribute restore_sp.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#499
  def restore_sp; end
end

# source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#535
class SyntaxTree::YARV::InstructionSequence::CatchNext < ::SyntaxTree::YARV::InstructionSequence::CatchEntry
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#536
  def to_a; end
end

# source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#541
class SyntaxTree::YARV::InstructionSequence::CatchRedo < ::SyntaxTree::YARV::InstructionSequence::CatchEntry
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#542
  def to_a; end
end

# source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#547
class SyntaxTree::YARV::InstructionSequence::CatchRescue < ::SyntaxTree::YARV::InstructionSequence::CatchEntry
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#548
  def to_a; end
end

# source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#559
class SyntaxTree::YARV::InstructionSequence::CatchRetry < ::SyntaxTree::YARV::InstructionSequence::CatchEntry
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#560
  def to_a; end
end

# When the list of instructions is first being created, it's stored as a
# linked list. This is to make it easier to perform peephole optimizations
# and other transformations like instruction specialization.
#
# source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#35
class SyntaxTree::YARV::InstructionSequence::InstructionList
  include ::Enumerable

  # @return [InstructionList] a new instance of InstructionList
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#48
  def initialize; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#53
  def each(&_blk); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#58
  def each_node; end

  # Returns the value of attribute head_node.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#46
  def head_node; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#68
  def push(instruction); end

  # Returns the value of attribute tail_node.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#46
  def tail_node; end
end

# source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#36
class SyntaxTree::YARV::InstructionSequence::InstructionList::Node
  # @return [Node] a new instance of Node
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#39
  def initialize(value, next_node = T.unsafe(nil)); end

  # Returns the value of attribute next_node.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#37
  def next_node; end

  # Sets the attribute next_node
  #
  # @param value the value to set the attribute next_node to.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#37
  def next_node=(_arg0); end

  # Returns the value of attribute value.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#37
  def value; end

  # Sets the attribute value
  #
  # @param value the value to set the attribute value to.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#37
  def value=(_arg0); end
end

# This represents the destination of instructions that jump. Initially it
# does not track its position so that when we perform optimizations the
# indices don't get messed up.
#
# source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#107
class SyntaxTree::YARV::InstructionSequence::Label
  # @return [Label] a new instance of Label
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#115
  def initialize(name = T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#123
  def inspect; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#108
  def name; end

  # When we're serializing the instruction sequence, we need to be able to
  # look up the label from the branch instructions and then access the
  # subsequent node. So we'll store the reference here.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#113
  def node; end

  # When we're serializing the instruction sequence, we need to be able to
  # look up the label from the branch instructions and then access the
  # subsequent node. So we'll store the reference here.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#113
  def node=(_arg0); end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#119
  def patch!(name); end
end

# source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#83
SyntaxTree::YARV::InstructionSequence::MAGIC = T.let(T.unsafe(nil), String)

# This object is used to track the size of the stack at any given time. It
# is effectively a mini symbolic interpreter. It's necessary because when
# instruction sequences get serialized they include a :stack_max field on
# them. This field is used to determine how much stack space to allocate
# for the instruction sequence.
#
# source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#90
class SyntaxTree::YARV::InstructionSequence::Stack
  # @return [Stack] a new instance of Stack
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#93
  def initialize; end

  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#98
  def change_by(value); end

  # Returns the value of attribute current_size.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#91
  def current_size; end

  # Returns the value of attribute maximum_size.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instruction_sequence.rb#91
  def maximum_size; end
end

# ### Summary
#
# `intern` converts the top element of the stack to a symbol and pushes the
# symbol onto the stack.
#
# ### Usage
#
# ~~~ruby
# :"#{"foo"}"
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2042
class SyntaxTree::YARV::Intern < ::SyntaxTree::YARV::Instruction
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2055
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2067
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2051
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2043
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2059
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2063
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2047
  def to_a(_iseq); end
end

# ### Summary
#
# `invokeblock` invokes the block given to the current method. It pops the
# arguments for the block off the stack and pushes the result of running the
# block onto the stack.
#
# ### Usage
#
# ~~~ruby
# def foo
#   yield
# end
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2086
class SyntaxTree::YARV::InvokeBlock < ::SyntaxTree::YARV::Instruction
  # @return [InvokeBlock] a new instance of InvokeBlock
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2089
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2105
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2121
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2087
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2101
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2093
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2109
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2113
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2117
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2097
  def to_a(_iseq); end
end

# ### Summary
#
# `invokesuper` is similar to the `send` instruction, except that it calls
# the super method. It pops the receiver and arguments off the stack and
# pushes the return value onto the stack.
#
# ### Usage
#
# ~~~ruby
# def foo
#   super
# end
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2140
class SyntaxTree::YARV::InvokeSuper < ::SyntaxTree::YARV::Instruction
  # @return [InvokeSuper] a new instance of InvokeSuper
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2143
  def initialize(calldata, block_iseq); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2164
  def ==(other); end

  # Returns the value of attribute block_iseq.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2141
  def block_iseq; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2178
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2141
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2160
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2148
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2169
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2174
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2156
  def to_a(_iseq); end
end

# ### Summary
#
# `jump` unconditionally jumps to the label given as its only argument.
#
# ### Usage
#
# ~~~ruby
# x = 0
# if x == 0
#   puts "0"
# else
#   puts "2"
# end
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2217
class SyntaxTree::YARV::Jump < ::SyntaxTree::YARV::Instruction
  # @return [Jump] a new instance of Jump
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2220
  def initialize(label); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2236
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2248
  def branch_targets; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2244
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2232
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2224
  def disasm(fmt); end

  # Returns the value of attribute label.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2218
  def label; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2240
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2228
  def to_a(_iseq); end
end

# ### Summary
#
# `leave` exits the current frame.
#
# ### Usage
#
# ~~~ruby
# ;;
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2263
class SyntaxTree::YARV::Leave < ::SyntaxTree::YARV::Instruction
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2276
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2290
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2272
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2264
  def disasm(fmt); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2294
  def leaves?; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2280
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2284
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2268
  def to_a(_iseq); end
end

# This module contains the instructions that used to be a part of YARV but
# have been replaced or removed in more recent versions.
#
# source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#7
module SyntaxTree::YARV::Legacy; end

# ### Summary
#
# `getclassvariable` looks for a class variable in the current class and
# pushes its value onto the stack.
#
# This version of the `getclassvariable` instruction is no longer used
# since in Ruby 3.0 it gained an inline cache.`
#
# ### Usage
#
# ~~~ruby
# @@class_variable
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#22
class SyntaxTree::YARV::Legacy::GetClassVariable < ::SyntaxTree::YARV::Instruction
  # @return [GetClassVariable] a new instance of GetClassVariable
  #
  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#25
  def initialize(name); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#41
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#57
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#53
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#37
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#29
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#45
  def length; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#23
  def name; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#49
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#33
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_getinlinecache` is a wrapper around a series of `putobject` and
# `getconstant` instructions that allows skipping past them if the inline
# cache is currently set. It pushes the value of the cache onto the stack
# if it is set, otherwise it pushes `nil`.
#
# This instruction is no longer used since in Ruby 3.2 it was replaced by
# the consolidated `opt_getconstant_path` instruction.
#
# ### Usage
#
# ~~~ruby
# Constant
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#78
class SyntaxTree::YARV::Legacy::OptGetInlineCache < ::SyntaxTree::YARV::Instruction
  # @return [OptGetInlineCache] a new instance of OptGetInlineCache
  #
  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#81
  def initialize(label, cache); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#101
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#118
  def branch_targets; end

  # Returns the value of attribute cache.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#79
  def cache; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#114
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#97
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#86
  def disasm(fmt); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#122
  def falls_through?; end

  # Returns the value of attribute label.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#79
  def label; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#106
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#110
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#93
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_newarray_max` is a specialization that occurs when the `max` method
# is called on an array literal. It pops the values of the array off the
# stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# [a, b, c].max
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#139
class SyntaxTree::YARV::Legacy::OptNewArrayMax < ::SyntaxTree::YARV::Instruction
  # @return [OptNewArrayMax] a new instance of OptNewArrayMax
  #
  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#142
  def initialize(number); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#158
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#174
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#154
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#146
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#162
  def length; end

  # Returns the value of attribute number.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#140
  def number; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#166
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#170
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#150
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_newarray_min` is a specialization that occurs when the `min` method
# is called on an array literal. It pops the values of the array off the
# stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# [a, b, c].min
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#191
class SyntaxTree::YARV::Legacy::OptNewArrayMin < ::SyntaxTree::YARV::Instruction
  # @return [OptNewArrayMin] a new instance of OptNewArrayMin
  #
  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#194
  def initialize(number); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#210
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#226
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#206
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#198
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#214
  def length; end

  # Returns the value of attribute number.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#192
  def number; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#218
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#222
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#202
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_setinlinecache` sets an inline cache for a constant lookup. It pops
# the value it should set off the top of the stack. It uses this value to
# set the cache. It then pushes that value back onto the top of the stack.
#
# This instruction is no longer used since in Ruby 3.2 it was replaced by
# the consolidated `opt_getconstant_path` instruction.
#
# ### Usage
#
# ~~~ruby
# Constant
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#246
class SyntaxTree::YARV::Legacy::OptSetInlineCache < ::SyntaxTree::YARV::Instruction
  # @return [OptSetInlineCache] a new instance of OptSetInlineCache
  #
  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#249
  def initialize(cache); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#265
  def ==(other); end

  # Returns the value of attribute cache.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#247
  def cache; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#281
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#261
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#253
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#269
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#273
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#277
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#257
  def to_a(_iseq); end
end

# ### Summary
#
# `setclassvariable` looks for a class variable in the current class and
# sets its value to the value it pops off the top of the stack.
#
# This version of the `setclassvariable` instruction is no longer used
# since in Ruby 3.0 it gained an inline cache.
#
# ### Usage
#
# ~~~ruby
# @@class_variable = 1
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#299
class SyntaxTree::YARV::Legacy::SetClassVariable < ::SyntaxTree::YARV::Instruction
  # @return [SetClassVariable] a new instance of SetClassVariable
  #
  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#302
  def initialize(name); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#318
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#334
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#330
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#314
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#306
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#322
  def length; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#300
  def name; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#326
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/legacy.rb#310
  def to_a(_iseq); end
end

# This represents every local variable associated with an instruction
# sequence. There are two kinds of locals: plain locals that are what you
# expect, and block proxy locals, which represent local variables
# associated with blocks that were passed into the current instruction
# sequence.
#
# source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#10
class SyntaxTree::YARV::LocalTable
  # @return [LocalTable] a new instance of LocalTable
  #
  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#43
  def initialize; end

  # Add a BlockLocal to the local table.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#73
  def block(name); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#47
  def empty?; end

  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#51
  def find(name, level = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#56
  def has?(name); end

  # Returns the value of attribute locals.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#41
  def locals; end

  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#64
  def name_at(index); end

  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#60
  def names; end

  # This is the offset from the top of the stack where this local variable
  # lives.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#84
  def offset(index); end

  # Add a PlainLocal to the local table.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#78
  def plain(name); end

  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#68
  def size; end
end

# A local representing a block passed into the current instruction
# sequence.
#
# source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#13
class SyntaxTree::YARV::LocalTable::BlockLocal
  # @return [BlockLocal] a new instance of BlockLocal
  #
  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#16
  def initialize(name); end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#14
  def name; end
end

# The result of looking up a local variable in the current local table.
#
# source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#31
class SyntaxTree::YARV::LocalTable::Lookup
  # @return [Lookup] a new instance of Lookup
  #
  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#34
  def initialize(local, index, level); end

  # Returns the value of attribute index.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#32
  def index; end

  # Returns the value of attribute level.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#32
  def level; end

  # Returns the value of attribute local.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#32
  def local; end
end

# A regular local variable.
#
# source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#22
class SyntaxTree::YARV::LocalTable::PlainLocal
  # @return [PlainLocal] a new instance of PlainLocal
  #
  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#25
  def initialize(name); end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/local_table.rb#23
  def name; end
end

# ### Summary
#
# `newarray` puts a new array initialized with `number` values from the
# stack. It pops `number` values off the stack and pushes the array onto the
# stack.
#
# ### Usage
#
# ~~~ruby
# ["string"]
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2311
class SyntaxTree::YARV::NewArray < ::SyntaxTree::YARV::Instruction
  # @return [NewArray] a new instance of NewArray
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2314
  def initialize(number); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2330
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2346
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2326
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2318
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2334
  def length; end

  # Returns the value of attribute number.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2312
  def number; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2338
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2342
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2322
  def to_a(_iseq); end
end

# ### Summary
#
# `newarraykwsplat` is a specialized version of `newarray` that takes a **
# splat argument. It pops `number` values off the stack and pushes the array
# onto the stack.
#
# ### Usage
#
# ~~~ruby
# ["string", **{ foo: "bar" }]
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2363
class SyntaxTree::YARV::NewArrayKwSplat < ::SyntaxTree::YARV::Instruction
  # @return [NewArrayKwSplat] a new instance of NewArrayKwSplat
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2366
  def initialize(number); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2382
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2398
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2378
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2370
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2386
  def length; end

  # Returns the value of attribute number.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2364
  def number; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2390
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2394
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2374
  def to_a(_iseq); end
end

# ### Summary
#
# `newhash` puts a new hash onto the stack, using `number` elements from the
# stack. `number` needs to be even. It pops `number` elements off the stack
# and pushes a hash onto the stack.
#
# ### Usage
#
# ~~~ruby
# def foo(key, value)
#   { key => value }
# end
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2417
class SyntaxTree::YARV::NewHash < ::SyntaxTree::YARV::Instruction
  # @return [NewHash] a new instance of NewHash
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2420
  def initialize(number); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2436
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2452
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2432
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2424
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2440
  def length; end

  # Returns the value of attribute number.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2418
  def number; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2444
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2448
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2428
  def to_a(_iseq); end
end

# ### Summary
#
# `newrange` creates a new range object from the top two values on the
# stack. It pops both of them off, and then pushes on the new range. It
# takes one argument which is 0 if the end is included or 1 if the end value
# is excluded.
#
# ### Usage
#
# ~~~ruby
# x = 0
# y = 1
# p (x..y), (x...y)
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2472
class SyntaxTree::YARV::NewRange < ::SyntaxTree::YARV::Instruction
  # @return [NewRange] a new instance of NewRange
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2475
  def initialize(exclude_end); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2491
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2507
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2487
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2479
  def disasm(fmt); end

  # Returns the value of attribute exclude_end.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2473
  def exclude_end; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2495
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2499
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2503
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2483
  def to_a(_iseq); end
end

# ### Summary
#
# `nop` is a no-operation instruction. It is used to pad the instruction
# sequence so there is a place for other instructions to jump to.
#
# ### Usage
#
# ~~~ruby
# raise rescue true
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2523
class SyntaxTree::YARV::Nop < ::SyntaxTree::YARV::Instruction
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2536
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2540
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2532
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2524
  def disasm(fmt); end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2543
  def side_effects?; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2528
  def to_a(_iseq); end
end

# ### Summary
#
# `objtostring` pops a value from the stack, calls `to_s` on that value and
# then pushes the result back to the stack.
#
# It has various fast paths for classes like String, Symbol, Module, Class,
# etc. For everything else it calls `to_s`.
#
# ### Usage
#
# ~~~ruby
# "#{5}"
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2562
class SyntaxTree::YARV::ObjToString < ::SyntaxTree::YARV::Instruction
  # @return [ObjToString] a new instance of ObjToString
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2565
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2581
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2597
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2563
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2577
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2569
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2585
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2589
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2593
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2573
  def to_a(_iseq); end
end

# ### Summary
#
# `once` is an instruction that wraps an instruction sequence and ensures
# that is it only ever executed once for the lifetime of the program. It
# uses a cache to ensure that it is only executed once. It pushes the result
# of running the instruction sequence onto the stack.
#
# ### Usage
#
# ~~~ruby
# END { puts "END" }
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2615
class SyntaxTree::YARV::Once < ::SyntaxTree::YARV::Instruction
  # @return [Once] a new instance of Once
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2618
  def initialize(iseq, cache); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2636
  def ==(other); end

  # Returns the value of attribute cache.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2616
  def cache; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2648
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2632
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2623
  def disasm(fmt); end

  # Returns the value of attribute iseq.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2616
  def iseq; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2640
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2644
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2628
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_and` is a specialization of the `opt_send_without_block` instruction
# that occurs when the `&` operator is used. There is a fast path for if
# both operands are integers. It pops both the receiver and the argument off
# the stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# 2 & 3
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2668
class SyntaxTree::YARV::OptAnd < ::SyntaxTree::YARV::Instruction
  # @return [OptAnd] a new instance of OptAnd
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2671
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2687
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2707
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2669
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2703
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2683
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2675
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2691
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2695
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2699
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2679
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_aref` is a specialization of the `opt_send_without_block` instruction
# that occurs when the `[]` operator is used. There are fast paths if the
# receiver is an integer, array, or hash.
#
# ### Usage
#
# ~~~ruby
# 7[2]
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2724
class SyntaxTree::YARV::OptAref < ::SyntaxTree::YARV::Instruction
  # @return [OptAref] a new instance of OptAref
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2727
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2743
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2763
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2725
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2759
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2739
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2731
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2747
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2751
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2755
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2735
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_aref_with` is a specialization of the `opt_aref` instruction that
# occurs when the `[]` operator is used with a string argument known at
# compile time. There are fast paths if the receiver is a hash. It pops the
# receiver off the stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# { 'test' => true }['test']
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2781
class SyntaxTree::YARV::OptArefWith < ::SyntaxTree::YARV::Instruction
  # @return [OptArefWith] a new instance of OptArefWith
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2784
  def initialize(object, calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2804
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2821
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2782
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2800
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2789
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2809
  def length; end

  # Returns the value of attribute object.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2782
  def object; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2813
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2817
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2796
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_aset` is an instruction for setting the hash value by the key in
# the `recv[obj] = set` format. It is a specialization of the
# `opt_send_without_block` instruction. It pops the receiver, the key, and
# the value off the stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# {}[:key] = value
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2839
class SyntaxTree::YARV::OptAset < ::SyntaxTree::YARV::Instruction
  # @return [OptAset] a new instance of OptAset
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2842
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2858
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2878
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2840
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2874
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2854
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2846
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2862
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2866
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2870
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2850
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_aset_with` is an instruction for setting the hash value by the known
# string key in the `recv[obj] = set` format. It pops the receiver and the
# value off the stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# {}["key"] = value
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2895
class SyntaxTree::YARV::OptAsetWith < ::SyntaxTree::YARV::Instruction
  # @return [OptAsetWith] a new instance of OptAsetWith
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2898
  def initialize(object, calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2918
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2935
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2896
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2914
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2903
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2923
  def length; end

  # Returns the value of attribute object.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2896
  def object; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2927
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2931
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2910
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_case_dispatch` is a branch instruction that moves the control flow
# for case statements that have clauses where they can all be used as hash
# keys for an internal hash.
#
# It has two arguments: the `case_dispatch_hash` and an `else_label`. It
# pops one value off the stack: a hash key. `opt_case_dispatch` looks up the
# key in the `case_dispatch_hash` and jumps to the corresponding label if
# there is one. If there is no value in the `case_dispatch_hash`,
# `opt_case_dispatch` jumps to the `else_label` index.
#
# ### Usage
#
# ~~~ruby
# case 1
# when 1
#   puts "foo"
# else
#   puts "bar"
# end
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2964
class SyntaxTree::YARV::OptCaseDispatch < ::SyntaxTree::YARV::Instruction
  # @return [OptCaseDispatch] a new instance of OptCaseDispatch
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2967
  def initialize(case_dispatch_hash, else_label); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2991
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3009
  def branch_targets; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3005
  def call(vm); end

  # Returns the value of attribute case_dispatch_hash.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2965
  def case_dispatch_hash; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2987
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2972
  def disasm(fmt); end

  # Returns the value of attribute else_label.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2965
  def else_label; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3013
  def falls_through?; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2997
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3001
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#2979
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_div` is a specialization of the `opt_send_without_block` instruction
# that occurs when the `/` operator is used. There are fast paths for if
# both operands are integers, or if both operands are floats. It pops both
# the receiver and the argument off the stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# 2 / 3
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3031
class SyntaxTree::YARV::OptDiv < ::SyntaxTree::YARV::Instruction
  # @return [OptDiv] a new instance of OptDiv
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3034
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3050
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3070
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3032
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3066
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3046
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3038
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3054
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3058
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3062
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3042
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_empty_p` is an optimization applied when the method `empty?` is
# called. It pops the receiver off the stack and pushes on the result of the
# method call.
#
# ### Usage
#
# ~~~ruby
# "".empty?
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3087
class SyntaxTree::YARV::OptEmptyP < ::SyntaxTree::YARV::Instruction
  # @return [OptEmptyP] a new instance of OptEmptyP
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3090
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3106
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3126
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3088
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3122
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3102
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3094
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3110
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3114
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3118
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3098
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_eq` is a specialization of the `opt_send_without_block` instruction
# that occurs when the == operator is used. Fast paths exist when both
# operands are integers, floats, symbols or strings. It pops both the
# receiver and the argument off the stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# 2 == 2
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3144
class SyntaxTree::YARV::OptEq < ::SyntaxTree::YARV::Instruction
  # @return [OptEq] a new instance of OptEq
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3147
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3163
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3183
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3145
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3179
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3159
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3151
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3167
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3171
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3175
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3155
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_ge` is a specialization of the `opt_send_without_block` instruction
# that occurs when the >= operator is used. Fast paths exist when both
# operands are integers or floats. It pops both the receiver and the
# argument off the stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# 4 >= 3
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3201
class SyntaxTree::YARV::OptGE < ::SyntaxTree::YARV::Instruction
  # @return [OptGE] a new instance of OptGE
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3204
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3220
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3240
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3202
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3236
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3216
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3208
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3224
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3228
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3232
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3212
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_gt` is a specialization of the `opt_send_without_block` instruction
# that occurs when the > operator is used. Fast paths exist when both
# operands are integers or floats. It pops both the receiver and the
# argument off the stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# 4 > 3
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3314
class SyntaxTree::YARV::OptGT < ::SyntaxTree::YARV::Instruction
  # @return [OptGT] a new instance of OptGT
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3317
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3333
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3353
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3315
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3349
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3329
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3321
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3337
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3341
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3345
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3325
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_getconstant_path` performs a constant lookup on a chain of constant
# names. It accepts as its argument an array of constant names, and pushes
# the value of the constant onto the stack.
#
# ### Usage
#
# ~~~ruby
# ::Object
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3257
class SyntaxTree::YARV::OptGetConstantPath < ::SyntaxTree::YARV::Instruction
  # @return [OptGetConstantPath] a new instance of OptGetConstantPath
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3260
  def initialize(names); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3277
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3289
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3273
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3264
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3281
  def length; end

  # Returns the value of attribute names.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3258
  def names; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3285
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3269
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_le` is a specialization of the `opt_send_without_block` instruction
# that occurs when the <= operator is used. Fast paths exist when both
# operands are integers or floats. It pops both the receiver and the
# argument off the stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# 3 <= 4
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3371
class SyntaxTree::YARV::OptLE < ::SyntaxTree::YARV::Instruction
  # @return [OptLE] a new instance of OptLE
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3374
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3390
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3410
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3372
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3406
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3386
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3378
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3394
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3398
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3402
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3382
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_lt` is a specialization of the `opt_send_without_block` instruction
# that occurs when the < operator is used. Fast paths exist when both
# operands are integers or floats. It pops both the receiver and the
# argument off the stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# 3 < 4
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3485
class SyntaxTree::YARV::OptLT < ::SyntaxTree::YARV::Instruction
  # @return [OptLT] a new instance of OptLT
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3488
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3504
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3524
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3486
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3520
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3500
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3492
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3508
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3512
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3516
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3496
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_ltlt` is a specialization of the `opt_send_without_block` instruction
# that occurs when the `<<` operator is used. Fast paths exists when the
# receiver is either a String or an Array. It pops both the receiver and the
# argument off the stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# "" << 2
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3542
class SyntaxTree::YARV::OptLTLT < ::SyntaxTree::YARV::Instruction
  # @return [OptLTLT] a new instance of OptLTLT
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3545
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3561
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3581
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3543
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3577
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3557
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3549
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3565
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3569
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3573
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3553
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_length` is a specialization of `opt_send_without_block`, when the
# `length` method is called. There are fast paths when the receiver is
# either a string, hash, or array. It pops the receiver off the stack and
# pushes on the result of the method call.
#
# ### Usage
#
# ~~~ruby
# "".length
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3428
class SyntaxTree::YARV::OptLength < ::SyntaxTree::YARV::Instruction
  # @return [OptLength] a new instance of OptLength
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3431
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3447
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3467
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3429
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3463
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3443
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3435
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3451
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3455
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3459
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3439
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_minus` is a specialization of the `opt_send_without_block`
# instruction that occurs when the `-` operator is used. There are fast
# paths for if both operands are integers or if both operands are floats. It
# pops both the receiver and the argument off the stack and pushes on the
# result.
#
# ### Usage
#
# ~~~ruby
# 3 - 2
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3600
class SyntaxTree::YARV::OptMinus < ::SyntaxTree::YARV::Instruction
  # @return [OptMinus] a new instance of OptMinus
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3603
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3619
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3639
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3601
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3635
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3615
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3607
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3623
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3627
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3631
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3611
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_mod` is a specialization of the `opt_send_without_block` instruction
# that occurs when the `%` operator is used. There are fast paths for if
# both operands are integers or if both operands are floats. It pops both
# the receiver and the argument off the stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# 4 % 2
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3657
class SyntaxTree::YARV::OptMod < ::SyntaxTree::YARV::Instruction
  # @return [OptMod] a new instance of OptMod
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3660
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3676
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3696
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3658
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3692
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3672
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3664
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3680
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3684
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3688
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3668
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_mult` is a specialization of the `opt_send_without_block` instruction
# that occurs when the `*` operator is used. There are fast paths for if
# both operands are integers or floats. It pops both the receiver and the
# argument off the stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# 3 * 2
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3714
class SyntaxTree::YARV::OptMult < ::SyntaxTree::YARV::Instruction
  # @return [OptMult] a new instance of OptMult
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3717
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3733
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3753
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3715
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3749
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3729
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3721
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3737
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3741
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3745
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3725
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_neq` is an optimization that tests whether two values at the top of
# the stack are not equal by testing their equality and calling the `!` on
# the result. This allows `opt_neq` to use the fast paths optimized in
# `opt_eq` when both operands are Integers, Floats, Symbols, or Strings. It
# pops both the receiver and the argument off the stack and pushes on the
# result.
#
# ### Usage
#
# ~~~ruby
# 2 != 2
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3773
class SyntaxTree::YARV::OptNEq < ::SyntaxTree::YARV::Instruction
  # @return [OptNEq] a new instance of OptNEq
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3776
  def initialize(eq_calldata, neq_calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3796
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3813
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3792
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3781
  def disasm(fmt); end

  # Returns the value of attribute eq_calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3774
  def eq_calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3801
  def length; end

  # Returns the value of attribute neq_calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3774
  def neq_calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3805
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3809
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3788
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_newarray_send` is a specialization that occurs when a dynamic array
# literal is created and immediately sent the `min`, `max`, or `hash`
# methods. It pops the values of the array off the stack and pushes on the
# result of the method call.
#
# ### Usage
#
# ~~~ruby
# [a, b, c].max
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3832
class SyntaxTree::YARV::OptNewArraySend < ::SyntaxTree::YARV::Instruction
  # @return [OptNewArraySend] a new instance of OptNewArraySend
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3835
  def initialize(number, method); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3855
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3872
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3851
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3840
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3860
  def length; end

  # Returns the value of attribute method.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3833
  def method; end

  # Returns the value of attribute number.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3833
  def number; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3864
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3868
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3847
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_nil_p` is an optimization applied when the method `nil?` is called.
# It returns true immediately when the receiver is `nil` and defers to the
# `nil?` method in other cases. It pops the receiver off the stack and
# pushes on the result.
#
# ### Usage
#
# ~~~ruby
# "".nil?
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3890
class SyntaxTree::YARV::OptNilP < ::SyntaxTree::YARV::Instruction
  # @return [OptNilP] a new instance of OptNilP
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3893
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3909
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3929
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3891
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3925
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3905
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3897
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3913
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3917
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3921
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3901
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_not` negates the value on top of the stack by calling the `!` method
# on it. It pops the receiver off the stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# !true
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3945
class SyntaxTree::YARV::OptNot < ::SyntaxTree::YARV::Instruction
  # @return [OptNot] a new instance of OptNot
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3948
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3964
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3984
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3946
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3980
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3960
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3952
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3968
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3972
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3976
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#3956
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_or` is a specialization of the `opt_send_without_block` instruction
# that occurs when the `|` operator is used. There is a fast path for if
# both operands are integers. It pops both the receiver and the argument off
# the stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# 2 | 3
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4002
class SyntaxTree::YARV::OptOr < ::SyntaxTree::YARV::Instruction
  # @return [OptOr] a new instance of OptOr
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4005
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4021
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4041
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4003
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4037
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4017
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4009
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4025
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4029
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4033
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4013
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_plus` is a specialization of the `opt_send_without_block` instruction
# that occurs when the `+` operator is used. There are fast paths for if
# both operands are integers, floats, strings, or arrays. It pops both the
# receiver and the argument off the stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# 2 + 3
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4059
class SyntaxTree::YARV::OptPlus < ::SyntaxTree::YARV::Instruction
  # @return [OptPlus] a new instance of OptPlus
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4062
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4078
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4098
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4060
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4094
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4074
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4066
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4082
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4086
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4090
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4070
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_regexpmatch2` is a specialization of the `opt_send_without_block`
# instruction that occurs when the `=~` operator is used. It pops both the
# receiver and the argument off the stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# /a/ =~ "a"
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4115
class SyntaxTree::YARV::OptRegExpMatch2 < ::SyntaxTree::YARV::Instruction
  # @return [OptRegExpMatch2] a new instance of OptRegExpMatch2
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4118
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4134
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4154
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4116
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4150
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4130
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4122
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4138
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4142
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4146
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4126
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_send_without_block` is a specialization of the send instruction that
# occurs when a method is being called without a block. It pops the receiver
# and the arguments off the stack and pushes on the result.
#
# ### Usage
#
# ~~~ruby
# puts "Hello, world!"
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4171
class SyntaxTree::YARV::OptSendWithoutBlock < ::SyntaxTree::YARV::Instruction
  # @return [OptSendWithoutBlock] a new instance of OptSendWithoutBlock
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4174
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4190
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4210
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4172
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4206
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4186
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4178
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4194
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4198
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4202
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4182
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_size` is a specialization of `opt_send_without_block`, when the
# `size` method is called. There are fast paths when the receiver is either
# a string, hash, or array. It pops the receiver off the stack and pushes on
# the result.
#
# ### Usage
#
# ~~~ruby
# "".size
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4228
class SyntaxTree::YARV::OptSize < ::SyntaxTree::YARV::Instruction
  # @return [OptSize] a new instance of OptSize
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4231
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4247
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4267
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4229
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4263
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4243
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4235
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4251
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4255
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4259
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4239
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_str_freeze` pushes a frozen known string value with no interpolation
# onto the stack using the #freeze method. If the method gets overridden,
# this will fall back to a send.
#
# ### Usage
#
# ~~~ruby
# "hello".freeze
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4284
class SyntaxTree::YARV::OptStrFreeze < ::SyntaxTree::YARV::Instruction
  # @return [OptStrFreeze] a new instance of OptStrFreeze
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4287
  def initialize(object, calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4307
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4320
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4285
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4303
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4292
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4312
  def length; end

  # Returns the value of attribute object.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4285
  def object; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4316
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4299
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_str_uminus` pushes a frozen known string value with no interpolation
# onto the stack. If the method gets overridden, this will fall back to a
# send.
#
# ### Usage
#
# ~~~ruby
# -"string"
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4337
class SyntaxTree::YARV::OptStrUMinus < ::SyntaxTree::YARV::Instruction
  # @return [OptStrUMinus] a new instance of OptStrUMinus
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4340
  def initialize(object, calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4360
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4373
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4338
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4356
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4345
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4365
  def length; end

  # Returns the value of attribute object.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4338
  def object; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4369
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4352
  def to_a(_iseq); end
end

# ### Summary
#
# `opt_succ` is a specialization of the `opt_send_without_block` instruction
# when the method being called is `succ`. Fast paths exist when the receiver
# is either a String or a Fixnum. It pops the receiver off the stack and
# pushes on the result.
#
# ### Usage
#
# ~~~ruby
# "".succ
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4391
class SyntaxTree::YARV::OptSucc < ::SyntaxTree::YARV::Instruction
  # @return [OptSucc] a new instance of OptSucc
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4394
  def initialize(calldata); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4410
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4430
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4392
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4426
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4406
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4398
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4414
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4418
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4422
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4402
  def to_a(_iseq); end
end

# ### Summary
#
# `pop` pops the top value off the stack.
#
# ### Usage
#
# ~~~ruby
# a ||= 2
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4445
class SyntaxTree::YARV::Pop < ::SyntaxTree::YARV::Instruction
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4458
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4466
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4454
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4446
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4462
  def pops; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4470
  def side_effects?; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4450
  def to_a(_iseq); end
end

# ### Summary
#
# `putnil` pushes a global nil object onto the stack.
#
# ### Usage
#
# ~~~ruby
# nil
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4485
class SyntaxTree::YARV::PutNil < ::SyntaxTree::YARV::Instruction
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4498
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4510
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4506
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4494
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4486
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4502
  def pushes; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4514
  def side_effects?; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4490
  def to_a(_iseq); end
end

# ### Summary
#
# `putobject` pushes a known value onto the stack.
#
# ### Usage
#
# ~~~ruby
# 5
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4529
class SyntaxTree::YARV::PutObject < ::SyntaxTree::YARV::Instruction
  # @return [PutObject] a new instance of PutObject
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4532
  def initialize(object); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4548
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4560
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4544
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4536
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4552
  def length; end

  # Returns the value of attribute object.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4530
  def object; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4556
  def pushes; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4564
  def side_effects?; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4540
  def to_a(_iseq); end
end

# ### Summary
#
# `putobject_INT2FIX_0_` pushes 0 on the stack. It is a specialized
# instruction resulting from the operand unification optimization. It is
# equivalent to `putobject 0`.
#
# ### Usage
#
# ~~~ruby
# 0
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4581
class SyntaxTree::YARV::PutObjectInt2Fix0 < ::SyntaxTree::YARV::Instruction
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4594
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4606
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4602
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4590
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4582
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4598
  def pushes; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4610
  def side_effects?; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4586
  def to_a(_iseq); end
end

# ### Summary
#
# `putobject_INT2FIX_1_` pushes 1 on the stack. It is a specialized
# instruction resulting from the operand unification optimization. It is
# equivalent to `putobject 1`.
#
# ### Usage
#
# ~~~ruby
# 1
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4627
class SyntaxTree::YARV::PutObjectInt2Fix1 < ::SyntaxTree::YARV::Instruction
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4640
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4652
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4648
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4636
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4628
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4644
  def pushes; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4656
  def side_effects?; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4632
  def to_a(_iseq); end
end

# ### Summary
#
# `putself` pushes the current value of self onto the stack.
#
# ### Usage
#
# ~~~ruby
# puts "Hello, world!"
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4671
class SyntaxTree::YARV::PutSelf < ::SyntaxTree::YARV::Instruction
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4684
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4692
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4680
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4672
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4688
  def pushes; end

  # @return [Boolean]
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4696
  def side_effects?; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4676
  def to_a(_iseq); end
end

# ### Summary
#
# `putspecialobject` pushes one of three special objects onto the stack.
# These are either the VM core special object, the class base special
# object, or the constant base special object.
#
# ### Usage
#
# ~~~ruby
# alias foo bar
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4713
class SyntaxTree::YARV::PutSpecialObject < ::SyntaxTree::YARV::Instruction
  # @return [PutSpecialObject] a new instance of PutSpecialObject
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4720
  def initialize(object); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4736
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4748
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4732
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4724
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4740
  def length; end

  # Returns the value of attribute object.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4718
  def object; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4744
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4728
  def to_a(_iseq); end
end

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4715
SyntaxTree::YARV::PutSpecialObject::OBJECT_CBASE = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4716
SyntaxTree::YARV::PutSpecialObject::OBJECT_CONST_BASE = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4714
SyntaxTree::YARV::PutSpecialObject::OBJECT_VMCORE = T.let(T.unsafe(nil), Integer)

# ### Summary
#
# `putstring` pushes an unfrozen string literal onto the stack.
#
# ### Usage
#
# ~~~ruby
# "foo"
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4772
class SyntaxTree::YARV::PutString < ::SyntaxTree::YARV::Instruction
  # @return [PutString] a new instance of PutString
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4775
  def initialize(object); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4791
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4803
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4787
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4779
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4795
  def length; end

  # Returns the value of attribute object.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4773
  def object; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4799
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4783
  def to_a(_iseq); end
end

# A sea of nodes is an intermediate representation used by a compiler to
# represent both control and data flow in the same graph. The way we use it
# allows us to have the vertices of the graph represent either an
# instruction in the instruction sequence or a synthesized node that we add
# to the graph. The edges of the graph represent either control flow or data
# flow.
#
# source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#11
class SyntaxTree::YARV::SeaOfNodes
  # @return [SeaOfNodes] a new instance of SeaOfNodes
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#462
  def initialize(dfg, nodes, local_graphs); end

  # Returns the value of attribute dfg.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#460
  def dfg; end

  # Returns the value of attribute local_graphs.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#460
  def local_graphs; end

  # Returns the value of attribute nodes.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#460
  def nodes; end

  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#468
  def to_mermaid; end

  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#499
  def verify; end

  class << self
    # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#529
    def compile(dfg); end
  end
end

# The compiler is responsible for taking a data flow graph and turning it
# into a sea of nodes.
#
# source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#100
class SyntaxTree::YARV::SeaOfNodes::Compiler
  # @return [Compiler] a new instance of Compiler
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#103
  def initialize(dfg); end

  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#113
  def compile; end

  # Returns the value of attribute dfg.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#101
  def dfg; end

  # Returns the value of attribute nodes.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#101
  def nodes; end

  private

  # Eliminate as many unnecessary nodes as we can.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#339
  def cleanup_insn_nodes; end

  # We don't always build things in an optimal way. Go back and fix up
  # some mess we left. Ideally we wouldn't create these problems in the
  # first place.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#315
  def cleanup_phi_nodes; end

  # Connect one node to another.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#423
  def connect(from, to, type, label = T.unsafe(nil)); end

  # Connect control flow that flows between basic blocks.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#246
  def connect_local_graphs_control(local_graphs); end

  # Connect data flow that flows between basic blocks.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#271
  def connect_local_graphs_data(local_graphs); end

  # Connect all of the inputs to all of the outputs of a node.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#433
  def connect_over(node); end

  # Create a sub-graph for a single basic block - block block argument
  # inputs and outputs will be left dangling, to be connected later.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#136
  def create_local_graph(block); end

  # Counter for synthetic nodes.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#130
  def id_counter; end

  # Remove a node from the graph.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#447
  def remove(node); end
end

# The edge of a graph represents either control flow or data flow.
#
# source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#67
class SyntaxTree::YARV::SeaOfNodes::Edge
  # @return [Edge] a new instance of Edge
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#75
  def initialize(from, to, type, label); end

  # Returns the value of attribute from.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#70
  def from; end

  # Returns the value of attribute label.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#73
  def label; end

  # Returns the value of attribute to.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#71
  def to; end

  # Returns the value of attribute type.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#72
  def type; end
end

# source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#68
SyntaxTree::YARV::SeaOfNodes::Edge::TYPES = T.let(T.unsafe(nil), Array)

# This object represents a node in the graph that holds a YARV
# instruction.
#
# source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#14
class SyntaxTree::YARV::SeaOfNodes::InsnNode
  # @return [InsnNode] a new instance of InsnNode
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#17
  def initialize(insn, offset); end

  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#25
  def id; end

  # Returns the value of attribute inputs.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#15
  def inputs; end

  # Returns the value of attribute insn.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#15
  def insn; end

  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#29
  def label; end

  # Returns the value of attribute offset.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#15
  def offset; end

  # Returns the value of attribute outputs.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#15
  def outputs; end
end

# Merge nodes are present in any block that has multiple incoming blocks.
# It provides a place for Phi nodes to attach their results.
#
# source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#52
class SyntaxTree::YARV::SeaOfNodes::MergeNode
  # @return [MergeNode] a new instance of MergeNode
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#55
  def initialize(id); end

  # Returns the value of attribute id.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#53
  def id; end

  # Returns the value of attribute inputs.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#53
  def inputs; end

  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#61
  def label; end

  # Returns the value of attribute outputs.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#53
  def outputs; end
end

# Phi nodes are used to represent the merging of data flow from multiple
# incoming blocks.
#
# source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#36
class SyntaxTree::YARV::SeaOfNodes::PhiNode
  # @return [PhiNode] a new instance of PhiNode
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#39
  def initialize(id); end

  # Returns the value of attribute id.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#37
  def id; end

  # Returns the value of attribute inputs.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#37
  def inputs; end

  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#45
  def label; end

  # Returns the value of attribute outputs.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#37
  def outputs; end
end

# A subgraph represents the local data and control flow of a single basic
# block.
#
# source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#87
class SyntaxTree::YARV::SeaOfNodes::SubGraph
  # @return [SubGraph] a new instance of SubGraph
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#90
  def initialize(first_fixed, last_fixed, inputs, outputs); end

  # Returns the value of attribute first_fixed.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#88
  def first_fixed; end

  # Returns the value of attribute inputs.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#88
  def inputs; end

  # Returns the value of attribute last_fixed.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#88
  def last_fixed; end

  # Returns the value of attribute outputs.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/sea_of_nodes.rb#88
  def outputs; end
end

# ### Summary
#
# `send` invokes a method with an optional block. It pops its receiver and
# the arguments for the method off the stack and pushes the return value
# onto the stack. It has two arguments: the calldata for the call site and
# the optional block instruction sequence.
#
# ### Usage
#
# ~~~ruby
# "hello".tap { |i| p i }
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4821
class SyntaxTree::YARV::Send < ::SyntaxTree::YARV::Instruction
  # @return [Send] a new instance of Send
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4824
  def initialize(calldata, block_iseq); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4845
  def ==(other); end

  # Returns the value of attribute block_iseq.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4822
  def block_iseq; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4863
  def call(vm); end

  # Returns the value of attribute calldata.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4822
  def calldata; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4841
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4829
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4850
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4854
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4859
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4837
  def to_a(_iseq); end
end

# ### Summary
#
# `setblockparam` sets the value of a block local variable on a frame
# determined by the level and index arguments. The level is the number of
# frames back to look and the index is the index in the local table. It pops
# the value it is setting off the stack.
#
# ### Usage
#
# ~~~ruby
# def foo(&bar)
#   bar = baz
# end
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4905
class SyntaxTree::YARV::SetBlockParam < ::SyntaxTree::YARV::Instruction
  # @return [SetBlockParam] a new instance of SetBlockParam
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4908
  def initialize(index, level); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4927
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4940
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4923
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4913
  def disasm(fmt); end

  # Returns the value of attribute index.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4906
  def index; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4932
  def length; end

  # Returns the value of attribute level.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4906
  def level; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4936
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4917
  def to_a(iseq); end
end

# ### Summary
#
# `setclassvariable` looks for a class variable in the current class and
# sets its value to the value it pops off the top of the stack. It uses an
# inline cache to reduce the need to lookup the class variable in the class
# hierarchy every time.
#
# ### Usage
#
# ~~~ruby
# @@class_variable = 1
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4958
class SyntaxTree::YARV::SetClassVariable < ::SyntaxTree::YARV::Instruction
  # @return [SetClassVariable] a new instance of SetClassVariable
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4961
  def initialize(name, cache); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4981
  def ==(other); end

  # Returns the value of attribute cache.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4959
  def cache; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4994
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4977
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4966
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4986
  def length; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4959
  def name; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4990
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#4973
  def to_a(_iseq); end
end

# ### Summary
#
# `setconstant` pops two values off the stack: the value to set the
# constant to and the constant base to set it in.
#
# ### Usage
#
# ~~~ruby
# Constant = 1
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5012
class SyntaxTree::YARV::SetConstant < ::SyntaxTree::YARV::Instruction
  # @return [SetConstant] a new instance of SetConstant
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5015
  def initialize(name); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5031
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5043
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5027
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5019
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5035
  def length; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5013
  def name; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5039
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5023
  def to_a(_iseq); end
end

# ### Summary
#
# `setglobal` sets the value of a global variable to a value popped off the
# top of the stack.
#
# ### Usage
#
# ~~~ruby
# $global = 5
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5060
class SyntaxTree::YARV::SetGlobal < ::SyntaxTree::YARV::Instruction
  # @return [SetGlobal] a new instance of SetGlobal
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5063
  def initialize(name); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5079
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5091
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5075
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5067
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5083
  def length; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5061
  def name; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5087
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5071
  def to_a(_iseq); end
end

# ### Summary
#
# `setinstancevariable` pops a value off the top of the stack and then sets
# the instance variable associated with the instruction to that value.
#
# This instruction has two forms, but both have the same structure. Before
# Ruby 3.2, the inline cache corresponded to both the get and set
# instructions and could be shared. Since Ruby 3.2, it uses object shapes
# instead so the caches are unique per instruction.
#
# ### Usage
#
# ~~~ruby
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5114
class SyntaxTree::YARV::SetInstanceVariable < ::SyntaxTree::YARV::Instruction
  # @return [SetInstanceVariable] a new instance of SetInstanceVariable
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5117
  def initialize(name, cache); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5137
  def ==(other); end

  # Returns the value of attribute cache.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5115
  def cache; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5150
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5133
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5122
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5142
  def length; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5115
  def name; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5146
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5129
  def to_a(_iseq); end
end

# ### Summary
#
# `setlocal` sets the value of a local variable on a frame determined by the
# level and index arguments. The level is the number of frames back to
# look and the index is the index in the local table. It pops the value it
# is setting off the stack.
#
# ### Usage
#
# ~~~ruby
# value = 5
# tap { tap { value = 10 } }
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5170
class SyntaxTree::YARV::SetLocal < ::SyntaxTree::YARV::Instruction
  # @return [SetLocal] a new instance of SetLocal
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5173
  def initialize(index, level); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5192
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5204
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5188
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5178
  def disasm(fmt); end

  # Returns the value of attribute index.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5171
  def index; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5196
  def length; end

  # Returns the value of attribute level.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5171
  def level; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5200
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5182
  def to_a(iseq); end
end

# ### Summary
#
# `setlocal_WC_0` is a specialized version of the `setlocal` instruction. It
# sets the value of a local variable on the current frame to the value at
# the top of the stack as determined by the index given as its only
# argument.
#
# ### Usage
#
# ~~~ruby
# value = 5
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5222
class SyntaxTree::YARV::SetLocalWC0 < ::SyntaxTree::YARV::Instruction
  # @return [SetLocalWC0] a new instance of SetLocalWC0
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5225
  def initialize(index); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5241
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5257
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5253
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5237
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5229
  def disasm(fmt); end

  # Returns the value of attribute index.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5223
  def index; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5245
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5249
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5233
  def to_a(iseq); end
end

# ### Summary
#
# `setlocal_WC_1` is a specialized version of the `setlocal` instruction. It
# sets the value of a local variable on the parent frame to the value at the
# top of the stack as determined by the index given as its only argument.
#
# ### Usage
#
# ~~~ruby
# value = 5
# self.then { value = 10 }
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5275
class SyntaxTree::YARV::SetLocalWC1 < ::SyntaxTree::YARV::Instruction
  # @return [SetLocalWC1] a new instance of SetLocalWC1
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5278
  def initialize(index); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5294
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5310
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5306
  def canonical; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5290
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5282
  def disasm(fmt); end

  # Returns the value of attribute index.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5276
  def index; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5298
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5302
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5286
  def to_a(iseq); end
end

# ### Summary
#
# `setn` sets a value in the stack to a value popped off the top of the
# stack. It then pushes that value onto the top of the stack as well.
#
# ### Usage
#
# ~~~ruby
# {}[:key] = 'val'
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5326
class SyntaxTree::YARV::SetN < ::SyntaxTree::YARV::Instruction
  # @return [SetN] a new instance of SetN
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5329
  def initialize(number); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5345
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5361
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5341
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5333
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5349
  def length; end

  # Returns the value of attribute number.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5327
  def number; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5353
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5357
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5337
  def to_a(_iseq); end
end

# ### Summary
#
# `setspecial` pops a value off the top of the stack and sets a special
# local variable to that value. The special local variable is determined by
# the key given as its only argument.
#
# ### Usage
#
# ~~~ruby
# baz if (foo == 1) .. (bar == 1)
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5378
class SyntaxTree::YARV::SetSpecial < ::SyntaxTree::YARV::Instruction
  # @return [SetSpecial] a new instance of SetSpecial
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5381
  def initialize(key); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5397
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5409
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5393
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5385
  def disasm(fmt); end

  # Returns the value of attribute key.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5379
  def key; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5401
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5405
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5389
  def to_a(_iseq); end
end

# ### Summary
#
# `splatarray` coerces the array object at the top of the stack into Array
# by calling `to_a`. It pushes a duplicate of the array if there is a flag,
# and the original array if there isn't one.
#
# ### Usage
#
# ~~~ruby
# x = *(5)
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5433
class SyntaxTree::YARV::SplatArray < ::SyntaxTree::YARV::Instruction
  # @return [SplatArray] a new instance of SplatArray
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5436
  def initialize(flag); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5452
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5468
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5448
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5440
  def disasm(fmt); end

  # Returns the value of attribute flag.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5434
  def flag; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5456
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5460
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5464
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5444
  def to_a(_iseq); end
end

# ### Summary
#
# `swap` swaps the top two elements in the stack.
#
# ### TracePoint
#
# `swap` does not dispatch any events.
#
# ### Usage
#
# ~~~ruby
# !!defined?([[]])
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5507
class SyntaxTree::YARV::Swap < ::SyntaxTree::YARV::Instruction
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5520
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5532
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5516
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5508
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5524
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5528
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5512
  def to_a(_iseq); end
end

# ### Summary
#
# `throw` pops a value off the top of the stack and throws it. It is caught
# using the instruction sequence's (or an ancestor's) catch table. It pushes
# on the result of throwing the value.
#
# ### Usage
#
# ~~~ruby
# [1, 2, 3].map { break 2 }
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5550
class SyntaxTree::YARV::Throw < ::SyntaxTree::YARV::Instruction
  # @return [Throw] a new instance of Throw
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5566
  def initialize(type); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5582
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5598
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5578
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5570
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5586
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5590
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5594
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5574
  def to_a(_iseq); end

  # Returns the value of attribute type.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5564
  def type; end

  private

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5625
  def error_backtrace(vm); end
end

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5553
SyntaxTree::YARV::Throw::RUBY_TAG_BREAK = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5559
SyntaxTree::YARV::Throw::RUBY_TAG_FATAL = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5554
SyntaxTree::YARV::Throw::RUBY_TAG_NEXT = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5551
SyntaxTree::YARV::Throw::RUBY_TAG_NONE = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5557
SyntaxTree::YARV::Throw::RUBY_TAG_RAISE = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5556
SyntaxTree::YARV::Throw::RUBY_TAG_REDO = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5555
SyntaxTree::YARV::Throw::RUBY_TAG_RETRY = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5552
SyntaxTree::YARV::Throw::RUBY_TAG_RETURN = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5558
SyntaxTree::YARV::Throw::RUBY_TAG_THROW = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5561
SyntaxTree::YARV::Throw::VM_THROW_NO_ESCAPE_FLAG = T.let(T.unsafe(nil), Integer)

# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5562
SyntaxTree::YARV::Throw::VM_THROW_STATE_MASK = T.let(T.unsafe(nil), Integer)

# ### Summary
#
# `toregexp` pops a number of values off the stack, combines them into a new
# regular expression, and pushes the new regular expression onto the stack.
#
# ### Usage
#
# ~~~ruby
# /foo #{bar}/
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5700
class SyntaxTree::YARV::ToRegExp < ::SyntaxTree::YARV::Instruction
  # @return [ToRegExp] a new instance of ToRegExp
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5703
  def initialize(options, length); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5720
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5733
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5716
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5708
  def disasm(fmt); end

  # Returns the value of attribute length.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5701
  def length; end

  # Returns the value of attribute options.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5701
  def options; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5725
  def pops; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5729
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5712
  def to_a(_iseq); end
end

# ### Summary
#
# `topn` pushes a single value onto the stack that is a copy of the value
# within the stack that is `number` of slots down from the top.
#
# ### Usage
#
# ~~~ruby
# case 3
# when 1..5
#   puts "foo"
# end
# ~~~
#
# source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5653
class SyntaxTree::YARV::TopN < ::SyntaxTree::YARV::Instruction
  # @return [TopN] a new instance of TopN
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5656
  def initialize(number); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5672
  def ==(other); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5684
  def call(vm); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5668
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5660
  def disasm(fmt); end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5676
  def length; end

  # Returns the value of attribute number.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5654
  def number; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5680
  def pushes; end

  # source://syntax_tree//lib/syntax_tree/yarv/instructions.rb#5664
  def to_a(_iseq); end
end

# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#8
class SyntaxTree::YARV::VM
  extend ::Forwardable

  # @return [VM] a new instance of VM
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#216
  def initialize(events = T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#623
  def catch(tag, &block); end

  # Helper methods for instructions
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#494
  def const_base; end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#610
  def eval(source, binding = T.unsafe(nil), filename = T.unsafe(nil), lineno = T.unsafe(nil)); end

  # Returns the value of attribute events.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#209
  def events; end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#344
  def find_catch_entry(frame, type); end

  # Returns the value of attribute frame.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#214
  def frame; end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#498
  def frame_at(level); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#504
  def frame_svar; end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#510
  def frame_yield; end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#516
  def frozen_core; end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#520
  def jump(label); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#524
  def leave; end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#606
  def load(filepath); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#528
  def local_get(index, level); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#532
  def local_set(index, level, value); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def pop(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def push(*args, **_arg1, &block); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#598
  def require(filepath); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#549
  def require_internal(filepath, loading: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#602
  def require_relative(filepath); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#543
  def require_resolved(filepath); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#360
  def run_block_frame(iseq, frame, *args, **kwargs, &block); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#366
  def run_class_frame(iseq, clazz); end

  # Helper methods for frames
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#230
  def run_frame(frame); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#370
  def run_method_frame(name, nesting, iseq, _self, *args, **kwargs, &block); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#384
  def run_rescue_frame(iseq, frame, error); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#356
  def run_top_frame(iseq); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#391
  def setup_arguments(iseq, args, kwargs, block); end

  # Returns the value of attribute stack.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#211
  def stack; end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#619
  def throw(tag, value = T.unsafe(nil)); end

  class << self
    # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#222
    def run(iseq); end
  end
end

# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#48
class SyntaxTree::YARV::VM::BlockFrame < ::SyntaxTree::YARV::VM::Frame
  # @return [BlockFrame] a new instance of BlockFrame
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#49
  def initialize(iseq, parent, stack_index); end
end

# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#89
class SyntaxTree::YARV::VM::BreakError < ::SyntaxTree::YARV::VM::ThrownError; end

# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#64
class SyntaxTree::YARV::VM::ClassFrame < ::SyntaxTree::YARV::VM::Frame
  # @return [ClassFrame] a new instance of ClassFrame
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#65
  def initialize(iseq, parent, stack_index, _self); end
end

# Methods for overriding runtime behavior
#
# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#540
SyntaxTree::YARV::VM::DLEXT = T.let(T.unsafe(nil), String)

# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#205
SyntaxTree::YARV::VM::FROZEN_CORE = T.let(T.unsafe(nil), SyntaxTree::YARV::VM::FrozenCore)

# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#25
class SyntaxTree::YARV::VM::Frame
  # @return [Frame] a new instance of Frame
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#29
  def initialize(iseq, parent, stack_index, _self, nesting); end

  # Returns the value of attribute _self.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#26
  def _self; end

  # Returns the value of attribute iseq.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#26
  def iseq; end

  # Returns the value of attribute line.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#27
  def line; end

  # Sets the attribute line
  #
  # @param value the value to set the attribute line to.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#27
  def line=(_arg0); end

  # Returns the value of attribute nesting.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#26
  def nesting; end

  # Returns the value of attribute parent.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#26
  def parent; end

  # Returns the value of attribute pc.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#27
  def pc; end

  # Sets the attribute pc
  #
  # @param value the value to set the attribute pc to.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#27
  def pc=(_arg0); end

  # Returns the value of attribute stack_index.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#26
  def stack_index; end

  # Returns the value of attribute svars.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#26
  def svars; end
end

# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#95
class SyntaxTree::YARV::VM::FrozenCore; end

# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#9
class SyntaxTree::YARV::VM::Jump
  # @return [Jump] a new instance of Jump
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#12
  def initialize(label); end

  # Returns the value of attribute label.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#10
  def label; end
end

# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#17
class SyntaxTree::YARV::VM::Leave
  # @return [Leave] a new instance of Leave
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#20
  def initialize(value); end

  # Returns the value of attribute value.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#18
  def value; end
end

# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#54
class SyntaxTree::YARV::VM::MethodFrame < ::SyntaxTree::YARV::VM::Frame
  # @return [MethodFrame] a new instance of MethodFrame
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#57
  def initialize(iseq, nesting, parent, stack_index, _self, name, block); end

  # Returns the value of attribute block.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#55
  def block; end

  # Returns the value of attribute name.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#55
  def name; end
end

# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#92
class SyntaxTree::YARV::VM::NextError < ::SyntaxTree::YARV::VM::ThrownError; end

# This is the main entrypoint for events firing in the VM, which allows
# us to implement tracing.
#
# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#122
class SyntaxTree::YARV::VM::NullEvents
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#123
  def publish_frame_change(frame); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#126
  def publish_instruction(iseq, insn); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#129
  def publish_stack_change(stack); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#132
  def publish_tracepoint(event); end
end

# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#70
class SyntaxTree::YARV::VM::RescueFrame < ::SyntaxTree::YARV::VM::Frame
  # @return [RescueFrame] a new instance of RescueFrame
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#71
  def initialize(iseq, parent, stack_index); end
end

# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#86
class SyntaxTree::YARV::VM::ReturnError < ::SyntaxTree::YARV::VM::ThrownError; end

# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#541
SyntaxTree::YARV::VM::SOEXT = T.let(T.unsafe(nil), String)

# This is a simple implementation of tracing that prints to STDOUT.
#
# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#137
class SyntaxTree::YARV::VM::STDOUTEvents
  # @return [STDOUTEvents] a new instance of STDOUTEvents
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#140
  def initialize; end

  # Returns the value of attribute disassembler.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#138
  def disassembler; end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#144
  def publish_frame_change(frame); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#148
  def publish_instruction(iseq, insn); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#153
  def publish_stack_change(stack); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#157
  def publish_tracepoint(event); end
end

# This represents the global VM stack. It effectively is an array, but
# wraps mutating functions with instrumentation.
#
# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#164
class SyntaxTree::YARV::VM::Stack
  # @return [Stack] a new instance of Stack
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#167
  def initialize(events); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#196
  def [](*_arg0, **_arg1, &_arg2); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#200
  def []=(*_arg0, **_arg1, &_arg2); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#172
  def concat(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute events.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#165
  def events; end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#176
  def last; end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#180
  def length; end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#188
  def pop(*_arg0, **_arg1, &_arg2); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#184
  def push(*_arg0, **_arg1, &_arg2); end

  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#192
  def slice!(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute values.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#165
  def values; end
end

# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#76
class SyntaxTree::YARV::VM::ThrownError < ::StandardError
  # @return [ThrownError] a new instance of ThrownError
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#79
  def initialize(value, backtrace); end

  # Returns the value of attribute value.
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#77
  def value; end
end

# source://syntax_tree//lib/syntax_tree/yarv/vm.rb#42
class SyntaxTree::YARV::VM::TopFrame < ::SyntaxTree::YARV::VM::Frame
  # @return [TopFrame] a new instance of TopFrame
  #
  # source://syntax_tree//lib/syntax_tree/yarv/vm.rb#43
  def initialize(iseq); end
end

# Yield represents using the +yield+ keyword with arguments.
#
#     yield value
#
# source://syntax_tree//lib/syntax_tree/node.rb#12274
class SyntaxTree::YieldNode < ::SyntaxTree::Node
  # @return [YieldNode] a new instance of YieldNode
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12280
  def initialize(arguments:, location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12334
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12286
  def accept(visitor); end

  # [nil | Args | Paren] the arguments passed to the yield
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12275
  def arguments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#12290
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12278
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#12294
  def copy(arguments: T.unsafe(nil), location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12290
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#12307
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12311
  def format(q); end
end

# ZSuper represents the bare +super+ keyword with no arguments.
#
#     super
#
# source://syntax_tree//lib/syntax_tree/node.rb#12344
class SyntaxTree::ZSuper < ::SyntaxTree::Node
  # @return [ZSuper] a new instance of ZSuper
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12347
  def initialize(location:); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12377
  def ===(other); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12352
  def accept(visitor); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12356
  def child_nodes; end

  # [Array[ Comment | EmbDoc ]] the comments attached to this node
  #
  # source://syntax_tree//lib/syntax_tree/node.rb#12345
  def comments; end

  # source://syntax_tree//lib/syntax_tree/node.rb#12360
  def copy(location: T.unsafe(nil)); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12356
  def deconstruct; end

  # source://syntax_tree//lib/syntax_tree/node.rb#12369
  def deconstruct_keys(_keys); end

  # source://syntax_tree//lib/syntax_tree/node.rb#12373
  def format(q); end
end
