# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `warning` gem.
# Please instead update this file by running `bin/tapioca gem warning`.

# source://warning//lib/warning.rb#3
module Warning
  extend ::Warning
  extend ::Warning::Processor
end

# source://warning//lib/warning.rb#4
module Warning::Processor
  # Clear all current ignored warnings, warning processors, and duplicate check cache.
  # Also disables deduplicating warnings if that is currently enabled.
  #
  # If a block is passed, the previous values are restored after the block exits.
  #
  # Examples:
  #
  #   # Clear warning state
  #   Warning.clear
  #
  #   Warning.clear do
  #     # Clear warning state inside the block
  #     ...
  #   end
  #   # Previous warning state restored when block exists
  #
  # source://warning//lib/warning.rb#48
  def clear; end

  # Deduplicate warnings, suppress warning messages if the same warning message
  # has already occurred.  Note that this can lead to unbounded memory use
  # if unique warnings are generated.
  #
  # source://warning//lib/warning.rb#79
  def dedup; end

  # source://warning//lib/warning.rb#83
  def freeze; end

  # Ignore any warning messages matching the given regexp, if they
  # start with the given path.
  # The regexp can also be one of the following symbols (or an array including them), which will
  # use an appropriate regexp for the given warning:
  #
  # :arg_prefix :: Ignore warnings when using * or & as an argument prefix
  # :ambiguous_slash :: Ignore warnings for things like <tt>method /regexp/</tt>
  # :bignum :: Ignore warnings when referencing the ::Bignum constant.
  # :fixnum :: Ignore warnings when referencing the ::Fixnum constant.
  # :keyword_separation :: Ignore warnings related to keyword argument separation.
  # :method_redefined :: Ignore warnings when defining a method in a class/module where a
  #                      method of the same name was already defined in that class/module.
  # :missing_gvar :: Ignore warnings for accesses to global variables
  #                  that have not yet been initialized
  # :missing_ivar :: Ignore warnings for accesses to instance variables
  #                  that have not yet been initialized
  # :not_reached :: Ignore statement not reached warnings.
  # :safe :: Ignore warnings related to $SAFE and related C-API functions.
  # :shadow :: Ignore warnings related to shadowing outer local variables.
  # :taint :: Ignore warnings related to taint and related methods and C-API functions.
  # :unused_var :: Ignore warnings for unused variables.
  # :useless_operator :: Ignore warnings when using operators such as == and > when the
  #                      result is not used.
  # :void_context :: Ignore warnings for :: to reference constants when the result is not
  #                  used (often used to trigger autoload).
  #
  # Examples:
  #
  #   # Ignore all uninitialized instance variable warnings
  #   Warning.ignore(/instance variable @\w+ not initialized/)
  #
  #   # Ignore all uninitialized instance variable warnings in current file
  #   Warning.ignore(/instance variable @\w+ not initialized/, __FILE__)
  #
  #   # Ignore all uninitialized instance variable warnings in current file
  #   Warning.ignore(:missing_ivar, __FILE__)
  #
  #   # Ignore all uninitialized instance variable and method redefined warnings in current file
  #   Warning.ignore([:missing_ivar, :method_redefined],  __FILE__)
  #
  # source://warning//lib/warning.rb#128
  def ignore(regexp, path = T.unsafe(nil)); end

  # Handle all warnings starting with the given path, instead of
  # the default behavior of printing them to $stderr. Examples:
  #
  #   # Write warning to LOGGER at level warning
  #   Warning.process do |warning|
  #     LOGGER.warning(warning)
  #   end
  #
  #   # Write warnings in the current file to LOGGER at level error level
  #   Warning.process(__FILE__) do |warning|
  #     LOGGER.error(warning)
  #   end
  #
  # The block can return one of the following symbols:
  #
  # :default :: Take the default action (call super, printing to $stderr).
  # :backtrace :: Take the default action (call super, printing to $stderr),
  #               and also print the backtrace.
  # :raise :: Raise a RuntimeError with the warning as the message.
  #
  # If the block returns anything else, it is assumed the block completely handled
  # the warning and takes no other action.
  #
  # Instead of passing a block, you can pass a hash of actions to take for specific
  # warnings, using regexp as keys and a callable objects as values:
  #
  #   Warning.process(__FILE__,
  #     /instance variable @\w+ not initialized/ => proc do |warning|
  #       LOGGER.warning(warning)
  #     end,
  #     /global variable `\$\w+' not initialized/ => proc do |warning|
  #       LOGGER.error(warning)
  #     end
  #   )
  #
  # Instead of passing a regexp as a key, you can pass a symbol that is recognized
  # by Warning.ignore.  Instead of passing a callable object as a value, you can
  # pass a symbol, which will be treated as a callable object that returns that symbol:
  #
  #   Warning.process(__FILE__, :missing_ivar=>:backtrace, :keyword_separation=>:raise)
  #
  # source://warning//lib/warning.rb#179
  def process(path = T.unsafe(nil), actions = T.unsafe(nil), &block); end

  # source://warning//lib/warning.rb#220
  def warn(str, category: T.unsafe(nil)); end

  private

  # Convert the given Regexp, Symbol, or Array of Symbols into a Regexp.
  #
  # source://warning//lib/warning.rb#272
  def convert_regexp(regexp); end

  # source://warning//lib/warning.rb#285
  def synchronize(&block); end
end

# Map of action symbols to procs that return the symbol
#
# source://warning//lib/warning.rb#26
Warning::Processor::ACTION_PROC_MAP = T.let(T.unsafe(nil), Hash)

# Map of symbols to regexps for warning messages to ignore.
#
# source://warning//lib/warning.rb#6
Warning::Processor::IGNORE_MAP = T.let(T.unsafe(nil), Hash)
