# frozen_string_literal: true
# typed: false

# DO NOT EDIT. This file is autogenerated. To regenerate, run:
#
#     bazel test //gems/sorbet-runtime:update_call_validation

module T::Private::Methods::CallValidation
  def self.create_validator_method_fast(mod, original_method, method_sig, original_visibility)
    if method_sig.return_type.is_a?(T::Private::Types::Void)
      raise 'Should have used create_validator_procedure_fast'
    end
    # trampoline to reduce stack frame size
    arg_types = method_sig.arg_types
    case arg_types.length
    when 0
      create_validator_method_fast0(mod, original_method, method_sig, original_visibility, method_sig.return_type.raw_type)
    when 1
      create_validator_method_fast1(mod, original_method, method_sig, original_visibility, method_sig.return_type.raw_type,
                                    arg_types[0][1].raw_type)
    when 2
      create_validator_method_fast2(mod, original_method, method_sig, original_visibility, method_sig.return_type.raw_type,
                                    arg_types[0][1].raw_type,
                                    arg_types[1][1].raw_type)
    when 3
      create_validator_method_fast3(mod, original_method, method_sig, original_visibility, method_sig.return_type.raw_type,
                                    arg_types[0][1].raw_type,
                                    arg_types[1][1].raw_type,
                                    arg_types[2][1].raw_type)
    when 4
      create_validator_method_fast4(mod, original_method, method_sig, original_visibility, method_sig.return_type.raw_type,
                                    arg_types[0][1].raw_type,
                                    arg_types[1][1].raw_type,
                                    arg_types[2][1].raw_type,
                                    arg_types[3][1].raw_type)
    else
      raise 'should not happen'
    end
  end

  def self.create_validator_method_fast0(mod, original_method, method_sig, original_visibility, return_type)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |&blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      return_value = original_method.bind(self).call(&blk)
      unless return_value.is_a?(return_type)
        message = method_sig.return_type.error_message_for_obj(return_value)
        if message
          CallValidation.report_error(
            method_sig,
            message,
            'Return value',
            nil,
            method_sig.return_type,
            return_value,
            caller_offset: -1
          )
        end
      end
      return_value
    end
  end

  def self.create_validator_method_fast1(mod, original_method, method_sig, original_visibility, return_type, arg0_type)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |arg0, &blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      unless arg0.is_a?(arg0_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[0][1].error_message_for_obj(arg0),
          'Parameter',
          method_sig.arg_types[0][0],
          arg0_type,
          arg0,
          caller_offset: -1
        )
      end

      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      return_value = original_method.bind(self).call(arg0, &blk)
      unless return_value.is_a?(return_type)
        message = method_sig.return_type.error_message_for_obj(return_value)
        if message
          CallValidation.report_error(
            method_sig,
            message,
            'Return value',
            nil,
            method_sig.return_type,
            return_value,
            caller_offset: -1
          )
        end
      end
      return_value
    end
  end

  def self.create_validator_method_fast2(mod, original_method, method_sig, original_visibility, return_type, arg0_type, arg1_type)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |arg0, arg1, &blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      unless arg0.is_a?(arg0_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[0][1].error_message_for_obj(arg0),
          'Parameter',
          method_sig.arg_types[0][0],
          arg0_type,
          arg0,
          caller_offset: -1
        )
      end

      unless arg1.is_a?(arg1_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[1][1].error_message_for_obj(arg1),
          'Parameter',
          method_sig.arg_types[1][0],
          arg1_type,
          arg1,
          caller_offset: -1
        )
      end

      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      return_value = original_method.bind(self).call(arg0, arg1, &blk)
      unless return_value.is_a?(return_type)
        message = method_sig.return_type.error_message_for_obj(return_value)
        if message
          CallValidation.report_error(
            method_sig,
            message,
            'Return value',
            nil,
            method_sig.return_type,
            return_value,
            caller_offset: -1
          )
        end
      end
      return_value
    end
  end

  def self.create_validator_method_fast3(mod, original_method, method_sig, original_visibility, return_type, arg0_type, arg1_type, arg2_type)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |arg0, arg1, arg2, &blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      unless arg0.is_a?(arg0_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[0][1].error_message_for_obj(arg0),
          'Parameter',
          method_sig.arg_types[0][0],
          arg0_type,
          arg0,
          caller_offset: -1
        )
      end

      unless arg1.is_a?(arg1_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[1][1].error_message_for_obj(arg1),
          'Parameter',
          method_sig.arg_types[1][0],
          arg1_type,
          arg1,
          caller_offset: -1
        )
      end

      unless arg2.is_a?(arg2_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[2][1].error_message_for_obj(arg2),
          'Parameter',
          method_sig.arg_types[2][0],
          arg2_type,
          arg2,
          caller_offset: -1
        )
      end

      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      return_value = original_method.bind(self).call(arg0, arg1, arg2, &blk)
      unless return_value.is_a?(return_type)
        message = method_sig.return_type.error_message_for_obj(return_value)
        if message
          CallValidation.report_error(
            method_sig,
            message,
            'Return value',
            nil,
            method_sig.return_type,
            return_value,
            caller_offset: -1
          )
        end
      end
      return_value
    end
  end

  def self.create_validator_method_fast4(mod, original_method, method_sig, original_visibility, return_type, arg0_type, arg1_type, arg2_type, arg3_type)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |arg0, arg1, arg2, arg3, &blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      unless arg0.is_a?(arg0_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[0][1].error_message_for_obj(arg0),
          'Parameter',
          method_sig.arg_types[0][0],
          arg0_type,
          arg0,
          caller_offset: -1
        )
      end

      unless arg1.is_a?(arg1_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[1][1].error_message_for_obj(arg1),
          'Parameter',
          method_sig.arg_types[1][0],
          arg1_type,
          arg1,
          caller_offset: -1
        )
      end

      unless arg2.is_a?(arg2_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[2][1].error_message_for_obj(arg2),
          'Parameter',
          method_sig.arg_types[2][0],
          arg2_type,
          arg2,
          caller_offset: -1
        )
      end

      unless arg3.is_a?(arg3_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[3][1].error_message_for_obj(arg3),
          'Parameter',
          method_sig.arg_types[3][0],
          arg3_type,
          arg3,
          caller_offset: -1
        )
      end

      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      return_value = original_method.bind(self).call(arg0, arg1, arg2, arg3, &blk)
      unless return_value.is_a?(return_type)
        message = method_sig.return_type.error_message_for_obj(return_value)
        if message
          CallValidation.report_error(
            method_sig,
            message,
            'Return value',
            nil,
            method_sig.return_type,
            return_value,
            caller_offset: -1
          )
        end
      end
      return_value
    end
  end

  def self.create_validator_procedure_fast(mod, original_method, method_sig, original_visibility)
    # trampoline to reduce stack frame size
    arg_types = method_sig.arg_types
    case arg_types.length
    when 0
      create_validator_procedure_fast0(mod, original_method, method_sig, original_visibility)
    when 1
      create_validator_procedure_fast1(mod, original_method, method_sig, original_visibility,
                                    arg_types[0][1].raw_type)
    when 2
      create_validator_procedure_fast2(mod, original_method, method_sig, original_visibility,
                                    arg_types[0][1].raw_type,
                                    arg_types[1][1].raw_type)
    when 3
      create_validator_procedure_fast3(mod, original_method, method_sig, original_visibility,
                                    arg_types[0][1].raw_type,
                                    arg_types[1][1].raw_type,
                                    arg_types[2][1].raw_type)
    when 4
      create_validator_procedure_fast4(mod, original_method, method_sig, original_visibility,
                                    arg_types[0][1].raw_type,
                                    arg_types[1][1].raw_type,
                                    arg_types[2][1].raw_type,
                                    arg_types[3][1].raw_type)
    else
      raise 'should not happen'
    end
  end

  def self.create_validator_procedure_fast0(mod, original_method, method_sig, original_visibility)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |&blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      original_method.bind(self).call(&blk)
      T::Private::Types::Void::VOID
    end
  end

  def self.create_validator_procedure_fast1(mod, original_method, method_sig, original_visibility, arg0_type)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |arg0, &blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      unless arg0.is_a?(arg0_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[0][1].error_message_for_obj(arg0),
          'Parameter',
          method_sig.arg_types[0][0],
          arg0_type,
          arg0,
          caller_offset: -1
        )
      end

      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      original_method.bind(self).call(arg0, &blk)
      T::Private::Types::Void::VOID
    end
  end

  def self.create_validator_procedure_fast2(mod, original_method, method_sig, original_visibility, arg0_type, arg1_type)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |arg0, arg1, &blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      unless arg0.is_a?(arg0_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[0][1].error_message_for_obj(arg0),
          'Parameter',
          method_sig.arg_types[0][0],
          arg0_type,
          arg0,
          caller_offset: -1
        )
      end

      unless arg1.is_a?(arg1_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[1][1].error_message_for_obj(arg1),
          'Parameter',
          method_sig.arg_types[1][0],
          arg1_type,
          arg1,
          caller_offset: -1
        )
      end

      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      original_method.bind(self).call(arg0, arg1, &blk)
      T::Private::Types::Void::VOID
    end
  end

  def self.create_validator_procedure_fast3(mod, original_method, method_sig, original_visibility, arg0_type, arg1_type, arg2_type)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |arg0, arg1, arg2, &blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      unless arg0.is_a?(arg0_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[0][1].error_message_for_obj(arg0),
          'Parameter',
          method_sig.arg_types[0][0],
          arg0_type,
          arg0,
          caller_offset: -1
        )
      end

      unless arg1.is_a?(arg1_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[1][1].error_message_for_obj(arg1),
          'Parameter',
          method_sig.arg_types[1][0],
          arg1_type,
          arg1,
          caller_offset: -1
        )
      end

      unless arg2.is_a?(arg2_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[2][1].error_message_for_obj(arg2),
          'Parameter',
          method_sig.arg_types[2][0],
          arg2_type,
          arg2,
          caller_offset: -1
        )
      end

      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      original_method.bind(self).call(arg0, arg1, arg2, &blk)
      T::Private::Types::Void::VOID
    end
  end

  def self.create_validator_procedure_fast4(mod, original_method, method_sig, original_visibility, arg0_type, arg1_type, arg2_type, arg3_type)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |arg0, arg1, arg2, arg3, &blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      unless arg0.is_a?(arg0_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[0][1].error_message_for_obj(arg0),
          'Parameter',
          method_sig.arg_types[0][0],
          arg0_type,
          arg0,
          caller_offset: -1
        )
      end

      unless arg1.is_a?(arg1_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[1][1].error_message_for_obj(arg1),
          'Parameter',
          method_sig.arg_types[1][0],
          arg1_type,
          arg1,
          caller_offset: -1
        )
      end

      unless arg2.is_a?(arg2_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[2][1].error_message_for_obj(arg2),
          'Parameter',
          method_sig.arg_types[2][0],
          arg2_type,
          arg2,
          caller_offset: -1
        )
      end

      unless arg3.is_a?(arg3_type)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[3][1].error_message_for_obj(arg3),
          'Parameter',
          method_sig.arg_types[3][0],
          arg3_type,
          arg3,
          caller_offset: -1
        )
      end

      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      original_method.bind(self).call(arg0, arg1, arg2, arg3, &blk)
      T::Private::Types::Void::VOID
    end
  end

  def self.create_validator_method_medium(mod, original_method, method_sig, original_visibility)
    if method_sig.return_type.is_a?(T::Private::Types::Void)
      raise 'Should have used create_validator_procedure_medium'
    end
    # trampoline to reduce stack frame size
    arg_types = method_sig.arg_types
    case arg_types.length
    when 0
      create_validator_method_medium0(mod, original_method, method_sig, original_visibility, method_sig.return_type)
    when 1
      create_validator_method_medium1(mod, original_method, method_sig, original_visibility, method_sig.return_type,
                                    arg_types[0][1])
    when 2
      create_validator_method_medium2(mod, original_method, method_sig, original_visibility, method_sig.return_type,
                                    arg_types[0][1],
                                    arg_types[1][1])
    when 3
      create_validator_method_medium3(mod, original_method, method_sig, original_visibility, method_sig.return_type,
                                    arg_types[0][1],
                                    arg_types[1][1],
                                    arg_types[2][1])
    when 4
      create_validator_method_medium4(mod, original_method, method_sig, original_visibility, method_sig.return_type,
                                    arg_types[0][1],
                                    arg_types[1][1],
                                    arg_types[2][1],
                                    arg_types[3][1])
    else
      raise 'should not happen'
    end
  end

  def self.create_validator_method_medium0(mod, original_method, method_sig, original_visibility, return_type)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |&blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      return_value = original_method.bind(self).call(&blk)
      unless return_type.valid?(return_value)
        message = method_sig.return_type.error_message_for_obj(return_value)
        if message
          CallValidation.report_error(
            method_sig,
            message,
            'Return value',
            nil,
            method_sig.return_type,
            return_value,
            caller_offset: -1
          )
        end
      end
      return_value
    end
  end

  def self.create_validator_method_medium1(mod, original_method, method_sig, original_visibility, return_type, arg0_type)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |arg0, &blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      unless arg0_type.valid?(arg0)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[0][1].error_message_for_obj(arg0),
          'Parameter',
          method_sig.arg_types[0][0],
          arg0_type,
          arg0,
          caller_offset: -1
        )
      end

      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      return_value = original_method.bind(self).call(arg0, &blk)
      unless return_type.valid?(return_value)
        message = method_sig.return_type.error_message_for_obj(return_value)
        if message
          CallValidation.report_error(
            method_sig,
            message,
            'Return value',
            nil,
            method_sig.return_type,
            return_value,
            caller_offset: -1
          )
        end
      end
      return_value
    end
  end

  def self.create_validator_method_medium2(mod, original_method, method_sig, original_visibility, return_type, arg0_type, arg1_type)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |arg0, arg1, &blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      unless arg0_type.valid?(arg0)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[0][1].error_message_for_obj(arg0),
          'Parameter',
          method_sig.arg_types[0][0],
          arg0_type,
          arg0,
          caller_offset: -1
        )
      end

      unless arg1_type.valid?(arg1)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[1][1].error_message_for_obj(arg1),
          'Parameter',
          method_sig.arg_types[1][0],
          arg1_type,
          arg1,
          caller_offset: -1
        )
      end

      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      return_value = original_method.bind(self).call(arg0, arg1, &blk)
      unless return_type.valid?(return_value)
        message = method_sig.return_type.error_message_for_obj(return_value)
        if message
          CallValidation.report_error(
            method_sig,
            message,
            'Return value',
            nil,
            method_sig.return_type,
            return_value,
            caller_offset: -1
          )
        end
      end
      return_value
    end
  end

  def self.create_validator_method_medium3(mod, original_method, method_sig, original_visibility, return_type, arg0_type, arg1_type, arg2_type)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |arg0, arg1, arg2, &blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      unless arg0_type.valid?(arg0)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[0][1].error_message_for_obj(arg0),
          'Parameter',
          method_sig.arg_types[0][0],
          arg0_type,
          arg0,
          caller_offset: -1
        )
      end

      unless arg1_type.valid?(arg1)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[1][1].error_message_for_obj(arg1),
          'Parameter',
          method_sig.arg_types[1][0],
          arg1_type,
          arg1,
          caller_offset: -1
        )
      end

      unless arg2_type.valid?(arg2)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[2][1].error_message_for_obj(arg2),
          'Parameter',
          method_sig.arg_types[2][0],
          arg2_type,
          arg2,
          caller_offset: -1
        )
      end

      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      return_value = original_method.bind(self).call(arg0, arg1, arg2, &blk)
      unless return_type.valid?(return_value)
        message = method_sig.return_type.error_message_for_obj(return_value)
        if message
          CallValidation.report_error(
            method_sig,
            message,
            'Return value',
            nil,
            method_sig.return_type,
            return_value,
            caller_offset: -1
          )
        end
      end
      return_value
    end
  end

  def self.create_validator_method_medium4(mod, original_method, method_sig, original_visibility, return_type, arg0_type, arg1_type, arg2_type, arg3_type)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |arg0, arg1, arg2, arg3, &blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      unless arg0_type.valid?(arg0)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[0][1].error_message_for_obj(arg0),
          'Parameter',
          method_sig.arg_types[0][0],
          arg0_type,
          arg0,
          caller_offset: -1
        )
      end

      unless arg1_type.valid?(arg1)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[1][1].error_message_for_obj(arg1),
          'Parameter',
          method_sig.arg_types[1][0],
          arg1_type,
          arg1,
          caller_offset: -1
        )
      end

      unless arg2_type.valid?(arg2)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[2][1].error_message_for_obj(arg2),
          'Parameter',
          method_sig.arg_types[2][0],
          arg2_type,
          arg2,
          caller_offset: -1
        )
      end

      unless arg3_type.valid?(arg3)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[3][1].error_message_for_obj(arg3),
          'Parameter',
          method_sig.arg_types[3][0],
          arg3_type,
          arg3,
          caller_offset: -1
        )
      end

      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      return_value = original_method.bind(self).call(arg0, arg1, arg2, arg3, &blk)
      unless return_type.valid?(return_value)
        message = method_sig.return_type.error_message_for_obj(return_value)
        if message
          CallValidation.report_error(
            method_sig,
            message,
            'Return value',
            nil,
            method_sig.return_type,
            return_value,
            caller_offset: -1
          )
        end
      end
      return_value
    end
  end

  def self.create_validator_procedure_medium(mod, original_method, method_sig, original_visibility)
    # trampoline to reduce stack frame size
    arg_types = method_sig.arg_types
    case arg_types.length
    when 0
      create_validator_procedure_medium0(mod, original_method, method_sig, original_visibility)
    when 1
      create_validator_procedure_medium1(mod, original_method, method_sig, original_visibility,
                                    arg_types[0][1])
    when 2
      create_validator_procedure_medium2(mod, original_method, method_sig, original_visibility,
                                    arg_types[0][1],
                                    arg_types[1][1])
    when 3
      create_validator_procedure_medium3(mod, original_method, method_sig, original_visibility,
                                    arg_types[0][1],
                                    arg_types[1][1],
                                    arg_types[2][1])
    when 4
      create_validator_procedure_medium4(mod, original_method, method_sig, original_visibility,
                                    arg_types[0][1],
                                    arg_types[1][1],
                                    arg_types[2][1],
                                    arg_types[3][1])
    else
      raise 'should not happen'
    end
  end

  def self.create_validator_procedure_medium0(mod, original_method, method_sig, original_visibility)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |&blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      original_method.bind(self).call(&blk)
      T::Private::Types::Void::VOID
    end
  end

  def self.create_validator_procedure_medium1(mod, original_method, method_sig, original_visibility, arg0_type)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |arg0, &blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      unless arg0_type.valid?(arg0)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[0][1].error_message_for_obj(arg0),
          'Parameter',
          method_sig.arg_types[0][0],
          arg0_type,
          arg0,
          caller_offset: -1
        )
      end

      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      original_method.bind(self).call(arg0, &blk)
      T::Private::Types::Void::VOID
    end
  end

  def self.create_validator_procedure_medium2(mod, original_method, method_sig, original_visibility, arg0_type, arg1_type)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |arg0, arg1, &blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      unless arg0_type.valid?(arg0)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[0][1].error_message_for_obj(arg0),
          'Parameter',
          method_sig.arg_types[0][0],
          arg0_type,
          arg0,
          caller_offset: -1
        )
      end

      unless arg1_type.valid?(arg1)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[1][1].error_message_for_obj(arg1),
          'Parameter',
          method_sig.arg_types[1][0],
          arg1_type,
          arg1,
          caller_offset: -1
        )
      end

      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      original_method.bind(self).call(arg0, arg1, &blk)
      T::Private::Types::Void::VOID
    end
  end

  def self.create_validator_procedure_medium3(mod, original_method, method_sig, original_visibility, arg0_type, arg1_type, arg2_type)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |arg0, arg1, arg2, &blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      unless arg0_type.valid?(arg0)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[0][1].error_message_for_obj(arg0),
          'Parameter',
          method_sig.arg_types[0][0],
          arg0_type,
          arg0,
          caller_offset: -1
        )
      end

      unless arg1_type.valid?(arg1)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[1][1].error_message_for_obj(arg1),
          'Parameter',
          method_sig.arg_types[1][0],
          arg1_type,
          arg1,
          caller_offset: -1
        )
      end

      unless arg2_type.valid?(arg2)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[2][1].error_message_for_obj(arg2),
          'Parameter',
          method_sig.arg_types[2][0],
          arg2_type,
          arg2,
          caller_offset: -1
        )
      end

      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      original_method.bind(self).call(arg0, arg1, arg2, &blk)
      T::Private::Types::Void::VOID
    end
  end

  def self.create_validator_procedure_medium4(mod, original_method, method_sig, original_visibility, arg0_type, arg1_type, arg2_type, arg3_type)
    T::Private::ClassUtils.def_with_visibility(mod, method_sig.method_name, original_visibility) do |arg0, arg1, arg2, arg3, &blk|
      # This method is a manually sped-up version of more general code in `validate_call`
      unless arg0_type.valid?(arg0)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[0][1].error_message_for_obj(arg0),
          'Parameter',
          method_sig.arg_types[0][0],
          arg0_type,
          arg0,
          caller_offset: -1
        )
      end

      unless arg1_type.valid?(arg1)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[1][1].error_message_for_obj(arg1),
          'Parameter',
          method_sig.arg_types[1][0],
          arg1_type,
          arg1,
          caller_offset: -1
        )
      end

      unless arg2_type.valid?(arg2)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[2][1].error_message_for_obj(arg2),
          'Parameter',
          method_sig.arg_types[2][0],
          arg2_type,
          arg2,
          caller_offset: -1
        )
      end

      unless arg3_type.valid?(arg3)
        CallValidation.report_error(
          method_sig,
          method_sig.arg_types[3][1].error_message_for_obj(arg3),
          'Parameter',
          method_sig.arg_types[3][0],
          arg3_type,
          arg3,
          caller_offset: -1
        )
      end

      # The following line breaks are intentional to show nice pry message










      # PRY note:
      # this code is sig validation code.
      # Please issue `finish` to step out of it

      original_method.bind(self).call(arg0, arg1, arg2, arg3, &blk)
      T::Private::Types::Void::VOID
    end
  end

end
