# Homebrew Leadership Responsibilities

## Project Leadership Committee

### PLC Sole Responsibilities

- organising the AGM
- voting on maintainer hardware grants (before they are purchased)
- voting on maintainer hackathon/conference/AGM travel expenses (before they are booked)
- responding to and handling Code of Conduct complaints
- removing inactive members (that are not maintainers) that did not vote in the AGM

### PLC Shared Responsibilities

- approving Open Collective expenses that are expected or have already been agreed upon by the PLC (e.g. Homebrew cloud usage on a personal credit card) (only one approval needed)
- blocking abusive GitHub users
- performing GitHub admin operations on the Homebrew GitHub organisation
- performing Slack admin operations on the Homebrew Slack

### PLC Dated Yearly Tasks

- January: check membership, announce AGM votes
  - Ask for nominations for the for the PLC and project leader, and ask who is interested in serving on the TSC
  - Create ballots for the elections on <https://www.opavote.com>
  - Ask the project leader and representatives of the PLC and TSC to prepare reports for the AGM
  - Ask for members interested in presenting lightning talks at the AGM
- February: organise the annual general meeting (AGM)
  - Create a dedicated Slack channel
  - Book a group dinner (which Homebrew pays for) and check for any dietary requirements
  - Ask someone to bring a conference/table microphone for people to be able to remotely participate in AGM
  - Reconsider current OpenCollective invoice hourly rates based on e.g. inflation
- February after the AGM:
  - Add the minutes of the AGM to Homebrew/brew's [governance archives](https://github.com/Homebrew/brew/tree/master/docs/governance)
  - Create an [issue in Homebrew/brew](https://github.com/Homebrew/brew/issues?q=is%3Aissue+in%3Atitle+membership+) to survey members who did not vote in the election whether they wish to remain or step down as members
    - Members that are not maintainers should be a least one of:
      - An current or previously active maintainer, PLC/TSC member or Project Leader
      - A long-standing member of the Homebrew community (e.g. been submitting good bug reports for over two years)
    - After the survey issue is closed, list the current year's members in a new file within the [governance archives](https://github.com/Homebrew/brew/tree/master/docs/governance)
- October: arrange in-person AGM
  - Offer to pay for Homebrew maintainers who are at least one of:
    - active Homebrew maintainers (i.e. not just contributors)
    - new Homebrew maintainers (i.e. this would be their first AGM)
    - current members of or running for election for PLC/TSC/Project Leader
  - Authorise people to book travel

## Project Leader

### PL Sole Responsibilities

- manage all day-to-day technical decisions
- resolve disputes related to the operation of Homebrew between maintainers, members, other contributors, and users
- [product management](https://en.wikipedia.org/wiki/Product_management) for the various Homebrew products
- in February, before the AGM: checking for activity of non-PLC/TSC maintainers and asking them to step down if they have not been active enough in the past 12 months

### PL Shared Responsibilities

- approving new Homebrew maintainers (only one approval needed)
- approving Open Collective expenses that are expected or have already been agreed upon by the PLC (e.g. Homebrew cloud usage on a personal credit card) (only one approval needed)
- blocking abusive GitHub users
- performing GitHub admin operations on the Homebrew GitHub organisation
- performing Slack admin operations on the Homebrew Slack

## Technical Steering Committee

### TSC Sole Responsibilities

- decide on technical disputes between Homebrew maintainers and the Project Leader

### TSC Shared Responsibilities

- approving new Homebrew maintainers (only one approval needed)
- blocking abusive GitHub users
- performing GitHub admin operations on the Homebrew GitHub organisation
