# Documentation

## Users

- [`brew` manual page (command documentation)](Manpage.md)
- [Homebrew Blog (news on major updates)](https://brew.sh/blog/)
- [Installation](Installation.md)
- [Troubleshooting](Troubleshooting.md)
- [FAQ (Frequently Asked Questions)](FAQ.md)
- [Common Issues](Common-Issues.md)
- [`brew` Shell Completion](Shell-Completion.md)
- [Homebrew on Linux](Homebrew-on-Linux.md)

- [Bottles (binary packages)](Bottles.md)
- [Taps (third-party repositories)](Taps.md)
- [Interesting Taps and Forks](Interesting-Taps-and-Forks.md)
- [Tips and Tricks](Tips-N'-Tricks.md)
- [Anonymous Analytics](Analytics.md)

- [Querying `brew`](Querying-Brew.md)
- [C++ Standard Libraries](C++-Standard-Libraries.md)
- [MD5 and SHA-1 Deprecation](Checksum_Deprecation.md)
- [Custom GCC and Cross Compilers](Custom-GCC-and-cross-compilers.md)
- [External Commands](External-Commands.md)
- [Ruby Gems, Python Eggs and Perl Modules](Gems,-Eggs-and-Perl-Modules.md)
- [Python](Homebrew-and-Python.md)
- [How to Build Software Outside Homebrew with Homebrew `keg_only` Dependencies](How-to-Build-Software-Outside-Homebrew-with-Homebrew-keg-only-Dependencies.md)
- [Xcode](Xcode.md)

- [Creating a Homebrew Issue](Creating-a-Homebrew-Issue.md)
- [Updating Software in Homebrew](Updating-Software-in-Homebrew.md)
- [Adding Software to Homebrew](Adding-Software-to-Homebrew.md)

- [Kickstarter Supporters](Kickstarter-Supporters.md)

## Contributors

- [How to Open a Pull Request (and get it merged)](How-To-Open-a-Homebrew-Pull-Request.md)
- [Formula Cookbook](Formula-Cookbook.md)
- [Cask Cookbook](Cask-Cookbook.md)
- [Acceptable Formulae](Acceptable-Formulae.md)
- [Acceptable Casks](Acceptable-Casks.md)
- [License Guidelines](License-Guidelines.md)
- [Formulae Versions](Versions.md)
- [Deprecating, Disabling and Removing Formulae](Deprecating-Disabling-and-Removing-Formulae.md)
- [Node for Formula Authors](Node-for-Formula-Authors.md)
- [Python for Formula Authors](Python-for-Formula-Authors.md)
- [`brew livecheck`](Brew-Livecheck.md)
- [Migrating a Formula to a Tap](Migrating-A-Formula-To-A-Tap.md)
- [Renaming a Formula](Rename-A-Formula.md)
- [Building Against Non-Homebrew Dependencies](Building-Against-Non-Homebrew-Dependencies.md)
- [How to Create and Maintain a Tap](How-to-Create-and-Maintain-a-Tap.md)
- [Brew Test Bot](Brew-Test-Bot.md)
- [Diagram Guidelines](Diagram-Guidelines.md)
- [Prose Style Guidelines](Prose-Style-Guidelines.md)
- [Type Checking with Sorbet](Typechecking.md)
- [Reproducible Builds](Reproducible-Builds.md)

- [Ruby API Documentation](https://rubydoc.brew.sh) (e.g. for `Formula` etc.)

## Maintainers

- [New Maintainer Checklist](New-Maintainer-Checklist.md)
- [Maintainers: Avoiding Burnout](Maintainers-Avoiding-Burnout.md)

- [Maintainer Guidelines](Maintainer-Guidelines.md)
- [Homebrew/brew Maintainer Guide](Homebrew-brew-Maintainer-Guide.md)
- [Homebrew/homebrew-core Maintainer Guide](Homebrew-homebrew-core-Maintainer-Guide.md)
- [Homebrew/homebrew-cask Maintainer Guide](Homebrew-homebrew-cask-Maintainer-Guide.md)

- [Brew Test Bot for Maintainers](Brew-Test-Bot-For-Core-Contributors.md)
- [Common Issues for Maintainers](Common-Issues-for-Core-Contributors.md)
- [Releases](Releases.md)

## Governance

- [Homebrew Governance](Homebrew-Governance.md)
- [Homebrew Leadership Responsibilities](Homebrew-Leadership-Responsibilities.md)
- [Homebrew Governance Archives](Homebrew-Governance-Archives.md)
