#!/usr/local/bin/php
<?php

/*
 * Copyright (C) 2019 Deciso B.V.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

require_once("config.inc");
require_once("system.inc");
require_once("util.inc");
require_once("interfaces.inc");
require_once("plugins.inc");

$opts = getopt('hm:f:', array(), $optind);
if (isset($opts['h']) || empty($opts['f']) || empty($opts['m'])) {
    echo "Usage: clearlog.php [-h] [-m] [-f]\n\n";
    echo "\t-h show this help text and exit\n";
    echo "\t-m module name\n";
    echo "\t-f filename\n";
    exit(0);
}
if (isset($opts['m']) && isset($opts['f'])) {
    $mname = basename($opts['m']);
    $fname = basename($opts['f']);
    if ($mname == 'core') {
        $basename = "/var/log/{$fname}";
    } else {
        $basename = "/var/log/{$mname}/{$fname}";
    }

    if (is_dir($basename)) {
        foreach (glob("{$basename}/{$fname}_*.log") as $filename) {
            @unlink($filename);
        }
        system_syslog_start();
    }

    // non syslog files, in case service doesn't use our default syslog naming
    $filename = "{$basename}.log";
    if (is_file($filename)) {
        @unlink($filename);
        system_syslog_start();
        // XXX: should probably add some plugin hook for this.
        if ($fname == 'dhcpd' && $mname == 'core') {
            plugins_configure('dhcp');
        }
    }
}
