// Code generated by go-bindata. DO NOT EDIT.
// sources:
// faucet.html (8.959kB)

package main

import (
	"bytes"
	"compress/gzip"
	"crypto/sha256"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("read %q: %w", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("read %q: %w", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes  []byte
	info   os.FileInfo
	digest [sha256.Size]byte
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _faucetHtml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xd4\x5a\x5b\x8f\xe3\x36\xb2\x7e\x76\xff\x8a\x8a\xce\x24\x96\x4f\xb7\x24\x7b\x3a\x37\xd8\x92\x0f\xa6\x27\x39\xc1\x2c\x76\x27\x41\x26\xc1\xee\x22\xc9\x03\x2d\x95\x2d\x4e\x53\xa4\x42\x96\xec\x76\x0c\xff\xf7\x05\xa9\x8b\xe5\x4b\xf7\xce\x25\xc0\x62\xe7\xc1\x2d\x92\xc5\xaa\x8f\x55\xc5\xba\x48\x13\x7f\xf2\xcd\xf7\x2f\x7f\xfa\xe7\x0f\xdf\x42\x4e\x85\x98\x5f\xc5\xf6\x0f\x08\x26\x57\x89\x87\xd2\xb3\x13\xc8\xb2\xf9\xd5\x20\x2e\x90\x18\xa4\x39\xd3\x06\x29\xf1\x2a\x5a\x06\x5f\x7b\xdd\x7c\x4e\x54\x06\xf8\x7b\xc5\xd7\x89\xf7\x8f\xe0\xe7\x17\xc1\x4b\x55\x94\x8c\xf8\x42\xa0\x07\xa9\x92\x84\x92\x12\xef\xd5\xb7\x09\x66\x2b\x3c\x6c\x93\xac\xc0\xc4\x5b\x73\xdc\x94\x4a\x53\x8f\x72\xc3\x33\xca\x93\x0c\xd7\x3c\xc5\xc0\x0d\x6e\x80\x4b\x4e\x9c\x89\xc0\xa4\x4c\x60\x32\xf1\xe6\x57\x57\x83\x98\x38\x09\x9c\xef\x76\xe1\x6b\xa4\x8d\xd2\xf7\xfb\xfd\x14\xfe\x9f\x55\x29\x52\x1c\xd5\x6b\x96\x4a\x70\x79\x0f\xb9\xc6\x65\xe2\x59\xa4\x66\x1a\x45\x69\x26\xdf\x9a\x30\x15\xaa\xca\x96\x82\x69\x0c\x53\x55\x44\xec\x2d\x7b\x88\x04\x5f\x98\x88\x36\x9c\x08\x75\xb0\x50\x8a\x0c\x69\x56\x46\xb7\xe1\x6d\xf8\x55\x94\x1a\x13\x75\x73\x61\xc1\x65\x98\x1a\xe3\x81\x46\x91\x78\x86\xb6\x02\x4d\x8e\x48\x1e\x44\xf3\x0f\x12\xbb\x54\x92\x02\xb6\x41\xa3\x0a\x8c\x3e\x0f\xbf\x0a\xc7\x4e\x62\x7f\xfa\x69\xa1\x57\x83\xd8\xa4\x9a\x97\x04\x46\xa7\xef\x2c\xf6\xed\xef\x15\xea\x6d\x74\x1b\x4e\xc2\x49\x33\x70\x62\xde\x1a\x6f\x1e\x47\x35\xc3\xf9\xc7\xb0\x0e\xa4\xa2\x6d\xf4\x3c\xfc\x3c\x9c\x44\x25\x4b\xef\xd9\x0a\xb3\x56\x90\x5d\x0a\xdb\xc9\x3f\x4b\xec\x63\xf6\x7b\x7b\x6a\xbe\x3f\x41\x56\xa1\x0a\x94\x14\xbe\x35\xd1\xf3\x70\xf2\x75\x38\x6e\x27\xce\xd9\x5b\xfe\xd6\x5e\xf3\xab\xc1\x20\x5c\xa3\x26\x9e\x32\x11\xa4\x28\x09\x35\xec\xae\x06\x83\x41\xc1\x65\x90\x23\x5f\xe5\x34\x85\xc9\x78\xfc\xe9\xec\xc2\xe4\x3a\x77\xb3\x19\x37\xa5\x60\xdb\x29\x2c\x05\x3e\xb8\x19\x26\xf8\x4a\x06\x9c\xb0\x30\x53\xa8\xb9\xda\xf9\xbd\x95\x56\x6a\xb5\xd2\x68\x4c\x2d\xa6\x54\x86\x13\x57\x72\x6a\x9d\x88\x11\x5f\xe3\x39\xa1\x29\x99\x3c\xa5\x66\x0b\xa3\x44\x45\x78\x0c\x60\x21\x54\x7a\xef\xa6\xdc\x55\xed\x21\x4f\x95\x50\x7a\x0a\x9b\x9c\x53\x27\xa1\xd4\xd8\xb0\x65\x59\xc6\xe5\x6a\x0a\x5f\x96\x35\xfe\x82\xe9\x15\x97\x53\x18\x37\xa4\x71\xd4\x68\x2b\x8e\xea\x28\x74\x15\x2f\x54\xb6\x9d\x5f\xc5\x19\x5f\x43\x2a\x98\x31\x89\x77\xa2\x46\x17\x5c\x7a\xcb\x36\xa4\x30\x2e\xeb\x85\xa3\x15\xad\x36\x1e\x38\x01\x89\x57\x4b\x0e\x16\x8a\x48\x15\x53\x98\x58\x44\x6e\xc3\x09\x2f\x11\x88\x55\x30\x79\x5e\x2f\x0d\xe2\x7c\xd2\x32\x20\x7c\xa0\xc0\xe9\xbf\xd3\xbc\x37\x8f\x79\xbb\x73\xc9\x60\xc9\x82\x05\xa3\xdc\x03\xa6\x39\x0b\x72\x9e\x65\x28\x13\x8f\x74\x85\xd6\x43\xf8\x1c\xfa\x41\xac\x8b\x61\xf9\xa4\x46\x11\x65\x7c\xed\x0e\xd0\x3d\x9c\x9c\xe4\x31\xb0\x5f\x43\xf3\xa0\x96\x4b\x83\x14\x74\xd8\x7b\xa4\x5c\x96\x15\x05\x2b\xad\xaa\xb2\x59\x1d\xc4\x6e\x0e\x78\x96\x78\x95\x16\x5e\x13\xa9\xdd\x23\x6d\xcb\xe6\xc0\x5e\x77\x3c\xa5\x8b\xc0\x6a\x5a\x2b\xe1\x41\x29\x58\x8a\xb9\x12\x19\xea\xc4\x7b\xa3\x52\xce\x04\xc8\xfa\x64\xf0\xf3\x8f\x7f\x85\xc6\x24\x5c\xae\x60\xab\x2a\x0d\x77\x5c\x32\x99\x22\xbc\x29\x98\x26\x78\x99\x33\x2e\x81\x65\x99\x75\xc2\x30\x0c\x3b\x44\xce\x1f\xcf\x11\x07\x0b\x92\x2d\x8d\x25\x5b\x54\x44\xaa\x23\x5c\x90\x84\x05\xc9\x20\xc3\x25\xab\x04\x41\xa6\x55\x99\xa9\x8d\x0c\x48\xad\x56\x36\x39\xd5\xa7\xa9\x37\x79\x90\x31\x62\xcd\x52\xe2\xb5\xb4\xad\xc9\x98\x29\x55\x59\x95\x8d\xd1\xea\x49\x7c\x28\x99\xcc\x30\xb3\x26\x16\x06\xbd\xf9\x77\x7c\x8d\x50\x20\xdc\xbd\xbe\x1b\x9c\xda\x3f\x65\x1a\x29\xe8\xb3\x3c\xf3\x82\x38\xaa\xa1\xd4\x07\x82\xe6\x5f\x5c\x89\x96\x53\x77\x80\x02\x65\x05\x47\xa3\x40\xdb\x10\xe1\xcd\x77\x3b\xcd\xe4\x0a\xe1\x19\xcf\x1e\x6e\xe0\x19\x2b\x54\x25\x09\xa6\x09\x84\x2f\xdc\xa3\xd9\xef\x8f\xb8\x03\xc4\x82\xcf\x63\xf6\x94\x2f\x83\x92\xa9\xe0\xe9\x7d\xe2\x11\x47\x9d\xec\x76\x96\xf9\x7e\x3f\x33\xdb\x62\xa1\x44\x32\xbc\x7b\x7d\x37\x9c\xc1\x6e\xc7\x97\xf0\x2c\xfc\x11\x53\x56\x52\x9a\xb3\xfd\x7e\xa5\xdb\xe7\x10\x1f\x30\xad\x08\xfd\xd1\x6e\x87\xc2\xe0\x7e\x6f\xaa\x45\xc1\xc9\x6f\x79\xd9\x79\x99\xed\xf7\xf6\x00\x0d\xe8\xfd\x3e\x8e\xd8\x3c\x8e\x04\x9f\x37\x8b\xc7\x6a\x89\x2a\xd1\x59\x3e\x8e\xac\x83\xfc\x77\x39\xcb\x0f\xb8\x5a\x6d\x81\xd4\x3d\x4a\xf3\x1f\x72\x16\xe8\xbc\xa5\x36\xe5\x0d\x3c\x5b\x60\xf9\x1c\x5f\xc9\xa5\x72\x3e\x73\xd7\x8e\x5a\xb7\x71\x8a\x7b\x0f\x87\x69\x5c\x64\xb7\x6b\x24\xec\xf7\x1f\xe6\x28\x0e\x88\xdf\x63\x73\xe4\x30\x1d\xe8\xc6\xc9\xdf\x90\xde\xef\xa1\x47\xfd\x61\x9e\x54\xc7\x5b\x07\xb7\x8f\xf6\x2c\x84\xae\x82\x0e\x7f\xe3\x18\x86\x13\xde\xe3\x36\xf1\x76\xbb\xfe\xce\x66\x35\x65\x42\x2c\x98\x53\x8f\x3b\x5c\xb7\xe9\x0f\xb4\x0e\xbb\xe6\xc6\xd5\xce\xf3\x56\x7e\x07\xf9\xdf\x67\x82\x93\x9c\x46\xaa\x9c\xc2\xed\xf3\xa7\x12\xda\x97\x27\x39\xe2\xf6\x42\x8e\x28\x99\x44\x01\xee\x37\x30\x05\x13\xed\x73\x73\x57\xba\x28\x7d\xba\x25\xb0\x19\xbb\xc3\xd4\xa5\xfc\xf1\x0c\xd4\x1a\xf5\x52\xa8\xcd\x14\x58\x45\x6a\x06\x05\x7b\xe8\xaa\x9c\xdb\xf1\xb8\x03\x6c\xb9\x12\x5b\x08\x74\xd9\x48\xe3\xef\x15\x1a\x32\x5d\xee\xa9\x97\xdc\xaf\x4d\x41\x19\x4a\x83\xd9\x89\x12\xac\x3c\xab\x4b\x47\xd5\x22\x6d\xf5\x77\x11\xf5\x52\xa9\xa6\x98\xe8\x03\x68\x98\xf6\xaa\x1c\x6f\x1e\x93\x3e\x78\x0e\x65\xef\x55\x10\x68\x5b\xc6\x3f\x56\x0f\xd4\x31\xcc\x9e\xb9\x44\xd4\x75\x1d\x69\xfd\x12\xdc\x30\x8e\x28\xfb\x60\xb9\xd6\xd7\x16\xcc\xe0\xbb\x08\x77\xc5\xdd\x41\xb8\x1b\x7e\x9c\xf4\x1c\x99\xa6\x05\x32\x7a\x17\xf1\xcb\x4a\x66\xbd\xb3\xdf\xbd\xbe\xfb\x38\xe1\x95\xe4\x6b\xd4\x86\xd3\xf6\x5d\xa5\x63\x76\x10\x5f\x8f\xfb\x00\xe2\x88\xf4\xe3\x9e\x75\x78\x3c\xbb\xb7\xcd\xdf\xe6\xcf\x55\xdc\xb5\x20\x51\x04\xdf\x09\xb5\x60\x02\xd6\x16\xe0\x42\xa0\x01\x52\x60\x0b\x2a\xa0\x1c\x21\xad\xb4\x46\x49\x60\x88\x51\x65\x40\x2d\xdd\xec\xd2\x15\x8c\x57\x83\x35\xd3\xc0\x88\xb0\x28\x09\x12\x57\x49\xdb\x19\x83\x7a\xed\x9a\x01\x3b\xb0\x19\xbc\xbf\x56\xc7\x67\xcf\x6b\xc6\xed\x0d\x83\x04\x7e\xf9\x6d\x76\xe5\x00\x7d\x83\x4b\x2e\x11\x98\x55\x40\x6a\x5b\x01\xa0\x9c\x11\xa4\x1a\x19\xa1\x81\x54\x28\x53\xe9\x1a\xa7\xcd\x32\x60\xb1\xb6\x7c\x6a\xae\x76\xba\x74\x72\x5b\x16\x7e\xce\x4c\x3e\x72\xad\x80\x46\xaa\xb4\x3c\xac\xd4\xb3\x83\xa5\xd2\xe0\xdb\xcd\x3c\x19\xcf\x80\xc7\x2d\xc7\x50\xa0\x5c\x51\x3e\x03\x7e\x7d\xdd\x90\x0e\xf8\x12\xfc\x76\xfd\x17\xfe\x5b\x48\x0f\xa1\xe5\x0f\x49\x02\x07\x39\x03\x2b\xaa\xe1\x61\x4a\xc1\x53\xf4\xf9\x0d\x4c\x46\xb3\x7a\x6d\xa1\x91\xd5\x7d\x8c\x6b\x54\xdc\xcf\xfe\x6a\xb0\x9f\xf5\x75\xe0\x94\x7d\xa4\x85\x3a\x82\x1b\x60\xb0\xe2\x86\xa0\xd2\xc2\xea\xc1\xd2\xd5\x6a\x6f\xd4\xec\xa8\xfa\xe7\x3f\xcb\x2a\xcd\x43\x13\xed\x6b\xc8\x35\x8b\xd0\xa0\xcc\xfc\xbf\xbc\xf9\xfe\x75\x68\x48\x73\xb9\xe2\xcb\xad\xbf\xab\xb4\x98\xc2\x33\xdf\xfb\x1f\x5b\x97\x8f\x7e\x19\xff\x16\xae\x99\xa8\xf0\xa6\x31\xe9\x14\xda\x94\x6e\x2d\x3e\x75\xbf\x67\x32\x6f\xa0\x79\x9c\xc2\xb1\xf8\xfd\x68\x34\xbb\x94\xf7\x7a\x89\x5a\xa3\x41\xf2\x2d\x59\x93\x9e\x8e\x35\xc5\xa0\x40\xca\x55\x66\xb5\xa1\x31\x55\x52\x62\x4a\x50\x95\x4a\x36\x8a\x01\xa1\x8c\x69\x9d\xae\x5d\x4f\x4e\xdd\xa0\xa1\x4d\x40\xe2\x06\xfe\x8e\x8b\x37\x2a\xbd\x47\xf2\x7d\x7f\xc3\x65\xa6\x36\xa1\x50\x29\xb3\xe4\xb6\x73\x25\x95\x2a\x01\x49\x92\x40\xd3\xbc\x7b\x23\xf8\x3f\xf0\x36\xc6\xb6\xf1\x1e\x4c\xed\xa3\x7d\x1a\xc1\x35\x9c\x6e\xcf\x95\x21\xb8\x06\x2f\xaa\xaf\x92\xcd\x72\x9a\x22\x56\x72\x6f\x64\x6f\x41\x6b\x09\x25\x0b\x34\x86\xad\xb0\x8f\x14\xd7\x28\xa9\xf1\x31\x7b\x9c\xc2\xac\x20\x01\x67\xaf\x92\x69\x83\x35\x41\x68\xe3\x6e\xed\x6c\xd6\x5d\x1d\x51\x92\x80\xac\x84\x68\xfd\xb3\xbe\x09\xb3\xda\xfb\x7a\x84\xa1\x8b\x83\xf0\x49\x92\x80\x0d\x41\x56\xbf\x59\xbb\xc7\x7a\x40\x1d\x26\x47\xa1\x8d\x81\x07\xfa\xd1\xac\x75\xe3\x23\x3e\x98\x3d\xcd\x08\xb3\x53\x4e\x98\x5d\x60\xe5\xf2\xd0\xe3\x9c\xea\xac\xd5\x63\xe4\x26\x2e\xf0\x91\x55\xb1\x40\xfd\x38\xa3\x3a\x03\x35\x8c\x9c\x3a\x5f\x49\xea\xed\xbc\x81\xc9\x97\xa3\x0b\x7c\x51\x6b\xf5\x08\x5b\xa9\x68\xeb\xef\x04\xdb\xaa\x8a\xa6\x30\x24\x55\xbe\x74\x09\x63\x78\x03\x56\xca\x14\xba\xfd\x37\xae\xe8\x9f\xc2\xd0\x8d\xec\x3a\x2f\xd0\xed\xfa\x62\x3c\x1e\xdf\x40\xfb\xba\xe4\x8e\xd9\x1b\xa6\x2b\xdc\x5f\x40\x62\xaa\x34\x45\xf3\x88\xae\xde\x09\x4b\xc3\xa1\x43\xd3\x8c\x3f\x10\x4f\x17\xe2\x8f\x00\xc1\x67\x9f\xc1\xd9\x6a\xdf\x39\xa3\x08\xfe\xc6\xf4\x3d\xb8\xea\x4f\xe3\x9a\xab\xca\x1c\xd2\x45\xc1\x8d\xb1\x3d\x3d\x33\x90\x29\x89\x6e\xc7\xfb\x44\xf0\x33\x74\x0d\x11\xcc\x61\x7c\x0a\xcd\xc6\xba\x5e\x84\xbf\x10\xf8\x3b\xae\xfd\xa8\x3e\xd8\x1f\x24\x1d\xed\xe1\x05\xc2\x27\x09\x78\xde\x61\xdb\xd9\xba\x5d\x6e\xd8\x0c\x0c\xd2\x4f\xb5\xde\xfd\x26\xb1\x5d\x4a\x3e\xa3\x1b\x5b\xc8\x8e\x47\x47\xc2\xf7\xad\x2a\x5f\x94\x25\xca\x0c\x98\xdc\xba\xc8\xd6\xe9\x91\x4b\x52\xa0\x2a\x1b\x1d\x53\x26\x6c\x69\x2e\xd0\x45\x19\xb7\xd1\x2a\x33\x55\x45\xa1\x24\x24\x10\x4c\x66\x67\xc9\xaf\xa7\xb5\xee\x30\xa7\x66\xb8\xa0\xe5\x63\x53\x1c\x6b\xe8\x84\x34\x98\x1c\x29\xff\xc8\x2e\x97\x0c\x30\xe8\xf0\xf2\x56\x7f\x47\x46\x69\xad\xd2\xd7\x4f\x0f\x71\xbd\xfb\x7a\xf2\x4e\xc0\xbb\xc5\xb2\x32\xb9\x7f\x02\x6d\x34\x3b\xb6\xc0\x2b\x42\xcd\x08\x5d\x27\xe2\x34\x8e\x92\xb8\xc6\x33\xc5\x03\x93\xb6\x9c\x09\x34\xca\x0c\x75\x5b\x01\xd8\x46\xa6\xee\x3b\x7a\x86\x71\xdf\x2f\x7a\xae\xd2\x3b\xc7\x99\x16\x67\xc0\x61\x6e\xeb\x30\xe0\x41\xd0\x9d\xc0\x15\x4b\x4a\xa2\x6d\x4b\x4f\x3c\xdb\x79\x61\xcf\x0d\x2d\x29\x0a\x56\x1a\xcc\x20\x81\xfa\xad\xb3\x3f\x0a\x2b\xc9\x1f\xfc\x51\xd0\x8c\x4f\x39\xb4\xeb\x2e\xa7\x39\xe3\xd4\x98\xaf\x13\xf0\x62\xd2\xb6\xec\x1d\x7a\x70\x7d\xe9\x4e\xd9\xec\x38\x9c\xb7\xd2\xfb\x1b\x01\x62\xca\xe6\xae\x8d\xaa\x8b\xf1\x5f\x3d\xdb\xdd\xae\xb4\xaa\x64\x36\xb5\x25\x91\x7f\xc6\x94\xad\x19\x31\xed\x78\x8e\x66\x70\x20\x77\x4d\xf0\x14\x52\x6b\x95\x19\xd4\xbd\x96\xeb\x5f\xa1\xeb\x0e\xdd\x68\xa1\x74\x86\x3a\xd0\x2c\xe3\x95\x99\xc2\xe7\xe5\xc3\xec\xd7\xb6\x61\x76\x15\xfa\x13\x40\x4b\x8d\xf3\x33\x3c\x69\xea\x5e\x94\x5d\x83\x17\x47\x96\xe0\x69\x26\xdd\x41\xfb\xef\xbc\xe1\x42\x0f\x02\xdd\x1b\xea\x66\xbe\xe0\x59\x26\xd0\x82\x6d\x99\xdb\xdb\x66\x6d\x7e\xb8\x33\xc7\xe2\xa0\x69\x3c\x5a\xfa\x3d\xa0\x30\xf8\x28\x71\xd7\xbf\x0c\xad\xc1\x03\x7b\x50\xee\xf4\xdc\xb4\x42\x6e\x5a\x0f\x9d\x06\x9a\x6f\x15\x59\xa5\x5d\x15\xe4\x07\x8d\x43\xdd\xc0\xd0\xd8\x9a\x2c\x33\xc3\x51\x98\x57\x05\x93\xfc\x0f\xf4\x6d\x42\x19\xd5\x1a\x72\x0d\x91\x77\x1c\x57\xcf\x80\x1c\xfa\xea\x61\x9b\x98\x86\x8d\xe2\x86\xad\x35\xad\xe1\xe0\xd0\xa7\x0f\xdf\x43\x2b\x97\x25\x04\x0b\xa6\xa1\x3f\x08\xda\x6c\x09\x5a\x59\xc9\xed\xda\x82\xe9\x61\xdd\x04\xba\xba\x59\xaa\x4d\x32\xbc\x1d\x77\x00\x6b\xc3\x3a\xbb\x0e\x1b\xbf\x3a\x31\x80\x45\xd8\x5e\xc0\x39\xdc\x8e\x3f\x1e\x69\xc6\xe4\x0a\x4f\xd1\x93\xe6\x25\x66\xc0\x52\xe2\x6b\xfc\xd3\x0f\xf1\xd1\xca\x7d\x6f\x78\xd6\xef\x5a\xb5\x39\xb7\x3c\xc2\x6a\x57\x3b\xad\xfe\xaf\xbd\x57\x10\x39\xdd\x5e\x83\x77\xe1\x10\x8f\x78\xde\x11\xd1\xc9\xe5\x7d\xec\x5e\xbb\x5e\xde\xeb\x27\x09\x5b\x7e\x76\x6f\x9c\x46\x61\x4e\x85\xf0\xbd\x98\xdc\x57\x28\x8b\xb3\xdb\xed\x36\xd7\xd3\x87\x7a\x6b\xdf\xef\x1a\x6c\x8f\x8c\x27\xdd\x0d\xf4\xea\x88\xae\x03\x6a\x8b\x06\xb0\xdd\xd4\xde\x35\x54\x6f\x88\x69\x02\x06\x3f\xbf\x82\xaa\xcc\x18\xd9\x24\xa4\xc0\xa6\x38\x97\x8c\xba\x4f\x76\x0b\xa6\x0d\x2c\x95\xde\x30\x9d\x41\x25\x89\x0b\xbb\xbe\x05\xa6\xb1\xa9\xc9\x0c\xd2\x2b\x1b\x95\xd6\x4c\xf8\x27\x7d\xd6\x33\x7f\x18\xf6\x0d\x3b\x1c\x85\xc8\xd2\xfc\x94\xcc\x65\x9d\x4e\x62\x02\xaf\x5d\x0d\xee\x3f\xf3\x29\xe7\x66\x14\x32\x22\xed\x0f\x8f\x0c\x3e\x1c\x59\xdb\x4d\xba\xbe\xa7\xdb\x1c\xf7\xae\xcc\x53\xfb\x0f\x55\x6d\x93\xc1\x5b\xe2\xd4\x18\xbf\xf6\x9a\xe1\x4d\x8f\xef\xb1\xd3\x0c\x3f\x1d\x36\x26\x39\x5c\xda\x03\xfe\xe4\x02\x86\x23\xb6\x43\x7b\x77\x86\x27\x82\x59\x96\xbd\xb4\xf7\xc2\xf7\x2e\xdc\xde\xbe\x07\x8c\x1a\xc5\xd6\x11\xf7\x09\x8d\x72\x99\xe1\xc3\x63\xea\xe4\xd9\x70\x14\x9a\x6a\x51\xf7\xfe\xfe\x17\x4d\xb7\xd3\x12\x39\xb7\x3c\x0d\xe4\x67\xe9\xdf\x0a\x38\x2e\x01\x82\x93\x92\xe1\x89\x98\xef\x04\xda\xd3\xec\x6f\xac\x72\xc7\xa3\xe6\xc5\xd0\xb7\xc6\x56\x40\xdc\xe4\xc0\x60\x83\x0b\xe3\x7a\x73\x68\x3c\xd9\xbd\x21\xa9\xdf\x84\xbc\xf8\xe1\x55\xf7\x36\xa4\xf3\x74\x5b\x84\x74\x1f\xc7\xcf\xdf\x35\x5c\xfc\x16\xbf\xd9\x6c\xc2\x95\x52\x2b\x51\x7f\x85\xef\x5e\x46\xd8\x46\x3d\x7c\x6b\x3c\x60\x66\x2b\x53\xc8\x70\x89\x7a\xde\x63\x5e\xbf\xa1\x88\xa3\xe6\x03\x72\x54\xff\x77\x97\x7f\x05\x00\x00\xff\xff\x1d\xd7\x27\x7a\xff\x22\x00\x00")

func faucetHtmlBytes() ([]byte, error) {
	return bindataRead(
		_faucetHtml,
		"faucet.html",
	)
}

func faucetHtml() (*asset, error) {
	bytes, err := faucetHtmlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "faucet.html", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x39, 0x4d, 0x5d, 0x6d, 0x7f, 0xf1, 0x26, 0x19, 0x7, 0xee, 0xd2, 0xb3, 0x2, 0xdf, 0xd2, 0x8c, 0x36, 0x87, 0x8e, 0x17, 0x50, 0xb6, 0x8f, 0xb0, 0xb5, 0xce, 0x73, 0xcc, 0x24, 0xd3, 0xd6, 0x8e}}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// AssetString returns the asset contents as a string (instead of a []byte).
func AssetString(name string) (string, error) {
	data, err := Asset(name)
	return string(data), err
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// MustAssetString is like AssetString but panics when Asset would return an
// error. It simplifies safe initialization of global variables.
func MustAssetString(name string) string {
	return string(MustAsset(name))
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetDigest returns the digest of the file with the given name. It returns an
// error if the asset could not be found or the digest could not be loaded.
func AssetDigest(name string) ([sha256.Size]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s can't read by error: %v", name, err)
		}
		return a.digest, nil
	}
	return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s not found", name)
}

// Digests returns a map of all known files and their checksums.
func Digests() (map[string][sha256.Size]byte, error) {
	mp := make(map[string][sha256.Size]byte, len(_bindata))
	for name := range _bindata {
		a, err := _bindata[name]()
		if err != nil {
			return nil, err
		}
		mp[name] = a.digest
	}
	return mp, nil
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"faucet.html": faucetHtml,
}

// AssetDebug is true if the assets were built with the debug flag enabled.
const AssetDebug = false

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"},
// AssetDir("data/img") would return []string{"a.png", "b.png"},
// AssetDir("foo.txt") and AssetDir("notexist") would return an error, and
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		canonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(canonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"faucet.html": {faucetHtml, map[string]*bintree{}},
}}

// RestoreAsset restores an asset under the given directory.
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	return os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
}

// RestoreAssets restores an asset under the given directory recursively.
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(canonicalName, "/")...)...)
}
