﻿using MediaBrowser.Model.LiveTv;

namespace MediaBrowser.Controller.LiveTv
{
    /// <summary>
    /// Class ChannelInfo
    /// </summary>
    public class ChannelInfo
    {
        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>The name.</value>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the number.
        /// </summary>
        /// <value>The number.</value>
        public string Number { get; set; }

        /// <summary>
        /// Get or sets the Id.
        /// </summary>
        /// <value>The id of the channel.</value>
        public string Id { get; set; }

        public string Path { get; set; }

        public string TunerChannelId { get; set; }

        public string CallSign { get; set; }

        /// <summary>
        /// Gets or sets the tuner host identifier.
        /// </summary>
        /// <value>The tuner host identifier.</value>
        public string TunerHostId { get; set; }
        
        /// <summary>
        /// Gets or sets the type of the channel.
        /// </summary>
        /// <value>The type of the channel.</value>
        public ChannelType ChannelType { get; set; }

        /// <summary>
        /// Supply the image path if it can be accessed directly from the file system
        /// </summary>
        /// <value>The image path.</value>
        public string ImagePath { get; set; }

        /// <summary>
        /// Supply the image url if it can be downloaded
        /// </summary>
        /// <value>The image URL.</value>
        public string ImageUrl { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance has image.
        /// </summary>
        /// <value><c>null</c> if [has image] contains no value, <c>true</c> if [has image]; otherwise, <c>false</c>.</value>
        public bool? HasImage { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether this instance is favorite.
        /// </summary>
        /// <value><c>null</c> if [is favorite] contains no value, <c>true</c> if [is favorite]; otherwise, <c>false</c>.</value>
        public bool? IsFavorite { get; set; }

        public bool? IsHD { get; set; }
        public string AudioCodec { get; set; }
        public string VideoCodec { get; set; }
        public string[] Tags { get; set; }
    }
}
