﻿namespace MediaBrowser.Controller.Sorting
{
    public static class SortHelper
    {
        private enum ChunkType { Alphanumeric, Numeric };

        public static bool InChunk(char ch, char otherCh)
        {
            var type = ChunkType.Alphanumeric;

            if (char.IsDigit(otherCh))
            {
                type = ChunkType.Numeric;
            }

            if ((type == ChunkType.Alphanumeric && char.IsDigit(ch))
                || (type == ChunkType.Numeric && !char.IsDigit(ch)))
            {
                return false;
            }

            return true;
        }
    }
}
