﻿
namespace MediaBrowser.Model.Querying
{
    /// <summary>
    /// These represent sort orders that are known by the core
    /// </summary>
    public static class ItemSortBy
    {
        public const string AiredEpisodeOrder = "AiredEpisodeOrder";
        /// <summary>
        /// The album
        /// </summary>
        public const string Album = "Album";
        /// <summary>
        /// The album artist
        /// </summary>
        public const string AlbumArtist = "AlbumArtist";
        /// <summary>
        /// The artist
        /// </summary>
        public const string Artist = "Artist";
        /// <summary>
        /// The date created
        /// </summary>
        public const string DateCreated = "DateCreated";
        /// <summary>
        /// The official rating
        /// </summary>
        public const string OfficialRating = "OfficialRating";
        /// <summary>
        /// The date played
        /// </summary>
        public const string DatePlayed = "DatePlayed";
        /// <summary>
        /// The premiere date
        /// </summary>
        public const string PremiereDate = "PremiereDate";
        public const string StartDate = "StartDate";
        /// <summary>
        /// The sort name
        /// </summary>
        public const string SortName = "SortName";
        public const string Name = "Name";
        /// <summary>
        /// The random
        /// </summary>
        public const string Random = "Random";
        /// <summary>
        /// The runtime
        /// </summary>
        public const string Runtime = "Runtime";
        /// <summary>
        /// The community rating
        /// </summary>
        public const string CommunityRating = "CommunityRating";
        /// <summary>
        /// The production year
        /// </summary>
        public const string ProductionYear = "ProductionYear";
        /// <summary>
        /// The play count
        /// </summary>
        public const string PlayCount = "PlayCount";
        /// <summary>
        /// The critic rating
        /// </summary>
        public const string CriticRating = "CriticRating";
        public const string IsFolder = "IsFolder";
        public const string IsUnplayed = "IsUnplayed";
        public const string IsPlayed = "IsPlayed";
        public const string SeriesSortName = "SeriesSortName";
        public const string VideoBitRate = "VideoBitRate";
        public const string AirTime = "AirTime";
        public const string Studio = "Studio";
        public const string Players = "Players";
        public const string GameSystem = "GameSystem";
        public const string IsFavoriteOrLiked = "IsFavoriteOrLiked";
        public const string DateLastContentAdded = "DateLastContentAdded";
        public const string SeriesDatePlayed = "SeriesDatePlayed";
    }
}
