define(["filerepository","itemrepository","useractionrepository","transfermanager"],function(filerepository,itemrepository,useractionrepository,transfermanager){"use strict";function getLocalItem(serverId,itemId){return console.log("[lcoalassetmanager] Begin getLocalItem"),itemrepository.get(serverId,itemId)}function recordUserAction(action){return action.Id=createGuid(),useractionrepository.set(action.Id,action)}function getUserActions(serverId){return useractionrepository.getByServerId(serverId)}function deleteUserAction(action){return useractionrepository.remove(action.Id)}function deleteUserActions(actions){var results=[];return actions.forEach(function(action){results.push(deleteUserAction(action))}),Promise.all(results)}function getServerItems(serverId){return console.log("[localassetmanager] Begin getServerItems"),itemrepository.getAll(serverId)}function getItemsFromIds(serverId,ids){var actions=ids.map(function(id){var strippedId=stripStart(id,"local:");return getLocalItem(serverId,strippedId)});return Promise.all(actions).then(function(items){var libItems=items.map(function(locItem){return locItem.Item});return Promise.resolve(libItems)})}function getViews(serverId,userId){return itemrepository.getServerItemTypes(serverId,userId).then(function(types){var item,list=[];return types.indexOf("Audio")>-1&&(item={Name:"Music",ServerId:serverId,Id:"localview:MusicView",Type:"MusicView",CollectionType:"music",IsFolder:!0},list.push(item)),types.indexOf("Photo")>-1&&(item={Name:"Photos",ServerId:serverId,Id:"localview:PhotosView",Type:"PhotosView",CollectionType:"photos",IsFolder:!0},list.push(item)),types.indexOf("Episode")>-1&&(item={Name:"TV",ServerId:serverId,Id:"localview:TVView",Type:"TVView",CollectionType:"tvshows",IsFolder:!0},list.push(item)),types.indexOf("Movie")>-1&&(item={Name:"Movies",ServerId:serverId,Id:"localview:MoviesView",Type:"MoviesView",CollectionType:"movies",IsFolder:!0},list.push(item)),types.indexOf("Video")>-1&&(item={Name:"Videos",ServerId:serverId,Id:"localview:VideosView",Type:"VideosView",CollectionType:"videos",IsFolder:!0},list.push(item)),types.indexOf("MusicVideo")>-1&&(item={Name:"Music Videos",ServerId:serverId,Id:"localview:MusicVideosView",Type:"MusicVideosView",CollectionType:"videos",IsFolder:!0},list.push(item)),Promise.resolve(list)})}function updateFiltersForTopLevelView(parentId,mediaTypes,includeItemTypes,query){switch(parentId){case"MusicView":return query.Recursive?includeItemTypes.push("Audio"):includeItemTypes.push("MusicAlbum"),!0;case"PhotosView":return query.Recursive?includeItemTypes.push("Photo"):includeItemTypes.push("PhotoAlbum"),!0;case"TVView":return query.Recursive?includeItemTypes.push("Episode"):includeItemTypes.push("Series"),!0;case"VideosView":return query.Recursive,includeItemTypes.push("Video"),!0;case"MoviesView":return query.Recursive,includeItemTypes.push("Movie"),!0;case"MusicVideosView":return query.Recursive,includeItemTypes.push("MusicVideo"),!0}return!1}function normalizeId(id){return id?(id=stripStart(id,"localview:"),id=stripStart(id,"local:")):null}function normalizeIdList(val){return val?val.split(",").map(normalizeId):[]}function shuffle(array){for(var temporaryValue,randomIndex,currentIndex=array.length;0!==currentIndex;)randomIndex=Math.floor(Math.random()*currentIndex),currentIndex-=1,temporaryValue=array[currentIndex],array[currentIndex]=array[randomIndex],array[randomIndex]=temporaryValue;return array}function sortItems(items,query){var sortBy=(query.sortBy||"").split(",")[0];return"DateCreated"===sortBy?items.sort(function(a,b){return compareDates(a.DateCreated,b.DateCreated)}):"Random"===sortBy?items=shuffle(items):items.sort(function(a,b){return a.SortName.toLowerCase().localeCompare(b.SortName.toLowerCase())}),items}function getViewItems(serverId,userId,options){var parentId=options.ParentId;parentId=normalizeId(parentId);var seasonId=normalizeId(options.SeasonId||options.seasonId),seriesId=normalizeId(options.SeriesId||options.seriesId),albumIds=normalizeIdList(options.AlbumIds||options.albumIds),includeItemTypes=options.IncludeItemTypes?options.IncludeItemTypes.split(","):[],filters=options.Filters?options.Filters.split(","):[],mediaTypes=options.MediaTypes?options.MediaTypes.split(","):[];return updateFiltersForTopLevelView(parentId,mediaTypes,includeItemTypes,options)&&(parentId=null),getServerItems(serverId).then(function(items){var resultItems=items.filter(function(item){if(item.SyncStatus&&"synced"!==item.SyncStatus)return!1;if(mediaTypes.length&&-1===mediaTypes.indexOf(item.Item.MediaType||""))return!1;if(seriesId&&item.Item.SeriesId!==seriesId)return!1;if(seasonId&&item.Item.SeasonId!==seasonId)return!1;if(albumIds.length&&-1===albumIds.indexOf(item.Item.AlbumId||""))return!1;if(item.Item.IsFolder&&-1!==filters.indexOf("IsNotFolder"))return!1;if(!item.Item.IsFolder&&-1!==filters.indexOf("IsFolder"))return!1;if(includeItemTypes.length&&-1===includeItemTypes.indexOf(item.Item.Type||""))return!1;if(options.Recursive);else if(parentId&&item.Item.ParentId!==parentId)return!1;return!0}).map(function(item2){return item2.Item});return resultItems=sortItems(resultItems,options),options.Limit&&(resultItems=resultItems.slice(0,options.Limit)),Promise.resolve(resultItems)})}function removeObsoleteContainerItems(serverId){return getServerItems(serverId).then(function(items){var seriesItems=items.filter(function(item){return"series"===(item.Item.Type||"").toLowerCase()}),seasonItems=items.filter(function(item){return"season"===(item.Item.Type||"").toLowerCase()}),albumItems=items.filter(function(item){var type=(item.Item.Type||"").toLowerCase();return"musicalbum"===type||"photoalbum"===type}),requiredSeriesIds=items.filter(function(item){return"episode"===(item.Item.Type||"").toLowerCase()}).map(function(item2){return item2.Item.SeriesId}).filter(filterDistinct),requiredSeasonIds=items.filter(function(item){return"episode"===(item.Item.Type||"").toLowerCase()}).map(function(item2){return item2.Item.SeasonId}).filter(filterDistinct),requiredAlbumIds=items.filter(function(item){var type=(item.Item.Type||"").toLowerCase();return"audio"===type||"photo"===type}).map(function(item2){return item2.Item.AlbumId}).filter(filterDistinct),obsoleteItems=[];seriesItems.forEach(function(item){requiredSeriesIds.indexOf(item.Item.Id)<0&&obsoleteItems.push(item)}),seasonItems.forEach(function(item){requiredSeasonIds.indexOf(item.Item.Id)<0&&obsoleteItems.push(item)}),albumItems.forEach(function(item){requiredAlbumIds.indexOf(item.Item.Id)<0&&obsoleteItems.push(item)});var p=Promise.resolve();return obsoleteItems.forEach(function(item){p=p.then(function(){return itemrepository.remove(item.ServerId,item.Id)})}),p})}function removeLocalItem(localItem){return itemrepository.get(localItem.ServerId,localItem.Id).then(function(item){var onFileDeletedSuccessOrFail=function(){return itemrepository.remove(localItem.ServerId,localItem.Id)};return item.LocalPath?filerepository.deleteFile(item.LocalPath).then(onFileDeletedSuccessOrFail,onFileDeletedSuccessOrFail):onFileDeletedSuccessOrFail()})}function addOrUpdateLocalItem(localItem){return itemrepository.set(localItem.ServerId,localItem.Id,localItem)}function getSubtitleSaveFileName(localItem,mediaPath,language,isForced,format){var name=getNameWithoutExtension(mediaPath);language&&(name+="."+language.toLowerCase()),isForced&&(name+=".foreign"),name=name+"."+format.toLowerCase();var localPathArray=[localItem.LocalFolder,name];return filerepository.getPathFromArray(localPathArray)}function getItemFileSize(path){return filerepository.getItemFileSize(path)}function getNameWithoutExtension(path){var fileName=path,pos=fileName.lastIndexOf(".");return pos>0&&(fileName=fileName.substring(0,pos)),fileName}function downloadFile(url,localItem){var imageUrl=getImageUrl(localItem.Item.ServerId,localItem.Item.Id,{type:"Primary",index:0});return transfermanager.downloadFile(url,localItem,imageUrl)}function downloadSubtitles(url,fileName){return transfermanager.downloadSubtitles(url,fileName)}function getImageUrl(serverId,itemId,imageOptions){var imageType=imageOptions.type,index=imageOptions.index,pathArray=getImagePath(serverId,itemId,imageType,index);return filerepository.getImageUrl(pathArray)}function hasImage(serverId,itemId,imageType,index){var pathArray=getImagePath(serverId,itemId,imageType,index),localFilePath=filerepository.getFullMetadataPath(pathArray);return filerepository.fileExists(localFilePath).then(function(exists){return Promise.resolve(exists)},function(err){return Promise.resolve(!1)})}function fileExists(localFilePath){return filerepository.fileExists(localFilePath)}function downloadImage(localItem,url,serverId,itemId,imageType,index){var localPathParts=getImagePath(serverId,itemId,imageType,index);return transfermanager.downloadImage(url,localPathParts)}function isDownloadFileInQueue(path){return transfermanager.isDownloadFileInQueue(path)}function getDownloadItemCount(){return transfermanager.getDownloadItemCount()}function getDirectoryPath(item){var parts=[],itemtype=item.Type.toLowerCase(),mediaType=(item.MediaType||"").toLowerCase();"episode"===itemtype||"series"===itemtype||"season"===itemtype?parts.push("TV"):"video"===mediaType?parts.push("Videos"):"audio"===itemtype||"musicalbum"===itemtype||"musicartist"===itemtype?parts.push("Music"):"photo"===itemtype||"photoalbum"===itemtype?parts.push("Photos"):"game"!==itemtype&&"gamesystem"!==itemtype||parts.push("Games");var albumArtist=item.AlbumArtist;albumArtist&&parts.push(albumArtist);var seriesName=item.SeriesName;seriesName&&parts.push(seriesName);var seasonName=item.SeasonName;seasonName&&parts.push(seasonName),item.Album&&parts.push(item.Album),("video"===mediaType&&"episode"!==itemtype||"game"===itemtype||item.IsFolder)&&parts.push(item.Name);for(var finalParts=[],i=0;i<parts.length;i++)finalParts.push(filerepository.getValidFileName(parts[i]));return finalParts}function getImagePath(serverId,itemId,imageType,index){var parts=[];parts.push("images"),index=index||0,parts.push(itemId+"_"+imageType+"_"+index.toString());for(var finalParts=[],i=0;i<parts.length;i++)finalParts.push(parts[i]);return finalParts}function getLocalFileName(item,originalFileName){var filename=originalFileName||item.Name;return filerepository.getValidFileName(filename)}function resyncTransfers(){return transfermanager.resyncTransfers()}function createGuid(){var d=(new Date).getTime();return window.performance&&"function"==typeof window.performance.now&&(d+=performance.now()),"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(c){var r=(d+16*Math.random())%16|0;return d=Math.floor(d/16),("x"===c?r:3&r|8).toString(16)})}function startsWith(str,find){return!!(str&&find&&str.length>find.length&&0===str.indexOf(find))}function stripStart(str,find){return startsWith(str,find)?str.substr(find.length):str}function filterDistinct(value,index,self){return self.indexOf(value)===index}function compareDates(a,b){return isFinite(a=a.valueOf())&&isFinite(b=b.valueOf())?(a>b)-(a<b):NaN}function enableBackgroundCompletion(){return transfermanager.enableBackgroundCompletion}return{getLocalItem:getLocalItem,getDirectoryPath:getDirectoryPath,getLocalFileName:getLocalFileName,recordUserAction:recordUserAction,getUserActions:getUserActions,deleteUserAction:deleteUserAction,deleteUserActions:deleteUserActions,removeLocalItem:removeLocalItem,addOrUpdateLocalItem:addOrUpdateLocalItem,downloadFile:downloadFile,downloadSubtitles:downloadSubtitles,hasImage:hasImage,downloadImage:downloadImage,getImageUrl:getImageUrl,getSubtitleSaveFileName:getSubtitleSaveFileName,getServerItems:getServerItems,getItemFileSize:getItemFileSize,isDownloadFileInQueue:isDownloadFileInQueue,getDownloadItemCount:getDownloadItemCount,getViews:getViews,getViewItems:getViewItems,resyncTransfers:resyncTransfers,getItemsFromIds:getItemsFromIds,removeObsoleteContainerItems:removeObsoleteContainerItems,fileExists:fileExists,enableBackgroundCompletion:enableBackgroundCompletion}});