﻿using MediaBrowser.Model.Entities;
using System;
using System.Collections.Generic;
using MediaBrowser.Model.Configuration;
using System.Linq;
using MediaBrowser.Controller.Dto;
using MediaBrowser.Model.Querying;

namespace MediaBrowser.Controller.Entities
{
    public class InternalItemsQuery
    {
        public bool Recursive { get; set; }

        public int? StartIndex { get; set; }

        public int? Limit { get; set; }

        public User User { get; set; }

        public BaseItem SimilarTo { get; set; }

        public bool? IsFolder { get; set; }
        public bool? IsFavorite { get; set; }
        public bool? IsFavoriteOrLiked { get; set; }
        public bool? IsLiked { get; set; }
        public bool? IsPlayed { get; set; }
        public bool? IsResumable { get; set; }
        public bool? IncludeItemsByName { get; set; }

        public string[] MediaTypes { get; set; }
        public string[] IncludeItemTypes { get; set; }
        public string[] ExcludeItemTypes { get; set; }
        public string[] ExcludeTags { get; set; }
        public string[] ExcludeInheritedTags { get; set; }
        public string[] Genres { get; set; }

        public bool? IsSpecialSeason { get; set; }
        public bool? IsMissing { get; set; }
        public bool? IsUnaired { get; set; }
        public bool? CollapseBoxSetItems { get; set; }

        public string NameStartsWithOrGreater { get; set; }
        public string NameStartsWith { get; set; }
        public string NameLessThan { get; set; }
        public string NameContains { get; set; }
        public string MinSortName { get; set; }

        public string PresentationUniqueKey { get; set; }
        public string Path { get; set; }
        public string PathNotStartsWith { get; set; }
        public string Name { get; set; }

        public string Person { get; set; }
        public string[] PersonIds { get; set; }
        public string[] ItemIds { get; set; }
        public string[] ExcludeItemIds { get; set; }
        public string AdjacentTo { get; set; }
        public string[] PersonTypes { get; set; }

        public bool? Is3D { get; set; }
        public bool? IsHD { get; set; }
        public bool? IsLocked { get; set; }
        public bool? IsPlaceHolder { get; set; }

        public bool? HasImdbId { get; set; }
        public bool? HasOverview { get; set; }
        public bool? HasTmdbId { get; set; }
        public bool? HasOfficialRating { get; set; }
        public bool? HasTvdbId { get; set; }
        public bool? HasThemeSong { get; set; }
        public bool? HasThemeVideo { get; set; }
        public bool? HasSubtitles { get; set; }
        public bool? HasSpecialFeature { get; set; }
        public bool? HasTrailer { get; set; }
        public bool? HasParentalRating { get; set; }

        public string[] StudioIds { get; set; }
        public string[] GenreIds { get; set; }
        public ImageType[] ImageTypes { get; set; }
        public VideoType[] VideoTypes { get; set; }
        public UnratedItem[] BlockUnratedItems { get; set; }
        public int[] Years { get; set; }
        public string[] Tags { get; set; }
        public string[] OfficialRatings { get; set; }

        public DateTime? MinPremiereDate { get; set; }
        public DateTime? MaxPremiereDate { get; set; }
        public DateTime? MinStartDate { get; set; }
        public DateTime? MaxStartDate { get; set; }
        public DateTime? MinEndDate { get; set; }
        public DateTime? MaxEndDate { get; set; }
        public bool? IsAiring { get; set; }

        public bool? IsMovie { get; set; }
        public bool? IsSports { get; set; }
        public bool? IsKids { get; set; }
        public bool? IsNews { get; set; }
        public bool? IsSeries { get; set; }

        public int? MinPlayers { get; set; }
        public int? MaxPlayers { get; set; }
        public int? MinIndexNumber { get; set; }
        public int? AiredDuringSeason { get; set; }
        public double? MinCriticRating { get; set; }
        public double? MinCommunityRating { get; set; }

        public string[] ChannelIds { get; set; }

        public int? ParentIndexNumber { get; set; }
        public int? ParentIndexNumberNotEquals { get; set; }
        public int? IndexNumber { get; set; }
        public int? MinParentalRating { get; set; }
        public int? MaxParentalRating { get; set; }

        public bool? HasDeadParentId { get; set; }
        public bool? IsVirtualItem { get; set; }

        public Guid? ParentId { get; set; }
        public string ParentType { get; set; }
        public string[] AncestorIds { get; set; }
        public string[] TopParentIds { get; set; }

        public BaseItem Parent
        {
            set
            {
                if (value == null)
                {
                    ParentId = null;
                    ParentType = null;
                }
                else
                {
                    ParentId = value.Id;
                    ParentType = value.GetType().Name;
                }
            }
        }

        public string[] PresetViews { get; set; }
        public TrailerType[] TrailerTypes { get; set; }
        public SourceType[] SourceTypes { get; set; }

        public SeriesStatus[] SeriesStatuses { get; set; }
        public string ExternalSeriesId { get; set; }
        public string ExternalId { get; set; }

        public string[] AlbumIds { get; set; }
        public string[] ArtistIds { get; set; }
        public string[] ExcludeArtistIds { get; set; }
        public string AncestorWithPresentationUniqueKey { get; set; }
        public string SeriesPresentationUniqueKey { get; set; }

        public bool GroupByPresentationUniqueKey { get; set; }
        public bool GroupBySeriesPresentationUniqueKey { get; set; }
        public bool EnableTotalRecordCount { get; set; }
        public bool ForceDirect { get; set; }
        public Dictionary<string, string> ExcludeProviderIds { get; set; }
        public bool EnableGroupByMetadataKey { get; set; }
        public bool? HasChapterImages { get; set; }

        public Tuple<string, SortOrder>[] OrderBy { get; set; }

        public DateTime? MinDateCreated { get; set; }
        public DateTime? MinDateLastSaved { get; set; }
        public DateTime? MinDateLastSavedForUser { get; set; }

        public DtoOptions DtoOptions { get; set; }
        public int MinSimilarityScore { get; set; }
        public string HasNoAudioTrackWithLanguage { get; set; }
        public string HasNoInternalSubtitleTrackWithLanguage { get; set; }
        public string HasNoExternalSubtitleTrackWithLanguage { get; set; }
        public string HasNoSubtitleTrackWithLanguage { get; set; }
        public bool? IsDeadArtist { get; set; }
        public bool? IsDeadStudio { get; set; }
        public bool? IsDeadPerson { get; set; }

        public InternalItemsQuery()
        {
            MinSimilarityScore = 20;

            GroupByPresentationUniqueKey = true;
            EnableTotalRecordCount = true;

            DtoOptions = new DtoOptions();
            AlbumIds = new string[] { };
            ArtistIds = new string[] { };
            ExcludeArtistIds = new string[] { };
            ExcludeProviderIds = new Dictionary<string, string>(StringComparer.OrdinalIgnoreCase);

            BlockUnratedItems = new UnratedItem[] { };
            Tags = new string[] { };
            OfficialRatings = new string[] { };
            MediaTypes = new string[] { };
            IncludeItemTypes = new string[] { };
            ExcludeItemTypes = new string[] { };
            Genres = new string[] { };
            StudioIds = new string[] { };
            GenreIds = new string[] { };
            ImageTypes = new ImageType[] { };
            VideoTypes = new VideoType[] { };
            Years = new int[] { };
            PersonTypes = new string[] { };
            PersonIds = new string[] { };
            ChannelIds = new string[] { };
            ItemIds = new string[] { };
            ExcludeItemIds = new string[] { };
            AncestorIds = new string[] { };
            TopParentIds = new string[] { };
            ExcludeTags = new string[] { };
            ExcludeInheritedTags = new string[] { };
            PresetViews = new string[] { };
            TrailerTypes = new TrailerType[] { };
            SourceTypes = new SourceType[] { };
            SeriesStatuses = new SeriesStatus[] { };
            OrderBy = new Tuple<string, SortOrder>[] { };
        }

        public InternalItemsQuery(User user)
            : this()
        {
            SetUser(user);
        }

        public void SetUser(User user)
        {
            if (user != null)
            {
                var policy = user.Policy;
                MaxParentalRating = policy.MaxParentalRating;

                if (policy.MaxParentalRating.HasValue)
                {
                    BlockUnratedItems = policy.BlockUnratedItems.Where(i => i != UnratedItem.Other).ToArray();
                }

                ExcludeInheritedTags = policy.BlockedTags;

                User = user;
            }
        }
    }
}
