define(["events","libraryBrowser","datetime","userSettings","serverNotifications","connectionManager","emby-button"],function(events,libraryBrowser,datetime,userSettings,serverNotifications,connectionManager){"use strict";function getEntryHtml(entry,apiClient){var html="";html+='<div class="listItem listItem-noborder">';var color="Error"==entry.Severity||"Fatal"==entry.Severity||"Warn"==entry.Severity?"#cc0000":"#52B54B";if(entry.UserId&&entry.UserPrimaryImageTag){html+='<i class="listItemIcon md-icon" style="width:2em!important;height:2em!important;padding:0;color:transparent;background-color:'+color+";background-image:url('"+apiClient.getUserImageUrl(entry.UserId,{type:"Primary",tag:entry.UserPrimaryImageTag,height:40})+"');background-repeat:no-repeat;background-position:center center;background-size: cover;\">dvr</i>"}else html+='<i class="listItemIcon md-icon" style="background-color:'+color+'">dvr</i>';html+='<div class="listItemBody three-line">',html+='<div class="listItemBodyText">',html+=entry.Name,html+="</div>",html+='<div class="listItemBodyText secondary">';var date=datetime.parseISO8601Date(entry.Date,!0);return html+=datetime.toLocaleString(date).toLowerCase(),html+="</div>",html+='<div class="listItemBodyText secondary listItemBodyText-nowrap">',html+=entry.ShortOverview||"",html+="</div>",html+="</div>",html+="</div>"}function renderList(elem,apiClient,result,startIndex,limit){var html=result.Items.map(function(i){return getEntryHtml(i,apiClient)}).join("");if(result.TotalRecordCount>limit){var query={StartIndex:startIndex,Limit:limit};html+=libraryBrowser.getQueryPagingHtml({startIndex:query.StartIndex,limit:query.Limit,totalRecordCount:result.TotalRecordCount,showLimit:!1,updatePageSizeSetting:!1})}elem.innerHTML=html;var btnNextPage=elem.querySelector(".btnNextPage");btnNextPage&&btnNextPage.addEventListener("click",function(){reloadData(elem,apiClient,startIndex+limit,limit)});var btnPreviousPage=elem.querySelector(".btnPreviousPage");btnPreviousPage&&btnPreviousPage.addEventListener("click",function(){reloadData(elem,apiClient,startIndex-limit,limit)})}function reloadData(elem,apiClient,startIndex,limit){null==startIndex&&(startIndex=parseInt(elem.getAttribute("data-activitystartindex")||"0")),limit=limit||parseInt(elem.getAttribute("data-activitylimit")||"7");var minDate=new Date;minDate.setTime(minDate.getTime()-864e5),ApiClient.getJSON(ApiClient.getUrl("System/ActivityLog/Entries",{startIndex:startIndex,limit:limit,minDate:minDate.toISOString()})).then(function(result){elem.setAttribute("data-activitystartindex",startIndex),elem.setAttribute("data-activitylimit",limit),renderList(elem,apiClient,result,startIndex,limit)})}function onActivityLogUpdate(e,apiClient,data){var options=this.options;options&&options.serverId===apiClient.serverId()&&reloadData(options.element,apiClient)}function ActivityLog(options){this.options=options;var element=options.element;element.classList.add("activityLogListWidget");var apiClient=connectionManager.getApiClient(options.serverId);reloadData(element,apiClient);var onUpdate=onActivityLogUpdate.bind(this);this.updateFn=onUpdate,events.on(serverNotifications,"ActivityLogEntry",onUpdate),apiClient.sendMessage("ActivityLogEntryStart","0,1500")}return ActivityLog.prototype.destroy=function(){var options=this.options;if(options){options.element.classList.remove("activityLogListWidget");connectionManager.getApiClient(options.serverId).sendMessage("ActivityLogEntryStop","0,1500")}var onUpdate=this.updateFn;onUpdate&&events.off(serverNotifications,"ActivityLogEntry",onUpdate),this.options=null},ActivityLog});