// SPDX-FileCopyrightText: 2019-2022 Connor McLaughlin <stenzek@gmail.com>
// SPDX-License-Identifier: (GPL-3.0 OR CC-BY-NC-ND-4.0)

#pragma once
#include "common/types.h"

#include <functional>
#include <string>

namespace NoGUIHost {
/// Sets batch mode (exit after game shutdown).
bool InBatchMode();
void SetBatchMode(bool enabled);

/// Returns the application name and version, optionally including debug/devel config indicator.
std::string GetAppNameAndVersion();

/// Returns the debug/devel config indicator.
std::string GetAppConfigSuffix();

/// Thread-safe settings access.
void SaveSettings();

void StopRunning();

/// Called on the UI thread in response to various events.
void ProcessPlatformWindowResize(s32 width, s32 height, float scale);
void ProcessPlatformMouseMoveEvent(float x, float y);
void ProcessPlatformMouseButtonEvent(s32 button, bool pressed);
void ProcessPlatformMouseWheelEvent(float x, float y);
void ProcessPlatformKeyEvent(s32 key, bool pressed);
void ProcessPlatformTextEvent(const char* text);
void PlatformWindowFocusGained();
void PlatformWindowFocusLost();
void PlatformDevicesChanged();
bool GetSavedPlatformWindowGeometry(s32* x, s32* y, s32* width, s32* height);
void SavePlatformWindowGeometry(s32 x, s32 y, s32 width, s32 height);
} // namespace NoGUIHost
