using module ..\Modules\Include.psm1

param(
    [String]$Name,
    [PSCustomObject]$Pools,
    [Bool]$InfoOnly
)

if (-not $IsWindows -and -not $IsLinux) {return}
if ($IsLinux -and ($Global:GlobalCPUInfo.Vendor -eq "ARM" -or $Global:GlobalCPUInfo.Features.ARM)) {return} # No ARM binaries available
if (-not $Global:DeviceCache.DevicesByTypes.AMD -and -not $Global:DeviceCache.DevicesByTypes.CPU -and -not $Global:DeviceCache.DevicesByTypes.INTEL -and -not $Global:DeviceCache.DevicesByTypes.NVIDIA -and -not $InfoOnly) {return} # No GPU present in system

$ManualURI = "https://github.com/nanopool/nanominer/releases"
$Port = "234{0:d2}"
$Cuda = "10.0"
$DevFee = 3.0
$Version = "3.10.0"

if ($IsLinux) {
    $Path = ".\Bin\ANY-Nanominer\nanominer"
    $Uri  = "https://github.com/RainbowMiner/miner-binaries/releases/download/v3.10.0-nanominer/nanominer-linux-3.10.0.tar.gz"
} else {
    $Path = ".\Bin\ANY-Nanominer\nanominer.exe"
    $Uri  = "https://github.com/RainbowMiner/miner-binaries/releases/download/v3.10.0-nanominer/nanominer-windows-3.10.0.zip"
}

$Commands = [PSCustomObject[]]@(
    [PSCustomObject]@{MainAlgorithm = "autolykos";       DAG = $true; Params = ""; MinMemGb = 2;  Vendor = @("AMD","NVIDIA");         ExtendInterval = 2; DevFee = 2.5} #Autolycos/Ergo
    [PSCustomObject]@{MainAlgorithm = "Cuckaroo30";                   Params = ""; MinMemGb = 14; Vendor = @("AMD");                  ExtendInterval = 2; DevFee = 5.0} #Cuckaroo30/Cortex
    [PSCustomObject]@{MainAlgorithm = "Ethash";          DAG = $true; Params = ""; MinMemGb = 3;  Vendor = @("AMD","INTEL","NVIDIA");          ExtendInterval = 2; DevFee = 1.0; ExcludePoolName = "F2Pool"} #Ethash
    [PSCustomObject]@{MainAlgorithm = "Ethash2g";        DAG = $true; Params = ""; MinMemGb = 1;  Vendor = @("AMD","INTEL","NVIDIA");          ExtendInterval = 2; DevFee = 1.0; Algorithm = "Ethash"; ExcludePoolName = "F2Pool"} #Ethash
    [PSCustomObject]@{MainAlgorithm = "Ethash3g";        DAG = $true; Params = ""; MinMemGb = 2;  Vendor = @("AMD","INTEL","NVIDIA");          ExtendInterval = 2; DevFee = 1.0; Algorithm = "Ethash"; ExcludePoolName = "F2Pool"} #Ethash
    [PSCustomObject]@{MainAlgorithm = "Ethash4g";        DAG = $true; Params = ""; MinMemGb = 3;  Vendor = @("AMD","INTEL","NVIDIA");          ExtendInterval = 2; DevFee = 1.0; Algorithm = "Ethash"; ExcludePoolName = "F2Pool"} #Ethash
    [PSCustomObject]@{MainAlgorithm = "Ethash5g";        DAG = $true; Params = ""; MinMemGb = 4;  Vendor = @("AMD","INTEL","NVIDIA");          ExtendInterval = 2; DevFee = 1.0; Algorithm = "Ethash"; ExcludePoolName = "F2Pool"} #Ethash
    [PSCustomObject]@{MainAlgorithm = "EthashLowMemory"; DAG = $true; Params = ""; MinMemGb = 2;  Vendor = @("AMD","INTEL","NVIDIA");          ExtendInterval = 2; DevFee = 1.0; Algorithm = "Ethash"; ExcludePoolName = "F2Pool"} #Ethash for low memory coins
    [PSCustomObject]@{MainAlgorithm = "EthashB3";        DAG = $true; Params = ""; MinMemGb = 3;  Vendor = @("AMD","INTEL","NVIDIA");          ExtendInterval = 2; DevFee = 1.0} #EthashB3
    [PSCustomObject]@{MainAlgorithm = "EtcHash";         DAG = $true; Params = ""; MinMemGb = 3;  Vendor = @("AMD","NVIDIA");                  ExtendInterval = 2; DevFee = 1.0} #EtcHash
    [PSCustomObject]@{MainAlgorithm = "EvrProgPow";      DAG = $true; Params = ""; MinMemGb = 2;  Vendor = @("AMD","INTEL","NVIDIA"); ExtendInterval = 2; DevFee = 2.0} #EvrProgPow/EVR
    #[PSCustomObject]@{MainAlgorithm = "FiroPow";         DAG = $true; Params = ""; MinMemGb = 2;  Vendor = @("AMD","INTEL","NVIDIA"); ExtendInterval = 2; DevFee = 1.0; ZombieMode = $true} #FiroPOW
    [PSCustomObject]@{MainAlgorithm = "fishhash";                     Params = ""; MinMemGb = 2;  Vendor = @("AMD","NVIDIA");         ExtendInterval = 2; DevFee = 1.0} #FishHash
    [PSCustomObject]@{MainAlgorithm = "karlsenhashv2";                Params = ""; MinMemGb = 2;  Vendor = @("AMD","NVIDIA");         ExtendInterval = 2; DevFee = 1.0} #KarlsenhashV2/KLS
    [PSCustomObject]@{MainAlgorithm = "KawPow";          DAG = $true; Params = ""; MinMemGb = 3;  Vendor = @("AMD","INTEL","NVIDIA"); ExtendInterval = 2; DevFee = 2.0} #KawPOW
    [PSCustomObject]@{MainAlgorithm = "KawPow2g";        DAG = $true; Params = ""; MinMemGb = 3;  Vendor = @("AMD","INTEL","NVIDIA"); ExtendInterval = 2; DevFee = 2.0; Algorithm = "KawPow"} #KawPOW
    [PSCustomObject]@{MainAlgorithm = "KawPow3g";        DAG = $true; Params = ""; MinMemGb = 3;  Vendor = @("AMD","INTEL","NVIDIA"); ExtendInterval = 2; DevFee = 2.0; Algorithm = "KawPow"} #KawPOW
    [PSCustomObject]@{MainAlgorithm = "KawPow4g";        DAG = $true; Params = ""; MinMemGb = 3;  Vendor = @("AMD","INTEL","NVIDIA"); ExtendInterval = 2; DevFee = 2.0; Algorithm = "KawPow"} #KawPOW
    [PSCustomObject]@{MainAlgorithm = "KawPow5g";        DAG = $true; Params = ""; MinMemGb = 3;  Vendor = @("AMD","INTEL","NVIDIA"); ExtendInterval = 2; DevFee = 2.0; Algorithm = "KawPow"} #KawPOW
    [PSCustomObject]@{MainAlgorithm = "Octopus";         DAG = $true; Params = ""; MinMemGb = 5;  Vendor = @("AMD","NVIDIA");         ExtendInterval = 2; DevFee = 2.0} #Octopus/Conflux
    [PSCustomObject]@{MainAlgorithm = "RandomNEVO";                   Params = ""; MinMemGb = 3;  Vendor = @("CPU");                  ExtendInterval = 2; DevFee = 2.0} #RandomNEVO
    [PSCustomObject]@{MainAlgorithm = "RandomX";                      Params = ""; MinMemGb = 3;  Vendor = @("CPU");                  ExtendInterval = 2; DevFee = 2.0} #RandomX
    [PSCustomObject]@{MainAlgorithm = "SCCPow";          DAG = $true; Params = ""; MinMemGb = 3;  Vendor = @("AMD","INTEL","NVIDIA"); ExtendInterval = 2; DevFee = 1.0; ZombieMode = $true; Algorithm = "FiroPow"} #SCCPow
    [PSCustomObject]@{MainAlgorithm = "Verushash";                    Params = ""; MinMemGb = 3;  Vendor = @("CPU");                  ExtendInterval = 2; DevFee = 2.0; CPUFeatures = @("avx","aes"); ExcludePoolName="LuckPool"} #Verushash
    [PSCustomObject]@{MainAlgorithm = "UbqHash";                      Params = ""; MinMemGb = 3;  Vendor = @("AMD","NVIDIA");         ExtendInterval = 2; DevFee = 1.0; Algorithm = "Ethash"; Coins = @("UBQ"); ExcludePoolName = "F2Pool"} #UbqHash
    [PSCustomObject]@{MainAlgorithm = "Verthash";                     Params = ""; MinMemGb = 2;  Vendor = @("AMD");                  ExtendInterval = 2; DevFee = 1.0} #Verthash

    # Dual mining
    #[PSCustomObject]@{MainAlgorithm = "autolykos";       DAG = $true; Params = ""; MinMemGb = 2;  Vendor = @("AMD","NVIDIA");         ExtendInterval = 2; DevFee = 2.5; SecondaryAlgorithm = "heavyhash"} #Autolycos/Ergo + kHeavyhash/KAS
    #[PSCustomObject]@{MainAlgorithm = "Ethash";          DAG = $true; Params = ""; MinMemGb = 3;  Vendor = @("AMD","INTEL","NVIDIA");          ExtendInterval = 2; DevFee = 1.0; ExcludePoolName = "F2Pool"; SecondaryAlgorithm = "heavyhash"} #Ethash + kHeavyHash
    #[PSCustomObject]@{MainAlgorithm = "Ethash2g";        DAG = $true; Params = ""; MinMemGb = 1;  Vendor = @("AMD","INTEL","NVIDIA");          ExtendInterval = 2; DevFee = 1.0; Algorithm = "Ethash"; ExcludePoolName = "F2Pool"; SecondaryAlgorithm = "heavyhash"} #Ethash + kHeavyhash/KAS
    #[PSCustomObject]@{MainAlgorithm = "Ethash3g";        DAG = $true; Params = ""; MinMemGb = 2;  Vendor = @("AMD","INTEL","NVIDIA");          ExtendInterval = 2; DevFee = 1.0; Algorithm = "Ethash"; ExcludePoolName = "F2Pool"; SecondaryAlgorithm = "heavyhash"} #Ethash + kHeavyhash/KAS
    #[PSCustomObject]@{MainAlgorithm = "Ethash4g";        DAG = $true; Params = ""; MinMemGb = 3;  Vendor = @("AMD","INTEL","NVIDIA");          ExtendInterval = 2; DevFee = 1.0; Algorithm = "Ethash"; ExcludePoolName = "F2Pool"; SecondaryAlgorithm = "heavyhash"} #Ethash + kHeavyhash/KAS
    #[PSCustomObject]@{MainAlgorithm = "Ethash5g";        DAG = $true; Params = ""; MinMemGb = 4;  Vendor = @("AMD","INTEL","NVIDIA");          ExtendInterval = 2; DevFee = 1.0; Algorithm = "Ethash"; ExcludePoolName = "F2Pool"; SecondaryAlgorithm = "heavyhash"} #Ethash + kHeavyhash/KAS
    #[PSCustomObject]@{MainAlgorithm = "EthashLowMemory"; DAG = $true; Params = ""; MinMemGb = 2;  Vendor = @("AMD","INTEL","NVIDIA");          ExtendInterval = 2; DevFee = 1.0; Algorithm = "Ethash"; ExcludePoolName = "F2Pool"; SecondaryAlgorithm = "heavyhash"} #Ethash for low memory coins + kHeavyhash/KAS
    #[PSCustomObject]@{MainAlgorithm = "EtcHash";         DAG = $true; Params = ""; MinMemGb = 3;  Vendor = @("AMD");                  ExtendInterval = 2; DevFee = 1.0; SecondaryAlgorithm = "heavyhash"} #EtcHash + kHeavyhash/KAS

)

# $Name = Get-Item $MyInvocation.MyCommand.Path | Select-Object -ExpandProperty BaseName

if ($InfoOnly) {
    [PSCustomObject]@{
        Type      = @("AMD","CPU","INTEL","NVIDIA")
        Name      = $Name
        Path      = $Path
        Port      = $Miner_Port
        Uri       = $Uri
        DevFee    = $DevFee
        ManualUri = $ManualUri
        Commands  = $Commands
    }
    return
}

if ($Global:DeviceCache.DevicesByTypes.NVIDIA) {
    $Cuda = Confirm-Cuda -ActualVersion $Session.Config.CUDAVersion -RequiredVersion $Cuda -Warning $Name
    $Cuda11 = Confirm-Cuda -ActualVersion $Session.Config.CUDAVersion -RequiredVersion "11.0"
}

foreach ($Miner_Vendor in @("AMD","CPU","INTEL","NVIDIA")) {
    $Global:DeviceCache.DevicesByTypes.$Miner_Vendor | Where-Object {$_.Vendor -ne "NVIDIA" -or $Cuda} | Select-Object Vendor, Model -Unique | ForEach-Object {
        $Miner_Model = $_.Model
        $Device = $Global:DeviceCache.DevicesByTypes.$Miner_Vendor | Where-Object {$_.Model -eq $Miner_Model}

        $Commands | Where-Object {$_.Vendor -icontains $Miner_Vendor -and ($Miner_Vendor -ne "CPU" -or -not $_.CPUFeatures -or ($Global:GlobalCPUInfo.Features -and -not (Compare-Object @($Global:GlobalCPUInfo.Features.Keys) $_.CPUFeatures | Where-Object SideIndicator -eq "=>" | Measure-Object).Count))} | ForEach-Object {
            $First = $true

            $MainAlgorithm_0   = if ($_.Algorithm) {$_.Algorithm} else {$_.MainAlgorithm}
            $SecondAlgorithm_0 = $_.SecondaryAlgorithm

            $MainAlgorithm_Norm_0 = Get-Algorithm "$(if ($_.MainAlgorithm -eq "heavyhash") {"kHeavyHash"} else {$_.MainAlgorithm})"
            $SecondAlgorithm_Norm_0 = if ($_.SecondaryAlgorithm) {Get-Algorithm $_.SecondaryAlgorithm} else {$null}
            
            $SecondAlgorithm_Norm_0 = if ($_.SecondaryAlgorithm) {Get-Algorithm "$(if ($_.SecondaryAlgorithm -eq "heavyhash") {"kHeavyHash"} else {$_.SecondaryAlgorithm})"} else {$null}

            if ($Miner_Vendor -eq "CPU") {
                $CPUThreads = if ($Session.Config.Miners."$Name-CPU-$MainAlgorithm_Norm_0".Threads)  {$Session.Config.Miners."$Name-CPU-$MainAlgorithm_Norm_0".Threads}  elseif ($Session.Config.Miners."$Name-CPU".Threads)  {$Session.Config.Miners."$Name-CPU".Threads}  elseif ($Session.Config.CPUMiningThreads)  {$Session.Config.CPUMiningThreads}
                $CPUAffinity= if ($Session.Config.Miners."$Name-CPU-$MainAlgorithm_Norm_0".Affinity) {$Session.Config.Miners."$Name-CPU-$MainAlgorithm_Norm_0".Affinity} elseif ($Session.Config.Miners."$Name-CPU".Affinity) {$Session.Config.Miners."$Name-CPU".Affinity} elseif ($Session.Config.CPUMiningAffinity) {$Session.Config.CPUMiningAffinity}
            }

            $All_MainAlgorithms = if ($Miner_Vendor -eq "CPU") {@($MainAlgorithm_Norm_0,"$($MainAlgorithm_Norm_0)-$($Miner_Model)")} else {@($MainAlgorithm_Norm_0,"$($MainAlgorithm_Norm_0)-$($Miner_Model)","$($MainAlgorithm_Norm_0)-GPU")}
            $All_SecondAlgorithms = if ($SecondAlgorithm_Norm_0) {if ($Miner_Vendor -eq "CPU") {@($SecondAlgorithm_Norm_0,"$($SecondAlgorithm_Norm_0)-$($Miner_Model)")} else {@($SecondAlgorithm_Norm_0,"$($SecondAlgorithm_Norm_0)-$($Miner_Model)","$($SecondAlgorithm_Norm_0)-GPU")}} else {$null}

            foreach($MainAlgorithm_Norm in $All_MainAlgorithms) {
                if (-not $Pools.$MainAlgorithm_Norm.Host) {continue}

                $MinMemGB = if ($_.DAG) {if ($Pools.$MainAlgorithm_Norm.DagSizeMax) {$Pools.$MainAlgorithm_Norm.DagSizeMax} else {Get-EthDAGSize -CoinSymbol $Pools.$MainAlgorithm_Norm.CoinSymbol -Algorithm $MainAlgorithm_Norm_0 -Minimum $_.MinMemGb}} else {$_.MinMemGb}
                if ($_.ZombieMode -and -not $_.NoMemCalcCheck -and $MinMemGB -gt $_.MinMemGB -and $Session.Config.EnableEthashZombieMode) {
                    $MinMemGB = $_.MinMemGB
                }
                $Miner_Device = $Device | Where-Object {$Miner_Vendor -eq "CPU" -or (($MainAlgorithm_Norm_0 -ne "Cuckaroo30" -or $_.Model -eq "RX57016GB") -and ($Miner_Vendor -ne "NVIDIA" -or $Cuda11 -or $_.Model -notmatch "^RTX[345]0") -and (Test-VRAM $_ $MinMemGb))}

                if ($Miner_Device -and (-not $_.ExcludePoolName -or $Pools.$MainAlgorithm_Norm.Host -notmatch $_.ExcludePoolName) -and (-not $_.Coins -or ($Pools.$MainAlgorithm_Norm.CoinSymbol -and $_.Coins -icontains $Pools.$MainAlgorithm_Norm.CoinSymbol)) -and (-not $Pools.$MainAlgorithm_Norm.SSL -or -not $Pools.$MainAlgorithm_Norm.SSLSelfSigned)) {
                    if ($First) {
                        $Miner_Port = $Port -f ($Miner_Device | Select-Object -First 1 -ExpandProperty Index)
                        $Miner_Name = (@($Name) + @($SecondAlgorithm_Norm_0 | Select-Object | Foreach-Object {"$($MainAlgorithm_Norm_0)-$($_)"}) + @($Miner_Device.Name | Sort-Object) | Select-Object) -join '-'
                        $First = $false
                    }
                    $Pool_Port = if ($Miner_Vendor -ne "CPU" -and $Pools.$MainAlgorithm_Norm.Ports -ne $null -and $Pools.$MainAlgorithm_Norm.Ports.GPU) {$Pools.$MainAlgorithm_Norm.Ports.GPU} else {$Pools.$MainAlgorithm_Norm.Port}
                    $Wallet    = if ($Pools.$MainAlgorithm_Norm.Wallet) {$Pools.$MainAlgorithm_Norm.Wallet} else {$Pools.$MainAlgorithm_Norm.User}

                    $PaymentId = $null
                    #if ($Wallet -match "^(.+?)[\.\+]([0-9a-f]{16,})") {
                    #    $Wallet    = $Matches[1]
                    #    $PaymentId = $Matches[2]
                    #} elseif ($MainAlgorithm_Norm -match "^RandomHash") {
                    #    $PaymentId = "0"
                    #}

                    #$Wallet = $Wallet -replace "@","%40"

                    $MainCoin = $Pools.$MainAlgorithm_Norm.CoinSymbol
                    $MainCoin_Data = Get-Coin $MainCoin
                    if ($MainCoin_Data.Algo -ne $MainAlgorithm_Norm -and $MainCoin -ne "SCC") {$MainCoin = $null}
                    
                    if ($All_SecondAlgorithms) {

                        $Miner_Name_Dual = $Miner_Name

                        foreach($SecondAlgorithm_Norm in $All_SecondAlgorithms) {
			                if ($Pools.$SecondAlgorithm_Norm.Host -and (-not $_.CoinSymbols -or $Pools.$SecondAlgorithm_Norm.CoinSymbol -in $_.CoinSymbols) -and (-not $_.ExcludePoolName -or $Pools.$SecondAlgorithm_Norm.Host -notmatch $_.ExcludePoolName) -and (-not $_.ExcludeYiimp -or -not $Session.YiimpPools.Contains("$($Pools.$SecondAlgorithm_Norm_0.Name)"))) {

                                $SecondPool_Port = if ($Pools.$SecondAlgorithm_Norm.Ports -ne $null -and $Pools.$SecondAlgorithm_Norm.Ports.$Pool_Port_Index) {$Pools.$SecondAlgorithm_Norm.Ports.$Pool_Port_Index} else {$Pools.$SecondAlgorithm_Norm.Port}
                                $SecondWallet    = if ($Pools.$SecondAlgorithm_Norm.Wallet) {$Pools.$SecondAlgorithm_Norm.Wallet} else {$Pools.$SecondAlgorithm_Norm.User}

                                $SecondWallet = $SecondWallet -replace "@","%40"

                                $SecondPaymentId = $null
                                if ($Wallet -match "^(.+?)[\.\+]([0-9a-f]{16,})") {
                                    $Wallet    = $Matches[1]
                                    $SecondPaymentId = $Matches[2]
                                } elseif ($SecondAlgorithm_Norm -match "^RandomHash") {
                                    $SecondPaymentId = "0"
                                }

                                $SecondCoin = $Pools.$MainAlgorithm_Norm.CoinSymbol
                                $SecondCoin_Data = Get-Coin $SecondCoin
                                if ($SecondCoin_Data.Algo -ne $SecondAlgorithm_Norm) {$SecondCoin = $null}

                                $Arguments = [PSCustomObject]@{
                                    Algorithms = @(
                                        [PSCustomObject]@{
                                            Algo      = $MainAlgorithm_0
                                            Coin      = $MainCoin
                                            Host      = $Pools.$MainAlgorithm_Norm.Host
                                            Port      = $Pool_Port
                                            SSL       = $Pools.$MainAlgorithm_Norm.SSL
                                            Wallet    = $Wallet
                                            PaymentId = $PaymentId
                                            Worker    = $Pools.$MainAlgorithm_Norm.Worker
                                            Pass      = $Pools.$MainAlgorithm_Norm.Pass
                                            Email     = $Pools.$MainAlgorithm_Norm.Email
                                        }
                                        [PSCustomObject]@{
                                            Algo      = $SecondAlgorithm_0
                                            Coin      = $SecondCoin
                                            Host      = $Pools.$SecondAlgorithm_Norm.Host
                                            Port      = $SecondPool_Port
                                            SSL       = $Pools.$SecondAlgorithm_Norm.SSL
                                            Wallet    = $SecondWallet
                                            PaymentId = $SecondPaymentId
                                            Worker    = $Pools.$SecondAlgorithm_Norm.Worker
                                            Pass      = $Pools.$SecondAlgorithm_Norm.Pass
                                            Email     = $Pools.$SecondAlgorithm_Norm.Email
                                        }
                                    )                            

                                    Devices   = if ($Miner_Vendor -ne "CPU") {$Miner_Device.BusId_Type_Mineable_Index} else {$null}
                                    LHR       = "$(if ($Miner_Vendor -eq "NVIDIA" -and $MainAlgorithm_Norm -match "^Etc?hash") {($Miner_Device | Foreach-Object {if ($_.IsLHR) {"0"} else {"off"}}) -join ','})"
                                    Threads   = if ($Miner_Vendor -eq "CPU") {$CPUThreads} else {$null}
                                    Params    = "$($_.Params)"
                                }

                                [PSCustomObject]@{
                                    Name            = $Miner_Name
                                    DeviceName      = $Miner_Device.Name
                                    DeviceModel     = $Miner_Model
                                    Path            = $Path
                                    Arguments       = $Arguments
					                HashRates      = [PSCustomObject]@{
                                                        $MainAlgorithm_Norm   = $Global:StatsCache."$($Miner_Name_Dual)_$($MainAlgorithm_Norm_0)_HashRate".Week
                                                        $SecondAlgorithm_Norm = $Global:StatsCache."$($Miner_Name_Dual)_$($SecondAlgorithm_Norm_0)_HashRate".Week
                                                    }
                                    API             = "Nanominer"
                                    Port            = $Miner_Port
                                    Uri             = $Uri
                                    FaultTolerance  = $_.FaultTolerance
                                    ExtendInterval  = $_.ExtendInterval
                                    Penalty         = 0
					                DevFee         = [PSCustomObject]@{
								                        ($MainAlgorithm_Norm) = if ($_.Fee -ne $null) {$_.Fee} else {$DevFee}
								                        ($SecondAlgorithm_Norm) = 0
                                                        }
                                    ManualUri       = $ManualUri
                                    MiningAffinity  = if ($Miner_Vendor -eq "CPU") {$CPUAffinity} else {$null}
                                    Version         = $Version
                                    PowerDraw       = 0
                                    BaseName        = $Name
                                    BaseAlgorithm   = "$($MainAlgorithm_Norm_0)-$($SecondAlgorithm_Norm_0)"
                                    Benchmarked     = $Global:StatsCache."$($Miner_Name_Dual)_$($MainAlgorithm_Norm_0)_HashRate".Benchmarked
                                    LogFile         = $Global:StatsCache."$($Miner_Name_Dual)_$($MainAlgorithm_Norm_0)_HashRate".LogFile
                                    #ListDevices    = "-d"
                                    ExcludePoolName = $_.ExcludePoolName
                                }
                            }
                        }

                    } else {

                        $Arguments = [PSCustomObject]@{
                            Algorithms = @(
                                [PSCustomObject]@{
                                    Algo      = $MainAlgorithm_0
                                    Coin      = $MainCoin
                                    Host      = $Pools.$MainAlgorithm_Norm.Host
                                    Port      = $Pool_Port
                                    SSL       = $Pools.$MainAlgorithm_Norm.SSL
                                    Wallet    = $Wallet
                                    PaymentId = $PaymentId
                                    Worker    = $Pools.$MainAlgorithm_Norm.Worker
                                    Pass      = $Pools.$MainAlgorithm_Norm.Pass
                                    Email     = $Pools.$MainAlgorithm_Norm.Email
                                }
                            )                            

                            Devices   = if ($Miner_Vendor -ne "CPU") {$Miner_Device.BusId_Type_Mineable_Index} else {$null}
                            Threads   = if ($Miner_Vendor -eq "CPU") {$CPUThreads} else {$null}
                            LHR       = "$(if ($Miner_Vendor -eq "NVIDIA" -and $MainAlgorithm_Norm -match "^Etc?hash") {($Miner_Device | Foreach-Object {if ($_.IsLHR) {"0"} else {"off"}}) -join ','})"
                        }

                        [PSCustomObject]@{
                            Name            = $Miner_Name
                            DeviceName      = $Miner_Device.Name
                            DeviceModel     = $Miner_Model
                            Path            = $Path
                            Arguments       = $Arguments
                            HashRates       = [PSCustomObject]@{$MainAlgorithm_Norm = $Global:StatsCache."$($Miner_Name)_$($MainAlgorithm_Norm_0)_HashRate".Week}
                            API             = "Nanominer"
                            Port            = $Miner_Port
                            Uri             = $Uri
                            FaultTolerance  = $_.FaultTolerance
                            ExtendInterval  = $_.ExtendInterval
                            Penalty         = 0
                            DevFee          = $_.DevFee
                            ManualUri       = $ManualUri
                            MiningAffinity  = if ($Miner_Vendor -eq "CPU") {$CPUAffinity} else {$null}
                            Version         = $Version
                            PowerDraw       = 0
                            BaseName        = $Name
                            BaseAlgorithm   = $MainAlgorithm_Norm_0
                            Benchmarked     = $Global:StatsCache."$($Miner_Name)_$($MainAlgorithm_Norm_0)_HashRate".Benchmarked
                            LogFile         = $Global:StatsCache."$($Miner_Name)_$($MainAlgorithm_Norm_0)_HashRate".LogFile
                            #ListDevices    = "-d"
                            ExcludePoolName = $_.ExcludePoolName
                        }
                    }
                }
            }
        }
    }
}
