﻿
Add-Type -Path .\DotNet\OpenCL\*.cs

$Result = [PSCustomObject]@{
    Platform_Devices = $null
    ErrorMessage     = $null
}

[System.Collections.Generic.List[string]]$AllPlatforms = @()
try {
    $PlatformId = 0
    $Result.Platform_Devices = [OpenCl.Platform]::GetPlatformIDs() | ForEach-Object {

        $PlatformVendor = switch -Regex ([String]$_.Vendor) { 
                                "Advanced Micro Devices" {"AMD"}
                                "Intel"  {"INTEL"}
                                "NVIDIA" {"NVIDIA"}
                                "AMD"    {"AMD"}
                                default {$_.Vendor -replace '\(R\)|\(TM\)|\(C\)' -replace '[^A-Z0-9]'}
                    }

        if (($Global:IsLinux -and $PlatformVendor -eq "AMD") -or $AllPlatforms -inotcontains "$($_.Name) $($_.Version)") {

            [void]$AllPlatforms.Add("$($_.Name) $($_.Version)")
            $Device_Index = 0
            [PSCustomObject]@{
                PlatformId=$PlatformId
                Vendor=$PlatformVendor
                Name="$($_.Name) $($_.Version)"
                Devices=[OpenCl.Device]::GetDeviceIDs($_, [OpenCl.DeviceType]::All) | Foreach-Object {
                    [PSCustomObject]@{
                        DeviceIndex      = $Device_Index
                        Name             = $_.Name
                        Architecture     = $_.Architecture
                        Type             = "$($_.Type)"
                        Vendor           = $_.Vendor
                        GlobalMemSize    = $_.GlobalMemSize
                        GlobalMemSizeGB  = [int]($_.GlobalMemSize/1GB)
                        MaxComputeUnits  = $_.MaxComputeUnits
                        PlatformVersion  = $_.Platform.Version
                        DriverVersion    = $_.DriverVersion
                        PCIBusId         = $_.PCIBusId
                        DeviceCapability = $_.DeviceCapability
                        CardId           = -1
                    }
                    $Device_Index++
                }
            }

            $PlatformId++
        }
    }
} catch {
    $Result.ErrorMessage = $_.Exception.Message
}

$Result