<br/>
<p align="center">
  <a href="https://github.com/rearth/Oritech">
    <img src="https://github.com/Rearth/Oritech/assets/10100603/d459b3fa-ef6f-4675-99d7-c44a78a3cf71" alt="Logo" width="80" height="80">
  </a>

<h3 align="center">Oritech</h3>

<div align="center">
  A minecraft fabric / neoforge tech mod, currently in beta.
  <br/>
  <br/>
  <a href="https://moddedmc.org/en/mod/oritech/docs"><strong>Explore the docs»</strong></a>
  <br/>
  <br/>
  <a href="https://github.com/rearth/Oritech/issues">Report Bug</a>
  .
  <a href="https://github.com/rearth/Oritech/issues">Request Feature</a>
  <br/>
  <br/>
  <br/>

  ![Downloads](https://img.shields.io/github/downloads/rearth/Oritech/total) ![Stargazers](https://img.shields.io/github/stars/rearth/Oritech?style=social) ![Issues](https://img.shields.io/github/issues/rearth/Oritech) ![License](https://img.shields.io/github/license/rearth/Oritech) ![Discord](https://img.shields.io/discord/1233448016128512082)


  
</div>

---
<p align="center">
  <img src="https://github.com/Rearth/Oritech/assets/10100603/bb99651d-d9af-48e2-9b00-6fb980517e0a" />
</p>
<p align="center">
  <img src="https://github.com/Rearth/Oritech/assets/10100603/be0fd041-40fc-40c3-a273-976140e89e90" />
</p>
<p align="center">
  <img src="https://github.com/Rearth/Oritech/assets/10100603/b76bf232-74e7-4a17-8166-89d1c80f738e" />
</p>

---

## About The Project


An upcoming tech mod for minecraft fabric. Features advanced ore processing, powered tools and armor, and much much more.

Wiki is available online (https://moddedmc.org/en/mod/oritech/docs) or via the [Oracle Index](https://www.curseforge.com/minecraft/mc-mods/oracle-index) mod.

Currently in very early access, numerous bugs and issues are to be expected.

If you want to contribute, suggest ideas or just see what's planned, make sure to check out the GitHub discussions for this project (https://github.com/Rearth/Oritech/discussions).

Includes JEI, REI and EMI compatibility. Works best with EMI.

Extra mod compatibilities (allowing metals and other components to be processed in Oritech machines, and vice-versa) for the following mods are included:
### Fabric
- Alloy Forgery
- Clutter
- Energized Power
- Mythic Metals
- Tech Reborn
### Neoforge
- Actually Additions
- Applied Energistics 2
- Create
- Ender IO
- Energized Power
- Immersive Engineering
- Industrial Foregoing
- Mekanism (and Mekanism Generators)
- PneumaticCraft: Repressurized
- Powah!
- Productive Metalworks

The following translations are available:
- English
- Chinese (by PlatinumOak)
- Brazilian Portuguese (by RenanEuzebio)
- Russian (by nuchohent)
- Ukrainian (by nuchohent)
- Spanish (by Seyronh)
- Turkish (by RuyaSavascisi)
- French (by kikipunk)
- German (by Wolkensteinchen)
- Polish (by plhappylemonpl & Przemol)

## Built With

- Fabric API (or FFAPI)
- Owo lib (for all the GUIs, config, and much more)
- Geckolib (for the animations)
- Blockbench (to create and animate the models)

## Roadmap

See the [open issues](https://github.com/rearth/Oritech/issues) for a list of proposed features (and known issues).

## Depending on Oritech

Release artifacts are published to the [BlameJared Maven repository](https://maven.blamejared.com/).

```groovy
repositories {
    maven {
        name = "BlameJared"
        url = "https://maven.blamejared.com"
    }
}
```

### Common

The common module is published with Mojang mappings. It can only be used in an environment that doesn't remap the code,
such as [ModDevGradle](https://github.com/neoforged/ModDevGradle) in Vanilla mode.
If you use [Architectury Loom](https://github.com/architectury/architectury-loom), make sure to use the `intermediary`
artifact, so it can be properly remapped. This will also work with yarn mappings.

```groovy
dependencies {
    // Mojmaps - ModDevGradle
    implementation "rearth.oritech:oritech-common-<minecraft-version>:<oritech-version>"
    // Intermediary - Architectury Loom
    modImplementation "rearth.oritech:oritech-common-<minecraft-version>-intermediary:<oritech-version>"
}
```

### Fabric

The Fabric module is published in intermediary mappings.

```groovy
dependencies {
    // Fabric Loom or Architectury Loom
    modImplementation "rearth.oritech:oritech-fabric-<minecraft-version>:<oritech-version>"
}
```

### NeoForge

The NeoForge module is published in Mojang mappings. It is not possible to get an intermediary artifact for this module.
You can use it with yarn mappings, but it will not be remapped and have clashing names. It's still possible to use
common code, though.

```groovy
dependencies {
    // ModDevGradle or Architectury Loom
    implementation "rearth.oritech:oritech-neoforge-<minecraft-version>:<oritech-version>"
}
```

## Contributing

Contributions are what make the open source community such an amazing place to be learn, inspire, and create. Any
contributions you make are **greatly appreciated**. However, I do have a specific vision for the mod and what content
would fit, so for content and balance changes please reach out to me first (via github issue/discussion or discord)

* If you have suggestions for adding or removing projects, feel free
  to [open an issue](https://github.com/rearth/Oritech/issues/new) to discuss it, or directly create a pull request
  after you edit the *README.md* file with necessary changes.
* Please make sure you check your spelling and grammar.
* Create individual PR for each suggestion.

## Credits

This mod is heavily inspired by the original techarium mod, which sadly hasn't been released in a playable version yet. A lot of the machine names and models
were taken or strongly inspired by techarium. Huge thanks to the original techarium devs (YCar and Gecko and everyone else involved) for creating
the assets and ideas, and also for making them available under the [CC BY-NC 4.0 DEED](https://creativecommons.org/licenses/by-nc/4.0/) license.

Some blocks and item textures are also from malcolmriley's unused-textures repository. Huge thanks to him for making those available as well (under the [CC BY 4.0 DEED](https://creativecommons.org/licenses/by/4.0/) license).

In detail, these are the following items that are from the above-mentioned sources:
* From [ArtOfTecharium](https://github.com/Ycarx/artoftecharium) (animations and textures were slightly modified, e.g. addon ports added, etc.)
  * Assembler Model
  * Foundry Model
  * Laser Arm Model
  * Powered Furnace Model
  * Energy Acceptor Model
  * Machine Extender Texture
  * Exosuit Model
  * Deep Drill Model
  * Ceiling Lights
  * Tech Door, Lever, Button
  * Machine Platings
  * Metal Beam
  * Charger Model (heavily modified)
* From [malcolmriley's unused-textures repo](https://github.com/malcolmriley/unused-textures)
  * Oil fluid textures (the dark gas texture)
  * The withered crop textures
  * Most of the crafting component textures

## Acknowledgements

* Kekie6, for creating the energy pipe and big solar panel models
* glisco, the creator of owo-lib, for creating this awesome library and supporting in its usage
* unilock, for providing most of the work on the EMI integration
* The creators and maintainers of Geckolib for creating the great animation engine, and helping out in their discord
* [LyFl0w's texture maker](https://github.com/LyFl0w/TextureMaker), which has been used for item textures. Around 10 textures made with it are still in use.
* Ycar, for creating all tiers of the machine core textures
* BBoldt and BLOKBUSTR, for providing most of the metal item variant textures
* jshipley, for a lot of contributions with new features, block, mechanics and bugfixes
* CrazyMiner34, for improvements to item rendering in 3rd person & the wrench texture
* NovaKatt, for creating most of the metal / compacted block textures, as well as the pipe duct textures
* The_Dvil, for creating the initial framed pipe concepts and models
* Armen, for making pipes configurable, adding pipe ducts/framed variants, and a ton of additional stuff
* VasariRulez, for improving compatibility of the enderic laser with AE2 quartz clusters
* Relentless, for migrating the project to Mojang mappings and help with Maven publishing

## Sound Credits
 * Nuke Explosion: Atomic Explosion and Sub Rumble.wav by GowlerMusic -- https://freesound.org/s/265459/ -- License: Attribution 4.0
 * Bio Generator: Squishy Gore.mp3 by DigPro120 -- https://freesound.org/s/432653/ -- License: Creative Commons 0
 * Generators: Spinning reel.wav by tosha73 -- https://freesound.org/s/509902/ -- License: Creative Commons 0
 * Lava Generator: Heavy Bubbles by casiba842 -- https://freesound.org/s/577880/ -- License: Creative Commons 0
 * Furnace: burning-fire-steam.wav by laribum -- https://freesound.org/s/213802/ -- License: Creative Commons 0
 * Drone takeoff: Mini Quadcopter Flying Loop by simeonradivoev -- https://freesound.org/s/383852/ -- License: Creative Commons 0