//-----------------------------------------------------------------------------
// 2022 Ahoy, https://github.com/lumpapu/ahoy
// Creative Commons - http://creativecommons.org/licenses/by-nc-sa/3.0/de/
//-----------------------------------------------------------------------------

#include "crc.h"

namespace ah {
    uint8_t crc8(uint8_t buf[], uint8_t len) {
        uint8_t crc = CRC8_INIT;
        for(uint8_t i = 0; i < len; i++) {
            crc ^= buf[i];
            for(uint8_t b = 0; b < 8; b ++) {
                crc = (crc << 1) ^ ((crc & 0x80) ? CRC8_POLY : 0x00);
            }
        }
        return crc;
    }

    uint16_t crc16(uint8_t buf[], uint8_t len, uint16_t start) {
        uint16_t crc = start;
        uint8_t shift = 0;

        for(uint8_t i = 0; i < len; i ++) {
            crc = crc ^ buf[i];
            for(uint8_t bit = 0; bit < 8; bit ++) {
                shift = (crc & 0x0001);
                crc = crc >> 1;
                if(shift != 0)
                    crc = crc ^ CRC16_MODBUS_POLYNOM;
            }
        }
        return crc;
    }
}
