<?php

// Copyright (c) ppy Pty Ltd <contact@ppy.sh>. Licensed under the GNU Affero General Public License v3.0.
// See the LICENCE file in the repository root for full licence text.

return [
    'beatmapset_update_notice' => [
        'new' => 'Just letting you know that there has been a new update in beatmap ":title" since your last visit.',
        'subject' => 'New update for beatmap ":title"',
        'unwatch' => 'If you no longer wish to watch this beatmap, you can either click the "Unwatch" link found in the page above, or from the modding watchlist page:',
        'visit' => 'Visit the discussion page here:',
    ],

    'common' => [
        'closing' => 'Regards,',
        'hello' => 'Hi :user,',
        'report' => 'Please reply to this email IMMEDIATELY if you did not request this change.',
    ],

    'donation_thanks' => [
        'benefit_more' => 'More new supporter benefits will appear over time, as well!',
        'feedback' => "If you have any questions or feedback, don't hesitate to reply to this mail; I'll get back to you as soon as possible!",
        'keep_free' => 'It is thanks to people like you that osu! is able to keep the game and community running smoothly without any advertisements or forced payments.',
        'keep_running' => 'Your support keeps osu! running for around :minutes! It may not seem like much, but it all adds up :).',
        'subject' => 'Thanks, osu! <3s you',
        'translation' => 'A community-provided translation for informational purposes follows:',

        'benefit' => [
            'gift' => 'Your giftee(s) will now have access to osu!direct and many other supporter benefits.',
            'self' => 'You will now have access to osu!direct and many other supporter benefits for :duration.',
        ],

        'support' => [
            '_' => 'Thanks a lot for your :support towards osu!.',
            'first' => 'support',
            'repeat' => 'continued support',
        ],
    ],

    'forum_new_reply' => [
        'new' => 'Just letting you know that there has been a new reply in ":title" since your last visit.',
        'subject' => '[osu!] New reply for topic ":title"',
        'unwatch' => 'If you no longer wish to watch this topic, you can either click the "Unsubscribe topic" link found at the bottom of the topic above, or from topic subscriptions management page:',
        'visit' => 'Jump straight to the latest reply using the following link:',
    ],

    'password_reset' => [
        'code' => 'Your verification code is:',
        'requested' => 'Either you or someone pretending to be you has requested a password reset on your osu! account.',
        'subject' => 'osu! account recover',
    ],

    'store_payment_completed' => [
        'prepare_shipping' => 'We have received your payment and are preparing your order for shipping. It may take a few days for us to send it out, depending on the quantity of orders. You can follow the progress of your order here, including tracking details where available:',
        'processing' => 'We have received your payment and are currently processing your order. You can follow the progress of your order here:',
        'questions' => "If you have any questions, don't hesitate to reply to this email.",
        'shipping' => 'Shipping',
        'subject' => 'We received your osu!store order!',
        'thank_you' => 'Thanks for your osu!store order!',
        'total' => 'Total',
    ],

    'supporter_gift' => [
        'anonymous_gift' => 'The person who gifted you this tag may choose to remain anonymous, so they have not been mentioned in this notification.',
        'anonymous_gift_maybe_not' => 'But you likely already know who it is ;).',
        'duration' => 'Thanks to them, you have access to osu!direct and other osu!supporter benefits for the next :duration.',
        'features' => 'You can find out more details on these features here:',
        'gifted' => 'Someone has just gifted you an osu!supporter tag!',
        'subject' => 'You have been gifted an osu!supporter tag!',
    ],

    'user_email_updated' => [
        'changed_to' => 'This is a confirmation email to inform you that your osu! email address has been changed to: ":email".',
        'check' => 'Please ensure that you received this email at your new address to prevent losing access your osu! account in the future.',
        'sent' => 'For security reasons, this email has been sent both to your new and old email address.',
        'subject' => 'osu! email change confirmation',
    ],

    'user_force_reactivation' => [
        'main' => 'Your account is suspected to have been compromised, has recent suspicious activity or a VERY weak password. As a result, we require you to set a new password. Please make sure to choose a SECURE password.',
        'perform_reset' => 'You can perform the reset from :url',
        'reason' => 'Reason:',
        'subject' => 'osu! Account Reactivation Required',
    ],

    'user_notification_digest' => [
        'new' => 'Just letting you know that there have been new updates on items you are watching.',
        'settings' => 'Change email notification preferences:',
        'subject' => 'New osu! notifications',
    ],

    'user_password_updated' => [
        'confirmation' => 'This is just a confirmation that your osu! password has been changed.',
        'subject' => 'osu! password change confirmation',
    ],

    'user_verification' => [
        'code' => 'Your verification code is:',
        'code_hint' => 'You can enter the code with or without spaces.',
        'link' => 'Alternatively, you can also visit this link below to finish verification:',
        'report' => 'If you did not request this, please REPLY IMMEDIATELY as your account may be in danger.',
        'subject' => 'osu! account verification',

        'action_from' => [
            '_' => 'An action performed on your account from :country requires verification.',
            'unknown_country' => 'unknown country',
        ],
    ],
];
