# InstructLab UI

![Lint](https://github.com/instructlab/ui/actions/workflows/lint-ui.yml/badge.svg?branch=main)
![Image](https://github.com/instructlab/ui/actions/workflows/images.yml/badge.svg?branch=main)

Project aims to provide a UI based interface to the contributors and reviewers to submit and review contribution to [instructlab/taxonomy](https://github.com/instructlab/taxonomy).
The intention is to simplify the process of contribution by providing a user friendly interface, that doesn't require the user to have a deep understanding of tools required to contribute skill and knowledge to the taxonomy. This project also aims to provide a platform for the reviewers to efficiently review the contributions and provide feedback to the contributors.

## Overview

Current scope of the project is to work on following personas:

- Taxonomy **Contributor**: Person who wants to contribute a skill or a knowledge to the taxonomy.
- Taxonomy **Triager**: Person who has expertise to review the contributions and provide feedback to the contributors.

The technical overview and developer docs for getting started can be found [here](docs/development.md).

## Contributing

If you have suggestions for how instructlab/ui could be improved, or want to
report a bug, open an [issue](https://github.com/instructlab/ui/issues)! We'd love all and any contributions.

For more, check out the [InstructLab UI Contribution Guide](CONTRIBUTING.md)
and [InstructLab Community Guide](https://github.com/instructlab/community/blob/main/CONTRIBUTING.md).

## Community Meeting

We have a weekly community meeting to discuss the project and contributions. Meeting happens **every Wednesday 10AM PST**.
Please subscribe to the InstructLab Community Calendar following the instructions [here](https://github.com/instructlab/community/blob/main/Collaboration.md). UI project meeting details are present in the calendar event.

## Slack channel

Please subscribe to the InstructLab Slack workspace by following the instructions [here](https://github.com/instructlab/community/blob/main/Collaboration.md#chat). Once you are part of the workspace, you can join the `#ui` channel where most of the project related topics are discussed.

## License

[Apache 2.0](LICENSE)
