/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.app.IUiAutomationConnection;
import android.graphics.Bitmap;
import android.hardware.input.InputManager;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.view.IWindowManager;
import android.view.InputEvent;
import android.view.SurfaceControl;
import android.view.accessibility.IAccessibilityManager;

public final class UiAutomationConnection
extends IUiAutomationConnection.Stub {
    private static final int INITIAL_FROZEN_ROTATION_UNSPECIFIED = -1;
    private final IWindowManager mWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
    private final Object mLock = new Object();
    private final Binder mToken = new Binder();
    private int mInitialFrozenRotation = -1;
    private IAccessibilityServiceClient mClient;
    private boolean mIsShutdown;
    private int mOwningUid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(IAccessibilityServiceClient client) {
        if (client == null) {
            throw new IllegalArgumentException("Client cannot be null!");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfShutdownLocked();
            if (this.isConnectedLocked()) {
                throw new IllegalStateException("Already connected.");
            }
            this.mOwningUid = Binder.getCallingUid();
            this.registerUiTestAutomationServiceLocked(client);
            this.storeRotationStateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            if (!this.isConnectedLocked()) {
                throw new IllegalStateException("Already disconnected.");
            }
            this.mOwningUid = -1;
            this.unregisterUiTestAutomationServiceLocked();
            this.restoreRotationStateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean injectInputEvent(InputEvent event, boolean sync) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        int mode = sync ? 2 : 0;
        long identity = Binder.clearCallingIdentity();
        try {
            boolean bl = InputManager.getInstance().injectInputEvent(event, mode);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setRotation(int rotation) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            if (rotation == -2) {
                this.mWindowManager.thawRotation();
            } else {
                this.mWindowManager.freezeRotation(rotation);
            }
            boolean bl = true;
            return bl;
        }
        catch (RemoteException re) {
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap takeScreenshot(int width, int height) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            Bitmap bitmap = SurfaceControl.screenshot(width, height);
            return bitmap;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isConnectedLocked()) {
                this.throwIfCalledByNotTrustedUidLocked();
            }
            this.throwIfShutdownLocked();
            this.mIsShutdown = true;
            if (this.isConnectedLocked()) {
                this.disconnect();
            }
        }
    }

    private void registerUiTestAutomationServiceLocked(IAccessibilityServiceClient client) {
        IAccessibilityManager manager = IAccessibilityManager.Stub.asInterface(ServiceManager.getService("accessibility"));
        AccessibilityServiceInfo info = new AccessibilityServiceInfo();
        info.eventTypes = -1;
        info.feedbackType = 16;
        info.flags |= 0x12;
        info.setCapabilities(15);
        try {
            manager.registerUiTestAutomationService(this.mToken, client, info);
            this.mClient = client;
        }
        catch (RemoteException re) {
            throw new IllegalStateException("Error while registering UiTestAutomationService.", re);
        }
    }

    private void unregisterUiTestAutomationServiceLocked() {
        IAccessibilityManager manager = IAccessibilityManager.Stub.asInterface(ServiceManager.getService("accessibility"));
        try {
            manager.unregisterUiTestAutomationService(this.mClient);
            this.mClient = null;
        }
        catch (RemoteException re) {
            throw new IllegalStateException("Error while unregistering UiTestAutomationService", re);
        }
    }

    private void storeRotationStateLocked() {
        try {
            if (this.mWindowManager.isRotationFrozen()) {
                this.mInitialFrozenRotation = this.mWindowManager.getRotation();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void restoreRotationStateLocked() {
        try {
            if (this.mInitialFrozenRotation != -1) {
                this.mWindowManager.freezeRotation(this.mInitialFrozenRotation);
            } else {
                this.mWindowManager.thawRotation();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private boolean isConnectedLocked() {
        return this.mClient != null;
    }

    private void throwIfShutdownLocked() {
        if (this.mIsShutdown) {
            throw new IllegalStateException("Connection shutdown!");
        }
    }

    private void throwIfNotConnectedLocked() {
        if (!this.isConnectedLocked()) {
            throw new IllegalStateException("Not connected!");
        }
    }

    private void throwIfCalledByNotTrustedUidLocked() {
        int callingUid = Binder.getCallingUid();
        if (callingUid != this.mOwningUid && this.mOwningUid != 1000 && callingUid != 0) {
            throw new SecurityException("Calling from not trusted UID!");
        }
    }
}

