/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.base;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.os.Handler;
import android.os.Looper;

public class CallbackFilter
extends Filter {
    @GenerateFieldPort(name="listener", hasDefault=true)
    private FilterContext.OnFrameReceivedListener mListener;
    @GenerateFieldPort(name="userData", hasDefault=true)
    private Object mUserData;
    @GenerateFinalPort(name="callUiThread", hasDefault=true)
    private boolean mCallbacksOnUiThread = true;
    private Handler mUiThreadHandler;

    public CallbackFilter(String name) {
        super(name);
    }

    public void setupPorts() {
        this.addInputPort("frame");
    }

    public void prepare(FilterContext context) {
        if (this.mCallbacksOnUiThread) {
            this.mUiThreadHandler = new Handler(Looper.getMainLooper());
        }
    }

    public void process(FilterContext context) {
        Frame input = this.pullInput("frame");
        if (this.mListener != null) {
            if (this.mCallbacksOnUiThread) {
                input.retain();
                CallbackRunnable uiRunnable = new CallbackRunnable(this.mListener, this, input, this.mUserData);
                if (!this.mUiThreadHandler.post(uiRunnable)) {
                    throw new RuntimeException("Unable to send callback to UI thread!");
                }
            } else {
                this.mListener.onFrameReceived(this, input, this.mUserData);
            }
        } else {
            throw new RuntimeException("CallbackFilter received frame, but no listener set!");
        }
    }

    private class CallbackRunnable
    implements Runnable {
        private Filter mFilter;
        private Frame mFrame;
        private Object mUserData;
        private FilterContext.OnFrameReceivedListener mListener;

        public CallbackRunnable(FilterContext.OnFrameReceivedListener listener, Filter filter, Frame frame, Object userData) {
            this.mListener = listener;
            this.mFilter = filter;
            this.mFrame = frame;
            this.mUserData = userData;
        }

        public void run() {
            this.mListener.onFrameReceived(this.mFilter, this.mFrame, this.mUserData);
            this.mFrame.release();
        }
    }
}

