/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.NativeProgram;
import android.filterfw.core.Program;

public class ToRGBAFilter
extends Filter {
    private int mInputBPP;
    private Program mProgram;
    private FrameFormat mLastFormat = null;

    public ToRGBAFilter(String name) {
        super(name);
    }

    public void setupPorts() {
        MutableFrameFormat mask = new MutableFrameFormat(2, 2);
        mask.setDimensionCount(2);
        this.addMaskedInputPort("image", mask);
        this.addOutputBasedOnInput("image", "image");
    }

    public FrameFormat getOutputFormat(String portName, FrameFormat inputFormat) {
        return this.getConvertedFormat(inputFormat);
    }

    public FrameFormat getConvertedFormat(FrameFormat format) {
        MutableFrameFormat result = format.mutableCopy();
        result.setMetaValue("colorspace", 3);
        result.setBytesPerSample(4);
        return result;
    }

    public void createProgram(FilterContext context, FrameFormat format) {
        this.mInputBPP = format.getBytesPerSample();
        if (this.mLastFormat != null && this.mLastFormat.getBytesPerSample() == this.mInputBPP) {
            return;
        }
        this.mLastFormat = format;
        switch (this.mInputBPP) {
            case 1: {
                this.mProgram = new NativeProgram("filterpack_imageproc", "gray_to_rgba");
                break;
            }
            case 3: {
                this.mProgram = new NativeProgram("filterpack_imageproc", "rgb_to_rgba");
                break;
            }
            default: {
                throw new RuntimeException("Unsupported BytesPerPixel: " + this.mInputBPP + "!");
            }
        }
    }

    public void process(FilterContext context) {
        Frame input = this.pullInput("image");
        this.createProgram(context, input.getFormat());
        Frame output = context.getFrameManager().newFrame(this.getConvertedFormat(input.getFormat()));
        this.mProgram.process(input, output);
        this.pushOutput("image", output);
        output.release();
    }
}

