/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;

public final class LargeBitmap {
    private int mNativeLargeBitmap;
    private boolean mRecycled;

    private LargeBitmap(int lbm) {
        this.mNativeLargeBitmap = lbm;
        this.mRecycled = false;
    }

    public Bitmap decodeRegion(Rect rect, BitmapFactory.Options options) {
        this.checkRecycled("decodeRegion called on recycled large bitmap");
        if (rect.left < 0 || rect.top < 0 || rect.right > this.getWidth() || rect.bottom > this.getHeight()) {
            throw new IllegalArgumentException("rectangle is not inside the image");
        }
        return LargeBitmap.nativeDecodeRegion(this.mNativeLargeBitmap, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, options);
    }

    public int getWidth() {
        this.checkRecycled("getWidth called on recycled large bitmap");
        return LargeBitmap.nativeGetWidth(this.mNativeLargeBitmap);
    }

    public int getHeight() {
        this.checkRecycled("getHeight called on recycled large bitmap");
        return LargeBitmap.nativeGetHeight(this.mNativeLargeBitmap);
    }

    public void recycle() {
        if (!this.mRecycled) {
            LargeBitmap.nativeClean(this.mNativeLargeBitmap);
            this.mRecycled = true;
        }
    }

    public final boolean isRecycled() {
        return this.mRecycled;
    }

    private void checkRecycled(String errorMessage) {
        if (this.mRecycled) {
            throw new IllegalStateException(errorMessage);
        }
    }

    protected void finalize() {
        this.recycle();
    }

    private static native Bitmap nativeDecodeRegion(int var0, int var1, int var2, int var3, int var4, BitmapFactory.Options var5);

    private static native int nativeGetWidth(int var0);

    private static native int nativeGetHeight(int var0);

    private static native void nativeClean(int var0);
}

