/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.content.Context;
import android.hardware.input.IInputDevicesChangedListener;
import android.hardware.input.IInputManager;
import android.hardware.input.KeyboardLayout;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.Vibrator;
import android.provider.Settings;
import android.util.Log;
import android.util.SparseArray;
import android.view.InputDevice;
import android.view.InputEvent;
import com.android.internal.util.ArrayUtils;
import java.util.ArrayList;

public final class InputManager {
    private static final String TAG = "InputManager";
    private static final boolean DEBUG = false;
    private static final int MSG_DEVICE_ADDED = 1;
    private static final int MSG_DEVICE_REMOVED = 2;
    private static final int MSG_DEVICE_CHANGED = 3;
    private static InputManager sInstance;
    private final IInputManager mIm;
    private final Object mInputDevicesLock = new Object();
    private SparseArray<InputDevice> mInputDevices;
    private InputDevicesChangedListener mInputDevicesChangedListener;
    private final ArrayList<InputDeviceListenerDelegate> mInputDeviceListeners = new ArrayList();
    public static final String ACTION_QUERY_KEYBOARD_LAYOUTS = "android.hardware.input.action.QUERY_KEYBOARD_LAYOUTS";
    public static final String META_DATA_KEYBOARD_LAYOUTS = "android.hardware.input.metadata.KEYBOARD_LAYOUTS";
    public static final int MIN_POINTER_SPEED = -7;
    public static final int MAX_POINTER_SPEED = 7;
    public static final int DEFAULT_POINTER_SPEED = 0;
    public static final int INJECT_INPUT_EVENT_MODE_ASYNC = 0;
    public static final int INJECT_INPUT_EVENT_MODE_WAIT_FOR_RESULT = 1;
    public static final int INJECT_INPUT_EVENT_MODE_WAIT_FOR_FINISH = 2;

    private InputManager(IInputManager im) {
        this.mIm = im;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputManager getInstance() {
        Class<InputManager> clazz = InputManager.class;
        synchronized (InputManager.class) {
            if (sInstance == null) {
                IBinder b = ServiceManager.getService("input");
                sInstance = new InputManager(IInputManager.Stub.asInterface(b));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputDevice getInputDevice(int id2) {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            this.populateInputDevicesLocked();
            int index = this.mInputDevices.indexOfKey(id2);
            if (index < 0) {
                return null;
            }
            InputDevice inputDevice = this.mInputDevices.valueAt(index);
            if (inputDevice == null) {
                try {
                    inputDevice = this.mIm.getInputDevice(id2);
                }
                catch (RemoteException ex) {
                    throw new RuntimeException("Could not get input device information.", ex);
                }
                if (inputDevice != null) {
                    this.mInputDevices.setValueAt(index, inputDevice);
                }
            }
            return inputDevice;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputDevice getInputDeviceByDescriptor(String descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor must not be null.");
        }
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            this.populateInputDevicesLocked();
            int numDevices = this.mInputDevices.size();
            for (int i = 0; i < numDevices; ++i) {
                InputDevice inputDevice = this.mInputDevices.valueAt(i);
                if (inputDevice == null) {
                    int id2 = this.mInputDevices.keyAt(i);
                    try {
                        inputDevice = this.mIm.getInputDevice(id2);
                    }
                    catch (RemoteException ex) {
                        // empty catch block
                    }
                    if (inputDevice == null) continue;
                    this.mInputDevices.setValueAt(i, inputDevice);
                }
                if (!descriptor.equals(inputDevice.getDescriptor())) continue;
                return inputDevice;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getInputDeviceIds() {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            this.populateInputDevicesLocked();
            int count = this.mInputDevices.size();
            int[] ids = new int[count];
            for (int i = 0; i < count; ++i) {
                ids[i] = this.mInputDevices.keyAt(i);
            }
            return ids;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInputDeviceListener(InputDeviceListener listener, Handler handler) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            int index = this.findInputDeviceListenerLocked(listener);
            if (index < 0) {
                this.mInputDeviceListeners.add(new InputDeviceListenerDelegate(listener, handler));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterInputDeviceListener(InputDeviceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            int index = this.findInputDeviceListenerLocked(listener);
            if (index >= 0) {
                InputDeviceListenerDelegate d = this.mInputDeviceListeners.get(index);
                d.removeCallbacksAndMessages(null);
                this.mInputDeviceListeners.remove(index);
            }
        }
    }

    private int findInputDeviceListenerLocked(InputDeviceListener listener) {
        int numListeners = this.mInputDeviceListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            if (this.mInputDeviceListeners.get((int)i).mListener != listener) continue;
            return i;
        }
        return -1;
    }

    public KeyboardLayout[] getKeyboardLayouts() {
        try {
            return this.mIm.getKeyboardLayouts();
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Could not get list of keyboard layout informations.", ex);
            return new KeyboardLayout[0];
        }
    }

    public KeyboardLayout getKeyboardLayout(String keyboardLayoutDescriptor) {
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            return this.mIm.getKeyboardLayout(keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Could not get keyboard layout information.", ex);
            return null;
        }
    }

    public String getCurrentKeyboardLayoutForInputDevice(String inputDeviceDescriptor) {
        if (inputDeviceDescriptor == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        try {
            return this.mIm.getCurrentKeyboardLayoutForInputDevice(inputDeviceDescriptor);
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Could not get current keyboard layout for input device.", ex);
            return null;
        }
    }

    public void setCurrentKeyboardLayoutForInputDevice(String inputDeviceDescriptor, String keyboardLayoutDescriptor) {
        if (inputDeviceDescriptor == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.setCurrentKeyboardLayoutForInputDevice(inputDeviceDescriptor, keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Could not set current keyboard layout for input device.", ex);
        }
    }

    public String[] getKeyboardLayoutsForInputDevice(String inputDeviceDescriptor) {
        if (inputDeviceDescriptor == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        try {
            return this.mIm.getKeyboardLayoutsForInputDevice(inputDeviceDescriptor);
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Could not get keyboard layouts for input device.", ex);
            return ArrayUtils.emptyArray(String.class);
        }
    }

    public void addKeyboardLayoutForInputDevice(String inputDeviceDescriptor, String keyboardLayoutDescriptor) {
        if (inputDeviceDescriptor == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.addKeyboardLayoutForInputDevice(inputDeviceDescriptor, keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Could not add keyboard layout for input device.", ex);
        }
    }

    public void removeKeyboardLayoutForInputDevice(String inputDeviceDescriptor, String keyboardLayoutDescriptor) {
        if (inputDeviceDescriptor == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.removeKeyboardLayoutForInputDevice(inputDeviceDescriptor, keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Could not remove keyboard layout for input device.", ex);
        }
    }

    public int getPointerSpeed(Context context) {
        int speed = 0;
        try {
            speed = Settings.System.getInt(context.getContentResolver(), "pointer_speed");
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            // empty catch block
        }
        return speed;
    }

    public void setPointerSpeed(Context context, int speed) {
        if (speed < -7 || speed > 7) {
            throw new IllegalArgumentException("speed out of range");
        }
        Settings.System.putInt(context.getContentResolver(), "pointer_speed", speed);
    }

    public void tryPointerSpeed(int speed) {
        if (speed < -7 || speed > 7) {
            throw new IllegalArgumentException("speed out of range");
        }
        try {
            this.mIm.tryPointerSpeed(speed);
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Could not set temporary pointer speed.", ex);
        }
    }

    public boolean[] deviceHasKeys(int[] keyCodes) {
        return this.deviceHasKeys(-1, keyCodes);
    }

    public boolean[] deviceHasKeys(int id2, int[] keyCodes) {
        boolean[] ret = new boolean[keyCodes.length];
        try {
            this.mIm.hasKeys(id2, -256, keyCodes, ret);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return ret;
    }

    public boolean injectInputEvent(InputEvent event, int mode) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        if (mode != 0 && mode != 2 && mode != 1) {
            throw new IllegalArgumentException("mode is invalid");
        }
        try {
            return this.mIm.injectInputEvent(event, mode);
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    private void populateInputDevicesLocked() {
        if (this.mInputDevicesChangedListener == null) {
            InputDevicesChangedListener listener = new InputDevicesChangedListener();
            try {
                this.mIm.registerInputDevicesChangedListener(listener);
            }
            catch (RemoteException ex) {
                throw new RuntimeException("Could not get register input device changed listener", ex);
            }
            this.mInputDevicesChangedListener = listener;
        }
        if (this.mInputDevices == null) {
            int[] ids;
            try {
                ids = this.mIm.getInputDeviceIds();
            }
            catch (RemoteException ex) {
                throw new RuntimeException("Could not get input device ids.", ex);
            }
            this.mInputDevices = new SparseArray();
            for (int i = 0; i < ids.length; ++i) {
                this.mInputDevices.put(ids[i], null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInputDevicesChanged(int[] deviceIdAndGeneration) {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            int deviceId;
            int i = this.mInputDevices.size();
            while (--i > 0) {
                deviceId = this.mInputDevices.keyAt(i);
                if (InputManager.containsDeviceId(deviceIdAndGeneration, deviceId)) continue;
                this.mInputDevices.removeAt(i);
                this.sendMessageToInputDeviceListenersLocked(2, deviceId);
            }
            for (i = 0; i < deviceIdAndGeneration.length; i += 2) {
                deviceId = deviceIdAndGeneration[i];
                int index = this.mInputDevices.indexOfKey(deviceId);
                if (index >= 0) {
                    InputDevice device = this.mInputDevices.valueAt(index);
                    if (device == null) continue;
                    int generation = deviceIdAndGeneration[i + 1];
                    if (device.getGeneration() == generation) continue;
                    this.mInputDevices.setValueAt(index, null);
                    this.sendMessageToInputDeviceListenersLocked(3, deviceId);
                    continue;
                }
                this.mInputDevices.put(deviceId, null);
                this.sendMessageToInputDeviceListenersLocked(1, deviceId);
            }
        }
    }

    private void sendMessageToInputDeviceListenersLocked(int what, int deviceId) {
        int numListeners = this.mInputDeviceListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            InputDeviceListenerDelegate listener = this.mInputDeviceListeners.get(i);
            listener.sendMessage(listener.obtainMessage(what, deviceId, 0));
        }
    }

    private static boolean containsDeviceId(int[] deviceIdAndGeneration, int deviceId) {
        for (int i = 0; i < deviceIdAndGeneration.length; i += 2) {
            if (deviceIdAndGeneration[i] != deviceId) continue;
            return true;
        }
        return false;
    }

    public Vibrator getInputDeviceVibrator(int deviceId) {
        return new InputDeviceVibrator(deviceId);
    }

    private final class InputDeviceVibrator
    extends Vibrator {
        private final int mDeviceId;
        private final Binder mToken;

        public InputDeviceVibrator(int deviceId) {
            this.mDeviceId = deviceId;
            this.mToken = new Binder();
        }

        public boolean hasVibrator() {
            return true;
        }

        public void vibrate(long milliseconds) {
            this.vibrate(new long[]{0L, milliseconds}, -1);
        }

        public void vibrate(long[] pattern, int repeat) {
            if (repeat >= pattern.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            try {
                InputManager.this.mIm.vibrate(this.mDeviceId, pattern, repeat, this.mToken);
            }
            catch (RemoteException ex) {
                Log.w(InputManager.TAG, "Failed to vibrate.", ex);
            }
        }

        public void vibrate(int owningUid, String owningPackage, long milliseconds) {
            this.vibrate(milliseconds);
        }

        public void vibrate(int owningUid, String owningPackage, long[] pattern, int repeat) {
            this.vibrate(pattern, repeat);
        }

        public void cancel() {
            try {
                InputManager.this.mIm.cancelVibrate(this.mDeviceId, this.mToken);
            }
            catch (RemoteException ex) {
                Log.w(InputManager.TAG, "Failed to cancel vibration.", ex);
            }
        }
    }

    private static final class InputDeviceListenerDelegate
    extends Handler {
        public final InputDeviceListener mListener;

        public InputDeviceListenerDelegate(InputDeviceListener listener, Handler handler) {
            super(handler != null ? handler.getLooper() : Looper.myLooper());
            this.mListener = listener;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.mListener.onInputDeviceAdded(msg.arg1);
                    break;
                }
                case 2: {
                    this.mListener.onInputDeviceRemoved(msg.arg1);
                    break;
                }
                case 3: {
                    this.mListener.onInputDeviceChanged(msg.arg1);
                }
            }
        }
    }

    private final class InputDevicesChangedListener
    extends IInputDevicesChangedListener.Stub {
        private InputDevicesChangedListener() {
        }

        public void onInputDevicesChanged(int[] deviceIdAndGeneration) throws RemoteException {
            InputManager.this.onInputDevicesChanged(deviceIdAndGeneration);
        }
    }

    public static interface InputDeviceListener {
        public void onInputDeviceAdded(int var1);

        public void onInputDeviceRemoved(int var1);

        public void onInputDeviceChanged(int var1);
    }
}

