/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.Image;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ImageReader
implements AutoCloseable {
    private static final int ACQUIRE_SUCCESS = 0;
    private static final int ACQUIRE_NO_BUFS = 1;
    private static final int ACQUIRE_MAX_IMAGES = 2;
    private final int mWidth;
    private final int mHeight;
    private final int mFormat;
    private final int mMaxImages;
    private final int mNumPlanes;
    private final Surface mSurface;
    private final Object mListenerLock = new Object();
    private OnImageAvailableListener mListener;
    private ListenerHandler mListenerHandler;
    private long mNativeContext;

    public static ImageReader newInstance(int width, int height, int format, int maxImages) {
        return new ImageReader(width, height, format, maxImages);
    }

    protected ImageReader(int width, int height, int format, int maxImages) {
        this.mWidth = width;
        this.mHeight = height;
        this.mFormat = format;
        this.mMaxImages = maxImages;
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("The image dimensions must be positive");
        }
        if (this.mMaxImages < 1) {
            throw new IllegalArgumentException("Maximum outstanding image count must be at least 1");
        }
        if (format == 17) {
            throw new IllegalArgumentException("NV21 format is not supported");
        }
        this.mNumPlanes = this.getNumPlanesFromFormat();
        this.nativeInit(new WeakReference<ImageReader>(this), width, height, format, maxImages);
        this.mSurface = this.nativeGetSurface();
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getImageFormat() {
        return this.mFormat;
    }

    public int getMaxImages() {
        return this.mMaxImages;
    }

    public Surface getSurface() {
        return this.mSurface;
    }

    public Image acquireLatestImage() {
        Image image = this.acquireNextImage();
        if (image == null) {
            return null;
        }
        try {
            while (true) {
                Image next;
                if ((next = this.acquireNextImageNoThrowISE()) == null) {
                    Image result = image;
                    image = null;
                    Image image2 = result;
                    return image2;
                }
                image.close();
                image = next;
            }
        }
        finally {
            if (image != null) {
                image.close();
            }
        }
    }

    public Image acquireNextImageNoThrowISE() {
        SurfaceImage si = new SurfaceImage();
        return this.acquireNextSurfaceImage(si) == 0 ? si : null;
    }

    private int acquireNextSurfaceImage(SurfaceImage si) {
        int status = this.nativeImageSetup(si);
        switch (status) {
            case 0: {
                si.createSurfacePlanes();
                si.setImageValid(true);
            }
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown nativeImageSetup return code " + status));
            }
        }
        return status;
    }

    public Image acquireNextImage() {
        SurfaceImage si = new SurfaceImage();
        int status = this.acquireNextSurfaceImage(si);
        switch (status) {
            case 0: {
                return si;
            }
            case 1: {
                return null;
            }
            case 2: {
                throw new IllegalStateException(String.format("maxImages (%d) has already been acquired, call #close before acquiring more.", this.mMaxImages));
            }
        }
        throw new AssertionError((Object)("Unknown nativeImageSetup return code " + status));
    }

    private void releaseImage(Image i) {
        if (!(i instanceof SurfaceImage)) {
            throw new IllegalArgumentException("This image was not produced by an ImageReader");
        }
        SurfaceImage si = (SurfaceImage)i;
        if (si.getReader() != this) {
            throw new IllegalArgumentException("This image was not produced by this ImageReader");
        }
        si.clearSurfacePlanes();
        this.nativeReleaseImage(i);
        si.setImageValid(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnImageAvailableListener(OnImageAvailableListener listener, Handler handler) {
        Object object = this.mListenerLock;
        synchronized (object) {
            if (listener != null) {
                Looper looper;
                Looper looper2 = looper = handler != null ? handler.getLooper() : Looper.myLooper();
                if (looper == null) {
                    throw new IllegalArgumentException("handler is null but the current thread is not a looper");
                }
                if (this.mListenerHandler == null || this.mListenerHandler.getLooper() != looper) {
                    this.mListenerHandler = new ListenerHandler(looper);
                }
                this.mListener = listener;
            } else {
                this.mListener = null;
                this.mListenerHandler = null;
            }
        }
    }

    public void close() {
        this.setOnImageAvailableListener(null, null);
        this.nativeClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private int getNumPlanesFromFormat() {
        switch (this.mFormat) {
            case 17: 
            case 35: 
            case 842094169: {
                return 3;
            }
            case 16: {
                return 2;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 20: 
            case 32: 
            case 256: 
            case 538982489: 
            case 540422489: {
                return 1;
            }
        }
        throw new UnsupportedOperationException(String.format("Invalid format specified %d", this.mFormat));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postEventFromNative(Object selfRef) {
        ListenerHandler handler;
        WeakReference weakSelf = (WeakReference)selfRef;
        ImageReader ir = (ImageReader)weakSelf.get();
        if (ir == null) {
            return;
        }
        Object object = ir.mListenerLock;
        synchronized (object) {
            handler = ir.mListenerHandler;
        }
        if (handler != null) {
            handler.sendEmptyMessage(0);
        }
    }

    private synchronized native void nativeInit(Object var1, int var2, int var3, int var4, int var5);

    private synchronized native void nativeClose();

    private synchronized native void nativeReleaseImage(Image var1);

    private synchronized native Surface nativeGetSurface();

    private synchronized native int nativeImageSetup(Image var1);

    private static native void nativeClassInit();

    static {
        System.loadLibrary("media_jni");
        ImageReader.nativeClassInit();
    }

    private class SurfaceImage
    extends Image {
        private long mLockedBuffer;
        private long mTimestamp;
        private SurfacePlane[] mPlanes;
        private boolean mIsImageValid = false;

        public void close() {
            if (this.mIsImageValid) {
                ImageReader.this.releaseImage(this);
            }
        }

        public ImageReader getReader() {
            return ImageReader.this;
        }

        public int getFormat() {
            if (this.mIsImageValid) {
                return ImageReader.this.mFormat;
            }
            throw new IllegalStateException("Image is already released");
        }

        public int getWidth() {
            if (this.mIsImageValid) {
                return ImageReader.this.mWidth;
            }
            throw new IllegalStateException("Image is already released");
        }

        public int getHeight() {
            if (this.mIsImageValid) {
                return ImageReader.this.mHeight;
            }
            throw new IllegalStateException("Image is already released");
        }

        public long getTimestamp() {
            if (this.mIsImageValid) {
                return this.mTimestamp;
            }
            throw new IllegalStateException("Image is already released");
        }

        public Image.Plane[] getPlanes() {
            if (this.mIsImageValid) {
                return (Image.Plane[])this.mPlanes.clone();
            }
            throw new IllegalStateException("Image is already released");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private void setImageValid(boolean isValid) {
            this.mIsImageValid = isValid;
        }

        private boolean isImageValid() {
            return this.mIsImageValid;
        }

        private void clearSurfacePlanes() {
            if (this.mIsImageValid) {
                for (int i = 0; i < this.mPlanes.length; ++i) {
                    if (this.mPlanes[i] == null) continue;
                    this.mPlanes[i].clearBuffer();
                    this.mPlanes[i] = null;
                }
            }
        }

        private void createSurfacePlanes() {
            this.mPlanes = new SurfacePlane[ImageReader.this.mNumPlanes];
            for (int i = 0; i < ImageReader.this.mNumPlanes; ++i) {
                this.mPlanes[i] = this.nativeCreatePlane(i);
            }
        }

        private synchronized native ByteBuffer nativeImageGetBuffer(int var1);

        private synchronized native SurfacePlane nativeCreatePlane(int var1);

        private class SurfacePlane
        extends Image.Plane {
            private final int mIndex;
            private final int mPixelStride;
            private final int mRowStride;
            private ByteBuffer mBuffer;

            private SurfacePlane(int index, int rowStride, int pixelStride) {
                this.mIndex = index;
                this.mRowStride = rowStride;
                this.mPixelStride = pixelStride;
            }

            public ByteBuffer getBuffer() {
                if (!SurfaceImage.this.isImageValid()) {
                    throw new IllegalStateException("Image is already released");
                }
                if (this.mBuffer != null) {
                    return this.mBuffer;
                }
                this.mBuffer = SurfaceImage.this.nativeImageGetBuffer(this.mIndex);
                return this.mBuffer.order(ByteOrder.nativeOrder());
            }

            public int getPixelStride() {
                if (SurfaceImage.this.isImageValid()) {
                    return this.mPixelStride;
                }
                throw new IllegalStateException("Image is already released");
            }

            public int getRowStride() {
                if (SurfaceImage.this.isImageValid()) {
                    return this.mRowStride;
                }
                throw new IllegalStateException("Image is already released");
            }

            private void clearBuffer() {
                this.mBuffer = null;
            }
        }
    }

    private final class ListenerHandler
    extends Handler {
        public ListenerHandler(Looper looper) {
            super(looper, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            OnImageAvailableListener listener;
            Object object = ImageReader.this.mListenerLock;
            synchronized (object) {
                listener = ImageReader.this.mListener;
            }
            if (listener != null) {
                listener.onImageAvailable(ImageReader.this);
            }
        }
    }

    public static interface OnImageAvailableListener {
        public void onImageAvailable(ImageReader var1);
    }
}

