/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Bundle;
import android.view.Surface;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MediaCodec {
    public static final int BUFFER_FLAG_SYNC_FRAME = 1;
    public static final int BUFFER_FLAG_CODEC_CONFIG = 2;
    public static final int BUFFER_FLAG_END_OF_STREAM = 4;
    public static final int CONFIGURE_FLAG_ENCODE = 1;
    public static final int CRYPTO_MODE_UNENCRYPTED = 0;
    public static final int CRYPTO_MODE_AES_CTR = 1;
    public static final int INFO_TRY_AGAIN_LATER = -1;
    public static final int INFO_OUTPUT_FORMAT_CHANGED = -2;
    public static final int INFO_OUTPUT_BUFFERS_CHANGED = -3;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2;
    public static final String PARAMETER_KEY_VIDEO_BITRATE = "video-bitrate";
    public static final String PARAMETER_KEY_SUSPEND = "drop-input-frames";
    public static final String PARAMETER_KEY_REQUEST_SYNC_FRAME = "request-sync";
    private long mNativeContext;

    public static MediaCodec createDecoderByType(String type) {
        return new MediaCodec(type, true, false);
    }

    public static MediaCodec createEncoderByType(String type) {
        return new MediaCodec(type, true, true);
    }

    public static MediaCodec createByCodecName(String name) {
        return new MediaCodec(name, false, false);
    }

    private MediaCodec(String name, boolean nameIsType, boolean encoder) {
        this.native_setup(name, nameIsType, encoder);
    }

    protected void finalize() {
        this.native_finalize();
    }

    public final native void release();

    public void configure(MediaFormat format, Surface surface, MediaCrypto crypto, int flags) {
        Map<String, Object> formatMap = format.getMap();
        String[] keys = null;
        Object[] values = null;
        if (format != null) {
            keys = new String[formatMap.size()];
            values = new Object[formatMap.size()];
            int i = 0;
            for (Map.Entry<String, Object> entry : formatMap.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
        }
        this.native_configure(keys, values, surface, crypto, flags);
    }

    private final native void native_configure(String[] var1, Object[] var2, Surface var3, MediaCrypto var4, int var5);

    public final native Surface createInputSurface();

    public final native void start();

    public final native void stop();

    public final native void flush();

    public final native void queueInputBuffer(int var1, int var2, int var3, long var4, int var6) throws CryptoException;

    public final native void queueSecureInputBuffer(int var1, int var2, CryptoInfo var3, long var4, int var6) throws CryptoException;

    public final native int dequeueInputBuffer(long var1);

    public final native int dequeueOutputBuffer(BufferInfo var1, long var2);

    public final native void releaseOutputBuffer(int var1, boolean var2);

    public final native void signalEndOfInputStream();

    public final MediaFormat getOutputFormat() {
        return new MediaFormat(this.getOutputFormatNative());
    }

    private final native Map<String, Object> getOutputFormatNative();

    public ByteBuffer[] getInputBuffers() {
        return this.getBuffers(true);
    }

    public ByteBuffer[] getOutputBuffers() {
        return this.getBuffers(false);
    }

    public final native void setVideoScalingMode(int var1);

    public final native String getName();

    public final void setParameters(Bundle params) {
        if (params == null) {
            return;
        }
        String[] keys = new String[params.size()];
        Object[] values = new Object[params.size()];
        int i = 0;
        Iterator<String> i$ = params.keySet().iterator();
        while (i$.hasNext()) {
            String key;
            keys[i] = key = i$.next();
            values[i] = params.get(key);
            ++i;
        }
        this.setParameters(keys, values);
    }

    private final native void setParameters(String[] var1, Object[] var2);

    public MediaCodecInfo getCodecInfo() {
        return MediaCodecList.getCodecInfoAt(MediaCodecList.findCodecByName(this.getName()));
    }

    private final native ByteBuffer[] getBuffers(boolean var1);

    private static final native void native_init();

    private final native void native_setup(String var1, boolean var2, boolean var3);

    private final native void native_finalize();

    static {
        System.loadLibrary("media_jni");
        MediaCodec.native_init();
    }

    public static final class CryptoInfo {
        public int numSubSamples;
        public int[] numBytesOfClearData;
        public int[] numBytesOfEncryptedData;
        public byte[] key;
        public byte[] iv;
        public int mode;

        public void set(int newNumSubSamples, int[] newNumBytesOfClearData, int[] newNumBytesOfEncryptedData, byte[] newKey, byte[] newIV, int newMode) {
            this.numSubSamples = newNumSubSamples;
            this.numBytesOfClearData = newNumBytesOfClearData;
            this.numBytesOfEncryptedData = newNumBytesOfEncryptedData;
            this.key = newKey;
            this.iv = newIV;
            this.mode = newMode;
        }

        public String toString() {
            int i;
            StringBuilder builder = new StringBuilder();
            builder.append(this.numSubSamples + " subsamples, key [");
            String hexdigits = "0123456789abcdef";
            for (i = 0; i < this.key.length; ++i) {
                builder.append(hexdigits.charAt((this.key[i] & 0xF0) >> 4));
                builder.append(hexdigits.charAt(this.key[i] & 0xF));
            }
            builder.append("], iv [");
            for (i = 0; i < this.key.length; ++i) {
                builder.append(hexdigits.charAt((this.iv[i] & 0xF0) >> 4));
                builder.append(hexdigits.charAt(this.iv[i] & 0xF));
            }
            builder.append("], clear ");
            builder.append(Arrays.toString(this.numBytesOfClearData));
            builder.append(", encrypted ");
            builder.append(Arrays.toString(this.numBytesOfEncryptedData));
            return builder.toString();
        }
    }

    public static final class CryptoException
    extends RuntimeException {
        public static final int ERROR_NO_KEY = 1;
        public static final int ERROR_KEY_EXPIRED = 2;
        public static final int ERROR_RESOURCE_BUSY = 3;
        private int mErrorCode;

        public CryptoException(int errorCode, String detailMessage) {
            super(detailMessage);
            this.mErrorCode = errorCode;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }
    }

    public static final class BufferInfo {
        public int offset;
        public int size;
        public long presentationTimeUs;
        public int flags;

        public void set(int newOffset, int newSize, long newTimeUs, int newFlags) {
            this.offset = newOffset;
            this.size = newSize;
            this.presentationTimeUs = newTimeUs;
            this.flags = newFlags;
        }
    }
}

