/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.DeniedByServerException;
import android.media.NotProvisionedException;
import android.media.UnsupportedSchemeException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MediaDrm {
    private static final String TAG = "MediaDrm";
    private EventHandler mEventHandler;
    private OnEventListener mOnEventListener;
    private long mNativeContext;
    public static final int EVENT_PROVISION_REQUIRED = 1;
    public static final int EVENT_KEY_REQUIRED = 2;
    public static final int EVENT_KEY_EXPIRED = 3;
    public static final int EVENT_VENDOR_DEFINED = 4;
    private static final int DRM_EVENT = 200;
    public static final int KEY_TYPE_STREAMING = 1;
    public static final int KEY_TYPE_OFFLINE = 2;
    public static final int KEY_TYPE_RELEASE = 3;
    public static final String PROPERTY_VENDOR = "vendor";
    public static final String PROPERTY_VERSION = "version";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_ALGORITHMS = "algorithms";
    public static final String PROPERTY_DEVICE_UNIQUE_ID = "deviceUniqueId";

    public static final boolean isCryptoSchemeSupported(UUID uuid) {
        return MediaDrm.isCryptoSchemeSupportedNative(MediaDrm.getByteArrayFromUUID(uuid), null);
    }

    public static final boolean isCryptoSchemeSupported(UUID uuid, String mimeType) {
        return MediaDrm.isCryptoSchemeSupportedNative(MediaDrm.getByteArrayFromUUID(uuid), mimeType);
    }

    private static final byte[] getByteArrayFromUUID(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] uuidBytes = new byte[16];
        for (int i = 0; i < 8; ++i) {
            uuidBytes[i] = (byte)(msb >>> 8 * (7 - i));
            uuidBytes[8 + i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return uuidBytes;
    }

    private static final native boolean isCryptoSchemeSupportedNative(byte[] var0, String var1);

    public MediaDrm(UUID uuid) throws UnsupportedSchemeException {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.native_setup(new WeakReference<MediaDrm>(this), MediaDrm.getByteArrayFromUUID(uuid));
    }

    public void setOnEventListener(OnEventListener listener) {
        this.mOnEventListener = listener;
    }

    private static void postEventFromNative(Object mediadrm_ref, int eventType, int extra, Object obj) {
        MediaDrm md = (MediaDrm)((WeakReference)mediadrm_ref).get();
        if (md == null) {
            return;
        }
        if (md.mEventHandler != null) {
            Message m = md.mEventHandler.obtainMessage(200, eventType, extra, obj);
            md.mEventHandler.sendMessage(m);
        }
    }

    public native byte[] openSession() throws NotProvisionedException;

    public native void closeSession(byte[] var1);

    public native KeyRequest getKeyRequest(byte[] var1, byte[] var2, String var3, int var4, HashMap<String, String> var5) throws NotProvisionedException;

    public native byte[] provideKeyResponse(byte[] var1, byte[] var2) throws NotProvisionedException, DeniedByServerException;

    public native void restoreKeys(byte[] var1, byte[] var2);

    public native void removeKeys(byte[] var1);

    public native HashMap<String, String> queryKeyStatus(byte[] var1);

    public native ProvisionRequest getProvisionRequest();

    public native void provideProvisionResponse(byte[] var1) throws DeniedByServerException;

    public native List<byte[]> getSecureStops();

    public native void releaseSecureStops(byte[] var1);

    public native String getPropertyString(String var1);

    public native byte[] getPropertyByteArray(String var1);

    public native void setPropertyString(String var1, String var2);

    public native void setPropertyByteArray(String var1, byte[] var2);

    private static final native void setCipherAlgorithmNative(MediaDrm var0, byte[] var1, String var2);

    private static final native void setMacAlgorithmNative(MediaDrm var0, byte[] var1, String var2);

    private static final native byte[] encryptNative(MediaDrm var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    private static final native byte[] decryptNative(MediaDrm var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    private static final native byte[] signNative(MediaDrm var0, byte[] var1, byte[] var2, byte[] var3);

    private static final native boolean verifyNative(MediaDrm var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    public CryptoSession getCryptoSession(byte[] sessionId, String cipherAlgorithm, String macAlgorithm) {
        return new CryptoSession(this, sessionId, cipherAlgorithm, macAlgorithm);
    }

    protected void finalize() {
        this.native_finalize();
    }

    public final native void release();

    private static final native void native_init();

    private final native void native_setup(Object var1, byte[] var2);

    private final native void native_finalize();

    static {
        System.loadLibrary("media_jni");
        MediaDrm.native_init();
    }

    public final class CryptoSession {
        private MediaDrm mDrm;
        private byte[] mSessionId;

        CryptoSession(MediaDrm drm, byte[] sessionId, String cipherAlgorithm, String macAlgorithm) {
            this.mSessionId = sessionId;
            this.mDrm = drm;
            MediaDrm.setCipherAlgorithmNative(drm, sessionId, cipherAlgorithm);
            MediaDrm.setMacAlgorithmNative(drm, sessionId, macAlgorithm);
        }

        public byte[] encrypt(byte[] keyid, byte[] input, byte[] iv) {
            return MediaDrm.encryptNative(this.mDrm, this.mSessionId, keyid, input, iv);
        }

        public byte[] decrypt(byte[] keyid, byte[] input, byte[] iv) {
            return MediaDrm.decryptNative(this.mDrm, this.mSessionId, keyid, input, iv);
        }

        public byte[] sign(byte[] keyid, byte[] message) {
            return MediaDrm.signNative(this.mDrm, this.mSessionId, keyid, message);
        }

        public boolean verify(byte[] keyid, byte[] message, byte[] signature) {
            return MediaDrm.verifyNative(this.mDrm, this.mSessionId, keyid, message, signature);
        }
    }

    public static final class ProvisionRequest {
        private byte[] mData;
        private String mDefaultUrl;

        ProvisionRequest() {
        }

        public byte[] getData() {
            return this.mData;
        }

        public String getDefaultUrl() {
            return this.mDefaultUrl;
        }
    }

    public static final class KeyRequest {
        private byte[] mData;
        private String mDefaultUrl;

        KeyRequest() {
        }

        public byte[] getData() {
            return this.mData;
        }

        public String getDefaultUrl() {
            return this.mDefaultUrl;
        }
    }

    private class EventHandler
    extends Handler {
        private MediaDrm mMediaDrm;

        public EventHandler(MediaDrm md, Looper looper) {
            super(looper);
            this.mMediaDrm = md;
        }

        public void handleMessage(Message msg) {
            if (this.mMediaDrm.mNativeContext == 0L) {
                Log.w(MediaDrm.TAG, "MediaDrm went away with unhandled events");
                return;
            }
            switch (msg.what) {
                case 200: {
                    Log.i(MediaDrm.TAG, "Drm event (" + msg.arg1 + "," + msg.arg2 + ")");
                    if (MediaDrm.this.mOnEventListener != null && msg.obj != null && msg.obj instanceof Parcel) {
                        byte[] data;
                        Parcel parcel = (Parcel)msg.obj;
                        byte[] sessionId = parcel.createByteArray();
                        if (sessionId.length == 0) {
                            sessionId = null;
                        }
                        if ((data = parcel.createByteArray()).length == 0) {
                            data = null;
                        }
                        MediaDrm.this.mOnEventListener.onEvent(this.mMediaDrm, sessionId, msg.arg1, msg.arg2, data);
                    }
                    return;
                }
            }
            Log.e(MediaDrm.TAG, "Unknown message type " + msg.what);
        }
    }

    public static interface OnEventListener {
        public void onEvent(MediaDrm var1, byte[] var2, int var3, int var4, byte[] var5);
    }
}

