/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.PendingIntent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.media.AudioSystem;
import android.media.IAudioService;
import android.media.IRemoteControlClient;
import android.media.IRemoteControlDisplay;
import android.media.MediaMetadataEditor;
import android.media.Rating;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.Log;
import java.util.ArrayList;
import java.util.Iterator;

public class RemoteControlClient {
    private static final String TAG = "RemoteControlClient";
    private static final boolean DEBUG = false;
    public static final int PLAYSTATE_STOPPED = 1;
    public static final int PLAYSTATE_PAUSED = 2;
    public static final int PLAYSTATE_PLAYING = 3;
    public static final int PLAYSTATE_FAST_FORWARDING = 4;
    public static final int PLAYSTATE_REWINDING = 5;
    public static final int PLAYSTATE_SKIPPING_FORWARDS = 6;
    public static final int PLAYSTATE_SKIPPING_BACKWARDS = 7;
    public static final int PLAYSTATE_BUFFERING = 8;
    public static final int PLAYSTATE_ERROR = 9;
    public static final int PLAYSTATE_NONE = 0;
    public static final int PLAYBACK_TYPE_LOCAL = 0;
    public static final int PLAYBACK_TYPE_REMOTE = 1;
    private static final int PLAYBACK_TYPE_MIN = 0;
    private static final int PLAYBACK_TYPE_MAX = 1;
    public static final int PLAYBACK_VOLUME_FIXED = 0;
    public static final int PLAYBACK_VOLUME_VARIABLE = 1;
    public static final int PLAYBACKINFO_INVALID_VALUE = Integer.MIN_VALUE;
    public static final long PLAYBACK_POSITION_INVALID = -1L;
    public static final long PLAYBACK_POSITION_ALWAYS_UNKNOWN = -9216204211029966080L;
    public static final float PLAYBACK_SPEED_1X = 1.0f;
    public static final int PLAYBACKINFO_PLAYBACK_TYPE = 1;
    public static final int PLAYBACKINFO_VOLUME = 2;
    public static final int PLAYBACKINFO_VOLUME_MAX = 3;
    public static final int PLAYBACKINFO_VOLUME_HANDLING = 4;
    public static final int PLAYBACKINFO_USES_STREAM = 5;
    public static final int FLAG_KEY_MEDIA_PREVIOUS = 1;
    public static final int FLAG_KEY_MEDIA_REWIND = 2;
    public static final int FLAG_KEY_MEDIA_PLAY = 4;
    public static final int FLAG_KEY_MEDIA_PLAY_PAUSE = 8;
    public static final int FLAG_KEY_MEDIA_PAUSE = 16;
    public static final int FLAG_KEY_MEDIA_STOP = 32;
    public static final int FLAG_KEY_MEDIA_FAST_FORWARD = 64;
    public static final int FLAG_KEY_MEDIA_NEXT = 128;
    public static final int FLAG_KEY_MEDIA_POSITION_UPDATE = 256;
    public static final int FLAG_KEY_MEDIA_RATING = 512;
    public static final int FLAGS_KEY_MEDIA_NONE = 0;
    public static final int FLAG_INFORMATION_REQUEST_METADATA = 1;
    public static final int FLAG_INFORMATION_REQUEST_KEY_MEDIA = 2;
    public static final int FLAG_INFORMATION_REQUEST_PLAYSTATE = 4;
    public static final int FLAG_INFORMATION_REQUEST_ALBUM_ART = 8;
    public static int MEDIA_POSITION_READABLE = 1;
    public static int MEDIA_POSITION_WRITABLE = 2;
    private int mPlaybackPositionCapabilities = 0;
    public static final int DEFAULT_PLAYBACK_VOLUME_HANDLING = 1;
    public static final int DEFAULT_PLAYBACK_VOLUME = 15;
    private int mPlaybackType = 0;
    private int mPlaybackVolumeMax = 15;
    private int mPlaybackVolume = 15;
    private int mPlaybackVolumeHandling = 1;
    private int mPlaybackStream = 3;
    private final Object mCacheLock = new Object();
    private int mPlaybackState = 0;
    private long mPlaybackStateChangeTimeMs = 0L;
    private long mPlaybackPositionMs = -1L;
    private float mPlaybackSpeed = 1.0f;
    private Bitmap mOriginalArtwork;
    private int mTransportControlFlags = 0;
    private Bundle mMetadata = new Bundle();
    private OnPlaybackPositionUpdateListener mPositionUpdateListener;
    private OnGetPlaybackPositionListener mPositionProvider;
    private OnMetadataUpdateListener mMetadataUpdateListener;
    private int mCurrentClientGenId = -1;
    private int mInternalClientGenId = -2;
    private final PendingIntent mRcMediaIntent;
    private boolean mNeedsPositionSync = false;
    private ArrayList<DisplayInfoForClient> mRcDisplays = new ArrayList(1);
    private final IRemoteControlClient mIRCC = new IRemoteControlClient.Stub(){

        public void onInformationRequested(int generationId, int infoFlags) {
            if (RemoteControlClient.this.mEventHandler != null) {
                RemoteControlClient.this.mEventHandler.removeMessages(5);
                RemoteControlClient.this.mEventHandler.sendMessage(RemoteControlClient.this.mEventHandler.obtainMessage(5, generationId, 0));
                RemoteControlClient.this.mEventHandler.removeMessages(1);
                RemoteControlClient.this.mEventHandler.removeMessages(2);
                RemoteControlClient.this.mEventHandler.removeMessages(3);
                RemoteControlClient.this.mEventHandler.removeMessages(4);
                RemoteControlClient.this.mEventHandler.removeMessages(14);
                RemoteControlClient.this.mEventHandler.sendMessage(RemoteControlClient.this.mEventHandler.obtainMessage(1, null));
                RemoteControlClient.this.mEventHandler.sendMessage(RemoteControlClient.this.mEventHandler.obtainMessage(3, null));
                RemoteControlClient.this.mEventHandler.sendMessage(RemoteControlClient.this.mEventHandler.obtainMessage(14, 0, 0, null));
            }
        }

        public void informationRequestForDisplay(IRemoteControlDisplay rcd, int w, int h) {
            if (RemoteControlClient.this.mEventHandler != null) {
                RemoteControlClient.this.mEventHandler.sendMessage(RemoteControlClient.this.mEventHandler.obtainMessage(3, rcd));
                RemoteControlClient.this.mEventHandler.sendMessage(RemoteControlClient.this.mEventHandler.obtainMessage(1, rcd));
                if (w > 0 && h > 0) {
                    RemoteControlClient.this.mEventHandler.sendMessage(RemoteControlClient.this.mEventHandler.obtainMessage(14, w, h, rcd));
                } else {
                    RemoteControlClient.this.mEventHandler.sendMessage(RemoteControlClient.this.mEventHandler.obtainMessage(2, rcd));
                }
            }
        }

        public void setCurrentClientGenerationId(int clientGeneration) {
            if (RemoteControlClient.this.mEventHandler != null) {
                RemoteControlClient.this.mEventHandler.removeMessages(6);
                RemoteControlClient.this.mEventHandler.sendMessage(RemoteControlClient.this.mEventHandler.obtainMessage(6, clientGeneration, 0));
            }
        }

        public void plugRemoteControlDisplay(IRemoteControlDisplay rcd, int w, int h) {
            if (RemoteControlClient.this.mEventHandler != null && rcd != null) {
                RemoteControlClient.this.mEventHandler.sendMessage(RemoteControlClient.this.mEventHandler.obtainMessage(7, w, h, rcd));
            }
        }

        public void unplugRemoteControlDisplay(IRemoteControlDisplay rcd) {
            if (RemoteControlClient.this.mEventHandler != null && rcd != null) {
                RemoteControlClient.this.mEventHandler.sendMessage(RemoteControlClient.this.mEventHandler.obtainMessage(8, rcd));
            }
        }

        public void setBitmapSizeForDisplay(IRemoteControlDisplay rcd, int w, int h) {
            if (RemoteControlClient.this.mEventHandler != null && rcd != null) {
                RemoteControlClient.this.mEventHandler.sendMessage(RemoteControlClient.this.mEventHandler.obtainMessage(9, w, h, rcd));
            }
        }

        public void setWantsSyncForDisplay(IRemoteControlDisplay rcd, boolean wantsSync) {
            if (RemoteControlClient.this.mEventHandler != null && rcd != null) {
                RemoteControlClient.this.mEventHandler.sendMessage(RemoteControlClient.this.mEventHandler.obtainMessage(12, wantsSync ? 1 : 0, 0, rcd));
            }
        }

        public void enableRemoteControlDisplay(IRemoteControlDisplay rcd, boolean enabled) {
            if (RemoteControlClient.this.mEventHandler != null && rcd != null) {
                RemoteControlClient.this.mEventHandler.sendMessage(RemoteControlClient.this.mEventHandler.obtainMessage(15, enabled ? 1 : 0, 0, rcd));
            }
        }

        public void seekTo(int generationId, long timeMs) {
            if (RemoteControlClient.this.mEventHandler != null) {
                RemoteControlClient.this.mEventHandler.removeMessages(10);
                RemoteControlClient.this.mEventHandler.sendMessage(RemoteControlClient.this.mEventHandler.obtainMessage(10, generationId, 0, new Long(timeMs)));
            }
        }

        public void updateMetadata(int generationId, int key, Rating value) {
            if (RemoteControlClient.this.mEventHandler != null) {
                RemoteControlClient.this.mEventHandler.sendMessage(RemoteControlClient.this.mEventHandler.obtainMessage(13, generationId, key, value));
            }
        }
    };
    public static final int RCSE_ID_UNREGISTERED = -1;
    private int mRcseId = -1;
    private EventHandler mEventHandler;
    private static final int MSG_REQUEST_PLAYBACK_STATE = 1;
    private static final int MSG_REQUEST_METADATA = 2;
    private static final int MSG_REQUEST_TRANSPORTCONTROL = 3;
    private static final int MSG_REQUEST_ARTWORK = 4;
    private static final int MSG_NEW_INTERNAL_CLIENT_GEN = 5;
    private static final int MSG_NEW_CURRENT_CLIENT_GEN = 6;
    private static final int MSG_PLUG_DISPLAY = 7;
    private static final int MSG_UNPLUG_DISPLAY = 8;
    private static final int MSG_UPDATE_DISPLAY_ARTWORK_SIZE = 9;
    private static final int MSG_SEEK_TO = 10;
    private static final int MSG_POSITION_DRIFT_CHECK = 11;
    private static final int MSG_DISPLAY_WANTS_POS_SYNC = 12;
    private static final int MSG_UPDATE_METADATA = 13;
    private static final int MSG_REQUEST_METADATA_ARTWORK = 14;
    private static final int MSG_DISPLAY_ENABLE = 15;
    private static IAudioService sService;
    private static final long POSITION_REFRESH_PERIOD_PLAYING_MS = 15000L;
    private static final long POSITION_REFRESH_PERIOD_MIN_MS = 2000L;
    private static final long POSITION_DRIFT_MAX_MS = 500L;

    public RemoteControlClient(PendingIntent mediaButtonIntent) {
        this.mRcMediaIntent = mediaButtonIntent;
        Looper looper = Looper.myLooper();
        if (looper != null) {
            this.mEventHandler = new EventHandler(this, looper);
        } else {
            looper = Looper.getMainLooper();
            if (looper != null) {
                this.mEventHandler = new EventHandler(this, looper);
            } else {
                this.mEventHandler = null;
                Log.e(TAG, "RemoteControlClient() couldn't find main application thread");
            }
        }
    }

    public RemoteControlClient(PendingIntent mediaButtonIntent, Looper looper) {
        this.mRcMediaIntent = mediaButtonIntent;
        this.mEventHandler = new EventHandler(this, looper);
    }

    public MetadataEditor editMetadata(boolean startEmpty) {
        MetadataEditor editor = new MetadataEditor();
        if (startEmpty) {
            editor.mEditorMetadata = new Bundle();
            editor.mEditorArtwork = null;
            editor.mMetadataChanged = true;
            editor.mArtworkChanged = true;
            editor.mEditableKeys = 0L;
        } else {
            editor.mEditorMetadata = new Bundle(this.mMetadata);
            editor.mEditorArtwork = this.mOriginalArtwork;
            editor.mMetadataChanged = false;
            editor.mArtworkChanged = false;
        }
        return editor;
    }

    public void setPlaybackState(int state) {
        this.setPlaybackStateInt(state, -9216204211029966080L, 1.0f, false);
    }

    public void setPlaybackState(int state, long timeInMs, float playbackSpeed) {
        this.setPlaybackStateInt(state, timeInMs, playbackSpeed, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPlaybackStateInt(int state, long timeInMs, float playbackSpeed, boolean hasPosition) {
        Object object = this.mCacheLock;
        synchronized (object) {
            if (this.mPlaybackState != state || this.mPlaybackPositionMs != timeInMs || this.mPlaybackSpeed != playbackSpeed) {
                this.mPlaybackState = state;
                this.mPlaybackPositionMs = hasPosition ? (timeInMs < 0L ? -1L : timeInMs) : -9216204211029966080L;
                this.mPlaybackSpeed = playbackSpeed;
                this.mPlaybackStateChangeTimeMs = SystemClock.elapsedRealtime();
                this.sendPlaybackState_syncCacheLock(null);
                this.sendAudioServiceNewPlaybackState_syncCacheLock();
                this.initiateCheckForDrift_syncCacheLock();
            }
        }
    }

    private void initiateCheckForDrift_syncCacheLock() {
        if (this.mEventHandler == null) {
            return;
        }
        this.mEventHandler.removeMessages(11);
        if (!this.mNeedsPositionSync) {
            return;
        }
        if (this.mPlaybackPositionMs < 0L) {
            return;
        }
        if (RemoteControlClient.playbackPositionShouldMove(this.mPlaybackState)) {
            this.mEventHandler.sendMessageDelayed(this.mEventHandler.obtainMessage(11), RemoteControlClient.getCheckPeriodFromSpeed(this.mPlaybackSpeed));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPositionDriftCheck() {
        Object object = this.mCacheLock;
        synchronized (object) {
            if (this.mEventHandler == null || this.mPositionProvider == null || !this.mNeedsPositionSync) {
                return;
            }
            if (this.mPlaybackPositionMs < 0L || this.mPlaybackSpeed == 0.0f) {
                return;
            }
            long estPos = this.mPlaybackPositionMs + (long)((float)(SystemClock.elapsedRealtime() - this.mPlaybackStateChangeTimeMs) / this.mPlaybackSpeed);
            long actPos = this.mPositionProvider.onGetPlaybackPosition();
            if (actPos >= 0L) {
                if (Math.abs(estPos - actPos) > 500L) {
                    this.setPlaybackState(this.mPlaybackState, actPos, this.mPlaybackSpeed);
                } else {
                    this.mEventHandler.sendMessageDelayed(this.mEventHandler.obtainMessage(11), RemoteControlClient.getCheckPeriodFromSpeed(this.mPlaybackSpeed));
                }
            } else {
                this.mEventHandler.removeMessages(11);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransportControlFlags(int transportControlFlags) {
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mTransportControlFlags = transportControlFlags;
            this.sendTransportControlInfo_syncCacheLock(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetadataUpdateListener(OnMetadataUpdateListener l) {
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mMetadataUpdateListener = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener l) {
        Object object = this.mCacheLock;
        synchronized (object) {
            int oldCapa = this.mPlaybackPositionCapabilities;
            this.mPlaybackPositionCapabilities = l != null ? (this.mPlaybackPositionCapabilities |= MEDIA_POSITION_WRITABLE) : (this.mPlaybackPositionCapabilities &= ~MEDIA_POSITION_WRITABLE);
            this.mPositionUpdateListener = l;
            if (oldCapa != this.mPlaybackPositionCapabilities) {
                this.sendTransportControlInfo_syncCacheLock(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnGetPlaybackPositionListener(OnGetPlaybackPositionListener l) {
        Object object = this.mCacheLock;
        synchronized (object) {
            int oldCapa = this.mPlaybackPositionCapabilities;
            this.mPlaybackPositionCapabilities = l != null ? (this.mPlaybackPositionCapabilities |= MEDIA_POSITION_READABLE) : (this.mPlaybackPositionCapabilities &= ~MEDIA_POSITION_READABLE);
            this.mPositionProvider = l;
            if (oldCapa != this.mPlaybackPositionCapabilities) {
                this.sendTransportControlInfo_syncCacheLock(null);
            }
            if (this.mPositionProvider != null && this.mEventHandler != null && RemoteControlClient.playbackPositionShouldMove(this.mPlaybackState)) {
                this.mEventHandler.sendMessageDelayed(this.mEventHandler.obtainMessage(11), 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaybackInformation(int what, int value) {
        Object object = this.mCacheLock;
        synchronized (object) {
            switch (what) {
                case 1: {
                    if (value >= 0 && value <= 1) {
                        if (this.mPlaybackType == value) break;
                        this.mPlaybackType = value;
                        this.sendAudioServiceNewPlaybackInfo_syncCacheLock(what, value);
                        break;
                    }
                    Log.w(TAG, "using invalid value for PLAYBACKINFO_PLAYBACK_TYPE");
                    break;
                }
                case 2: {
                    if (value > -1 && value <= this.mPlaybackVolumeMax) {
                        if (this.mPlaybackVolume == value) break;
                        this.mPlaybackVolume = value;
                        this.sendAudioServiceNewPlaybackInfo_syncCacheLock(what, value);
                        break;
                    }
                    Log.w(TAG, "using invalid value for PLAYBACKINFO_VOLUME");
                    break;
                }
                case 3: {
                    if (value > 0) {
                        if (this.mPlaybackVolumeMax == value) break;
                        this.mPlaybackVolumeMax = value;
                        this.sendAudioServiceNewPlaybackInfo_syncCacheLock(what, value);
                        break;
                    }
                    Log.w(TAG, "using invalid value for PLAYBACKINFO_VOLUME_MAX");
                    break;
                }
                case 5: {
                    if (value >= 0 && value < AudioSystem.getNumStreamTypes()) {
                        this.mPlaybackStream = value;
                        break;
                    }
                    Log.w(TAG, "using invalid value for PLAYBACKINFO_USES_STREAM");
                    break;
                }
                case 4: {
                    if (value >= 0 && value <= 1) {
                        if (this.mPlaybackVolumeHandling == value) break;
                        this.mPlaybackVolumeHandling = value;
                        this.sendAudioServiceNewPlaybackInfo_syncCacheLock(what, value);
                        break;
                    }
                    Log.w(TAG, "using invalid value for PLAYBACKINFO_VOLUME_HANDLING");
                    break;
                }
                default: {
                    Log.w(TAG, "setPlaybackInformation() ignoring unknown key " + what);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIntPlaybackInformation(int what) {
        Object object = this.mCacheLock;
        synchronized (object) {
            switch (what) {
                case 1: {
                    return this.mPlaybackType;
                }
                case 2: {
                    return this.mPlaybackVolume;
                }
                case 3: {
                    return this.mPlaybackVolumeMax;
                }
                case 5: {
                    return this.mPlaybackStream;
                }
                case 4: {
                    return this.mPlaybackVolumeHandling;
                }
            }
            Log.e(TAG, "getIntPlaybackInformation() unknown key " + what);
            return Integer.MIN_VALUE;
        }
    }

    public PendingIntent getRcMediaIntent() {
        return this.mRcMediaIntent;
    }

    public IRemoteControlClient getIRemoteControlClient() {
        return this.mIRCC;
    }

    public void setRcseId(int id2) {
        this.mRcseId = id2;
    }

    public int getRcseId() {
        return this.mRcseId;
    }

    private void sendPlaybackState_syncCacheLock(IRemoteControlDisplay target) {
        if (this.mCurrentClientGenId == this.mInternalClientGenId) {
            if (target != null) {
                try {
                    target.setPlaybackState(this.mInternalClientGenId, this.mPlaybackState, this.mPlaybackStateChangeTimeMs, this.mPlaybackPositionMs, this.mPlaybackSpeed);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Error in setPlaybackState() for dead display " + target, e);
                }
                return;
            }
            Iterator<DisplayInfoForClient> displayIterator = this.mRcDisplays.iterator();
            while (displayIterator.hasNext()) {
                DisplayInfoForClient di = displayIterator.next();
                if (!di.mEnabled) continue;
                try {
                    di.mRcDisplay.setPlaybackState(this.mInternalClientGenId, this.mPlaybackState, this.mPlaybackStateChangeTimeMs, this.mPlaybackPositionMs, this.mPlaybackSpeed);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Error in setPlaybackState(), dead display " + di.mRcDisplay, e);
                    displayIterator.remove();
                }
            }
        }
    }

    private void sendMetadata_syncCacheLock(IRemoteControlDisplay target) {
        if (this.mCurrentClientGenId == this.mInternalClientGenId) {
            if (target != null) {
                try {
                    target.setMetadata(this.mInternalClientGenId, this.mMetadata);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Error in setMetadata() for dead display " + target, e);
                }
                return;
            }
            Iterator<DisplayInfoForClient> displayIterator = this.mRcDisplays.iterator();
            while (displayIterator.hasNext()) {
                DisplayInfoForClient di = displayIterator.next();
                if (!di.mEnabled) continue;
                try {
                    di.mRcDisplay.setMetadata(this.mInternalClientGenId, this.mMetadata);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Error in setMetadata(), dead display " + di.mRcDisplay, e);
                    displayIterator.remove();
                }
            }
        }
    }

    private void sendTransportControlInfo_syncCacheLock(IRemoteControlDisplay target) {
        if (this.mCurrentClientGenId == this.mInternalClientGenId) {
            if (target != null) {
                try {
                    target.setTransportControlInfo(this.mInternalClientGenId, this.mTransportControlFlags, this.mPlaybackPositionCapabilities);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Error in setTransportControlFlags() for dead display " + target, e);
                }
                return;
            }
            Iterator<DisplayInfoForClient> displayIterator = this.mRcDisplays.iterator();
            while (displayIterator.hasNext()) {
                DisplayInfoForClient di = displayIterator.next();
                if (!di.mEnabled) continue;
                try {
                    di.mRcDisplay.setTransportControlInfo(this.mInternalClientGenId, this.mTransportControlFlags, this.mPlaybackPositionCapabilities);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Error in setTransportControlFlags(), dead display " + di.mRcDisplay, e);
                    displayIterator.remove();
                }
            }
        }
    }

    private void sendArtwork_syncCacheLock(IRemoteControlDisplay target, int w, int h) {
        if (this.mCurrentClientGenId == this.mInternalClientGenId) {
            if (target != null) {
                DisplayInfoForClient di = new DisplayInfoForClient(target, w, h);
                this.sendArtworkToDisplay(di);
                return;
            }
            Iterator<DisplayInfoForClient> displayIterator = this.mRcDisplays.iterator();
            while (displayIterator.hasNext()) {
                if (this.sendArtworkToDisplay(displayIterator.next())) continue;
                displayIterator.remove();
            }
        }
    }

    private boolean sendArtworkToDisplay(DisplayInfoForClient di) {
        if (di.mArtworkExpectedWidth > 0 && di.mArtworkExpectedHeight > 0) {
            Bitmap artwork = this.scaleBitmapIfTooBig(this.mOriginalArtwork, di.mArtworkExpectedWidth, di.mArtworkExpectedHeight);
            try {
                di.mRcDisplay.setArtwork(this.mInternalClientGenId, artwork);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error in sendArtworkToDisplay(), dead display " + di.mRcDisplay, e);
                return false;
            }
        }
        return true;
    }

    private void sendMetadataWithArtwork_syncCacheLock(IRemoteControlDisplay target, int w, int h) {
        if (this.mCurrentClientGenId == this.mInternalClientGenId) {
            if (target != null) {
                try {
                    if (w > 0 && h > 0) {
                        Bitmap artwork = this.scaleBitmapIfTooBig(this.mOriginalArtwork, w, h);
                        target.setAllMetadata(this.mInternalClientGenId, this.mMetadata, artwork);
                    } else {
                        target.setMetadata(this.mInternalClientGenId, this.mMetadata);
                    }
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Error in set(All)Metadata() for dead display " + target, e);
                }
                return;
            }
            Iterator<DisplayInfoForClient> displayIterator = this.mRcDisplays.iterator();
            while (displayIterator.hasNext()) {
                DisplayInfoForClient di = displayIterator.next();
                try {
                    if (!di.mEnabled) continue;
                    if (di.mArtworkExpectedWidth > 0 && di.mArtworkExpectedHeight > 0) {
                        Bitmap artwork = this.scaleBitmapIfTooBig(this.mOriginalArtwork, di.mArtworkExpectedWidth, di.mArtworkExpectedHeight);
                        di.mRcDisplay.setAllMetadata(this.mInternalClientGenId, this.mMetadata, artwork);
                        continue;
                    }
                    di.mRcDisplay.setMetadata(this.mInternalClientGenId, this.mMetadata);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Error when setting metadata, dead display " + di.mRcDisplay, e);
                    displayIterator.remove();
                }
            }
        }
    }

    private static IAudioService getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("audio");
        sService = IAudioService.Stub.asInterface(b);
        return sService;
    }

    private void sendAudioServiceNewPlaybackInfo_syncCacheLock(int what, int value) {
        if (this.mRcseId == -1) {
            return;
        }
        IAudioService service = RemoteControlClient.getService();
        try {
            service.setPlaybackInfoForRcc(this.mRcseId, what, value);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setPlaybackInfoForRcc", e);
        }
    }

    private void sendAudioServiceNewPlaybackState_syncCacheLock() {
        if (this.mRcseId == -1) {
            return;
        }
        IAudioService service = RemoteControlClient.getService();
        try {
            service.setPlaybackStateForRcc(this.mRcseId, this.mPlaybackState, this.mPlaybackPositionMs, this.mPlaybackSpeed);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setPlaybackStateForRcc", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewInternalClientGen(int clientGeneration) {
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mInternalClientGenId = clientGeneration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewCurrentClientGen(int clientGeneration) {
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mCurrentClientGenId = clientGeneration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlugDisplay(IRemoteControlDisplay rcd, int w, int h) {
        Object object = this.mCacheLock;
        synchronized (object) {
            boolean displayKnown = false;
            Iterator<DisplayInfoForClient> displayIterator = this.mRcDisplays.iterator();
            while (displayIterator.hasNext() && !displayKnown) {
                DisplayInfoForClient di = displayIterator.next();
                displayKnown = di.mRcDisplay.asBinder().equals(rcd.asBinder());
                if (!displayKnown || di.mArtworkExpectedWidth == w && di.mArtworkExpectedHeight == h) continue;
                di.mArtworkExpectedWidth = w;
                di.mArtworkExpectedHeight = h;
                if (this.sendArtworkToDisplay(di)) continue;
                displayIterator.remove();
            }
            if (!displayKnown) {
                this.mRcDisplays.add(new DisplayInfoForClient(rcd, w, h));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUnplugDisplay(IRemoteControlDisplay rcd) {
        Object object = this.mCacheLock;
        synchronized (object) {
            Iterator<DisplayInfoForClient> displayIterator = this.mRcDisplays.iterator();
            while (displayIterator.hasNext()) {
                DisplayInfoForClient di = displayIterator.next();
                if (!di.mRcDisplay.asBinder().equals(rcd.asBinder())) continue;
                displayIterator.remove();
                break;
            }
            boolean oldNeedsPositionSync = this.mNeedsPositionSync;
            boolean newNeedsPositionSync = false;
            for (DisplayInfoForClient di : this.mRcDisplays) {
                if (!di.mWantsPositionSync) continue;
                newNeedsPositionSync = true;
                break;
            }
            this.mNeedsPositionSync = newNeedsPositionSync;
            if (oldNeedsPositionSync != this.mNeedsPositionSync) {
                this.initiateCheckForDrift_syncCacheLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdateDisplayArtworkSize(IRemoteControlDisplay rcd, int w, int h) {
        Object object = this.mCacheLock;
        synchronized (object) {
            Iterator<DisplayInfoForClient> displayIterator = this.mRcDisplays.iterator();
            while (displayIterator.hasNext()) {
                DisplayInfoForClient di = displayIterator.next();
                if (!di.mRcDisplay.asBinder().equals(rcd.asBinder()) || di.mArtworkExpectedWidth == w && di.mArtworkExpectedHeight == h) continue;
                di.mArtworkExpectedWidth = w;
                di.mArtworkExpectedHeight = h;
                if (!di.mEnabled || this.sendArtworkToDisplay(di)) break;
                displayIterator.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDisplayWantsSync(IRemoteControlDisplay rcd, boolean wantsSync) {
        Object object = this.mCacheLock;
        synchronized (object) {
            boolean oldNeedsPositionSync = this.mNeedsPositionSync;
            boolean newNeedsPositionSync = false;
            for (DisplayInfoForClient di : this.mRcDisplays) {
                if (!di.mEnabled) continue;
                if (di.mRcDisplay.asBinder().equals(rcd.asBinder())) {
                    di.mWantsPositionSync = wantsSync;
                }
                if (!di.mWantsPositionSync) continue;
                newNeedsPositionSync = true;
            }
            this.mNeedsPositionSync = newNeedsPositionSync;
            if (oldNeedsPositionSync != this.mNeedsPositionSync) {
                this.initiateCheckForDrift_syncCacheLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDisplayEnable(IRemoteControlDisplay rcd, boolean enable) {
        Object object = this.mCacheLock;
        synchronized (object) {
            for (DisplayInfoForClient di : this.mRcDisplays) {
                if (!di.mRcDisplay.asBinder().equals(rcd.asBinder())) continue;
                di.mEnabled = enable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSeekTo(int generationId, long timeMs) {
        Object object = this.mCacheLock;
        synchronized (object) {
            if (this.mCurrentClientGenId == generationId && this.mPositionUpdateListener != null) {
                this.mPositionUpdateListener.onPlaybackPositionUpdate(timeMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdateMetadata(int generationId, int key, Object value) {
        Object object = this.mCacheLock;
        synchronized (object) {
            if (this.mCurrentClientGenId == generationId && this.mMetadataUpdateListener != null) {
                this.mMetadataUpdateListener.onMetadataUpdate(key, value);
            }
        }
    }

    private Bitmap scaleBitmapIfTooBig(Bitmap bitmap, int maxWidth, int maxHeight) {
        if (bitmap != null) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            if (width > maxWidth || height > maxHeight) {
                float scale = Math.min((float)maxWidth / (float)width, (float)maxHeight / (float)height);
                int newWidth = Math.round(scale * (float)width);
                int newHeight = Math.round(scale * (float)height);
                Bitmap.Config newConfig = bitmap.getConfig();
                if (newConfig == null) {
                    newConfig = Bitmap.Config.ARGB_8888;
                }
                Bitmap outBitmap = Bitmap.createBitmap(newWidth, newHeight, newConfig);
                Canvas canvas = new Canvas(outBitmap);
                Paint paint = new Paint();
                paint.setAntiAlias(true);
                paint.setFilterBitmap(true);
                canvas.drawBitmap(bitmap, null, new RectF(0.0f, 0.0f, outBitmap.getWidth(), outBitmap.getHeight()), paint);
                bitmap = outBitmap;
            }
        }
        return bitmap;
    }

    static boolean playbackPositionShouldMove(int playstate) {
        switch (playstate) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    private static long getCheckPeriodFromSpeed(float speed) {
        if (Math.abs(speed) <= 1.0f) {
            return 15000L;
        }
        return Math.max((long)(15000.0f / Math.abs(speed)), 2000L);
    }

    private class EventHandler
    extends Handler {
        public EventHandler(RemoteControlClient rcc, Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Object object = RemoteControlClient.this.mCacheLock;
                    synchronized (object) {
                        RemoteControlClient.this.sendPlaybackState_syncCacheLock((IRemoteControlDisplay)msg.obj);
                        break;
                    }
                }
                case 2: {
                    Object object = RemoteControlClient.this.mCacheLock;
                    synchronized (object) {
                        RemoteControlClient.this.sendMetadata_syncCacheLock((IRemoteControlDisplay)msg.obj);
                        break;
                    }
                }
                case 3: {
                    Object object = RemoteControlClient.this.mCacheLock;
                    synchronized (object) {
                        RemoteControlClient.this.sendTransportControlInfo_syncCacheLock((IRemoteControlDisplay)msg.obj);
                        break;
                    }
                }
                case 4: {
                    Object object = RemoteControlClient.this.mCacheLock;
                    synchronized (object) {
                        RemoteControlClient.this.sendArtwork_syncCacheLock((IRemoteControlDisplay)msg.obj, msg.arg1, msg.arg2);
                        break;
                    }
                }
                case 14: {
                    Object object = RemoteControlClient.this.mCacheLock;
                    synchronized (object) {
                        RemoteControlClient.this.sendMetadataWithArtwork_syncCacheLock((IRemoteControlDisplay)msg.obj, msg.arg1, msg.arg2);
                        break;
                    }
                }
                case 5: {
                    RemoteControlClient.this.onNewInternalClientGen(msg.arg1);
                    break;
                }
                case 6: {
                    RemoteControlClient.this.onNewCurrentClientGen(msg.arg1);
                    break;
                }
                case 7: {
                    RemoteControlClient.this.onPlugDisplay((IRemoteControlDisplay)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 8: {
                    RemoteControlClient.this.onUnplugDisplay((IRemoteControlDisplay)msg.obj);
                    break;
                }
                case 9: {
                    RemoteControlClient.this.onUpdateDisplayArtworkSize((IRemoteControlDisplay)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 10: {
                    RemoteControlClient.this.onSeekTo(msg.arg1, (Long)msg.obj);
                    break;
                }
                case 11: {
                    RemoteControlClient.this.onPositionDriftCheck();
                    break;
                }
                case 12: {
                    RemoteControlClient.this.onDisplayWantsSync((IRemoteControlDisplay)msg.obj, msg.arg1 == 1);
                    break;
                }
                case 13: {
                    RemoteControlClient.this.onUpdateMetadata(msg.arg1, msg.arg2, msg.obj);
                    break;
                }
                case 15: {
                    RemoteControlClient.this.onDisplayEnable((IRemoteControlDisplay)msg.obj, msg.arg1 == 1);
                    break;
                }
                default: {
                    Log.e(RemoteControlClient.TAG, "Unknown event " + msg.what + " in RemoteControlClient handler");
                }
            }
        }
    }

    private class DisplayInfoForClient {
        private IRemoteControlDisplay mRcDisplay;
        private int mArtworkExpectedWidth;
        private int mArtworkExpectedHeight;
        private boolean mWantsPositionSync = false;
        private boolean mEnabled = true;

        DisplayInfoForClient(IRemoteControlDisplay rcd, int w, int h) {
            this.mRcDisplay = rcd;
            this.mArtworkExpectedWidth = w;
            this.mArtworkExpectedHeight = h;
        }
    }

    public static interface OnGetPlaybackPositionListener {
        public long onGetPlaybackPosition();
    }

    public static interface OnPlaybackPositionUpdateListener {
        public void onPlaybackPositionUpdate(long var1);
    }

    public static interface OnMetadataUpdateListener {
        public void onMetadataUpdate(int var1, Object var2);
    }

    public class MetadataEditor
    extends MediaMetadataEditor {
        public static final int BITMAP_KEY_ARTWORK = 100;
        public static final int METADATA_KEY_ARTWORK = 100;

        private MetadataEditor() {
        }

        public Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException();
        }

        public synchronized MetadataEditor putString(int key, String value) throws IllegalArgumentException {
            super.putString(key, value);
            return this;
        }

        public synchronized MetadataEditor putLong(int key, long value) throws IllegalArgumentException {
            super.putLong(key, value);
            return this;
        }

        public synchronized MetadataEditor putBitmap(int key, Bitmap bitmap) throws IllegalArgumentException {
            super.putBitmap(key, bitmap);
            return this;
        }

        public synchronized void clear() {
            super.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void apply() {
            if (this.mApplied) {
                Log.e(RemoteControlClient.TAG, "Can't apply a previously applied MetadataEditor");
                return;
            }
            Object object = RemoteControlClient.this.mCacheLock;
            synchronized (object) {
                RemoteControlClient.this.mMetadata = new Bundle(this.mEditorMetadata);
                RemoteControlClient.this.mMetadata.putLong(String.valueOf(0x1FFFFFFF), this.mEditableKeys);
                if (RemoteControlClient.this.mOriginalArtwork != null && !RemoteControlClient.this.mOriginalArtwork.equals(this.mEditorArtwork)) {
                    RemoteControlClient.this.mOriginalArtwork.recycle();
                }
                RemoteControlClient.this.mOriginalArtwork = this.mEditorArtwork;
                this.mEditorArtwork = null;
                if (this.mMetadataChanged & this.mArtworkChanged) {
                    RemoteControlClient.this.sendMetadataWithArtwork_syncCacheLock(null, 0, 0);
                } else if (this.mMetadataChanged) {
                    RemoteControlClient.this.sendMetadata_syncCacheLock(null);
                } else if (this.mArtworkChanged) {
                    RemoteControlClient.this.sendArtwork_syncCacheLock(null, 0, 0);
                }
                this.mApplied = true;
            }
        }
    }
}

