/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.media.audiofx.AudioEffect;
import android.util.Log;
import java.util.StringTokenizer;

public class LoudnessEnhancer
extends AudioEffect {
    private static final String TAG = "LoudnessEnhancer";
    public static final int PARAM_TARGET_GAIN_MB = 0;
    private OnParameterChangeListener mParamListener = null;
    private BaseParameterListener mBaseParamListener = null;
    private final Object mParamListenerLock = new Object();

    public LoudnessEnhancer(int audioSession) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        super(EFFECT_TYPE_LOUDNESS_ENHANCER, EFFECT_TYPE_NULL, 0, audioSession);
        if (audioSession == 0) {
            Log.w(TAG, "WARNING: attaching a LoudnessEnhancer to global output mix is deprecated!");
        }
    }

    public LoudnessEnhancer(int priority, int audioSession) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        super(EFFECT_TYPE_LOUDNESS_ENHANCER, EFFECT_TYPE_NULL, priority, audioSession);
        if (audioSession == 0) {
            Log.w(TAG, "WARNING: attaching a LoudnessEnhancer to global output mix is deprecated!");
        }
    }

    public void setTargetGain(int gainmB) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(0, gainmB));
    }

    public float getTargetGain() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int[] value = new int[1];
        this.checkStatus(this.getParameter(0, value));
        return value[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterListener(OnParameterChangeListener listener) {
        Object object = this.mParamListenerLock;
        synchronized (object) {
            if (this.mParamListener == null) {
                this.mBaseParamListener = new BaseParameterListener();
                super.setParameterListener(this.mBaseParamListener);
            }
            this.mParamListener = listener;
        }
    }

    public Settings getProperties() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        Settings settings = new Settings();
        int[] value = new int[1];
        this.checkStatus(this.getParameter(0, value));
        settings.targetGainmB = value[0];
        return settings;
    }

    public void setProperties(Settings settings) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(0, settings.targetGainmB));
    }

    public static class Settings {
        public int targetGainmB;

        public Settings() {
        }

        public Settings(String settings) {
            StringTokenizer st = new StringTokenizer(settings, "=;");
            if (st.countTokens() != 3) {
                throw new IllegalArgumentException("settings: " + settings);
            }
            String key = st.nextToken();
            if (!key.equals(LoudnessEnhancer.TAG)) {
                throw new IllegalArgumentException("invalid settings for LoudnessEnhancer: " + key);
            }
            try {
                key = st.nextToken();
                if (!key.equals("targetGainmB")) {
                    throw new IllegalArgumentException("invalid key name: " + key);
                }
                this.targetGainmB = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("invalid value for key: " + key);
            }
        }

        public String toString() {
            String str = new String("LoudnessEnhancer;targetGainmB=" + Integer.toString(this.targetGainmB));
            return str;
        }
    }

    private class BaseParameterListener
    implements AudioEffect.OnParameterChangeListener {
        private BaseParameterListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onParameterChange(AudioEffect effect, int status, byte[] param, byte[] value) {
            if (status != 0) {
                return;
            }
            OnParameterChangeListener l = null;
            Object object = LoudnessEnhancer.this.mParamListenerLock;
            synchronized (object) {
                if (LoudnessEnhancer.this.mParamListener != null) {
                    l = LoudnessEnhancer.this.mParamListener;
                }
            }
            if (l != null) {
                int p = -1;
                int v = Integer.MIN_VALUE;
                if (param.length == 4) {
                    p = LoudnessEnhancer.this.byteArrayToInt(param, 0);
                }
                if (value.length == 4) {
                    v = LoudnessEnhancer.this.byteArrayToInt(value, 0);
                }
                if (p != -1 && v != Integer.MIN_VALUE) {
                    l.onParameterChange(LoudnessEnhancer.this, p, v);
                }
            }
        }
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(LoudnessEnhancer var1, int var2, int var3);
    }
}

