/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkCapabilities;
import android.net.LinkProperties;
import android.net.LinkQualityInfo;
import android.net.NetworkInfo;
import android.net.NetworkStateTracker;
import android.net.SamplingDataTracker;
import android.os.Handler;
import android.os.Messenger;
import com.android.internal.util.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BaseNetworkStateTracker
implements NetworkStateTracker {
    public static final String PROP_TCP_BUFFER_UNKNOWN = "net.tcp.buffersize.unknown";
    public static final String PROP_TCP_BUFFER_WIFI = "net.tcp.buffersize.wifi";
    protected Context mContext;
    private Handler mTarget;
    protected NetworkInfo mNetworkInfo;
    protected LinkProperties mLinkProperties;
    protected LinkCapabilities mLinkCapabilities;
    private AtomicBoolean mTeardownRequested = new AtomicBoolean(false);
    private AtomicBoolean mPrivateDnsRouteSet = new AtomicBoolean(false);
    private AtomicBoolean mDefaultRouteSet = new AtomicBoolean(false);

    public BaseNetworkStateTracker(int networkType) {
        this.mNetworkInfo = new NetworkInfo(networkType, -1, ConnectivityManager.getNetworkTypeName(networkType), null);
        this.mLinkProperties = new LinkProperties();
        this.mLinkCapabilities = new LinkCapabilities();
    }

    protected BaseNetworkStateTracker() {
    }

    @Deprecated
    protected Handler getTargetHandler() {
        return this.mTarget;
    }

    protected final void dispatchStateChanged() {
        this.mTarget.obtainMessage(458752, this.getNetworkInfo()).sendToTarget();
    }

    protected final void dispatchConfigurationChanged() {
        this.mTarget.obtainMessage(458753, this.getNetworkInfo()).sendToTarget();
    }

    public void startMonitoring(Context context, Handler target) {
        this.mContext = Preconditions.checkNotNull(context);
        this.mTarget = Preconditions.checkNotNull(target);
        this.startMonitoringInternal();
    }

    protected void startMonitoringInternal() {
    }

    public NetworkInfo getNetworkInfo() {
        return new NetworkInfo(this.mNetworkInfo);
    }

    public LinkProperties getLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    public LinkCapabilities getLinkCapabilities() {
        return new LinkCapabilities(this.mLinkCapabilities);
    }

    public LinkQualityInfo getLinkQualityInfo() {
        return null;
    }

    public void captivePortalCheckComplete() {
    }

    public void captivePortalCheckCompleted(boolean isCaptivePortal) {
    }

    public boolean setRadio(boolean turnOn) {
        return true;
    }

    public boolean isAvailable() {
        return this.mNetworkInfo.isAvailable();
    }

    public void setUserDataEnable(boolean enabled) {
    }

    public void setPolicyDataEnable(boolean enabled) {
    }

    public boolean isPrivateDnsRouteSet() {
        return this.mPrivateDnsRouteSet.get();
    }

    public void privateDnsRouteSet(boolean enabled) {
        this.mPrivateDnsRouteSet.set(enabled);
    }

    public boolean isDefaultRouteSet() {
        return this.mDefaultRouteSet.get();
    }

    public void defaultRouteSet(boolean enabled) {
        this.mDefaultRouteSet.set(enabled);
    }

    public boolean isTeardownRequested() {
        return this.mTeardownRequested.get();
    }

    public void setTeardownRequested(boolean isRequested) {
        this.mTeardownRequested.set(isRequested);
    }

    public void setDependencyMet(boolean met) {
    }

    public void addStackedLink(LinkProperties link) {
        this.mLinkProperties.addStackedLink(link);
    }

    public void removeStackedLink(LinkProperties link) {
        this.mLinkProperties.removeStackedLink(link);
    }

    public void supplyMessenger(Messenger messenger) {
    }

    public String getNetworkInterfaceName() {
        if (this.mLinkProperties != null) {
            return this.mLinkProperties.getInterfaceName();
        }
        return null;
    }

    public void startSampling(SamplingDataTracker.SamplingSnapshot s) {
    }

    public void stopSampling(SamplingDataTracker.SamplingSnapshot s) {
    }
}

