/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.SystemProperties;

public class Build {
    public static final String UNKNOWN = "unknown";
    public static final String ID = Build.getString("ro.build.id");
    public static final String DISPLAY = Build.getString("ro.build.display.id");
    public static final String PRODUCT = Build.getString("ro.product.name");
    public static final String DEVICE = Build.getString("ro.product.device");
    public static final String BOARD = Build.getString("ro.product.board");
    public static final String CPU_ABI = Build.getString("ro.product.cpu.abi");
    public static final String CPU_ABI2 = Build.getString("ro.product.cpu.abi2");
    public static final String MANUFACTURER = Build.getString("ro.product.manufacturer");
    public static final String BRAND = Build.getString("ro.product.brand");
    public static final String MODEL = Build.getString("ro.product.model");
    public static final String BOOTLOADER = Build.getString("ro.bootloader");
    @Deprecated
    public static final String RADIO = Build.getString("gsm.version.baseband");
    public static final String HARDWARE = Build.getString("ro.hardware");
    public static final String SERIAL = Build.getString("ro.serialno");
    public static final String TYPE = Build.getString("ro.build.type");
    public static final String TAGS = Build.getString("ro.build.tags");
    public static final String FINGERPRINT = Build.getString("ro.build.fingerprint");
    public static final long TIME = Build.getLong("ro.build.date.utc") * 1000L;
    public static final String USER = Build.getString("ro.build.user");
    public static final String HOST = Build.getString("ro.build.host");
    public static final boolean IS_DEBUGGABLE = SystemProperties.getInt("ro.debuggable", 0) == 1;

    public static String getRadioVersion() {
        return SystemProperties.get("gsm.version.baseband", null);
    }

    private static String getString(String property) {
        return SystemProperties.get(property, UNKNOWN);
    }

    private static long getLong(String property) {
        try {
            return Long.parseLong(SystemProperties.get(property));
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    static /* synthetic */ String access$000(String x0) {
        return Build.getString(x0);
    }

    public static class VERSION_CODES {
        public static final int CUR_DEVELOPMENT = 10000;
        public static final int BASE = 1;
        public static final int BASE_1_1 = 2;
        public static final int CUPCAKE = 3;
        public static final int DONUT = 4;
        public static final int ECLAIR = 5;
        public static final int ECLAIR_0_1 = 6;
        public static final int ECLAIR_MR1 = 7;
        public static final int FROYO = 8;
        public static final int GINGERBREAD = 9;
        public static final int GINGERBREAD_MR1 = 10;
        public static final int HONEYCOMB = 11;
        public static final int HONEYCOMB_MR1 = 12;
        public static final int HONEYCOMB_MR2 = 13;
        public static final int ICE_CREAM_SANDWICH = 14;
        public static final int ICE_CREAM_SANDWICH_MR1 = 15;
        public static final int JELLY_BEAN = 16;
        public static final int JELLY_BEAN_MR1 = 17;
        public static final int JELLY_BEAN_MR2 = 18;
        public static final int KITKAT = 19;
    }

    public static class VERSION {
        public static final String INCREMENTAL = Build.access$000("ro.build.version.incremental");
        public static final String RELEASE = Build.access$000("ro.build.version.release");
        @Deprecated
        public static final String SDK = Build.access$000("ro.build.version.sdk");
        public static final int SDK_INT = SystemProperties.getInt("ro.build.version.sdk", 0);
        public static final String CODENAME = Build.access$000("ro.build.version.codename");
        public static final int RESOURCES_SDK_INT = SDK_INT + ("REL".equals(CODENAME) ? 0 : 1);
    }
}

