/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.util.Printer;
import java.util.ArrayList;

public final class MessageQueue {
    private final boolean mQuitAllowed;
    private long mPtr;
    Message mMessages;
    private final ArrayList<IdleHandler> mIdleHandlers = new ArrayList();
    private IdleHandler[] mPendingIdleHandlers;
    private boolean mQuitting;
    private boolean mBlocked;
    private int mNextBarrierToken;

    private static native long nativeInit();

    private static native void nativeDestroy(long var0);

    private static native void nativePollOnce(long var0, int var2);

    private static native void nativeWake(long var0);

    private static native boolean nativeIsIdling(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdleHandler(IdleHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Can't add a null IdleHandler");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdleHandler(IdleHandler handler) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.remove(handler);
        }
    }

    MessageQueue(boolean quitAllowed) {
        this.mQuitAllowed = quitAllowed;
        this.mPtr = MessageQueue.nativeInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private void dispose() {
        if (this.mPtr != 0L) {
            MessageQueue.nativeDestroy(this.mPtr);
            this.mPtr = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Message next() {
        int pendingIdleHandlerCount = -1;
        int nextPollTimeoutMillis = 0;
        while (true) {
            if (nextPollTimeoutMillis != 0) {
                Binder.flushPendingCommands();
            }
            MessageQueue.nativePollOnce(this.mPtr, nextPollTimeoutMillis);
            MessageQueue messageQueue = this;
            synchronized (messageQueue) {
                long now;
                block20: {
                    now = SystemClock.uptimeMillis();
                    Message prevMsg = null;
                    Message msg = this.mMessages;
                    if (msg != null && msg.target == null) {
                        do {
                            prevMsg = msg;
                        } while ((msg = msg.next) != null && !msg.isAsynchronous());
                    }
                    if (msg != null) {
                        if (now < msg.when) {
                            nextPollTimeoutMillis = (int)Math.min(msg.when - now, Integer.MAX_VALUE);
                            break block20;
                        } else {
                            this.mBlocked = false;
                            if (prevMsg != null) {
                                prevMsg.next = msg.next;
                            } else {
                                this.mMessages = msg.next;
                            }
                            msg.next = null;
                            msg.markInUse();
                            return msg;
                        }
                    }
                    nextPollTimeoutMillis = -1;
                }
                if (this.mQuitting) {
                    this.dispose();
                    return null;
                }
                if (pendingIdleHandlerCount < 0 && (this.mMessages == null || now < this.mMessages.when)) {
                    pendingIdleHandlerCount = this.mIdleHandlers.size();
                }
                if (pendingIdleHandlerCount <= 0) {
                    this.mBlocked = true;
                    continue;
                }
                if (this.mPendingIdleHandlers == null) {
                    this.mPendingIdleHandlers = new IdleHandler[Math.max(pendingIdleHandlerCount, 4)];
                }
                this.mPendingIdleHandlers = this.mIdleHandlers.toArray(this.mPendingIdleHandlers);
            }
            for (int i = 0; i < pendingIdleHandlerCount; ++i) {
                IdleHandler idler = this.mPendingIdleHandlers[i];
                this.mPendingIdleHandlers[i] = null;
                boolean keep = false;
                try {
                    keep = idler.queueIdle();
                }
                catch (Throwable t) {
                    Log.wtf("MessageQueue", "IdleHandler threw exception", t);
                }
                if (keep) continue;
                MessageQueue messageQueue2 = this;
                synchronized (messageQueue2) {
                    this.mIdleHandlers.remove(idler);
                    continue;
                }
            }
            pendingIdleHandlerCount = 0;
            nextPollTimeoutMillis = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void quit(boolean safe) {
        if (!this.mQuitAllowed) {
            throw new RuntimeException("Main thread not allowed to quit.");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.mQuitting) {
                return;
            }
            this.mQuitting = true;
            if (safe) {
                this.removeAllFutureMessagesLocked();
            } else {
                this.removeAllMessagesLocked();
            }
            MessageQueue.nativeWake(this.mPtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int enqueueSyncBarrier(long when) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            int token = this.mNextBarrierToken++;
            Message msg = Message.obtain();
            msg.when = when;
            msg.arg1 = token;
            Message prev = null;
            Message p = this.mMessages;
            if (when != 0L) {
                while (p != null && p.when <= when) {
                    prev = p;
                    p = p.next;
                }
            }
            if (prev != null) {
                msg.next = p;
                prev.next = msg;
            } else {
                msg.next = p;
                this.mMessages = msg;
            }
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSyncBarrier(int token) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            boolean needWake;
            Message prev = null;
            Message p = this.mMessages;
            while (p != null && (p.target != null || p.arg1 != token)) {
                prev = p;
                p = p.next;
            }
            if (p == null) {
                throw new IllegalStateException("The specified message queue synchronization  barrier token has not been posted or has already been removed.");
            }
            if (prev != null) {
                prev.next = p.next;
                needWake = false;
            } else {
                this.mMessages = p.next;
                needWake = this.mMessages == null || this.mMessages.target != null;
            }
            p.recycle();
            if (needWake && !this.mQuitting) {
                MessageQueue.nativeWake(this.mPtr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueueMessage(Message msg, long when) {
        if (msg.isInUse()) {
            throw new AndroidRuntimeException(msg + " This message is already in use.");
        }
        if (msg.target == null) {
            throw new AndroidRuntimeException("Message must have a target.");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            boolean needWake;
            if (this.mQuitting) {
                RuntimeException e = new RuntimeException(msg.target + " sending message to a Handler on a dead thread");
                Log.w("MessageQueue", e.getMessage(), e);
                return false;
            }
            msg.when = when;
            Message p = this.mMessages;
            if (p == null || when == 0L || when < p.when) {
                msg.next = p;
                this.mMessages = msg;
                needWake = this.mBlocked;
            } else {
                needWake = this.mBlocked && p.target == null && msg.isAsynchronous();
                while (true) {
                    Message prev = p;
                    p = p.next;
                    if (p == null || when < p.when) break;
                    if (!needWake || !p.isAsynchronous()) continue;
                    needWake = false;
                }
                msg.next = p;
                prev.next = msg;
            }
            if (needWake) {
                MessageQueue.nativeWake(this.mPtr);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasMessages(Handler h, int what, Object object) {
        if (h == null) {
            return false;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h && p.what == what && (object == null || p.obj == object)) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasMessages(Handler h, Runnable r, Object object) {
        if (h == null) {
            return false;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h && p.callback == r && (object == null || p.obj == object)) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isIdling() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            return this.isIdlingLocked();
        }
    }

    private boolean isIdlingLocked() {
        return !this.mQuitting && MessageQueue.nativeIsIdling(this.mPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMessages(Handler h, int what, Object object) {
        if (h == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.what == what && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycle();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.what == what && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycle();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMessages(Handler h, Runnable r, Object object) {
        if (h == null || r == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.callback == r && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycle();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.callback == r && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycle();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCallbacksAndMessages(Handler h, Object object) {
        if (h == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycle();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycle();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    private void removeAllMessagesLocked() {
        Message p = this.mMessages;
        while (p != null) {
            Message n = p.next;
            p.recycle();
            p = n;
        }
        this.mMessages = null;
    }

    private void removeAllFutureMessagesLocked() {
        long now = SystemClock.uptimeMillis();
        Message p = this.mMessages;
        if (p != null) {
            if (p.when > now) {
                this.removeAllMessagesLocked();
            } else {
                Message n;
                while (true) {
                    if ((n = p.next) == null) {
                        return;
                    }
                    if (n.when > now) break;
                    p = n;
                }
                p.next = null;
                do {
                    p = n;
                    n = p.next;
                    p.recycle();
                } while (n != null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(Printer pw, String prefix) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            long now = SystemClock.uptimeMillis();
            int n = 0;
            Message msg = this.mMessages;
            while (msg != null) {
                pw.println(prefix + "Message " + n + ": " + msg.toString(now));
                ++n;
                msg = msg.next;
            }
            pw.println(prefix + "(Total messages: " + n + ", idling=" + this.isIdlingLocked() + ", quitting=" + this.mQuitting + ")");
        }
    }

    public static interface IdleHandler {
        public boolean queueIdle();
    }
}

