/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.preference.TwoStatePreference;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Checkable;
import android.widget.CompoundButton;
import android.widget.Switch;
import com.android.internal.R;

public class SwitchPreference
extends TwoStatePreference {
    private CharSequence mSwitchOn;
    private CharSequence mSwitchOff;
    private final Listener mListener = new Listener();

    public SwitchPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SwitchPreference, defStyle, 0);
        this.setSummaryOn(a.getString(0));
        this.setSummaryOff(a.getString(1));
        this.setSwitchTextOn(a.getString(3));
        this.setSwitchTextOff(a.getString(4));
        this.setDisableDependentsState(a.getBoolean(2, false));
        a.recycle();
    }

    public SwitchPreference(Context context, AttributeSet attrs) {
        this(context, attrs, 16843629);
    }

    public SwitchPreference(Context context) {
        this(context, null);
    }

    protected void onBindView(View view) {
        super.onBindView(view);
        View checkableView = view.findViewById(16909051);
        if (checkableView != null && checkableView instanceof Checkable) {
            ((Checkable)((Object)checkableView)).setChecked(this.mChecked);
            this.sendAccessibilityEvent(checkableView);
            if (checkableView instanceof Switch) {
                Switch switchView = (Switch)checkableView;
                switchView.setTextOn(this.mSwitchOn);
                switchView.setTextOff(this.mSwitchOff);
                switchView.setOnCheckedChangeListener(this.mListener);
            }
        }
        this.syncSummaryView(view);
    }

    public void setSwitchTextOn(CharSequence onText) {
        this.mSwitchOn = onText;
        this.notifyChanged();
    }

    public void setSwitchTextOff(CharSequence offText) {
        this.mSwitchOff = offText;
        this.notifyChanged();
    }

    public void setSwitchTextOn(int resId) {
        this.setSwitchTextOn(this.getContext().getString(resId));
    }

    public void setSwitchTextOff(int resId) {
        this.setSwitchTextOff(this.getContext().getString(resId));
    }

    public CharSequence getSwitchTextOn() {
        return this.mSwitchOn;
    }

    public CharSequence getSwitchTextOff() {
        return this.mSwitchOff;
    }

    private class Listener
    implements CompoundButton.OnCheckedChangeListener {
        private Listener() {
        }

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (!SwitchPreference.this.callChangeListener(isChecked)) {
                buttonView.setChecked(!isChecked);
                return;
            }
            SwitchPreference.this.setChecked(isChecked);
        }
    }
}

