/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.speech.tts.AbstractSynthesisCallback;
import android.speech.tts.AudioPlaybackHandler;
import android.speech.tts.BlockingAudioTrack;
import android.speech.tts.EventLogger;
import android.speech.tts.SynthesisPlaybackQueueItem;
import android.speech.tts.TextToSpeechService;
import android.util.Log;

class PlaybackSynthesisCallback
extends AbstractSynthesisCallback {
    private static final String TAG = "PlaybackSynthesisRequest";
    private static final boolean DBG = false;
    private static final int MIN_AUDIO_BUFFER_SIZE = 8192;
    private final int mStreamType;
    private final float mVolume;
    private final float mPan;
    private final Object mStateLock = new Object();
    private final AudioPlaybackHandler mAudioTrackHandler;
    private SynthesisPlaybackQueueItem mItem = null;
    private boolean mStopped = false;
    private volatile boolean mDone = false;
    private final TextToSpeechService.UtteranceProgressDispatcher mDispatcher;
    private final Object mCallerIdentity;
    private final EventLogger mLogger;

    PlaybackSynthesisCallback(int streamType, float volume, float pan, AudioPlaybackHandler audioTrackHandler, TextToSpeechService.UtteranceProgressDispatcher dispatcher, Object callerIdentity, EventLogger logger) {
        this.mStreamType = streamType;
        this.mVolume = volume;
        this.mPan = pan;
        this.mAudioTrackHandler = audioTrackHandler;
        this.mDispatcher = dispatcher;
        this.mCallerIdentity = callerIdentity;
        this.mLogger = logger;
    }

    void stop() {
        this.stopImpl(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopImpl(boolean wasError) {
        SynthesisPlaybackQueueItem item;
        this.mLogger.onStopped();
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mStopped) {
                Log.w(TAG, "stop() called twice");
                return;
            }
            item = this.mItem;
            this.mStopped = true;
        }
        if (item != null) {
            item.stop(wasError);
        } else {
            this.mLogger.onWriteData();
            if (wasError) {
                this.mDispatcher.dispatchOnError();
            }
        }
    }

    public int getMaxBufferSize() {
        return 8192;
    }

    boolean isDone() {
        return this.mDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start(int sampleRateInHz, int audioFormat, int channelCount) {
        int channelConfig = BlockingAudioTrack.getChannelConfig(channelCount);
        if (channelConfig == 0) {
            Log.e(TAG, "Unsupported number of channels :" + channelCount);
            return -1;
        }
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mStopped) {
                return -1;
            }
            SynthesisPlaybackQueueItem item = new SynthesisPlaybackQueueItem(this.mStreamType, sampleRateInHz, audioFormat, channelCount, this.mVolume, this.mPan, this.mDispatcher, this.mCallerIdentity, this.mLogger);
            this.mAudioTrackHandler.enqueue(item);
            this.mItem = item;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int audioAvailable(byte[] buffer, int offset, int length) {
        if (length > this.getMaxBufferSize() || length <= 0) {
            throw new IllegalArgumentException("buffer is too large or of zero length (" + length + " bytes)");
        }
        SynthesisPlaybackQueueItem item = null;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mItem == null || this.mStopped) {
                return -1;
            }
            item = this.mItem;
        }
        byte[] bufferCopy = new byte[length];
        System.arraycopy(buffer, offset, bufferCopy, 0, length);
        try {
            item.put(bufferCopy);
        }
        catch (InterruptedException ie) {
            return -1;
        }
        this.mLogger.onEngineDataReceived();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int done() {
        SynthesisPlaybackQueueItem item = null;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mDone) {
                Log.w(TAG, "Duplicate call to done()");
                return -1;
            }
            this.mDone = true;
            if (this.mItem == null) {
                return -1;
            }
            item = this.mItem;
        }
        item.done();
        this.mLogger.onEngineComplete();
        return 0;
    }

    public void error() {
        this.mLogger.onError();
        this.stopImpl(true);
    }
}

