/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.speech.tts.BlockingAudioTrack;
import android.speech.tts.EventLogger;
import android.speech.tts.PlaybackQueueItem;
import android.speech.tts.TextToSpeechService;
import java.util.LinkedList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class SynthesisPlaybackQueueItem
extends PlaybackQueueItem {
    private static final String TAG = "TTS.SynthQueueItem";
    private static final boolean DBG = false;
    private static final long MAX_UNCONSUMED_AUDIO_MS = 500L;
    private final Lock mListLock = new ReentrantLock();
    private final Condition mReadReady = this.mListLock.newCondition();
    private final Condition mNotFull = this.mListLock.newCondition();
    private final LinkedList<ListEntry> mDataBufferList = new LinkedList();
    private int mUnconsumedBytes = 0;
    private volatile boolean mStopped = false;
    private volatile boolean mDone = false;
    private volatile boolean mIsError = false;
    private final BlockingAudioTrack mAudioTrack;
    private final EventLogger mLogger;

    SynthesisPlaybackQueueItem(int streamType, int sampleRate, int audioFormat, int channelCount, float volume, float pan, TextToSpeechService.UtteranceProgressDispatcher dispatcher, Object callerIdentity, EventLogger logger) {
        super(dispatcher, callerIdentity);
        this.mAudioTrack = new BlockingAudioTrack(streamType, sampleRate, audioFormat, channelCount, volume, pan);
        this.mLogger = logger;
    }

    public void run() {
        TextToSpeechService.UtteranceProgressDispatcher dispatcher = this.getDispatcher();
        dispatcher.dispatchOnStart();
        if (!this.mAudioTrack.init()) {
            dispatcher.dispatchOnError();
            return;
        }
        try {
            byte[] buffer = null;
            while ((buffer = this.take()) != null) {
                this.mAudioTrack.write(buffer);
                this.mLogger.onAudioDataWritten();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mAudioTrack.waitAndRelease();
        if (this.mIsError) {
            dispatcher.dispatchOnError();
        } else {
            dispatcher.dispatchOnDone();
        }
        this.mLogger.onWriteData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(boolean isError) {
        try {
            this.mListLock.lock();
            this.mStopped = true;
            this.mIsError = isError;
            this.mReadReady.signal();
            this.mNotFull.signal();
        }
        finally {
            this.mListLock.unlock();
        }
        this.mAudioTrack.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void done() {
        try {
            this.mListLock.lock();
            this.mDone = true;
            this.mReadReady.signal();
            this.mNotFull.signal();
        }
        finally {
            this.mListLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(byte[] buffer) throws InterruptedException {
        try {
            this.mListLock.lock();
            long unconsumedAudioMs = 0L;
            while ((unconsumedAudioMs = this.mAudioTrack.getAudioLengthMs(this.mUnconsumedBytes)) > 500L && !this.mStopped) {
                this.mNotFull.await();
            }
            if (this.mStopped) {
                return;
            }
            this.mDataBufferList.add(new ListEntry(buffer));
            this.mUnconsumedBytes += buffer.length;
            this.mReadReady.signal();
        }
        finally {
            this.mListLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] take() throws InterruptedException {
        try {
            this.mListLock.lock();
            while (this.mDataBufferList.size() == 0 && !this.mStopped && !this.mDone) {
                this.mReadReady.await();
            }
            if (this.mStopped) {
                byte[] byArray = null;
                return byArray;
            }
            ListEntry entry = this.mDataBufferList.poll();
            if (entry == null) {
                byte[] byArray = null;
                return byArray;
            }
            this.mUnconsumedBytes -= entry.mBytes.length;
            this.mNotFull.signal();
            byte[] byArray = entry.mBytes;
            return byArray;
        }
        finally {
            this.mListLock.unlock();
        }
    }

    static final class ListEntry {
        final byte[] mBytes;

        ListEntry(byte[] bytes) {
            this.mBytes = bytes;
        }
    }
}

