/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.speech.tts.ITextToSpeechCallback;
import android.speech.tts.ITextToSpeechService;
import android.speech.tts.TtsEngines;
import android.speech.tts.UtteranceProgressListener;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextToSpeech {
    private static final String TAG = "TextToSpeech";
    public static final int SUCCESS = 0;
    public static final int ERROR = -1;
    public static final int QUEUE_FLUSH = 0;
    public static final int QUEUE_ADD = 1;
    static final int QUEUE_DESTROY = 2;
    public static final int LANG_COUNTRY_VAR_AVAILABLE = 2;
    public static final int LANG_COUNTRY_AVAILABLE = 1;
    public static final int LANG_AVAILABLE = 0;
    public static final int LANG_MISSING_DATA = -1;
    public static final int LANG_NOT_SUPPORTED = -2;
    public static final String ACTION_TTS_QUEUE_PROCESSING_COMPLETED = "android.speech.tts.TTS_QUEUE_PROCESSING_COMPLETED";
    private final Context mContext;
    private Connection mConnectingServiceConnection;
    private Connection mServiceConnection;
    private OnInitListener mInitListener;
    private volatile UtteranceProgressListener mUtteranceProgressListener;
    private final Object mStartLock = new Object();
    private String mRequestedEngine;
    private final boolean mUseFallback;
    private final Map<String, Uri> mEarcons;
    private final Map<String, Uri> mUtterances;
    private final Bundle mParams = new Bundle();
    private final TtsEngines mEnginesHelper;
    private final String mPackageName;
    private volatile String mCurrentEngine = null;

    public TextToSpeech(Context context, OnInitListener listener) {
        this(context, listener, null);
    }

    public TextToSpeech(Context context, OnInitListener listener, String engine) {
        this(context, listener, engine, null, true);
    }

    public TextToSpeech(Context context, OnInitListener listener, String engine, String packageName, boolean useFallback) {
        this.mContext = context;
        this.mInitListener = listener;
        this.mRequestedEngine = engine;
        this.mUseFallback = useFallback;
        this.mEarcons = new HashMap<String, Uri>();
        this.mUtterances = new HashMap<String, Uri>();
        this.mUtteranceProgressListener = null;
        this.mEnginesHelper = new TtsEngines(this.mContext);
        this.mPackageName = packageName != null ? packageName : this.mContext.getPackageName();
        this.initTts();
    }

    private <R> R runActionNoReconnect(Action<R> action, R errorResult, String method, boolean onlyEstablishedConnection) {
        return this.runAction(action, errorResult, method, false, onlyEstablishedConnection);
    }

    private <R> R runAction(Action<R> action, R errorResult, String method) {
        return this.runAction(action, errorResult, method, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R runAction(Action<R> action, R errorResult, String method, boolean reconnect, boolean onlyEstablishedConnection) {
        Object object = this.mStartLock;
        synchronized (object) {
            if (this.mServiceConnection == null) {
                Log.w(TAG, method + " failed: not bound to TTS engine");
                return errorResult;
            }
            return this.mServiceConnection.runAction(action, errorResult, method, reconnect, onlyEstablishedConnection);
        }
    }

    private int initTts() {
        String defaultEngine;
        if (this.mRequestedEngine != null) {
            if (this.mEnginesHelper.isEngineInstalled(this.mRequestedEngine)) {
                if (this.connectToEngine(this.mRequestedEngine)) {
                    this.mCurrentEngine = this.mRequestedEngine;
                    return 0;
                }
                if (!this.mUseFallback) {
                    this.mCurrentEngine = null;
                    this.dispatchOnInit(-1);
                    return -1;
                }
            } else if (!this.mUseFallback) {
                Log.i(TAG, "Requested engine not installed: " + this.mRequestedEngine);
                this.mCurrentEngine = null;
                this.dispatchOnInit(-1);
                return -1;
            }
        }
        if ((defaultEngine = this.getDefaultEngine()) != null && !defaultEngine.equals(this.mRequestedEngine) && this.connectToEngine(defaultEngine)) {
            this.mCurrentEngine = defaultEngine;
            return 0;
        }
        String highestRanked = this.mEnginesHelper.getHighestRankedEngineName();
        if (highestRanked != null && !highestRanked.equals(this.mRequestedEngine) && !highestRanked.equals(defaultEngine) && this.connectToEngine(highestRanked)) {
            this.mCurrentEngine = highestRanked;
            return 0;
        }
        this.mCurrentEngine = null;
        this.dispatchOnInit(-1);
        return -1;
    }

    private boolean connectToEngine(String engine) {
        Connection connection = new Connection();
        Intent intent = new Intent("android.intent.action.TTS_SERVICE");
        intent.setPackage(engine);
        boolean bound = this.mContext.bindService(intent, connection, 1);
        if (!bound) {
            Log.e(TAG, "Failed to bind to " + engine);
            return false;
        }
        Log.i(TAG, "Sucessfully bound to " + engine);
        this.mConnectingServiceConnection = connection;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchOnInit(int result) {
        Object object = this.mStartLock;
        synchronized (object) {
            if (this.mInitListener != null) {
                this.mInitListener.onInit(result);
                this.mInitListener = null;
            }
        }
    }

    private IBinder getCallerIdentity() {
        return this.mServiceConnection.getCallerIdentity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.mStartLock;
        synchronized (object) {
            if (this.mConnectingServiceConnection != null) {
                this.mContext.unbindService(this.mConnectingServiceConnection);
                this.mConnectingServiceConnection = null;
                return;
            }
        }
        this.runActionNoReconnect(new Action<Void>(){

            @Override
            public Void run(ITextToSpeechService service) throws RemoteException {
                service.setCallback(TextToSpeech.this.getCallerIdentity(), null);
                service.stop(TextToSpeech.this.getCallerIdentity());
                TextToSpeech.this.mServiceConnection.disconnect();
                TextToSpeech.this.mServiceConnection = null;
                TextToSpeech.this.mCurrentEngine = null;
                return null;
            }
        }, null, "shutdown", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSpeech(String text, String packagename, int resourceId) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mUtterances.put(text, this.makeResourceUri(packagename, resourceId));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSpeech(String text, String filename) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mUtterances.put(text, Uri.parse(filename));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addEarcon(String earcon, String packagename, int resourceId) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mEarcons.put(earcon, this.makeResourceUri(packagename, resourceId));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addEarcon(String earcon, String filename) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mEarcons.put(earcon, Uri.parse(filename));
            return 0;
        }
    }

    private Uri makeResourceUri(String packageName, int resourceId) {
        return new Uri.Builder().scheme("android.resource").encodedAuthority(packageName).appendEncodedPath(String.valueOf(resourceId)).build();
    }

    public int speak(final String text, final int queueMode, final HashMap<String, String> params) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService service) throws RemoteException {
                Uri utteranceUri = (Uri)TextToSpeech.this.mUtterances.get(text);
                if (utteranceUri != null) {
                    return service.playAudio(TextToSpeech.this.getCallerIdentity(), utteranceUri, queueMode, TextToSpeech.this.getParams(params));
                }
                return service.speak(TextToSpeech.this.getCallerIdentity(), text, queueMode, TextToSpeech.this.getParams(params));
            }
        }, -1, "speak");
    }

    public int playEarcon(final String earcon, final int queueMode, final HashMap<String, String> params) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService service) throws RemoteException {
                Uri earconUri = (Uri)TextToSpeech.this.mEarcons.get(earcon);
                if (earconUri == null) {
                    return -1;
                }
                return service.playAudio(TextToSpeech.this.getCallerIdentity(), earconUri, queueMode, TextToSpeech.this.getParams(params));
            }
        }, -1, "playEarcon");
    }

    public int playSilence(final long durationInMs, final int queueMode, final HashMap<String, String> params) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService service) throws RemoteException {
                return service.playSilence(TextToSpeech.this.getCallerIdentity(), durationInMs, queueMode, TextToSpeech.this.getParams(params));
            }
        }, -1, "playSilence");
    }

    public Set<String> getFeatures(final Locale locale) {
        return this.runAction(new Action<Set<String>>(){

            @Override
            public Set<String> run(ITextToSpeechService service) throws RemoteException {
                String[] features = null;
                try {
                    features = service.getFeaturesForLanguage(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
                }
                catch (MissingResourceException e) {
                    Log.w(TextToSpeech.TAG, "Couldn't retrieve 3 letter ISO 639-2/T language and/or ISO 3166 country code for locale: " + locale, e);
                    return null;
                }
                if (features != null) {
                    HashSet<String> featureSet = new HashSet<String>();
                    Collections.addAll(featureSet, features);
                    return featureSet;
                }
                return null;
            }
        }, null, "getFeatures");
    }

    public boolean isSpeaking() {
        return this.runAction(new Action<Boolean>(){

            @Override
            public Boolean run(ITextToSpeechService service) throws RemoteException {
                return service.isSpeaking();
            }
        }, false, "isSpeaking");
    }

    public int stop() {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService service) throws RemoteException {
                return service.stop(TextToSpeech.this.getCallerIdentity());
            }
        }, -1, "stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setSpeechRate(float speechRate) {
        int intRate;
        if (speechRate > 0.0f && (intRate = (int)(speechRate * 100.0f)) > 0) {
            Object object = this.mStartLock;
            synchronized (object) {
                this.mParams.putInt("rate", intRate);
            }
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setPitch(float pitch) {
        int intPitch;
        if (pitch > 0.0f && (intPitch = (int)(pitch * 100.0f)) > 0) {
            Object object = this.mStartLock;
            synchronized (object) {
                this.mParams.putInt("pitch", intPitch);
            }
            return 0;
        }
        return -1;
    }

    public String getCurrentEngine() {
        return this.mCurrentEngine;
    }

    public Locale getDefaultLanguage() {
        return this.runAction(new Action<Locale>(){

            @Override
            public Locale run(ITextToSpeechService service) throws RemoteException {
                String[] defaultLanguage = service.getClientDefaultLanguage();
                return new Locale(defaultLanguage[0], defaultLanguage[1], defaultLanguage[2]);
            }
        }, null, "getDefaultLanguage");
    }

    public int setLanguage(final Locale loc) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService service) throws RemoteException {
                if (loc == null) {
                    return -2;
                }
                String language = null;
                String country = null;
                try {
                    language = loc.getISO3Language();
                }
                catch (MissingResourceException e) {
                    Log.w(TextToSpeech.TAG, "Couldn't retrieve ISO 639-2/T language code for locale: " + loc, e);
                    return -2;
                }
                try {
                    country = loc.getISO3Country();
                }
                catch (MissingResourceException e) {
                    Log.w(TextToSpeech.TAG, "Couldn't retrieve ISO 3166 country code for locale: " + loc, e);
                    return -2;
                }
                String variant = loc.getVariant();
                int result = service.loadLanguage(TextToSpeech.this.getCallerIdentity(), language, country, variant);
                if (result >= 0) {
                    if (result < 2) {
                        variant = "";
                        if (result < 1) {
                            country = "";
                        }
                    }
                    TextToSpeech.this.mParams.putString("language", language);
                    TextToSpeech.this.mParams.putString("country", country);
                    TextToSpeech.this.mParams.putString("variant", variant);
                }
                return result;
            }
        }, -2, "setLanguage");
    }

    public Locale getLanguage() {
        return this.runAction(new Action<Locale>(){

            @Override
            public Locale run(ITextToSpeechService service) {
                String lang = TextToSpeech.this.mParams.getString("language", "");
                String country = TextToSpeech.this.mParams.getString("country", "");
                String variant = TextToSpeech.this.mParams.getString("variant", "");
                return new Locale(lang, country, variant);
            }
        }, null, "getLanguage");
    }

    public int isLanguageAvailable(final Locale loc) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService service) throws RemoteException {
                String language = null;
                String country = null;
                try {
                    language = loc.getISO3Language();
                }
                catch (MissingResourceException e) {
                    Log.w(TextToSpeech.TAG, "Couldn't retrieve ISO 639-2/T language code for locale: " + loc, e);
                    return -2;
                }
                try {
                    country = loc.getISO3Country();
                }
                catch (MissingResourceException e) {
                    Log.w(TextToSpeech.TAG, "Couldn't retrieve ISO 3166 country code for locale: " + loc, e);
                    return -2;
                }
                return service.isLanguageAvailable(language, country, loc.getVariant());
            }
        }, -2, "isLanguageAvailable");
    }

    public int synthesizeToFile(final String text, final HashMap<String, String> params, final String filename) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService service) throws RemoteException {
                try {
                    File file = new File(filename);
                    if (file.exists() && !file.canWrite()) {
                        Log.e(TextToSpeech.TAG, "Can't write to " + filename);
                        return -1;
                    }
                    ParcelFileDescriptor fileDescriptor = ParcelFileDescriptor.open(file, 0x2C000000);
                    int returnValue = service.synthesizeToFileDescriptor(TextToSpeech.this.getCallerIdentity(), text, fileDescriptor, TextToSpeech.this.getParams(params));
                    fileDescriptor.close();
                    return returnValue;
                }
                catch (FileNotFoundException e) {
                    Log.e(TextToSpeech.TAG, "Opening file " + filename + " failed", e);
                    return -1;
                }
                catch (IOException e) {
                    Log.e(TextToSpeech.TAG, "Closing file " + filename + " failed", e);
                    return -1;
                }
            }
        }, -1, "synthesizeToFile");
    }

    private Bundle getParams(HashMap<String, String> params) {
        if (params != null && !params.isEmpty()) {
            Bundle bundle = new Bundle(this.mParams);
            this.copyIntParam(bundle, params, "streamType");
            this.copyStringParam(bundle, params, "utteranceId");
            this.copyFloatParam(bundle, params, "volume");
            this.copyFloatParam(bundle, params, "pan");
            this.copyStringParam(bundle, params, "networkTts");
            this.copyStringParam(bundle, params, "embeddedTts");
            if (!TextUtils.isEmpty(this.mCurrentEngine)) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String key = entry.getKey();
                    if (key == null || !key.startsWith(this.mCurrentEngine)) continue;
                    bundle.putString(key, entry.getValue());
                }
            }
            return bundle;
        }
        return this.mParams;
    }

    private void copyStringParam(Bundle bundle, HashMap<String, String> params, String key) {
        String value = params.get(key);
        if (value != null) {
            bundle.putString(key, value);
        }
    }

    private void copyIntParam(Bundle bundle, HashMap<String, String> params, String key) {
        String valueString = params.get(key);
        if (!TextUtils.isEmpty(valueString)) {
            try {
                int value = Integer.parseInt(valueString);
                bundle.putInt(key, value);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
    }

    private void copyFloatParam(Bundle bundle, HashMap<String, String> params, String key) {
        String valueString = params.get(key);
        if (!TextUtils.isEmpty(valueString)) {
            try {
                float value = Float.parseFloat(valueString);
                bundle.putFloat(key, value);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public int setOnUtteranceCompletedListener(OnUtteranceCompletedListener listener) {
        this.mUtteranceProgressListener = UtteranceProgressListener.from(listener);
        return 0;
    }

    public int setOnUtteranceProgressListener(UtteranceProgressListener listener) {
        this.mUtteranceProgressListener = listener;
        return 0;
    }

    @Deprecated
    public int setEngineByPackageName(String enginePackageName) {
        this.mRequestedEngine = enginePackageName;
        return this.initTts();
    }

    public String getDefaultEngine() {
        return this.mEnginesHelper.getDefaultEngine();
    }

    public boolean areDefaultsEnforced() {
        return false;
    }

    public List<EngineInfo> getEngines() {
        return this.mEnginesHelper.getEngines();
    }

    public static int getMaxSpeechInputLength() {
        return 4000;
    }

    public static class EngineInfo {
        public String name;
        public String label;
        public int icon;
        public boolean system;
        public int priority;

        public String toString() {
            return "EngineInfo{name=" + this.name + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Action<R> {
        public R run(ITextToSpeechService var1) throws RemoteException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Connection
    implements ServiceConnection {
        private ITextToSpeechService mService;
        private SetupConnectionAsyncTask mOnSetupConnectionAsyncTask;
        private boolean mEstablished;
        private final ITextToSpeechCallback.Stub mCallback = new ITextToSpeechCallback.Stub(){

            public void onDone(String utteranceId) {
                UtteranceProgressListener listener = TextToSpeech.this.mUtteranceProgressListener;
                if (listener != null) {
                    listener.onDone(utteranceId);
                }
            }

            public void onError(String utteranceId) {
                UtteranceProgressListener listener = TextToSpeech.this.mUtteranceProgressListener;
                if (listener != null) {
                    listener.onError(utteranceId);
                }
            }

            public void onStart(String utteranceId) {
                UtteranceProgressListener listener = TextToSpeech.this.mUtteranceProgressListener;
                if (listener != null) {
                    listener.onStart(utteranceId);
                }
            }
        };

        private Connection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = TextToSpeech.this.mStartLock;
            synchronized (object) {
                TextToSpeech.this.mConnectingServiceConnection = null;
                Log.i(TextToSpeech.TAG, "Connected to " + name);
                if (this.mOnSetupConnectionAsyncTask != null) {
                    this.mOnSetupConnectionAsyncTask.cancel(false);
                }
                this.mService = ITextToSpeechService.Stub.asInterface(service);
                TextToSpeech.this.mServiceConnection = this;
                this.mEstablished = false;
                this.mOnSetupConnectionAsyncTask = new SetupConnectionAsyncTask(name);
                this.mOnSetupConnectionAsyncTask.execute(new Void[0]);
            }
        }

        public IBinder getCallerIdentity() {
            return this.mCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean clearServiceConnection() {
            Object object = TextToSpeech.this.mStartLock;
            synchronized (object) {
                boolean result = false;
                if (this.mOnSetupConnectionAsyncTask != null) {
                    result = this.mOnSetupConnectionAsyncTask.cancel(false);
                    this.mOnSetupConnectionAsyncTask = null;
                }
                this.mService = null;
                if (TextToSpeech.this.mServiceConnection == this) {
                    TextToSpeech.this.mServiceConnection = null;
                }
                return result;
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            Log.i(TextToSpeech.TAG, "Asked to disconnect from " + name);
            if (this.clearServiceConnection()) {
                TextToSpeech.this.dispatchOnInit(-1);
            }
        }

        public void disconnect() {
            TextToSpeech.this.mContext.unbindService(this);
            this.clearServiceConnection();
        }

        public boolean isEstablished() {
            return this.mService != null && this.mEstablished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <R> R runAction(Action<R> action, R errorResult, String method, boolean reconnect, boolean onlyEstablishedConnection) {
            Object object = TextToSpeech.this.mStartLock;
            synchronized (object) {
                try {
                    if (this.mService == null) {
                        Log.w(TextToSpeech.TAG, method + " failed: not connected to TTS engine");
                        return errorResult;
                    }
                    if (onlyEstablishedConnection && !this.isEstablished()) {
                        Log.w(TextToSpeech.TAG, method + " failed: TTS engine connection not fully set up");
                        return errorResult;
                    }
                    return action.run(this.mService);
                }
                catch (RemoteException ex) {
                    Log.e(TextToSpeech.TAG, method + " failed", ex);
                    if (reconnect) {
                        this.disconnect();
                        TextToSpeech.this.initTts();
                    }
                    return errorResult;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SetupConnectionAsyncTask
        extends AsyncTask<Void, Void, Integer> {
            private final ComponentName mName;

            public SetupConnectionAsyncTask(ComponentName name) {
                this.mName = name;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Integer doInBackground(Void ... params) {
                Object object = TextToSpeech.this.mStartLock;
                synchronized (object) {
                    if (this.isCancelled()) {
                        return null;
                    }
                    try {
                        Connection.this.mService.setCallback(Connection.this.getCallerIdentity(), Connection.this.mCallback);
                        String[] defaultLanguage = Connection.this.mService.getClientDefaultLanguage();
                        TextToSpeech.this.mParams.putString("language", defaultLanguage[0]);
                        TextToSpeech.this.mParams.putString("country", defaultLanguage[1]);
                        TextToSpeech.this.mParams.putString("variant", defaultLanguage[2]);
                        Log.i(TextToSpeech.TAG, "Set up connection to " + this.mName);
                        return 0;
                    }
                    catch (RemoteException re) {
                        Log.e(TextToSpeech.TAG, "Error connecting to service, setCallback() failed");
                        return -1;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onPostExecute(Integer result) {
                Object object = TextToSpeech.this.mStartLock;
                synchronized (object) {
                    if (Connection.this.mOnSetupConnectionAsyncTask == this) {
                        Connection.this.mOnSetupConnectionAsyncTask = null;
                    }
                    Connection.this.mEstablished = true;
                    TextToSpeech.this.dispatchOnInit(result);
                }
            }
        }
    }

    public class Engine {
        public static final int DEFAULT_RATE = 100;
        public static final int DEFAULT_PITCH = 100;
        public static final float DEFAULT_VOLUME = 1.0f;
        public static final float DEFAULT_PAN = 0.0f;
        public static final int USE_DEFAULTS = 0;
        @Deprecated
        public static final String DEFAULT_ENGINE = "com.svox.pico";
        public static final int DEFAULT_STREAM = 3;
        public static final int CHECK_VOICE_DATA_PASS = 1;
        public static final int CHECK_VOICE_DATA_FAIL = 0;
        @Deprecated
        public static final int CHECK_VOICE_DATA_BAD_DATA = -1;
        @Deprecated
        public static final int CHECK_VOICE_DATA_MISSING_DATA = -2;
        @Deprecated
        public static final int CHECK_VOICE_DATA_MISSING_VOLUME = -3;
        public static final String INTENT_ACTION_TTS_SERVICE = "android.intent.action.TTS_SERVICE";
        public static final String SERVICE_META_DATA = "android.speech.tts";
        public static final String ACTION_INSTALL_TTS_DATA = "android.speech.tts.engine.INSTALL_TTS_DATA";
        public static final String ACTION_TTS_DATA_INSTALLED = "android.speech.tts.engine.TTS_DATA_INSTALLED";
        public static final String ACTION_CHECK_TTS_DATA = "android.speech.tts.engine.CHECK_TTS_DATA";
        public static final String ACTION_GET_SAMPLE_TEXT = "android.speech.tts.engine.GET_SAMPLE_TEXT";
        public static final String EXTRA_SAMPLE_TEXT = "sampleText";
        public static final String EXTRA_AVAILABLE_VOICES = "availableVoices";
        public static final String EXTRA_UNAVAILABLE_VOICES = "unavailableVoices";
        @Deprecated
        public static final String EXTRA_VOICE_DATA_ROOT_DIRECTORY = "dataRoot";
        @Deprecated
        public static final String EXTRA_VOICE_DATA_FILES = "dataFiles";
        @Deprecated
        public static final String EXTRA_VOICE_DATA_FILES_INFO = "dataFilesInfo";
        @Deprecated
        public static final String EXTRA_CHECK_VOICE_DATA_FOR = "checkVoiceDataFor";
        @Deprecated
        public static final String EXTRA_TTS_DATA_INSTALLED = "dataInstalled";
        public static final String KEY_PARAM_RATE = "rate";
        public static final String KEY_PARAM_LANGUAGE = "language";
        public static final String KEY_PARAM_COUNTRY = "country";
        public static final String KEY_PARAM_VARIANT = "variant";
        public static final String KEY_PARAM_ENGINE = "engine";
        public static final String KEY_PARAM_PITCH = "pitch";
        public static final String KEY_PARAM_STREAM = "streamType";
        public static final String KEY_PARAM_UTTERANCE_ID = "utteranceId";
        public static final String KEY_PARAM_VOLUME = "volume";
        public static final String KEY_PARAM_PAN = "pan";
        public static final String KEY_FEATURE_NETWORK_SYNTHESIS = "networkTts";
        public static final String KEY_FEATURE_EMBEDDED_SYNTHESIS = "embeddedTts";
    }

    @Deprecated
    public static interface OnUtteranceCompletedListener {
        public void onUtteranceCompleted(String var1);
    }

    public static interface OnInitListener {
        public void onInit(int var1);
    }
}

