/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidTestCase
extends TestCase {
    protected Context mContext;
    private Context mTestContext;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAndroidTestCaseSetupProperly() {
        AndroidTestCase.assertNotNull("Context is null. setContext should be called before tests are run", this.mContext);
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    public Context getContext() {
        return this.mContext;
    }

    public void setTestContext(Context context) {
        this.mTestContext = context;
    }

    public Context getTestContext() {
        return this.mTestContext;
    }

    public void assertActivityRequiresPermission(String packageName, String className, String permission2) {
        Intent intent = new Intent();
        intent.setClassName(packageName, className);
        intent.addFlags(0x10000000);
        try {
            this.getContext().startActivity(intent);
            AndroidTestCase.fail("expected security exception for " + permission2);
        }
        catch (SecurityException expected) {
            AndroidTestCase.assertNotNull("security exception's error message.", expected.getMessage());
            AndroidTestCase.assertTrue("error message should contain " + permission2 + ".", expected.getMessage().contains(permission2));
        }
    }

    public void assertReadingContentUriRequiresPermission(Uri uri, String permission2) {
        try {
            this.getContext().getContentResolver().query(uri, null, null, null, null);
            AndroidTestCase.fail("expected SecurityException requiring " + permission2);
        }
        catch (SecurityException expected) {
            AndroidTestCase.assertNotNull("security exception's error message.", expected.getMessage());
            AndroidTestCase.assertTrue("error message should contain " + permission2 + ".", expected.getMessage().contains(permission2));
        }
    }

    public void assertWritingContentUriRequiresPermission(Uri uri, String permission2) {
        try {
            this.getContext().getContentResolver().insert(uri, new ContentValues());
            AndroidTestCase.fail("expected SecurityException requiring " + permission2);
        }
        catch (SecurityException expected) {
            AndroidTestCase.assertNotNull("security exception's error message.", expected.getMessage());
            AndroidTestCase.assertTrue("error message should contain \"" + permission2 + "\". Got: \"" + expected.getMessage() + "\".", expected.getMessage().contains(permission2));
        }
    }

    protected void scrubClass(Class<?> testCaseClass) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            if (field.getType().isPrimitive() || Modifier.isStatic(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                field.set(this, null);
            }
            catch (Exception e) {
                Log.d("TestCase", "Error: Could not nullify field!");
            }
            if (field.get(this) == null) continue;
            Log.d("TestCase", "Error: Could not nullify field!");
        }
    }
}

