/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.test.ClassPathPackageInfoSource;
import com.google.android.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathPackageInfo {
    private final ClassPathPackageInfoSource source;
    private final String packageName;
    private final Set<String> subpackageNames;
    private final Set<Class<?>> topLevelClasses;

    ClassPathPackageInfo(ClassPathPackageInfoSource source, String packageName, Set<String> subpackageNames, Set<Class<?>> topLevelClasses) {
        this.source = source;
        this.packageName = packageName;
        this.subpackageNames = Collections.unmodifiableSet(subpackageNames);
        this.topLevelClasses = Collections.unmodifiableSet(topLevelClasses);
    }

    public Set<ClassPathPackageInfo> getSubpackages() {
        HashSet<ClassPathPackageInfo> info = Sets.newHashSet();
        for (String name : this.subpackageNames) {
            info.add(this.source.getPackageInfo(name));
        }
        return info;
    }

    public Set<Class<?>> getTopLevelClassesRecursive() {
        HashSet<Class<?>> set = Sets.newHashSet();
        this.addTopLevelClassesTo(set);
        return set;
    }

    private void addTopLevelClassesTo(Set<Class<?>> set) {
        set.addAll(this.topLevelClasses);
        for (ClassPathPackageInfo info : this.getSubpackages()) {
            info.addTopLevelClassesTo(set);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassPathPackageInfo) {
            ClassPathPackageInfo that = (ClassPathPackageInfo)obj;
            return this.packageName.equals(that.packageName);
        }
        return false;
    }

    public int hashCode() {
        return this.packageName.hashCode();
    }
}

