/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.test.ClassPathPackageInfo;
import android.test.SimpleCache;
import android.util.Log;
import com.google.android.collect.Maps;
import com.google.android.collect.Sets;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathPackageInfoSource {
    private static final String CLASS_EXTENSION = ".class";
    private static final ClassLoader CLASS_LOADER = ClassPathPackageInfoSource.class.getClassLoader();
    private final SimpleCache<String, ClassPathPackageInfo> cache = new SimpleCache<String, ClassPathPackageInfo>(){

        @Override
        protected ClassPathPackageInfo load(String pkgName) {
            return ClassPathPackageInfoSource.this.createPackageInfo(pkgName);
        }
    };
    private final String[] classPath;
    private static String[] apkPaths;
    private final Map<File, Set<String>> jarFiles = Maps.newHashMap();
    private ClassLoader classLoader;

    ClassPathPackageInfoSource() {
        this.classPath = ClassPathPackageInfoSource.getClassPath();
    }

    public static void setApkPaths(String[] apkPaths) {
        ClassPathPackageInfoSource.apkPaths = apkPaths;
    }

    public ClassPathPackageInfo getPackageInfo(String pkgName) {
        return this.cache.get(pkgName);
    }

    private ClassPathPackageInfo createPackageInfo(String packageName) {
        TreeSet<String> subpackageNames = new TreeSet<String>();
        TreeSet<String> classNames = new TreeSet<String>();
        HashSet<Class<?>> topLevelClasses = Sets.newHashSet();
        this.findClasses(packageName, classNames, subpackageNames);
        for (String className : classNames) {
            if (className.endsWith(".R") || className.endsWith(".Manifest")) continue;
            try {
                topLevelClasses.add(Class.forName(className, false, this.classLoader != null ? this.classLoader : CLASS_LOADER));
            }
            catch (ClassNotFoundException e) {
                Log.w("ClassPathPackageInfoSource", "Cannot load class. Make sure it is in your apk. Class name: '" + className + "'. Message: " + e.getMessage(), e);
            }
        }
        return new ClassPathPackageInfo(this, packageName, subpackageNames, topLevelClasses);
    }

    private void findClasses(String packageName, Set<String> classNames, Set<String> subpackageNames) {
        String packagePrefix = packageName + '.';
        String pathPrefix = packagePrefix.replace('.', '/');
        for (String entryName : this.classPath) {
            File classPathEntry = new File(entryName);
            if (!classPathEntry.exists()) continue;
            try {
                if (entryName.endsWith(".apk")) {
                    this.findClassesInApk(entryName, packageName, classNames, subpackageNames);
                    continue;
                }
                for (String apkPath : apkPaths) {
                    File file = new File(apkPath);
                    this.scanForApkFiles(file, packageName, classNames, subpackageNames);
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)("Can't read classpath entry " + entryName + ": " + e.getMessage()));
            }
        }
    }

    private void scanForApkFiles(File source, String packageName, Set<String> classNames, Set<String> subpackageNames) throws IOException {
        if (source.getPath().endsWith(".apk")) {
            this.findClassesInApk(source.getPath(), packageName, classNames, subpackageNames);
        } else {
            File[] files = source.listFiles();
            if (files != null) {
                for (File file : files) {
                    this.scanForApkFiles(file, packageName, classNames, subpackageNames);
                }
            }
        }
    }

    private void findClassesInDirectory(File classDir, String packagePrefix, String pathPrefix, Set<String> classNames, Set<String> subpackageNames) throws IOException {
        File directory = new File(classDir, pathPrefix);
        if (directory.exists()) {
            for (File f : directory.listFiles()) {
                String name = f.getName();
                if (name.endsWith(CLASS_EXTENSION) && ClassPathPackageInfoSource.isToplevelClass(name)) {
                    classNames.add(packagePrefix + ClassPathPackageInfoSource.getClassName(name));
                    continue;
                }
                if (!f.isDirectory()) continue;
                subpackageNames.add(packagePrefix + name);
            }
        }
    }

    private void findClassesInJar(File jarFile, String pathPrefix, Set<String> classNames, Set<String> subpackageNames) throws IOException {
        Set<String> entryNames = this.getJarEntries(jarFile);
        if (!entryNames.contains(pathPrefix)) {
            return;
        }
        int prefixLength = pathPrefix.length();
        for (String entryName : entryNames) {
            if (!entryName.startsWith(pathPrefix) || !entryName.endsWith(CLASS_EXTENSION)) continue;
            int index = entryName.indexOf(47, prefixLength);
            if (index >= 0) {
                String p = entryName.substring(0, index).replace('/', '.');
                subpackageNames.add(p);
                continue;
            }
            if (!ClassPathPackageInfoSource.isToplevelClass(entryName)) continue;
            classNames.add(ClassPathPackageInfoSource.getClassName(entryName).replace('/', '.'));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findClassesInApk(String apkPath, String packageName, Set<String> classNames, Set<String> subpackageNames) throws IOException {
        DexFile dexFile = null;
        try {
            dexFile = new DexFile(apkPath);
            Enumeration<String> apkClassNames = dexFile.entries();
            while (apkClassNames.hasMoreElements()) {
                String className = apkClassNames.nextElement();
                if (!className.startsWith(packageName)) continue;
                String subPackageName = packageName;
                int lastPackageSeparator = className.lastIndexOf(46);
                if (lastPackageSeparator > 0) {
                    subPackageName = className.substring(0, lastPackageSeparator);
                }
                if (subPackageName.length() > packageName.length()) {
                    subpackageNames.add(subPackageName);
                    continue;
                }
                if (!ClassPathPackageInfoSource.isToplevelClass(className)) continue;
                classNames.add(className);
            }
        }
        catch (IOException e) {
        }
        finally {
            if (dexFile != null) {
                // empty if block
            }
        }
    }

    private Set<String> getJarEntries(File jarFile) throws IOException {
        Set<String> entryNames = this.jarFiles.get(jarFile);
        if (entryNames == null) {
            entryNames = Sets.newHashSet();
            ZipFile zipFile = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String entryName = entries.nextElement().getName();
                if (!entryName.endsWith(CLASS_EXTENSION)) continue;
                entryNames.add(entryName);
                int lastIndex = entryName.lastIndexOf(47);
                do {
                    String packageName = entryName.substring(0, lastIndex + 1);
                    entryNames.add(packageName);
                } while ((lastIndex = entryName.lastIndexOf(47, lastIndex - 1)) > 0);
            }
            this.jarFiles.put(jarFile, entryNames);
        }
        return entryNames;
    }

    private static boolean isToplevelClass(String fileName) {
        return fileName.indexOf(36) < 0;
    }

    private static String getClassName(String className) {
        int classNameEnd = className.length() - CLASS_EXTENSION.length();
        return className.substring(0, classNameEnd);
    }

    private static String[] getClassPath() {
        String classPath = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator", ":");
        return classPath.split(Pattern.quote(separator));
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

