/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.test.MoreAsserts;
import com.google.android.collect.Sets;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseTestUtils {
    public static void assertSchemaEquals(SQLiteDatabase expectedDb, SQLiteDatabase db) {
        Set<String> expectedSchema = DatabaseTestUtils.getSchemaSet(expectedDb);
        Set<String> schema = DatabaseTestUtils.getSchemaSet(db);
        MoreAsserts.assertEquals(expectedSchema, schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getSchemaSet(SQLiteDatabase db) {
        HashSet<String> schemaSet = Sets.newHashSet();
        Cursor entityCursor = db.rawQuery("SELECT sql FROM sqlite_master", null);
        try {
            while (entityCursor.moveToNext()) {
                String sql = entityCursor.getString(0);
                schemaSet.add(sql);
            }
        }
        finally {
            entityCursor.close();
        }
        return schemaSet;
    }
}

