/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MoreAsserts {
    private MoreAsserts() {
    }

    public static void assertAssignableFrom(Class<?> expected, Object actual) {
        MoreAsserts.assertAssignableFrom(expected, actual.getClass());
    }

    public static void assertAssignableFrom(Class<?> expected, Class<?> actual) {
        Assert.assertTrue("Expected " + expected.getCanonicalName() + " to be assignable from actual class " + actual.getCanonicalName(), expected.isAssignableFrom(actual));
    }

    public static void assertNotEqual(String message, Object unexpected, Object actual) {
        if (MoreAsserts.equal(unexpected, actual)) {
            MoreAsserts.failEqual(message, unexpected);
        }
    }

    public static void assertNotEqual(Object unexpected, Object actual) {
        MoreAsserts.assertNotEqual(null, unexpected, actual);
    }

    public static void assertEquals(String message, byte[] expected, byte[] actual) {
        if (expected.length != actual.length) {
            MoreAsserts.failWrongLength(message, expected.length, actual.length);
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            MoreAsserts.failWrongElement(message, i, expected[i], actual[i]);
        }
    }

    public static void assertEquals(byte[] expected, byte[] actual) {
        MoreAsserts.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, int[] expected, int[] actual) {
        if (expected.length != actual.length) {
            MoreAsserts.failWrongLength(message, expected.length, actual.length);
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            MoreAsserts.failWrongElement(message, i, expected[i], actual[i]);
        }
    }

    public static void assertEquals(int[] expected, int[] actual) {
        MoreAsserts.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, double[] expected, double[] actual) {
        if (expected.length != actual.length) {
            MoreAsserts.failWrongLength(message, expected.length, actual.length);
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            MoreAsserts.failWrongElement(message, i, expected[i], actual[i]);
        }
    }

    public static void assertEquals(double[] expected, double[] actual) {
        MoreAsserts.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Object[] expected, Object[] actual) {
        if (expected.length != actual.length) {
            MoreAsserts.failWrongLength(message, expected.length, actual.length);
        }
        for (int i = 0; i < expected.length; ++i) {
            Object exp = expected[i];
            Object act = actual[i];
            if (exp != null ? exp.equals(act) : act == null) continue;
            MoreAsserts.failWrongElement(message, i, exp, act);
        }
    }

    public static void assertEquals(Object[] expected, Object[] actual) {
        MoreAsserts.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Set<? extends Object> expected, Set<? extends Object> actual) {
        HashSet<? extends Object> onlyInExpected = new HashSet<Object>(expected);
        onlyInExpected.removeAll(actual);
        HashSet<? extends Object> onlyInActual = new HashSet<Object>(actual);
        onlyInActual.removeAll(expected);
        if (onlyInExpected.size() != 0 || onlyInActual.size() != 0) {
            HashSet<? extends Object> intersection = new HashSet<Object>(expected);
            intersection.retainAll(actual);
            MoreAsserts.failWithMessage(message, "Sets do not match.\nOnly in expected: " + onlyInExpected + "\nOnly in actual: " + onlyInActual + "\nIntersection: " + intersection);
        }
    }

    public static void assertEquals(Set<? extends Object> expected, Set<? extends Object> actual) {
        MoreAsserts.assertEquals(null, expected, actual);
    }

    public static MatchResult assertMatchesRegex(String message, String expectedRegex, String actual) {
        Matcher matcher;
        if (actual == null) {
            MoreAsserts.failNotMatches(message, expectedRegex, actual);
        }
        if (!(matcher = MoreAsserts.getMatcher(expectedRegex, actual)).matches()) {
            MoreAsserts.failNotMatches(message, expectedRegex, actual);
        }
        return matcher;
    }

    public static MatchResult assertMatchesRegex(String expectedRegex, String actual) {
        return MoreAsserts.assertMatchesRegex(null, expectedRegex, actual);
    }

    public static MatchResult assertContainsRegex(String message, String expectedRegex, String actual) {
        Matcher matcher;
        if (actual == null) {
            MoreAsserts.failNotContains(message, expectedRegex, actual);
        }
        if (!(matcher = MoreAsserts.getMatcher(expectedRegex, actual)).find()) {
            MoreAsserts.failNotContains(message, expectedRegex, actual);
        }
        return matcher;
    }

    public static MatchResult assertContainsRegex(String expectedRegex, String actual) {
        return MoreAsserts.assertContainsRegex(null, expectedRegex, actual);
    }

    public static void assertNotMatchesRegex(String message, String expectedRegex, String actual) {
        Matcher matcher = MoreAsserts.getMatcher(expectedRegex, actual);
        if (matcher.matches()) {
            MoreAsserts.failMatch(message, expectedRegex, actual);
        }
    }

    public static void assertNotMatchesRegex(String expectedRegex, String actual) {
        MoreAsserts.assertNotMatchesRegex(null, expectedRegex, actual);
    }

    public static void assertNotContainsRegex(String message, String expectedRegex, String actual) {
        Matcher matcher = MoreAsserts.getMatcher(expectedRegex, actual);
        if (matcher.find()) {
            MoreAsserts.failContains(message, expectedRegex, actual);
        }
    }

    public static void assertNotContainsRegex(String expectedRegex, String actual) {
        MoreAsserts.assertNotContainsRegex(null, expectedRegex, actual);
    }

    public static void assertContentsInOrder(String message, Iterable<?> actual, Object ... expected) {
        ArrayList actualList = new ArrayList();
        for (Object o : actual) {
            actualList.add(o);
        }
        Assert.assertEquals(message, Arrays.asList(expected), actualList);
    }

    public static void assertContentsInOrder(Iterable<?> actual, Object ... expected) {
        MoreAsserts.assertContentsInOrder((String)null, actual, expected);
    }

    public static void assertContentsInAnyOrder(String message, Iterable<?> actual, Object ... expected) {
        HashMap<Object, Object> expectedMap = new HashMap<Object, Object>(expected.length);
        for (Object expectedObj : expected) {
            expectedMap.put(expectedObj, expectedObj);
        }
        for (Object actualObj : actual) {
            if (expectedMap.remove(actualObj) != null) continue;
            MoreAsserts.failWithMessage(message, "Extra object in actual: (" + actualObj.toString() + ")");
        }
        if (expectedMap.size() > 0) {
            MoreAsserts.failWithMessage(message, "Extra objects in expected.");
        }
    }

    public static void assertContentsInAnyOrder(Iterable<?> actual, Object ... expected) {
        MoreAsserts.assertContentsInAnyOrder((String)null, actual, expected);
    }

    public static void assertEmpty(String message, Iterable<?> iterable) {
        if (iterable.iterator().hasNext()) {
            MoreAsserts.failNotEmpty(message, iterable.toString());
        }
    }

    public static void assertEmpty(Iterable<?> iterable) {
        MoreAsserts.assertEmpty(null, iterable);
    }

    public static void assertEmpty(String message, Map<?, ?> map) {
        if (!map.isEmpty()) {
            MoreAsserts.failNotEmpty(message, map.toString());
        }
    }

    public static void assertEmpty(Map<?, ?> map) {
        MoreAsserts.assertEmpty(null, map);
    }

    public static void assertNotEmpty(String message, Iterable<?> iterable) {
        if (!iterable.iterator().hasNext()) {
            MoreAsserts.failEmpty(message);
        }
    }

    public static void assertNotEmpty(Iterable<?> iterable) {
        MoreAsserts.assertNotEmpty(null, iterable);
    }

    public static void assertNotEmpty(String message, Map<?, ?> map) {
        if (map.isEmpty()) {
            MoreAsserts.failEmpty(message);
        }
    }

    public static void assertNotEmpty(Map<?, ?> map) {
        MoreAsserts.assertNotEmpty(null, map);
    }

    public static void checkEqualsAndHashCodeMethods(String message, Object lhs, Object rhs, boolean expectedResult) {
        if (lhs == null && rhs == null) {
            Assert.assertTrue("Your check is dubious...why would you expect null != null?", expectedResult);
            return;
        }
        if (lhs == null || rhs == null) {
            Assert.assertFalse("Your check is dubious...why would you expect an object to be equal to null?", expectedResult);
        }
        if (lhs != null) {
            Assert.assertEquals(message, expectedResult, lhs.equals(rhs));
        }
        if (rhs != null) {
            Assert.assertEquals(message, expectedResult, rhs.equals(lhs));
        }
        if (expectedResult) {
            String hashMessage = "hashCode() values for equal objects should be the same";
            if (message != null) {
                hashMessage = hashMessage + ": " + message;
            }
            Assert.assertTrue(hashMessage, lhs.hashCode() == rhs.hashCode());
        }
    }

    public static void checkEqualsAndHashCodeMethods(Object lhs, Object rhs, boolean expectedResult) {
        MoreAsserts.checkEqualsAndHashCodeMethods(null, lhs, rhs, expectedResult);
    }

    private static Matcher getMatcher(String expectedRegex, String actual) {
        Pattern pattern = Pattern.compile(expectedRegex);
        return pattern.matcher(actual);
    }

    private static void failEqual(String message, Object unexpected) {
        MoreAsserts.failWithMessage(message, "expected not to be:<" + unexpected + ">");
    }

    private static void failWrongLength(String message, int expected, int actual) {
        MoreAsserts.failWithMessage(message, "expected array length:<" + expected + "> but was:<" + actual + '>');
    }

    private static void failWrongElement(String message, int index, Object expected, Object actual) {
        MoreAsserts.failWithMessage(message, "expected array element[" + index + "]:<" + expected + "> but was:<" + actual + '>');
    }

    private static void failNotMatches(String message, String expectedRegex, String actual) {
        String actualDesc = actual == null ? "null" : '<' + actual + '>';
        MoreAsserts.failWithMessage(message, "expected to match regex:<" + expectedRegex + "> but was:" + actualDesc);
    }

    private static void failNotContains(String message, String expectedRegex, String actual) {
        String actualDesc = actual == null ? "null" : '<' + actual + '>';
        MoreAsserts.failWithMessage(message, "expected to contain regex:<" + expectedRegex + "> but was:" + actualDesc);
    }

    private static void failMatch(String message, String expectedRegex, String actual) {
        MoreAsserts.failWithMessage(message, "expected not to match regex:<" + expectedRegex + "> but was:<" + actual + '>');
    }

    private static void failContains(String message, String expectedRegex, String actual) {
        MoreAsserts.failWithMessage(message, "expected not to contain regex:<" + expectedRegex + "> but was:<" + actual + '>');
    }

    private static void failNotEmpty(String message, String actual) {
        MoreAsserts.failWithMessage(message, "expected to be empty, but contained: <" + actual + ">");
    }

    private static void failEmpty(String message) {
        MoreAsserts.failWithMessage(message, "expected not to be empty, but was");
    }

    private static void failWithMessage(String userMessage, String ourMessage) {
        Assert.fail(userMessage == null ? ourMessage : userMessage + ' ' + ourMessage);
    }

    private static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

