/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.content.ContentProvider;
import android.content.Context;
import android.content.ContextWrapper;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.os.FileUtils;
import android.util.Log;
import com.google.android.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenamingDelegatingContext
extends ContextWrapper {
    private Context mFileContext;
    private String mFilePrefix = null;
    private File mCacheDir;
    private final Object mSync = new Object();
    private Set<String> mDatabaseNames = Sets.newHashSet();
    private Set<String> mFileNames = Sets.newHashSet();

    public static <T extends ContentProvider> T providerWithRenamedContext(Class<T> contentProvider, Context c, String filePrefix) throws IllegalAccessException, InstantiationException {
        return RenamingDelegatingContext.providerWithRenamedContext(contentProvider, c, filePrefix, false);
    }

    public static <T extends ContentProvider> T providerWithRenamedContext(Class<T> contentProvider, Context c, String filePrefix, boolean allowAccessToExistingFilesAndDbs) throws IllegalAccessException, InstantiationException {
        Class<T> mProviderClass = contentProvider;
        ContentProvider mProvider = (ContentProvider)mProviderClass.newInstance();
        RenamingDelegatingContext mContext = new RenamingDelegatingContext(c, filePrefix);
        if (allowAccessToExistingFilesAndDbs) {
            mContext.makeExistingFilesAndDbsAccessible();
        }
        mProvider.attachInfoForTesting(mContext, null);
        return (T)mProvider;
    }

    public void makeExistingFilesAndDbsAccessible() {
        String[] fileList;
        String[] databaseList;
        for (String diskName : databaseList = this.mFileContext.databaseList()) {
            if (!this.shouldDiskNameBeVisible(diskName)) continue;
            this.mDatabaseNames.add(this.publicNameFromDiskName(diskName));
        }
        for (String diskName : fileList = this.mFileContext.fileList()) {
            if (!this.shouldDiskNameBeVisible(diskName)) continue;
            this.mFileNames.add(this.publicNameFromDiskName(diskName));
        }
    }

    boolean shouldDiskNameBeVisible(String diskName) {
        return diskName.startsWith(this.mFilePrefix);
    }

    String publicNameFromDiskName(String diskName) {
        if (!this.shouldDiskNameBeVisible(diskName)) {
            throw new IllegalArgumentException("disk file should not be visible: " + diskName);
        }
        return diskName.substring(this.mFilePrefix.length(), diskName.length());
    }

    public RenamingDelegatingContext(Context context, String filePrefix) {
        super(context);
        this.mFileContext = context;
        this.mFilePrefix = filePrefix;
    }

    public RenamingDelegatingContext(Context context, Context fileContext, String filePrefix) {
        super(context);
        this.mFileContext = fileContext;
        this.mFilePrefix = filePrefix;
    }

    public String getDatabasePrefix() {
        return this.mFilePrefix;
    }

    private String renamedFileName(String name) {
        return this.mFilePrefix + name;
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory) {
        String internalName = this.renamedFileName(name);
        if (!this.mDatabaseNames.contains(name)) {
            this.mDatabaseNames.add(name);
            this.mFileContext.deleteDatabase(internalName);
        }
        return this.mFileContext.openOrCreateDatabase(internalName, mode, factory);
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory, DatabaseErrorHandler errorHandler) {
        String internalName = this.renamedFileName(name);
        if (!this.mDatabaseNames.contains(name)) {
            this.mDatabaseNames.add(name);
            this.mFileContext.deleteDatabase(internalName);
        }
        return this.mFileContext.openOrCreateDatabase(internalName, mode, factory, errorHandler);
    }

    @Override
    public boolean deleteDatabase(String name) {
        if (this.mDatabaseNames.contains(name)) {
            this.mDatabaseNames.remove(name);
            return this.mFileContext.deleteDatabase(this.renamedFileName(name));
        }
        return false;
    }

    @Override
    public File getDatabasePath(String name) {
        return this.mFileContext.getDatabasePath(this.renamedFileName(name));
    }

    @Override
    public String[] databaseList() {
        return this.mDatabaseNames.toArray(new String[0]);
    }

    @Override
    public FileInputStream openFileInput(String name) throws FileNotFoundException {
        String internalName = this.renamedFileName(name);
        if (this.mFileNames.contains(name)) {
            return this.mFileContext.openFileInput(internalName);
        }
        throw new FileNotFoundException(internalName);
    }

    @Override
    public FileOutputStream openFileOutput(String name, int mode) throws FileNotFoundException {
        this.mFileNames.add(name);
        return this.mFileContext.openFileOutput(this.renamedFileName(name), mode);
    }

    @Override
    public File getFileStreamPath(String name) {
        return this.mFileContext.getFileStreamPath(this.renamedFileName(name));
    }

    @Override
    public boolean deleteFile(String name) {
        if (this.mFileNames.contains(name)) {
            this.mFileNames.remove(name);
            return this.mFileContext.deleteFile(this.renamedFileName(name));
        }
        return false;
    }

    @Override
    public String[] fileList() {
        return this.mFileNames.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getCacheDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mCacheDir == null) {
                this.mCacheDir = new File(this.mFileContext.getCacheDir(), this.renamedFileName("cache"));
            }
            if (!this.mCacheDir.exists()) {
                if (!this.mCacheDir.mkdirs()) {
                    Log.w("RenamingDelegatingContext", "Unable to create cache directory");
                    return null;
                }
                FileUtils.setPermissions(this.mCacheDir.getPath(), 505, -1, -1);
            }
        }
        return this.mCacheDir;
    }
}

