/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.app.Activity;
import android.app.Instrumentation;
import android.graphics.Point;
import android.os.SystemClock;
import android.test.ActivityInstrumentationTestCase;
import android.test.InstrumentationTestCase;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;

public class TouchUtils {
    @Deprecated
    public static void dragQuarterScreenDown(ActivityInstrumentationTestCase test) {
        TouchUtils.dragQuarterScreenDown(test, test.getActivity());
    }

    public static void dragQuarterScreenDown(InstrumentationTestCase test, Activity activity) {
        Display display = activity.getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        float x = (float)size.x / 2.0f;
        float fromY = (float)size.y * 0.5f;
        float toY = (float)size.y * 0.75f;
        TouchUtils.drag(test, x, x, fromY, toY, 4);
    }

    @Deprecated
    public static void dragQuarterScreenUp(ActivityInstrumentationTestCase test) {
        TouchUtils.dragQuarterScreenUp(test, test.getActivity());
    }

    public static void dragQuarterScreenUp(InstrumentationTestCase test, Activity activity) {
        Display display = activity.getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        float x = (float)size.x / 2.0f;
        float fromY = (float)size.y * 0.5f;
        float toY = (float)size.y * 0.25f;
        TouchUtils.drag(test, x, x, fromY, toY, 4);
    }

    @Deprecated
    public static void scrollToBottom(ActivityInstrumentationTestCase test, ViewGroup v) {
        TouchUtils.scrollToBottom(test, test.getActivity(), v);
    }

    public static void scrollToBottom(InstrumentationTestCase test, Activity activity, ViewGroup v) {
        int prevTop;
        int prevId;
        int firstId = Integer.MIN_VALUE;
        int firstTop = Integer.MIN_VALUE;
        do {
            prevId = firstId;
            prevTop = firstTop;
            TouchUtils.dragQuarterScreenUp(test, activity);
            View firstChild = v.getChildAt(0);
            firstId = firstChild.getId();
            firstTop = firstChild.getTop();
        } while (prevId != firstId || prevTop != firstTop);
    }

    @Deprecated
    public static void scrollToTop(ActivityInstrumentationTestCase test, ViewGroup v) {
        TouchUtils.scrollToTop(test, test.getActivity(), v);
    }

    public static void scrollToTop(InstrumentationTestCase test, Activity activity, ViewGroup v) {
        int prevTop;
        int prevId;
        int firstId = Integer.MIN_VALUE;
        int firstTop = Integer.MIN_VALUE;
        do {
            prevId = firstId;
            prevTop = firstTop;
            TouchUtils.dragQuarterScreenDown(test, activity);
            View firstChild = v.getChildAt(0);
            firstId = firstChild.getId();
            firstTop = firstChild.getTop();
        } while (prevId != firstId || prevTop != firstTop);
    }

    @Deprecated
    public static void dragViewToBottom(ActivityInstrumentationTestCase test, View v) {
        TouchUtils.dragViewToBottom(test, test.getActivity(), v, 4);
    }

    public static void dragViewToBottom(InstrumentationTestCase test, Activity activity, View v) {
        TouchUtils.dragViewToBottom(test, activity, v, 4);
    }

    @Deprecated
    public static void dragViewToBottom(ActivityInstrumentationTestCase test, View v, int stepCount) {
        TouchUtils.dragViewToBottom(test, test.getActivity(), v, stepCount);
    }

    public static void dragViewToBottom(InstrumentationTestCase test, Activity activity, View v, int stepCount) {
        int screenHeight = activity.getWindowManager().getDefaultDisplay().getHeight();
        int[] xy = new int[2];
        v.getLocationOnScreen(xy);
        int viewWidth = v.getWidth();
        int viewHeight = v.getHeight();
        float x = (float)xy[0] + (float)viewWidth / 2.0f;
        float fromY = (float)xy[1] + (float)viewHeight / 2.0f;
        float toY = screenHeight - 1;
        TouchUtils.drag(test, x, x, fromY, toY, stepCount);
    }

    public static void tapView(InstrumentationTestCase test, View v) {
        int[] xy = new int[2];
        v.getLocationOnScreen(xy);
        int viewWidth = v.getWidth();
        int viewHeight = v.getHeight();
        float x = (float)xy[0] + (float)viewWidth / 2.0f;
        float y = (float)xy[1] + (float)viewHeight / 2.0f;
        Instrumentation inst = test.getInstrumentation();
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        MotionEvent event = MotionEvent.obtain(downTime, eventTime, 0, x, y, 0);
        inst.sendPointerSync(event);
        inst.waitForIdleSync();
        eventTime = SystemClock.uptimeMillis();
        int touchSlop = ViewConfiguration.get(v.getContext()).getScaledTouchSlop();
        event = MotionEvent.obtain(downTime, eventTime, 2, x + (float)touchSlop / 2.0f, y + (float)touchSlop / 2.0f, 0);
        inst.sendPointerSync(event);
        inst.waitForIdleSync();
        eventTime = SystemClock.uptimeMillis();
        event = MotionEvent.obtain(downTime, eventTime, 1, x, y, 0);
        inst.sendPointerSync(event);
        inst.waitForIdleSync();
    }

    public static void touchAndCancelView(InstrumentationTestCase test, View v) {
        int[] xy = new int[2];
        v.getLocationOnScreen(xy);
        int viewWidth = v.getWidth();
        int viewHeight = v.getHeight();
        float x = (float)xy[0] + (float)viewWidth / 2.0f;
        float y = (float)xy[1] + (float)viewHeight / 2.0f;
        Instrumentation inst = test.getInstrumentation();
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        MotionEvent event = MotionEvent.obtain(downTime, eventTime, 0, x, y, 0);
        inst.sendPointerSync(event);
        inst.waitForIdleSync();
        eventTime = SystemClock.uptimeMillis();
        int touchSlop = ViewConfiguration.get(v.getContext()).getScaledTouchSlop();
        event = MotionEvent.obtain(downTime, eventTime, 3, x + (float)touchSlop / 2.0f, y + (float)touchSlop / 2.0f, 0);
        inst.sendPointerSync(event);
        inst.waitForIdleSync();
    }

    public static void clickView(InstrumentationTestCase test, View v) {
        int[] xy = new int[2];
        v.getLocationOnScreen(xy);
        int viewWidth = v.getWidth();
        int viewHeight = v.getHeight();
        float x = (float)xy[0] + (float)viewWidth / 2.0f;
        float y = (float)xy[1] + (float)viewHeight / 2.0f;
        Instrumentation inst = test.getInstrumentation();
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        MotionEvent event = MotionEvent.obtain(downTime, eventTime, 0, x, y, 0);
        inst.sendPointerSync(event);
        inst.waitForIdleSync();
        eventTime = SystemClock.uptimeMillis();
        int touchSlop = ViewConfiguration.get(v.getContext()).getScaledTouchSlop();
        event = MotionEvent.obtain(downTime, eventTime, 2, x + (float)touchSlop / 2.0f, y + (float)touchSlop / 2.0f, 0);
        inst.sendPointerSync(event);
        inst.waitForIdleSync();
        eventTime = SystemClock.uptimeMillis();
        event = MotionEvent.obtain(downTime, eventTime, 1, x, y, 0);
        inst.sendPointerSync(event);
        inst.waitForIdleSync();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static void longClickView(ActivityInstrumentationTestCase test, View v) {
        TouchUtils.longClickView((InstrumentationTestCase)test, v);
    }

    public static void longClickView(InstrumentationTestCase test, View v) {
        int[] xy = new int[2];
        v.getLocationOnScreen(xy);
        int viewWidth = v.getWidth();
        int viewHeight = v.getHeight();
        float x = (float)xy[0] + (float)viewWidth / 2.0f;
        float y = (float)xy[1] + (float)viewHeight / 2.0f;
        Instrumentation inst = test.getInstrumentation();
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        MotionEvent event = MotionEvent.obtain(downTime, eventTime, 0, x, y, 0);
        inst.sendPointerSync(event);
        inst.waitForIdleSync();
        eventTime = SystemClock.uptimeMillis();
        int touchSlop = ViewConfiguration.get(v.getContext()).getScaledTouchSlop();
        event = MotionEvent.obtain(downTime, eventTime, 2, x + (float)(touchSlop / 2), y + (float)(touchSlop / 2), 0);
        inst.sendPointerSync(event);
        inst.waitForIdleSync();
        try {
            Thread.sleep((long)((float)ViewConfiguration.getLongPressTimeout() * 1.5f));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        eventTime = SystemClock.uptimeMillis();
        event = MotionEvent.obtain(downTime, eventTime, 1, x, y, 0);
        inst.sendPointerSync(event);
        inst.waitForIdleSync();
    }

    @Deprecated
    public static void dragViewToTop(ActivityInstrumentationTestCase test, View v) {
        TouchUtils.dragViewToTop((InstrumentationTestCase)test, v, 4);
    }

    @Deprecated
    public static void dragViewToTop(ActivityInstrumentationTestCase test, View v, int stepCount) {
        TouchUtils.dragViewToTop((InstrumentationTestCase)test, v, stepCount);
    }

    public static void dragViewToTop(InstrumentationTestCase test, View v) {
        TouchUtils.dragViewToTop(test, v, 4);
    }

    public static void dragViewToTop(InstrumentationTestCase test, View v, int stepCount) {
        int[] xy = new int[2];
        v.getLocationOnScreen(xy);
        int viewWidth = v.getWidth();
        int viewHeight = v.getHeight();
        float x = (float)xy[0] + (float)viewWidth / 2.0f;
        float fromY = (float)xy[1] + (float)viewHeight / 2.0f;
        float toY = 0.0f;
        TouchUtils.drag(test, x, x, fromY, toY, stepCount);
    }

    private static void getStartLocation(View v, int gravity, int[] xy) {
        v.getLocationOnScreen(xy);
        int viewWidth = v.getWidth();
        int viewHeight = v.getHeight();
        switch (gravity & 0x70) {
            case 48: {
                break;
            }
            case 16: {
                xy[1] = xy[1] + viewHeight / 2;
                break;
            }
            case 80: {
                xy[1] = xy[1] + (viewHeight - 1);
                break;
            }
        }
        switch (gravity & 7) {
            case 3: {
                break;
            }
            case 1: {
                xy[0] = xy[0] + viewWidth / 2;
                break;
            }
            case 5: {
                xy[0] = xy[0] + (viewWidth - 1);
                break;
            }
        }
    }

    @Deprecated
    public static int dragViewBy(ActivityInstrumentationTestCase test, View v, int gravity, int deltaX, int deltaY) {
        return TouchUtils.dragViewBy((InstrumentationTestCase)test, v, gravity, deltaX, deltaY);
    }

    @Deprecated
    public static int dragViewBy(InstrumentationTestCase test, View v, int gravity, int deltaX, int deltaY) {
        int[] xy = new int[2];
        TouchUtils.getStartLocation(v, gravity, xy);
        int fromX = xy[0];
        int fromY = xy[1];
        int distance = (int)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        TouchUtils.drag(test, (float)fromX, (float)(fromX + deltaX), (float)fromY, (float)(fromY + deltaY), distance);
        return distance;
    }

    @Deprecated
    public static int dragViewTo(ActivityInstrumentationTestCase test, View v, int gravity, int toX, int toY) {
        return TouchUtils.dragViewTo((InstrumentationTestCase)test, v, gravity, toX, toY);
    }

    public static int dragViewTo(InstrumentationTestCase test, View v, int gravity, int toX, int toY) {
        int[] xy = new int[2];
        TouchUtils.getStartLocation(v, gravity, xy);
        int fromX = xy[0];
        int fromY = xy[1];
        int deltaX = fromX - toX;
        int deltaY = fromY - toY;
        int distance = (int)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        TouchUtils.drag(test, (float)fromX, (float)toX, (float)fromY, (float)toY, distance);
        return distance;
    }

    @Deprecated
    public static int dragViewToX(ActivityInstrumentationTestCase test, View v, int gravity, int toX) {
        return TouchUtils.dragViewToX((InstrumentationTestCase)test, v, gravity, toX);
    }

    public static int dragViewToX(InstrumentationTestCase test, View v, int gravity, int toX) {
        int[] xy = new int[2];
        TouchUtils.getStartLocation(v, gravity, xy);
        int fromX = xy[0];
        int fromY = xy[1];
        int deltaX = fromX - toX;
        TouchUtils.drag(test, (float)fromX, (float)toX, (float)fromY, (float)fromY, deltaX);
        return deltaX;
    }

    @Deprecated
    public static int dragViewToY(ActivityInstrumentationTestCase test, View v, int gravity, int toY) {
        return TouchUtils.dragViewToY((InstrumentationTestCase)test, v, gravity, toY);
    }

    public static int dragViewToY(InstrumentationTestCase test, View v, int gravity, int toY) {
        int[] xy = new int[2];
        TouchUtils.getStartLocation(v, gravity, xy);
        int fromX = xy[0];
        int fromY = xy[1];
        int deltaY = fromY - toY;
        TouchUtils.drag(test, (float)fromX, (float)fromX, (float)fromY, (float)toY, deltaY);
        return deltaY;
    }

    @Deprecated
    public static void drag(ActivityInstrumentationTestCase test, float fromX, float toX, float fromY, float toY, int stepCount) {
        TouchUtils.drag((InstrumentationTestCase)test, fromX, toX, fromY, toY, stepCount);
    }

    public static void drag(InstrumentationTestCase test, float fromX, float toX, float fromY, float toY, int stepCount) {
        Instrumentation inst = test.getInstrumentation();
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        float y = fromY;
        float x = fromX;
        float yStep = (toY - fromY) / (float)stepCount;
        float xStep = (toX - fromX) / (float)stepCount;
        MotionEvent event = MotionEvent.obtain(downTime, eventTime, 0, x, y, 0);
        inst.sendPointerSync(event);
        inst.waitForIdleSync();
        for (int i = 0; i < stepCount; ++i) {
            eventTime = SystemClock.uptimeMillis();
            event = MotionEvent.obtain(downTime, eventTime, 2, x += xStep, y += yStep, 0);
            inst.sendPointerSync(event);
            inst.waitForIdleSync();
        }
        eventTime = SystemClock.uptimeMillis();
        event = MotionEvent.obtain(downTime, eventTime, 1, x, y, 0);
        inst.sendPointerSync(event);
        inst.waitForIdleSync();
    }
}

