/*
 * Decompiled with CFR 0.152.
 */
package android.test.suitebuilder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMethod {
    private final String enclosingClassname;
    private final String testMethodName;
    private final Class<? extends TestCase> enclosingClass;

    public TestMethod(Method method, Class<? extends TestCase> enclosingClass) {
        this(method.getName(), enclosingClass);
    }

    public TestMethod(String methodName, Class<? extends TestCase> enclosingClass) {
        this.enclosingClass = enclosingClass;
        this.enclosingClassname = enclosingClass.getName();
        this.testMethodName = methodName;
    }

    public TestMethod(TestCase testCase) {
        this(testCase.getName(), testCase.getClass());
    }

    public String getName() {
        return this.testMethodName;
    }

    public String getEnclosingClassname() {
        return this.enclosingClassname;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        try {
            return this.getEnclosingClass().getMethod(this.getName(), new Class[0]).getAnnotation(annotationClass);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public Class<? extends TestCase> getEnclosingClass() {
        return this.enclosingClass;
    }

    public TestCase createTest() throws InvocationTargetException, IllegalAccessException, InstantiationException {
        return this.instantiateTest(this.enclosingClass, this.testMethodName);
    }

    private TestCase instantiateTest(Class testCaseClass, String testName) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Constructor<?>[] constructors = testCaseClass.getConstructors();
        if (constructors.length == 0) {
            return this.instantiateTest(testCaseClass.getSuperclass(), testName);
        }
        for (Constructor<?> constructor : constructors) {
            Class[] params = constructor.getParameterTypes();
            if (this.noargsConstructor(params)) {
                TestCase test = (TestCase)constructor.newInstance(new Object[0]);
                test.setName(testName);
                return test;
            }
            if (!this.singleStringConstructor(params)) continue;
            return (TestCase)constructor.newInstance(testName);
        }
        throw new RuntimeException("Unable to locate a constructor for " + testCaseClass.getName());
    }

    private boolean singleStringConstructor(Class[] params) {
        return params.length == 1 && params[0].equals(String.class);
    }

    private boolean noargsConstructor(Class[] params) {
        return params.length == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestMethod that = (TestMethod)o;
        if (this.enclosingClassname != null ? !this.enclosingClassname.equals(that.enclosingClassname) : that.enclosingClassname != null) {
            return false;
        }
        return !(this.testMethodName != null ? !this.testMethodName.equals(that.testMethodName) : that.testMethodName != null);
    }

    public int hashCode() {
        int result = this.enclosingClassname != null ? this.enclosingClassname.hashCode() : 0;
        result = 31 * result + (this.testMethodName != null ? this.testMethodName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.enclosingClassname + "." + this.testMethodName;
    }
}

