/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.util.Pools;
import android.view.DisplayList;
import android.view.GLES20Canvas;
import android.view.GLES20DisplayList;

class GLES20RecordingCanvas
extends GLES20Canvas {
    private static final int POOL_LIMIT = 25;
    private static final Pools.SynchronizedPool<GLES20RecordingCanvas> sPool = new Pools.SynchronizedPool(25);
    private GLES20DisplayList mDisplayList;

    private GLES20RecordingCanvas() {
        super(true, true);
    }

    static GLES20RecordingCanvas obtain(GLES20DisplayList displayList) {
        GLES20RecordingCanvas canvas = sPool.acquire();
        if (canvas == null) {
            canvas = new GLES20RecordingCanvas();
        }
        canvas.mDisplayList = displayList;
        return canvas;
    }

    void recycle() {
        this.mDisplayList = null;
        this.resetDisplayListRenderer();
        sPool.release(this);
    }

    void start() {
        this.mDisplayList.clearReferences();
    }

    int end(int nativeDisplayList) {
        return this.getDisplayList(nativeDisplayList);
    }

    public int drawDisplayList(DisplayList displayList, Rect dirty, int flags) {
        int status = super.drawDisplayList(displayList, dirty, flags);
        this.mDisplayList.getChildDisplayLists().add(displayList);
        return status;
    }
}

