/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.webkit.WebViewDatabase;

abstract class WebSyncManager
implements Runnable {
    private static final int SYNC_MESSAGE = 101;
    private static int SYNC_NOW_INTERVAL = 100;
    private static int SYNC_LATER_INTERVAL = 300000;
    private Thread mSyncThread;
    private String mThreadName;
    protected Handler mHandler;
    protected WebViewDatabase mDataBase;
    private int mStartSyncRefCount;
    protected static final String LOGTAG = "websync";

    protected WebSyncManager(Context context, String name) {
        this(name);
    }

    WebSyncManager(String name) {
        this.mThreadName = name;
        this.mSyncThread = new Thread(this);
        this.mSyncThread.setName(this.mThreadName);
        this.mSyncThread.start();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("doesn't implement Cloneable");
    }

    public void run() {
        Looper.prepare();
        this.mHandler = new SyncHandler();
        this.onSyncInit();
        Process.setThreadPriority(10);
        Message msg = this.mHandler.obtainMessage(101);
        this.mHandler.sendMessageDelayed(msg, SYNC_LATER_INTERVAL);
        Looper.loop();
    }

    public void sync() {
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.removeMessages(101);
        Message msg = this.mHandler.obtainMessage(101);
        this.mHandler.sendMessageDelayed(msg, SYNC_NOW_INTERVAL);
    }

    public void resetSync() {
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.removeMessages(101);
        Message msg = this.mHandler.obtainMessage(101);
        this.mHandler.sendMessageDelayed(msg, SYNC_LATER_INTERVAL);
    }

    public void startSync() {
        if (this.mHandler == null) {
            return;
        }
        if (++this.mStartSyncRefCount == 1) {
            Message msg = this.mHandler.obtainMessage(101);
            this.mHandler.sendMessageDelayed(msg, SYNC_LATER_INTERVAL);
        }
    }

    public void stopSync() {
        if (this.mHandler == null) {
            return;
        }
        if (--this.mStartSyncRefCount == 0) {
            this.mHandler.removeMessages(101);
        }
    }

    protected void onSyncInit() {
    }

    abstract void syncFromRamToFlash();

    private class SyncHandler
    extends Handler {
        private SyncHandler() {
        }

        public void handleMessage(Message msg) {
            if (msg.what == 101) {
                WebSyncManager.this.syncFromRamToFlash();
                Message newmsg = this.obtainMessage(101);
                this.sendMessageDelayed(newmsg, SYNC_LATER_INTERVAL);
            }
        }
    }
}

