/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ListView;
import android.widget.TextView;
import com.android.internal.R;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import libcore.icu.LocaleData;

public class CalendarView
extends FrameLayout {
    private static final String LOG_TAG = CalendarView.class.getSimpleName();
    private static final boolean DEFAULT_SHOW_WEEK_NUMBER = true;
    private static final long MILLIS_IN_DAY = 86400000L;
    private static final int DAYS_PER_WEEK = 7;
    private static final long MILLIS_IN_WEEK = 604800000L;
    private static final int SCROLL_HYST_WEEKS = 2;
    private static final int GOTO_SCROLL_DURATION = 1000;
    private static final int ADJUSTMENT_SCROLL_DURATION = 500;
    private static final int SCROLL_CHANGE_DELAY = 40;
    private static final String DATE_FORMAT = "MM/dd/yyyy";
    private static final String DEFAULT_MIN_DATE = "01/01/1900";
    private static final String DEFAULT_MAX_DATE = "01/01/2100";
    private static final int DEFAULT_SHOWN_WEEK_COUNT = 6;
    private static final int DEFAULT_DATE_TEXT_SIZE = 14;
    private static final int UNSCALED_SELECTED_DATE_VERTICAL_BAR_WIDTH = 6;
    private static final int UNSCALED_WEEK_MIN_VISIBLE_HEIGHT = 12;
    private static final int UNSCALED_LIST_SCROLL_TOP_OFFSET = 2;
    private static final int UNSCALED_BOTTOM_BUFFER = 20;
    private static final int UNSCALED_WEEK_SEPARATOR_LINE_WIDTH = 1;
    private static final int DEFAULT_WEEK_DAY_TEXT_APPEARANCE_RES_ID = -1;
    private final int mWeekSeperatorLineWidth;
    private int mDateTextSize;
    private Drawable mSelectedDateVerticalBar;
    private final int mSelectedDateVerticalBarWidth;
    private int mSelectedWeekBackgroundColor;
    private int mFocusedMonthDateColor;
    private int mUnfocusedMonthDateColor;
    private int mWeekSeparatorLineColor;
    private int mWeekNumberColor;
    private int mWeekDayTextAppearanceResId;
    private int mDateTextAppearanceResId;
    private int mListScrollTopOffset = 2;
    private int mWeekMinVisibleHeight = 12;
    private int mBottomBuffer = 20;
    private int mShownWeekCount;
    private boolean mShowWeekNumber;
    private int mDaysPerWeek = 7;
    private float mFriction = 0.05f;
    private float mVelocityScale = 0.333f;
    private WeeksAdapter mAdapter;
    private ListView mListView;
    private TextView mMonthName;
    private ViewGroup mDayNamesHeader;
    private String[] mDayLabels;
    private int mFirstDayOfWeek;
    private int mCurrentMonthDisplayed = -1;
    private long mPreviousScrollPosition;
    private boolean mIsScrollingUp = false;
    private int mPreviousScrollState = 0;
    private int mCurrentScrollState = 0;
    private OnDateChangeListener mOnDateChangeListener;
    private ScrollStateRunnable mScrollStateChangedRunnable = new ScrollStateRunnable();
    private Calendar mTempDate;
    private Calendar mFirstDayOfMonth;
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private final DateFormat mDateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private Locale mCurrentLocale;

    public CalendarView(Context context) {
        this(context, null);
    }

    public CalendarView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CalendarView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, 0);
        String maxDate;
        this.setCurrentLocale(Locale.getDefault());
        TypedArray attributesArray = context.obtainStyledAttributes(attrs, R.styleable.CalendarView, 16843613, 0);
        this.mShowWeekNumber = attributesArray.getBoolean(1, true);
        this.mFirstDayOfWeek = attributesArray.getInt(0, LocaleData.get((Locale)Locale.getDefault()).firstDayOfWeek);
        String minDate = attributesArray.getString(2);
        if (TextUtils.isEmpty(minDate) || !this.parseDate(minDate, this.mMinDate)) {
            this.parseDate(DEFAULT_MIN_DATE, this.mMinDate);
        }
        if (TextUtils.isEmpty(maxDate = attributesArray.getString(3)) || !this.parseDate(maxDate, this.mMaxDate)) {
            this.parseDate(DEFAULT_MAX_DATE, this.mMaxDate);
        }
        if (this.mMaxDate.before(this.mMinDate)) {
            throw new IllegalArgumentException("Max date cannot be before min date.");
        }
        this.mShownWeekCount = attributesArray.getInt(4, 6);
        this.mSelectedWeekBackgroundColor = attributesArray.getColor(5, 0);
        this.mFocusedMonthDateColor = attributesArray.getColor(6, 0);
        this.mUnfocusedMonthDateColor = attributesArray.getColor(7, 0);
        this.mWeekSeparatorLineColor = attributesArray.getColor(9, 0);
        this.mWeekNumberColor = attributesArray.getColor(8, 0);
        this.mSelectedDateVerticalBar = attributesArray.getDrawable(10);
        this.mDateTextAppearanceResId = attributesArray.getResourceId(12, 16973894);
        this.updateDateTextSize();
        this.mWeekDayTextAppearanceResId = attributesArray.getResourceId(11, -1);
        attributesArray.recycle();
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.mWeekMinVisibleHeight = (int)TypedValue.applyDimension(1, 12.0f, displayMetrics);
        this.mListScrollTopOffset = (int)TypedValue.applyDimension(1, 2.0f, displayMetrics);
        this.mBottomBuffer = (int)TypedValue.applyDimension(1, 20.0f, displayMetrics);
        this.mSelectedDateVerticalBarWidth = (int)TypedValue.applyDimension(1, 6.0f, displayMetrics);
        this.mWeekSeperatorLineWidth = (int)TypedValue.applyDimension(1, 1.0f, displayMetrics);
        LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View content = layoutInflater.inflate(17367089, null, false);
        this.addView(content);
        this.mListView = (ListView)this.findViewById(16908298);
        this.mDayNamesHeader = (ViewGroup)content.findViewById(16908940);
        this.mMonthName = (TextView)content.findViewById(16908939);
        this.setUpHeader();
        this.setUpListView();
        this.setUpAdapter();
        this.mTempDate.setTimeInMillis(System.currentTimeMillis());
        if (this.mTempDate.before(this.mMinDate)) {
            this.goTo(this.mMinDate, false, true, true);
        } else if (this.mMaxDate.before(this.mTempDate)) {
            this.goTo(this.mMaxDate, false, true, true);
        } else {
            this.goTo(this.mTempDate, false, true, true);
        }
        this.invalidate();
    }

    public void setShownWeekCount(int count) {
        if (this.mShownWeekCount != count) {
            this.mShownWeekCount = count;
            this.invalidate();
        }
    }

    public int getShownWeekCount() {
        return this.mShownWeekCount;
    }

    public void setSelectedWeekBackgroundColor(int color2) {
        if (this.mSelectedWeekBackgroundColor != color2) {
            this.mSelectedWeekBackgroundColor = color2;
            int childCount = this.mListView.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                WeekView weekView = (WeekView)this.mListView.getChildAt(i);
                if (!weekView.mHasSelectedDay) continue;
                weekView.invalidate();
            }
        }
    }

    public int getSelectedWeekBackgroundColor() {
        return this.mSelectedWeekBackgroundColor;
    }

    public void setFocusedMonthDateColor(int color2) {
        if (this.mFocusedMonthDateColor != color2) {
            this.mFocusedMonthDateColor = color2;
            int childCount = this.mListView.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                WeekView weekView = (WeekView)this.mListView.getChildAt(i);
                if (!weekView.mHasFocusedDay) continue;
                weekView.invalidate();
            }
        }
    }

    public int getFocusedMonthDateColor() {
        return this.mFocusedMonthDateColor;
    }

    public void setUnfocusedMonthDateColor(int color2) {
        if (this.mUnfocusedMonthDateColor != color2) {
            this.mUnfocusedMonthDateColor = color2;
            int childCount = this.mListView.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                WeekView weekView = (WeekView)this.mListView.getChildAt(i);
                if (!weekView.mHasUnfocusedDay) continue;
                weekView.invalidate();
            }
        }
    }

    public int getUnfocusedMonthDateColor() {
        return this.mFocusedMonthDateColor;
    }

    public void setWeekNumberColor(int color2) {
        if (this.mWeekNumberColor != color2) {
            this.mWeekNumberColor = color2;
            if (this.mShowWeekNumber) {
                this.invalidateAllWeekViews();
            }
        }
    }

    public int getWeekNumberColor() {
        return this.mWeekNumberColor;
    }

    public void setWeekSeparatorLineColor(int color2) {
        if (this.mWeekSeparatorLineColor != color2) {
            this.mWeekSeparatorLineColor = color2;
            this.invalidateAllWeekViews();
        }
    }

    public int getWeekSeparatorLineColor() {
        return this.mWeekSeparatorLineColor;
    }

    public void setSelectedDateVerticalBar(int resourceId) {
        Drawable drawable2 = this.getResources().getDrawable(resourceId);
        this.setSelectedDateVerticalBar(drawable2);
    }

    public void setSelectedDateVerticalBar(Drawable drawable2) {
        if (this.mSelectedDateVerticalBar != drawable2) {
            this.mSelectedDateVerticalBar = drawable2;
            int childCount = this.mListView.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                WeekView weekView = (WeekView)this.mListView.getChildAt(i);
                if (!weekView.mHasSelectedDay) continue;
                weekView.invalidate();
            }
        }
    }

    public Drawable getSelectedDateVerticalBar() {
        return this.mSelectedDateVerticalBar;
    }

    public void setWeekDayTextAppearance(int resourceId) {
        if (this.mWeekDayTextAppearanceResId != resourceId) {
            this.mWeekDayTextAppearanceResId = resourceId;
            this.setUpHeader();
        }
    }

    public int getWeekDayTextAppearance() {
        return this.mWeekDayTextAppearanceResId;
    }

    public void setDateTextAppearance(int resourceId) {
        if (this.mDateTextAppearanceResId != resourceId) {
            this.mDateTextAppearanceResId = resourceId;
            this.updateDateTextSize();
            this.invalidateAllWeekViews();
        }
    }

    public int getDateTextAppearance() {
        return this.mDateTextAppearanceResId;
    }

    public void setEnabled(boolean enabled) {
        this.mListView.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.mListView.isEnabled();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.setCurrentLocale(newConfig.locale);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(CalendarView.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(CalendarView.class.getName());
    }

    public long getMinDate() {
        return this.mMinDate.getTimeInMillis();
    }

    public void setMinDate(long minDate) {
        this.mTempDate.setTimeInMillis(minDate);
        if (this.isSameDate(this.mTempDate, this.mMinDate)) {
            return;
        }
        this.mMinDate.setTimeInMillis(minDate);
        Calendar date = this.mAdapter.mSelectedDate;
        if (date.before(this.mMinDate)) {
            this.mAdapter.setSelectedDay(this.mMinDate);
        }
        this.mAdapter.init();
        if (date.before(this.mMinDate)) {
            this.setDate(this.mTempDate.getTimeInMillis());
        } else {
            this.goTo(date, false, true, false);
        }
    }

    public long getMaxDate() {
        return this.mMaxDate.getTimeInMillis();
    }

    public void setMaxDate(long maxDate) {
        this.mTempDate.setTimeInMillis(maxDate);
        if (this.isSameDate(this.mTempDate, this.mMaxDate)) {
            return;
        }
        this.mMaxDate.setTimeInMillis(maxDate);
        this.mAdapter.init();
        Calendar date = this.mAdapter.mSelectedDate;
        if (date.after(this.mMaxDate)) {
            this.setDate(this.mMaxDate.getTimeInMillis());
        } else {
            this.goTo(date, false, true, false);
        }
    }

    public void setShowWeekNumber(boolean showWeekNumber) {
        if (this.mShowWeekNumber == showWeekNumber) {
            return;
        }
        this.mShowWeekNumber = showWeekNumber;
        this.mAdapter.notifyDataSetChanged();
        this.setUpHeader();
    }

    public boolean getShowWeekNumber() {
        return this.mShowWeekNumber;
    }

    public int getFirstDayOfWeek() {
        return this.mFirstDayOfWeek;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        if (this.mFirstDayOfWeek == firstDayOfWeek) {
            return;
        }
        this.mFirstDayOfWeek = firstDayOfWeek;
        this.mAdapter.init();
        this.setUpHeader();
    }

    public void setOnDateChangeListener(OnDateChangeListener listener) {
        this.mOnDateChangeListener = listener;
    }

    public long getDate() {
        return this.mAdapter.mSelectedDate.getTimeInMillis();
    }

    public void setDate(long date) {
        this.setDate(date, false, false);
    }

    public void setDate(long date, boolean animate, boolean center) {
        this.mTempDate.setTimeInMillis(date);
        if (this.isSameDate(this.mTempDate, this.mAdapter.mSelectedDate)) {
            return;
        }
        this.goTo(this.mTempDate, animate, true, center);
    }

    private void updateDateTextSize() {
        TypedArray dateTextAppearance = this.mContext.obtainStyledAttributes(this.mDateTextAppearanceResId, R.styleable.TextAppearance);
        this.mDateTextSize = dateTextAppearance.getDimensionPixelSize(0, 14);
        dateTextAppearance.recycle();
    }

    private void invalidateAllWeekViews() {
        int childCount = this.mListView.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = this.mListView.getChildAt(i);
            view.invalidate();
        }
    }

    private void setCurrentLocale(Locale locale) {
        if (locale.equals(this.mCurrentLocale)) {
            return;
        }
        this.mCurrentLocale = locale;
        this.mTempDate = this.getCalendarForLocale(this.mTempDate, locale);
        this.mFirstDayOfMonth = this.getCalendarForLocale(this.mFirstDayOfMonth, locale);
        this.mMinDate = this.getCalendarForLocale(this.mMinDate, locale);
        this.mMaxDate = this.getCalendarForLocale(this.mMaxDate, locale);
    }

    private Calendar getCalendarForLocale(Calendar oldCalendar, Locale locale) {
        if (oldCalendar == null) {
            return Calendar.getInstance(locale);
        }
        long currentTimeMillis = oldCalendar.getTimeInMillis();
        Calendar newCalendar = Calendar.getInstance(locale);
        newCalendar.setTimeInMillis(currentTimeMillis);
        return newCalendar;
    }

    private boolean isSameDate(Calendar firstDate, Calendar secondDate) {
        return firstDate.get(6) == secondDate.get(6) && firstDate.get(1) == secondDate.get(1);
    }

    private void setUpAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = new WeeksAdapter();
            this.mAdapter.registerDataSetObserver(new DataSetObserver(){

                public void onChanged() {
                    if (CalendarView.this.mOnDateChangeListener != null) {
                        Calendar selectedDay = CalendarView.this.mAdapter.getSelectedDay();
                        CalendarView.this.mOnDateChangeListener.onSelectedDayChange(CalendarView.this, selectedDay.get(1), selectedDay.get(2), selectedDay.get(5));
                    }
                }
            });
            this.mListView.setAdapter(this.mAdapter);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    private void setUpHeader() {
        String[] tinyWeekdayNames = LocaleData.get((Locale)Locale.getDefault()).tinyWeekdayNames;
        this.mDayLabels = new String[this.mDaysPerWeek];
        for (int i = 0; i < this.mDaysPerWeek; ++i) {
            int j = i + this.mFirstDayOfWeek;
            int calendarDay = j > 7 ? j - 7 : j;
            this.mDayLabels[i] = tinyWeekdayNames[calendarDay];
        }
        TextView label = (TextView)this.mDayNamesHeader.getChildAt(0);
        if (this.mShowWeekNumber) {
            label.setVisibility(0);
        } else {
            label.setVisibility(8);
        }
        int count = this.mDayNamesHeader.getChildCount();
        for (int i = 0; i < count - 1; ++i) {
            label = (TextView)this.mDayNamesHeader.getChildAt(i + 1);
            if (this.mWeekDayTextAppearanceResId > -1) {
                label.setTextAppearance(this.mContext, this.mWeekDayTextAppearanceResId);
            }
            if (i < this.mDaysPerWeek) {
                label.setText(this.mDayLabels[i]);
                label.setVisibility(0);
                continue;
            }
            label.setVisibility(8);
        }
        this.mDayNamesHeader.invalidate();
    }

    private void setUpListView() {
        this.mListView.setDivider(null);
        this.mListView.setItemsCanFocus(true);
        this.mListView.setVerticalScrollBarEnabled(false);
        this.mListView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                CalendarView.this.onScrollStateChanged(view, scrollState);
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                CalendarView.this.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
        });
        this.mListView.setFriction(this.mFriction);
        this.mListView.setVelocityScale(this.mVelocityScale);
    }

    private void goTo(Calendar date, boolean animate, boolean setSelected, boolean forceScroll) {
        int position;
        if (date.before(this.mMinDate) || date.after(this.mMaxDate)) {
            throw new IllegalArgumentException("Time not between " + this.mMinDate.getTime() + " and " + this.mMaxDate.getTime());
        }
        int firstFullyVisiblePosition = this.mListView.getFirstVisiblePosition();
        View firstChild = this.mListView.getChildAt(0);
        if (firstChild != null && firstChild.getTop() < 0) {
            ++firstFullyVisiblePosition;
        }
        int lastFullyVisiblePosition = firstFullyVisiblePosition + this.mShownWeekCount - 1;
        if (firstChild != null && firstChild.getTop() > this.mBottomBuffer) {
            --lastFullyVisiblePosition;
        }
        if (setSelected) {
            this.mAdapter.setSelectedDay(date);
        }
        if ((position = this.getWeeksSinceMinDate(date)) < firstFullyVisiblePosition || position > lastFullyVisiblePosition || forceScroll) {
            this.mFirstDayOfMonth.setTimeInMillis(date.getTimeInMillis());
            this.mFirstDayOfMonth.set(5, 1);
            this.setMonthDisplayed(this.mFirstDayOfMonth);
            position = this.mFirstDayOfMonth.before(this.mMinDate) ? 0 : this.getWeeksSinceMinDate(this.mFirstDayOfMonth);
            this.mPreviousScrollState = 2;
            if (animate) {
                this.mListView.smoothScrollToPositionFromTop(position, this.mListScrollTopOffset, 1000);
            } else {
                this.mListView.setSelectionFromTop(position, this.mListScrollTopOffset);
                this.onScrollStateChanged(this.mListView, 0);
            }
        } else if (setSelected) {
            this.setMonthDisplayed(date);
        }
    }

    private boolean parseDate(String date, Calendar outDate) {
        try {
            outDate.setTime(this.mDateFormat.parse(date));
            return true;
        }
        catch (ParseException e) {
            Log.w(LOG_TAG, "Date: " + date + " not in format: " + DATE_FORMAT);
            return false;
        }
    }

    private void onScrollStateChanged(AbsListView view, int scrollState) {
        this.mScrollStateChangedRunnable.doScrollStateChange(view, scrollState);
    }

    private void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        int offset;
        WeekView child = (WeekView)view.getChildAt(0);
        if (child == null) {
            return;
        }
        long currScroll = view.getFirstVisiblePosition() * child.getHeight() - child.getBottom();
        if (currScroll < this.mPreviousScrollPosition) {
            this.mIsScrollingUp = true;
        } else if (currScroll > this.mPreviousScrollPosition) {
            this.mIsScrollingUp = false;
        } else {
            return;
        }
        int n = offset = child.getBottom() < this.mWeekMinVisibleHeight ? 1 : 0;
        if (this.mIsScrollingUp) {
            child = (WeekView)view.getChildAt(2 + offset);
        } else if (offset != 0) {
            child = (WeekView)view.getChildAt(offset);
        }
        int month = this.mIsScrollingUp ? child.getMonthOfFirstWeekDay() : child.getMonthOfLastWeekDay();
        int monthDiff = this.mCurrentMonthDisplayed == 11 && month == 0 ? 1 : (this.mCurrentMonthDisplayed == 0 && month == 11 ? -1 : month - this.mCurrentMonthDisplayed);
        if (!this.mIsScrollingUp && monthDiff > 0 || this.mIsScrollingUp && monthDiff < 0) {
            Calendar firstDay = child.getFirstDay();
            if (this.mIsScrollingUp) {
                firstDay.add(5, -7);
            } else {
                firstDay.add(5, 7);
            }
            this.setMonthDisplayed(firstDay);
        }
        this.mPreviousScrollPosition = currScroll;
        this.mPreviousScrollState = this.mCurrentScrollState;
    }

    private void setMonthDisplayed(Calendar calendar) {
        this.mCurrentMonthDisplayed = calendar.get(2);
        this.mAdapter.setFocusMonth(this.mCurrentMonthDisplayed);
        int flags = 52;
        long millis = calendar.getTimeInMillis();
        String newMonthName = DateUtils.formatDateRange(this.mContext, millis, millis, 52);
        this.mMonthName.setText(newMonthName);
        this.mMonthName.invalidate();
    }

    private int getWeeksSinceMinDate(Calendar date) {
        if (date.before(this.mMinDate)) {
            throw new IllegalArgumentException("fromDate: " + this.mMinDate.getTime() + " does not precede toDate: " + date.getTime());
        }
        long endTimeMillis = date.getTimeInMillis() + (long)date.getTimeZone().getOffset(date.getTimeInMillis());
        long startTimeMillis = this.mMinDate.getTimeInMillis() + (long)this.mMinDate.getTimeZone().getOffset(this.mMinDate.getTimeInMillis());
        long dayOffsetMillis = (long)(this.mMinDate.get(7) - this.mFirstDayOfWeek) * 86400000L;
        return (int)((endTimeMillis - startTimeMillis + dayOffsetMillis) / 604800000L);
    }

    private class WeekView
    extends View {
        private final Rect mTempRect;
        private final Paint mDrawPaint;
        private final Paint mMonthNumDrawPaint;
        private String[] mDayNumbers;
        private boolean[] mFocusDay;
        private boolean mHasFocusedDay;
        private boolean mHasUnfocusedDay;
        private Calendar mFirstDay;
        private int mMonthOfFirstWeekDay;
        private int mLastWeekDayMonth;
        private int mWeek;
        private int mWidth;
        private int mHeight;
        private boolean mHasSelectedDay;
        private int mSelectedDay;
        private int mNumCells;
        private int mSelectedLeft;
        private int mSelectedRight;

        public WeekView(Context context) {
            super(context);
            this.mTempRect = new Rect();
            this.mDrawPaint = new Paint();
            this.mMonthNumDrawPaint = new Paint();
            this.mMonthOfFirstWeekDay = -1;
            this.mLastWeekDayMonth = -1;
            this.mWeek = -1;
            this.mHasSelectedDay = false;
            this.mSelectedDay = -1;
            this.mSelectedLeft = -1;
            this.mSelectedRight = -1;
            this.initilaizePaints();
        }

        public void init(int weekNumber, int selectedWeekDay, int focusedMonth) {
            this.mSelectedDay = selectedWeekDay;
            this.mHasSelectedDay = this.mSelectedDay != -1;
            this.mNumCells = CalendarView.this.mShowWeekNumber ? CalendarView.this.mDaysPerWeek + 1 : CalendarView.this.mDaysPerWeek;
            this.mWeek = weekNumber;
            CalendarView.this.mTempDate.setTimeInMillis(CalendarView.this.mMinDate.getTimeInMillis());
            CalendarView.this.mTempDate.add(3, this.mWeek);
            CalendarView.this.mTempDate.setFirstDayOfWeek(CalendarView.this.mFirstDayOfWeek);
            this.mDayNumbers = new String[this.mNumCells];
            this.mFocusDay = new boolean[this.mNumCells];
            int i = 0;
            if (CalendarView.this.mShowWeekNumber) {
                this.mDayNumbers[0] = String.format(Locale.getDefault(), "%d", CalendarView.this.mTempDate.get(3));
                ++i;
            }
            int diff = CalendarView.this.mFirstDayOfWeek - CalendarView.this.mTempDate.get(7);
            CalendarView.this.mTempDate.add(5, diff);
            this.mFirstDay = (Calendar)CalendarView.this.mTempDate.clone();
            this.mMonthOfFirstWeekDay = CalendarView.this.mTempDate.get(2);
            this.mHasUnfocusedDay = true;
            while (i < this.mNumCells) {
                boolean isFocusedDay;
                this.mFocusDay[i] = isFocusedDay = CalendarView.this.mTempDate.get(2) == focusedMonth;
                this.mHasFocusedDay |= isFocusedDay;
                this.mHasUnfocusedDay &= !isFocusedDay;
                this.mDayNumbers[i] = CalendarView.this.mTempDate.before(CalendarView.this.mMinDate) || CalendarView.this.mTempDate.after(CalendarView.this.mMaxDate) ? "" : String.format(Locale.getDefault(), "%d", CalendarView.this.mTempDate.get(5));
                CalendarView.this.mTempDate.add(5, 1);
                ++i;
            }
            if (CalendarView.this.mTempDate.get(5) == 1) {
                CalendarView.this.mTempDate.add(5, -1);
            }
            this.mLastWeekDayMonth = CalendarView.this.mTempDate.get(2);
            this.updateSelectionPositions();
        }

        private void initilaizePaints() {
            this.mDrawPaint.setFakeBoldText(false);
            this.mDrawPaint.setAntiAlias(true);
            this.mDrawPaint.setStyle(Paint.Style.FILL);
            this.mMonthNumDrawPaint.setFakeBoldText(true);
            this.mMonthNumDrawPaint.setAntiAlias(true);
            this.mMonthNumDrawPaint.setStyle(Paint.Style.FILL);
            this.mMonthNumDrawPaint.setTextAlign(Paint.Align.CENTER);
            this.mMonthNumDrawPaint.setTextSize(CalendarView.this.mDateTextSize);
        }

        public int getMonthOfFirstWeekDay() {
            return this.mMonthOfFirstWeekDay;
        }

        public int getMonthOfLastWeekDay() {
            return this.mLastWeekDayMonth;
        }

        public Calendar getFirstDay() {
            return this.mFirstDay;
        }

        public boolean getDayFromLocation(float x, Calendar outCalendar) {
            int end;
            int start;
            boolean isLayoutRtl = this.isLayoutRtl();
            if (isLayoutRtl) {
                start = 0;
                end = CalendarView.this.mShowWeekNumber ? this.mWidth - this.mWidth / this.mNumCells : this.mWidth;
            } else {
                start = CalendarView.this.mShowWeekNumber ? this.mWidth / this.mNumCells : 0;
                end = this.mWidth;
            }
            if (x < (float)start || x > (float)end) {
                outCalendar.clear();
                return false;
            }
            int dayPosition = (int)((x - (float)start) * (float)CalendarView.this.mDaysPerWeek / (float)(end - start));
            if (isLayoutRtl) {
                dayPosition = CalendarView.this.mDaysPerWeek - 1 - dayPosition;
            }
            outCalendar.setTimeInMillis(this.mFirstDay.getTimeInMillis());
            outCalendar.add(5, dayPosition);
            return true;
        }

        protected void onDraw(Canvas canvas) {
            this.drawBackground(canvas);
            this.drawWeekNumbersAndDates(canvas);
            this.drawWeekSeparators(canvas);
            this.drawSelectedDateVerticalBars(canvas);
        }

        private void drawBackground(Canvas canvas) {
            if (!this.mHasSelectedDay) {
                return;
            }
            this.mDrawPaint.setColor(CalendarView.this.mSelectedWeekBackgroundColor);
            this.mTempRect.top = CalendarView.this.mWeekSeperatorLineWidth;
            this.mTempRect.bottom = this.mHeight;
            boolean isLayoutRtl = this.isLayoutRtl();
            if (isLayoutRtl) {
                this.mTempRect.left = 0;
                this.mTempRect.right = this.mSelectedLeft - 2;
            } else {
                this.mTempRect.left = CalendarView.this.mShowWeekNumber ? this.mWidth / this.mNumCells : 0;
                this.mTempRect.right = this.mSelectedLeft - 2;
            }
            canvas.drawRect(this.mTempRect, this.mDrawPaint);
            if (isLayoutRtl) {
                this.mTempRect.left = this.mSelectedRight + 3;
                this.mTempRect.right = CalendarView.this.mShowWeekNumber ? this.mWidth - this.mWidth / this.mNumCells : this.mWidth;
            } else {
                this.mTempRect.left = this.mSelectedRight + 3;
                this.mTempRect.right = this.mWidth;
            }
            canvas.drawRect(this.mTempRect, this.mDrawPaint);
        }

        private void drawWeekNumbersAndDates(Canvas canvas) {
            int i;
            float textHeight = this.mDrawPaint.getTextSize();
            int y = (int)(((float)this.mHeight + textHeight) / 2.0f) - CalendarView.this.mWeekSeperatorLineWidth;
            int nDays = this.mNumCells;
            int divisor = 2 * nDays;
            this.mDrawPaint.setTextAlign(Paint.Align.CENTER);
            this.mDrawPaint.setTextSize(CalendarView.this.mDateTextSize);
            if (this.isLayoutRtl()) {
                int x;
                for (i = 0; i < nDays - 1; ++i) {
                    this.mMonthNumDrawPaint.setColor(this.mFocusDay[i] ? CalendarView.this.mFocusedMonthDateColor : CalendarView.this.mUnfocusedMonthDateColor);
                    x = (2 * i + 1) * this.mWidth / divisor;
                    canvas.drawText(this.mDayNumbers[nDays - 1 - i], x, y, this.mMonthNumDrawPaint);
                }
                if (CalendarView.this.mShowWeekNumber) {
                    this.mDrawPaint.setColor(CalendarView.this.mWeekNumberColor);
                    x = this.mWidth - this.mWidth / divisor;
                    canvas.drawText(this.mDayNumbers[0], x, y, this.mDrawPaint);
                }
            } else {
                int x;
                if (CalendarView.this.mShowWeekNumber) {
                    this.mDrawPaint.setColor(CalendarView.this.mWeekNumberColor);
                    x = this.mWidth / divisor;
                    canvas.drawText(this.mDayNumbers[0], x, y, this.mDrawPaint);
                    ++i;
                }
                while (i < nDays) {
                    this.mMonthNumDrawPaint.setColor(this.mFocusDay[i] ? CalendarView.this.mFocusedMonthDateColor : CalendarView.this.mUnfocusedMonthDateColor);
                    x = (2 * i + 1) * this.mWidth / divisor;
                    canvas.drawText(this.mDayNumbers[i], x, y, this.mMonthNumDrawPaint);
                    ++i;
                }
            }
        }

        private void drawWeekSeparators(Canvas canvas) {
            float stopX;
            float startX;
            int firstFullyVisiblePosition = CalendarView.this.mListView.getFirstVisiblePosition();
            if (CalendarView.this.mListView.getChildAt(0).getTop() < 0) {
                ++firstFullyVisiblePosition;
            }
            if (firstFullyVisiblePosition == this.mWeek) {
                return;
            }
            this.mDrawPaint.setColor(CalendarView.this.mWeekSeparatorLineColor);
            this.mDrawPaint.setStrokeWidth(CalendarView.this.mWeekSeperatorLineWidth);
            if (this.isLayoutRtl()) {
                startX = 0.0f;
                stopX = CalendarView.this.mShowWeekNumber ? (float)(this.mWidth - this.mWidth / this.mNumCells) : (float)this.mWidth;
            } else {
                startX = CalendarView.this.mShowWeekNumber ? (float)(this.mWidth / this.mNumCells) : 0.0f;
                stopX = this.mWidth;
            }
            canvas.drawLine(startX, 0.0f, stopX, 0.0f, this.mDrawPaint);
        }

        private void drawSelectedDateVerticalBars(Canvas canvas) {
            if (!this.mHasSelectedDay) {
                return;
            }
            CalendarView.this.mSelectedDateVerticalBar.setBounds(this.mSelectedLeft - CalendarView.this.mSelectedDateVerticalBarWidth / 2, CalendarView.this.mWeekSeperatorLineWidth, this.mSelectedLeft + CalendarView.this.mSelectedDateVerticalBarWidth / 2, this.mHeight);
            CalendarView.this.mSelectedDateVerticalBar.draw(canvas);
            CalendarView.this.mSelectedDateVerticalBar.setBounds(this.mSelectedRight - CalendarView.this.mSelectedDateVerticalBarWidth / 2, CalendarView.this.mWeekSeperatorLineWidth, this.mSelectedRight + CalendarView.this.mSelectedDateVerticalBarWidth / 2, this.mHeight);
            CalendarView.this.mSelectedDateVerticalBar.draw(canvas);
        }

        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            this.mWidth = w;
            this.updateSelectionPositions();
        }

        private void updateSelectionPositions() {
            if (this.mHasSelectedDay) {
                boolean isLayoutRtl = this.isLayoutRtl();
                int selectedPosition = this.mSelectedDay - CalendarView.this.mFirstDayOfWeek;
                if (selectedPosition < 0) {
                    selectedPosition += 7;
                }
                if (CalendarView.this.mShowWeekNumber && !isLayoutRtl) {
                    ++selectedPosition;
                }
                this.mSelectedLeft = isLayoutRtl ? (CalendarView.this.mDaysPerWeek - 1 - selectedPosition) * this.mWidth / this.mNumCells : selectedPosition * this.mWidth / this.mNumCells;
                this.mSelectedRight = this.mSelectedLeft + this.mWidth / this.mNumCells;
            }
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.mHeight = (CalendarView.this.mListView.getHeight() - CalendarView.this.mListView.getPaddingTop() - CalendarView.this.mListView.getPaddingBottom()) / CalendarView.this.mShownWeekCount;
            this.setMeasuredDimension(View.MeasureSpec.getSize(widthMeasureSpec), this.mHeight);
        }
    }

    private class WeeksAdapter
    extends BaseAdapter
    implements View.OnTouchListener {
        private final Calendar mSelectedDate = Calendar.getInstance();
        private final GestureDetector mGestureDetector;
        private int mSelectedWeek;
        private int mFocusedMonth;
        private int mTotalWeekCount;

        public WeeksAdapter() {
            this.mGestureDetector = new GestureDetector(CalendarView.this.mContext, new CalendarGestureListener());
            this.init();
        }

        private void init() {
            this.mSelectedWeek = CalendarView.this.getWeeksSinceMinDate(this.mSelectedDate);
            this.mTotalWeekCount = CalendarView.this.getWeeksSinceMinDate(CalendarView.this.mMaxDate);
            if (CalendarView.this.mMinDate.get(7) != CalendarView.this.mFirstDayOfWeek || CalendarView.this.mMaxDate.get(7) != CalendarView.this.mFirstDayOfWeek) {
                ++this.mTotalWeekCount;
            }
            this.notifyDataSetChanged();
        }

        public void setSelectedDay(Calendar selectedDay) {
            if (selectedDay.get(6) == this.mSelectedDate.get(6) && selectedDay.get(1) == this.mSelectedDate.get(1)) {
                return;
            }
            this.mSelectedDate.setTimeInMillis(selectedDay.getTimeInMillis());
            this.mSelectedWeek = CalendarView.this.getWeeksSinceMinDate(this.mSelectedDate);
            this.mFocusedMonth = this.mSelectedDate.get(2);
            this.notifyDataSetChanged();
        }

        public Calendar getSelectedDay() {
            return this.mSelectedDate;
        }

        public int getCount() {
            return this.mTotalWeekCount;
        }

        public Object getItem(int position) {
            return null;
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            WeekView weekView = null;
            if (convertView != null) {
                weekView = (WeekView)convertView;
            } else {
                weekView = new WeekView(CalendarView.this.mContext);
                AbsListView.LayoutParams params = new AbsListView.LayoutParams(-2, -2);
                weekView.setLayoutParams(params);
                weekView.setClickable(true);
                weekView.setOnTouchListener(this);
            }
            int selectedWeekDay = this.mSelectedWeek == position ? this.mSelectedDate.get(7) : -1;
            weekView.init(position, selectedWeekDay, this.mFocusedMonth);
            return weekView;
        }

        public void setFocusMonth(int month) {
            if (this.mFocusedMonth == month) {
                return;
            }
            this.mFocusedMonth = month;
            this.notifyDataSetChanged();
        }

        public boolean onTouch(View v, MotionEvent event) {
            if (CalendarView.this.mListView.isEnabled() && this.mGestureDetector.onTouchEvent(event)) {
                WeekView weekView = (WeekView)v;
                if (!weekView.getDayFromLocation(event.getX(), CalendarView.this.mTempDate)) {
                    return true;
                }
                if (CalendarView.this.mTempDate.before(CalendarView.this.mMinDate) || CalendarView.this.mTempDate.after(CalendarView.this.mMaxDate)) {
                    return true;
                }
                this.onDateTapped(CalendarView.this.mTempDate);
                return true;
            }
            return false;
        }

        private void onDateTapped(Calendar day) {
            this.setSelectedDay(day);
            CalendarView.this.setMonthDisplayed(day);
        }

        class CalendarGestureListener
        extends GestureDetector.SimpleOnGestureListener {
            CalendarGestureListener() {
            }

            public boolean onSingleTapUp(MotionEvent e) {
                return true;
            }
        }
    }

    private class ScrollStateRunnable
    implements Runnable {
        private AbsListView mView;
        private int mNewState;

        private ScrollStateRunnable() {
        }

        public void doScrollStateChange(AbsListView view, int scrollState) {
            this.mView = view;
            this.mNewState = scrollState;
            CalendarView.this.removeCallbacks(this);
            CalendarView.this.postDelayed(this, 40L);
        }

        public void run() {
            CalendarView.this.mCurrentScrollState = this.mNewState;
            if (this.mNewState == 0 && CalendarView.this.mPreviousScrollState != 0) {
                View child = this.mView.getChildAt(0);
                if (child == null) {
                    return;
                }
                int dist = child.getBottom() - CalendarView.this.mListScrollTopOffset;
                if (dist > CalendarView.this.mListScrollTopOffset) {
                    if (CalendarView.this.mIsScrollingUp) {
                        this.mView.smoothScrollBy(dist - child.getHeight(), 500);
                    } else {
                        this.mView.smoothScrollBy(dist, 500);
                    }
                }
            }
            CalendarView.this.mPreviousScrollState = this.mNewState;
        }
    }

    public static interface OnDateChangeListener {
        public void onSelectedDayChange(CalendarView var1, int var2, int var3, int var4);
    }
}

