/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.bu;

import android.app.backup.IBackupManager;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;

public final class Backup {
    static final String TAG = "bu";
    static String[] mArgs;
    int mNextArg;
    IBackupManager mBackupManager;

    public static void main(String[] args) {
        Log.d(TAG, "Beginning: " + args[0]);
        mArgs = args;
        try {
            new Backup().run();
        }
        catch (Exception e) {
            Log.e(TAG, "Error running backup/restore", e);
        }
        Log.d(TAG, "Finished.");
    }

    public void run() {
        this.mBackupManager = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
        if (this.mBackupManager == null) {
            Log.e(TAG, "Can't obtain Backup Manager binder");
            return;
        }
        int socketFd = Integer.parseInt(this.nextArg());
        String arg = this.nextArg();
        if (arg.equals("backup")) {
            this.doFullBackup(socketFd);
        } else if (arg.equals("restore")) {
            this.doFullRestore(socketFd);
        } else {
            Log.e(TAG, "Invalid operation '" + arg + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFullBackup(int socketFd) {
        String arg;
        ArrayList<String> packages = new ArrayList<String>();
        boolean saveApks = false;
        boolean saveObbs = false;
        boolean saveShared = false;
        boolean doEverything = false;
        boolean allIncludesSystem = true;
        while ((arg = this.nextArg()) != null) {
            if (arg.startsWith("-")) {
                if ("-apk".equals(arg)) {
                    saveApks = true;
                    continue;
                }
                if ("-noapk".equals(arg)) {
                    saveApks = false;
                    continue;
                }
                if ("-obb".equals(arg)) {
                    saveObbs = true;
                    continue;
                }
                if ("-noobb".equals(arg)) {
                    saveObbs = false;
                    continue;
                }
                if ("-shared".equals(arg)) {
                    saveShared = true;
                    continue;
                }
                if ("-noshared".equals(arg)) {
                    saveShared = false;
                    continue;
                }
                if ("-system".equals(arg)) {
                    allIncludesSystem = true;
                    continue;
                }
                if ("-nosystem".equals(arg)) {
                    allIncludesSystem = false;
                    continue;
                }
                if ("-all".equals(arg)) {
                    doEverything = true;
                    continue;
                }
                Log.w(TAG, "Unknown backup flag " + arg);
                continue;
            }
            packages.add(arg);
        }
        if (doEverything && packages.size() > 0) {
            Log.w(TAG, "-all passed for backup along with specific package names");
        }
        if (!doEverything && !saveShared && packages.size() == 0) {
            Log.e(TAG, "no backup packages supplied and neither -shared nor -all given");
            return;
        }
        ParcelFileDescriptor fd = null;
        try {
            fd = ParcelFileDescriptor.adoptFd(socketFd);
            String[] packArray = new String[packages.size()];
            this.mBackupManager.fullBackup(fd, saveApks, saveObbs, saveShared, doEverything, allIncludesSystem, packages.toArray(packArray));
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to invoke backup manager for backup");
        }
        finally {
            if (fd != null) {
                try {
                    fd.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFullRestore(int socketFd) {
        ParcelFileDescriptor fd = null;
        try {
            fd = ParcelFileDescriptor.adoptFd(socketFd);
            this.mBackupManager.fullRestore(fd);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to invoke backup manager for restore");
        }
        finally {
            if (fd != null) {
                try {
                    fd.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String nextArg() {
        if (this.mNextArg >= mArgs.length) {
            return null;
        }
        String arg = mArgs[this.mNextArg];
        ++this.mNextArg;
        return arg;
    }
}

