/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.content;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.content.ContentValues;
import android.content.IContentProvider;
import android.database.Cursor;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;

public class Content {
    private static final String USAGE = "usage: adb shell content [subcommand] [options]\n\nusage: adb shell content insert --uri <URI> [--user <USER_ID>] --bind <BINDING> [--bind <BINDING>...]\n  <URI> a content provider URI.\n  <BINDING> binds a typed value to a column and is formatted:\n  <COLUMN_NAME>:<TYPE>:<COLUMN_VALUE> where:\n  <TYPE> specifies data type such as:\n  b - boolean, s - string, i - integer, l - long, f - float, d - double\n  Note: Omit the value for passing an empty string, e.g column:s:\n  Example:\n  # Add \"new_setting\" secure setting with value \"new_value\".\n  adb shell content insert --uri content://settings/secure --bind name:s:new_setting --bind value:s:new_value\n\nusage: adb shell content update --uri <URI> [--user <USER_ID>] [--where <WHERE>]\n  <WHERE> is a SQL style where clause in quotes (You have to escape single quotes - see example below).\n  Example:\n  # Change \"new_setting\" secure setting to \"newer_value\".\n  adb shell content update --uri content://settings/secure --bind value:s:newer_value --where \"name='new_setting'\"\n\nusage: adb shell content delete --uri <URI> [--user <USER_ID>] --bind <BINDING> [--bind <BINDING>...] [--where <WHERE>]\n  Example:\n  # Remove \"new_setting\" secure setting.\n  adb shell content delete --uri content://settings/secure --where \"name='new_setting'\"\n\nusage: adb shell content query --uri <URI> [--user <USER_ID>] [--projection <PROJECTION>] [--where <WHERE>] [--sort <SORT_ORDER>]\n  <PROJECTION> is a list of colon separated column names and is formatted:\n  <COLUMN_NAME>[:<COLUMN_NAME>...]\n  <SORT_ORDER> is the order in which rows in the result should be sorted.\n  Example:\n  # Select \"name\" and \"value\" columns from secure settings where \"name\" is equal to \"new_setting\" and sort the result by name in ascending order.\n  adb shell content query --uri content://settings/secure --projection name:value --where \"name='new_setting'\" --sort \"name ASC\"\n\nusage: adb shell content call --uri <URI> --method <METHOD> [--arg <ARG>]\n       [--extra <BINDING> ...]\n  <METHOD> is the name of a provider-defined method\n  <ARG> is an optional string argument\n  <BINDING> is like --bind above, typed data of the form <KEY>:{b,s,i,l,f,d}:<VAL>\n\n";

    public static void main(String[] args) {
        Parser parser = new Parser(args);
        Command command = parser.parseCommand();
        if (command != null) {
            command.execute();
        }
    }

    private static class UpdateCommand
    extends InsertCommand {
        final String mWhere;

        public UpdateCommand(Uri uri, int userId, ContentValues contentValues, String where) {
            super(uri, userId, contentValues);
            this.mWhere = where;
        }

        public void onExecute(IContentProvider provider) throws Exception {
            provider.update(null, this.mUri, this.mContentValues, this.mWhere, null);
        }
    }

    private static class QueryCommand
    extends DeleteCommand {
        final String[] mProjection;
        final String mSortOrder;

        public QueryCommand(Uri uri, int userId, String[] projection, String where, String sortOrder) {
            super(uri, userId, where);
            this.mProjection = projection;
            this.mSortOrder = sortOrder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onExecute(IContentProvider provider) throws Exception {
            Cursor cursor = provider.query(null, this.mUri, this.mProjection, this.mWhere, null, this.mSortOrder, null);
            if (cursor == null) {
                System.out.println("No result found.");
                return;
            }
            try {
                if (cursor.moveToFirst()) {
                    int rowIndex = 0;
                    StringBuilder builder = new StringBuilder();
                    do {
                        builder.setLength(0);
                        builder.append("Row: ").append(rowIndex).append(" ");
                        ++rowIndex;
                        int columnCount = cursor.getColumnCount();
                        for (int i = 0; i < columnCount; ++i) {
                            if (i > 0) {
                                builder.append(", ");
                            }
                            String columnName = cursor.getColumnName(i);
                            String columnValue = null;
                            int columnIndex = cursor.getColumnIndex(columnName);
                            int type = cursor.getType(columnIndex);
                            switch (type) {
                                case 2: {
                                    columnValue = String.valueOf(cursor.getFloat(columnIndex));
                                    break;
                                }
                                case 1: {
                                    columnValue = String.valueOf(cursor.getInt(columnIndex));
                                    break;
                                }
                                case 3: {
                                    columnValue = cursor.getString(columnIndex);
                                    break;
                                }
                                case 4: {
                                    columnValue = "BLOB";
                                    break;
                                }
                                case 0: {
                                    columnValue = "NULL";
                                }
                            }
                            builder.append(columnName).append("=").append(columnValue);
                        }
                        System.out.println(builder);
                    } while (cursor.moveToNext());
                } else {
                    System.out.println("No result found.");
                }
            }
            finally {
                cursor.close();
            }
        }
    }

    private static class CallCommand
    extends Command {
        final String mMethod;
        final String mArg;
        Bundle mExtras = null;

        public CallCommand(Uri uri, int userId, String method, String arg, ContentValues values) {
            super(uri, userId);
            this.mMethod = method;
            this.mArg = arg;
            if (values != null) {
                this.mExtras = new Bundle();
                for (String key : values.keySet()) {
                    Object val = values.get(key);
                    if (val instanceof String) {
                        this.mExtras.putString(key, (String)val);
                        continue;
                    }
                    if (val instanceof Float) {
                        this.mExtras.putFloat(key, ((Float)val).floatValue());
                        continue;
                    }
                    if (val instanceof Double) {
                        this.mExtras.putDouble(key, (Double)val);
                        continue;
                    }
                    if (val instanceof Boolean) {
                        this.mExtras.putBoolean(key, (Boolean)val);
                        continue;
                    }
                    if (val instanceof Integer) {
                        this.mExtras.putInt(key, (Integer)val);
                        continue;
                    }
                    if (!(val instanceof Long)) continue;
                    this.mExtras.putLong(key, (Long)val);
                }
            }
        }

        public void onExecute(IContentProvider provider) throws Exception {
            Bundle result = provider.call(null, this.mMethod, this.mArg, this.mExtras);
            int size = result.size();
            System.out.println("Result: " + result);
        }
    }

    private static class DeleteCommand
    extends Command {
        final String mWhere;

        public DeleteCommand(Uri uri, int userId, String where) {
            super(uri, userId);
            this.mWhere = where;
        }

        public void onExecute(IContentProvider provider) throws Exception {
            provider.delete(null, this.mUri, this.mWhere, null);
        }
    }

    private static class InsertCommand
    extends Command {
        final ContentValues mContentValues;

        public InsertCommand(Uri uri, int userId, ContentValues contentValues) {
            super(uri, userId);
            this.mContentValues = contentValues;
        }

        public void onExecute(IContentProvider provider) throws Exception {
            provider.insert(null, this.mUri, this.mContentValues);
        }
    }

    private static abstract class Command {
        final Uri mUri;
        final int mUserId;

        public Command(Uri uri, int userId) {
            this.mUri = uri;
            this.mUserId = userId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void execute() {
            String providerName = this.mUri.getAuthority();
            try {
                IActivityManager activityManager = ActivityManagerNative.getDefault();
                IContentProvider provider = null;
                Binder token = new Binder();
                try {
                    IActivityManager.ContentProviderHolder holder = activityManager.getContentProviderExternal(providerName, this.mUserId, token);
                    if (holder == null) {
                        throw new IllegalStateException("Could not find provider: " + providerName);
                    }
                    provider = holder.provider;
                    this.onExecute(provider);
                }
                finally {
                    if (provider != null) {
                        activityManager.removeContentProviderExternal(providerName, token);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error while accessing provider:" + providerName);
                e.printStackTrace();
            }
        }

        protected abstract void onExecute(IContentProvider var1) throws Exception;
    }

    private static class Tokenizer {
        private final String[] mArgs;
        private int mNextArg;

        public Tokenizer(String[] args) {
            this.mArgs = args;
        }

        private String nextArg() {
            if (this.mNextArg < this.mArgs.length) {
                return this.mArgs[this.mNextArg++];
            }
            return null;
        }
    }

    private static class Parser {
        private static final String ARGUMENT_INSERT = "insert";
        private static final String ARGUMENT_DELETE = "delete";
        private static final String ARGUMENT_UPDATE = "update";
        private static final String ARGUMENT_QUERY = "query";
        private static final String ARGUMENT_CALL = "call";
        private static final String ARGUMENT_WHERE = "--where";
        private static final String ARGUMENT_BIND = "--bind";
        private static final String ARGUMENT_URI = "--uri";
        private static final String ARGUMENT_USER = "--user";
        private static final String ARGUMENT_PROJECTION = "--projection";
        private static final String ARGUMENT_SORT = "--sort";
        private static final String ARGUMENT_METHOD = "--method";
        private static final String ARGUMENT_ARG = "--arg";
        private static final String ARGUMENT_EXTRA = "--extra";
        private static final String TYPE_BOOLEAN = "b";
        private static final String TYPE_STRING = "s";
        private static final String TYPE_INTEGER = "i";
        private static final String TYPE_LONG = "l";
        private static final String TYPE_FLOAT = "f";
        private static final String TYPE_DOUBLE = "d";
        private static final String COLON = ":";
        private static final String ARGUMENT_PREFIX = "--";
        private final Tokenizer mTokenizer;

        public Parser(String[] args) {
            this.mTokenizer = new Tokenizer(args);
        }

        public Command parseCommand() {
            try {
                String operation = this.mTokenizer.nextArg();
                if (ARGUMENT_INSERT.equals(operation)) {
                    return this.parseInsertCommand();
                }
                if (ARGUMENT_DELETE.equals(operation)) {
                    return this.parseDeleteCommand();
                }
                if (ARGUMENT_UPDATE.equals(operation)) {
                    return this.parseUpdateCommand();
                }
                if (ARGUMENT_QUERY.equals(operation)) {
                    return this.parseQueryCommand();
                }
                if (ARGUMENT_CALL.equals(operation)) {
                    return this.parseCallCommand();
                }
                throw new IllegalArgumentException("Unsupported operation: " + operation);
            }
            catch (IllegalArgumentException iae) {
                System.out.println(Content.USAGE);
                System.out.println("[ERROR] " + iae.getMessage());
                return null;
            }
        }

        private InsertCommand parseInsertCommand() {
            String argument;
            Uri uri = null;
            int userId = 0;
            ContentValues values = new ContentValues();
            while ((argument = this.mTokenizer.nextArg()) != null) {
                if (ARGUMENT_URI.equals(argument)) {
                    uri = Uri.parse(this.argumentValueRequired(argument));
                    continue;
                }
                if (ARGUMENT_USER.equals(argument)) {
                    userId = Integer.parseInt(this.argumentValueRequired(argument));
                    continue;
                }
                if (ARGUMENT_BIND.equals(argument)) {
                    this.parseBindValue(values);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported argument: " + argument);
            }
            if (uri == null) {
                throw new IllegalArgumentException("Content provider URI not specified. Did you specify --uri argument?");
            }
            if (values.size() == 0) {
                throw new IllegalArgumentException("Bindings not specified. Did you specify --bind argument(s)?");
            }
            return new InsertCommand(uri, userId, values);
        }

        private DeleteCommand parseDeleteCommand() {
            String argument;
            Uri uri = null;
            int userId = 0;
            String where = null;
            while ((argument = this.mTokenizer.nextArg()) != null) {
                if (ARGUMENT_URI.equals(argument)) {
                    uri = Uri.parse(this.argumentValueRequired(argument));
                    continue;
                }
                if (ARGUMENT_USER.equals(argument)) {
                    userId = Integer.parseInt(this.argumentValueRequired(argument));
                    continue;
                }
                if (ARGUMENT_WHERE.equals(argument)) {
                    where = this.argumentValueRequired(argument);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported argument: " + argument);
            }
            if (uri == null) {
                throw new IllegalArgumentException("Content provider URI not specified. Did you specify --uri argument?");
            }
            return new DeleteCommand(uri, userId, where);
        }

        private UpdateCommand parseUpdateCommand() {
            String argument;
            Uri uri = null;
            int userId = 0;
            String where = null;
            ContentValues values = new ContentValues();
            while ((argument = this.mTokenizer.nextArg()) != null) {
                if (ARGUMENT_URI.equals(argument)) {
                    uri = Uri.parse(this.argumentValueRequired(argument));
                    continue;
                }
                if (ARGUMENT_USER.equals(argument)) {
                    userId = Integer.parseInt(this.argumentValueRequired(argument));
                    continue;
                }
                if (ARGUMENT_WHERE.equals(argument)) {
                    where = this.argumentValueRequired(argument);
                    continue;
                }
                if (ARGUMENT_BIND.equals(argument)) {
                    this.parseBindValue(values);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported argument: " + argument);
            }
            if (uri == null) {
                throw new IllegalArgumentException("Content provider URI not specified. Did you specify --uri argument?");
            }
            if (values.size() == 0) {
                throw new IllegalArgumentException("Bindings not specified. Did you specify --bind argument(s)?");
            }
            return new UpdateCommand(uri, userId, values, where);
        }

        public CallCommand parseCallCommand() {
            String argument;
            String method = null;
            int userId = 0;
            String arg = null;
            Uri uri = null;
            ContentValues values = new ContentValues();
            while ((argument = this.mTokenizer.nextArg()) != null) {
                if (ARGUMENT_URI.equals(argument)) {
                    uri = Uri.parse(this.argumentValueRequired(argument));
                    continue;
                }
                if (ARGUMENT_USER.equals(argument)) {
                    userId = Integer.parseInt(this.argumentValueRequired(argument));
                    continue;
                }
                if (ARGUMENT_METHOD.equals(argument)) {
                    method = this.argumentValueRequired(argument);
                    continue;
                }
                if (ARGUMENT_ARG.equals(argument)) {
                    arg = this.argumentValueRequired(argument);
                    continue;
                }
                if (ARGUMENT_EXTRA.equals(argument)) {
                    this.parseBindValue(values);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported argument: " + argument);
            }
            if (uri == null) {
                throw new IllegalArgumentException("Content provider URI not specified. Did you specify --uri argument?");
            }
            if (method == null) {
                throw new IllegalArgumentException("Content provider method not specified.");
            }
            return new CallCommand(uri, userId, method, arg, values);
        }

        public QueryCommand parseQueryCommand() {
            String argument;
            Uri uri = null;
            int userId = 0;
            String[] projection = null;
            String sort = null;
            String where = null;
            while ((argument = this.mTokenizer.nextArg()) != null) {
                if (ARGUMENT_URI.equals(argument)) {
                    uri = Uri.parse(this.argumentValueRequired(argument));
                    continue;
                }
                if (ARGUMENT_USER.equals(argument)) {
                    userId = Integer.parseInt(this.argumentValueRequired(argument));
                    continue;
                }
                if (ARGUMENT_WHERE.equals(argument)) {
                    where = this.argumentValueRequired(argument);
                    continue;
                }
                if (ARGUMENT_SORT.equals(argument)) {
                    sort = this.argumentValueRequired(argument);
                    continue;
                }
                if (ARGUMENT_PROJECTION.equals(argument)) {
                    projection = this.argumentValueRequired(argument).split("[\\s]*:[\\s]*");
                    continue;
                }
                throw new IllegalArgumentException("Unsupported argument: " + argument);
            }
            if (uri == null) {
                throw new IllegalArgumentException("Content provider URI not specified. Did you specify --uri argument?");
            }
            return new QueryCommand(uri, userId, projection, where, sort);
        }

        private void parseBindValue(ContentValues values) {
            String argument = this.mTokenizer.nextArg();
            if (TextUtils.isEmpty(argument)) {
                throw new IllegalArgumentException("Binding not well formed: " + argument);
            }
            int firstColonIndex = argument.indexOf(COLON);
            if (firstColonIndex < 0) {
                throw new IllegalArgumentException("Binding not well formed: " + argument);
            }
            int secondColonIndex = argument.indexOf(COLON, firstColonIndex + 1);
            if (secondColonIndex < 0) {
                throw new IllegalArgumentException("Binding not well formed: " + argument);
            }
            String column = argument.substring(0, firstColonIndex);
            String type = argument.substring(firstColonIndex + 1, secondColonIndex);
            String value = argument.substring(secondColonIndex + 1);
            if (TYPE_STRING.equals(type)) {
                values.put(column, value);
            } else if (TYPE_BOOLEAN.equalsIgnoreCase(type)) {
                values.put(column, Boolean.parseBoolean(value));
            } else if (TYPE_INTEGER.equalsIgnoreCase(type) || TYPE_LONG.equalsIgnoreCase(type)) {
                values.put(column, Long.parseLong(value));
            } else if (TYPE_FLOAT.equalsIgnoreCase(type) || TYPE_DOUBLE.equalsIgnoreCase(type)) {
                values.put(column, Double.parseDouble(value));
            } else {
                throw new IllegalArgumentException("Unsupported type: " + type);
            }
        }

        private String argumentValueRequired(String argument) {
            String value = this.mTokenizer.nextArg();
            if (TextUtils.isEmpty(value) || value.startsWith(ARGUMENT_PREFIX)) {
                throw new IllegalArgumentException("No value for argument: " + argument);
            }
            return value;
        }
    }
}

